<?php

add_filter( 'vc_load_default_templates', 'rella_reset_default_templates' ); // Hook in
function rella_reset_default_templates( $data ) {
    return array(); // This will remove all default templates. Basically you should use native PHP functions to modify existing array and then return it.
}

function rella_add_default_templates() {

	$templates = rella_vc_templates();
	return array_map( 'vc_add_default_templates', $templates );
}
rella_add_default_templates();

function rella_vc_templates(){
	
	$uri = get_template_directory_uri() . '/rella/assets/img/rella_templates/';
	$templates = array();
	
	//Category Banners
	//About Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner About', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/about-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" columns_placement="bottom" css=".vc_custom_1497034385550{background-color: #30349b !important;}"][vc_column css=".vc_custom_1497034433900{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ra_particles items="%5B%7B%22image%22%3A%22http%3A%2F%2Fboo.themerella.com%2Fwp-content%2Fuploads%2F2017%2F06%2FTriangle.svg%22%2C%22top_pos%22%3A%22110px%22%2C%22left_pos%22%3A%22500px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%2080%2C%20%5C%22rotationZ%5C%22%3A%2045%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-80%22%2C%22prlx_duration%22%3A%22120%25%22%7D%2C%7B%22image%22%3A%22http%3A%2F%2Fboo.themerella.com%2Fwp-content%2Fuploads%2F2017%2F06%2FTriangle-Copy-4.svg%22%2C%22top_pos%22%3A%2250px%22%2C%22left_pos%22%3A%22-50px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20180%2C%20%5C%22rotationZ%5C%22%3A%2045%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-100%22%2C%22prlx_time%22%3A%221.2%22%2C%22prlx_duration%22%3A%22150%25%22%7D%2C%7B%22image%22%3A%22http%3A%2F%2Fboo.themerella.com%2Fwp-content%2Fuploads%2F2017%2F06%2FTriangle.svg%22%2C%22top_pos%22%3A%22-80px%22%2C%22right_pos%22%3A%22-30%25%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20150%2C%20%5C%22rotationZ%5C%22%3A%20-30%2C%20%5C%22scale%5C%22%3A%200.7%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-80%22%2C%22prlx_time%22%3A%221.5%22%2C%22prlx_duration%22%3A%22100%25%22%7D%2C%7B%22image%22%3A%22http%3A%2F%2Fboo.themerella.com%2Fwp-content%2Fuploads%2F2017%2F06%2FOval.svg%22%2C%22top_pos%22%3A%22350px%22%2C%22right_pos%22%3A%22-40%25%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20150%2C%20%5C%22x%5C%22%3A%2050%2C%20%5C%22rotationZ%5C%22%3A%20-10%2C%20%5C%22scale%5C%22%3A%200.7%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-80%2C%20%5C%22x%5C%22%3A%20-150%2C%22%2C%22prlx_time%22%3A%222%22%2C%22prlx_duration%22%3A%22180%25%22%7D%5D"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``y``: 0, ``x``: -80, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeOut``"][vc_custom_heading text="I?m Sanchez" font_container="tag:h2|font_size:120px|text_align:left|color:%23ffffff|line_height:1.25em" google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``y``: 0, ``x``: -50, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeOut``"][vc_custom_heading text="FRONT END DEVELOPER" font_container="tag:h6|font_size:17px|text_align:left|color:%2321d287|line_height:1.5em" google_fonts="font_family:Space%20Mono%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" letter_spacing="0.15em" css=".vc_custom_1497036393742{margin-bottom: 30px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``y``: 0, ``x``: -50, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeOut``"][vc_custom_heading text="Humorously perilous business for both of us. For, before we proceed further, it must be said that the monkey-rope was fast at both ends; fast to broad canvas belt, and to my leather one." font_container="tag:p|font_size:26px|text_align:left|color:%23ffffff|line_height:43px" google_fonts="font_family:Space%20Mono%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1497036403419{margin-bottom: 30px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``y``: 0, ``x``: -50, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%"][vc_custom_heading font_container="tag:p|font_size:14px|text_align:left|color:%23ffffff|line_height:1.5em" google_fonts="font_family:Space%20Mono%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1497036845571{margin-bottom: 30px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``y``: 0, ``rotationX``: 45, ``transformOrigin``: ``0% 100%``" parallax_to="``transformOrigin``: ``0% 100%``" parallax_duration="50%"][vc_single_image source="external_link" css=".vc_custom_1499154921645{margin-bottom: -2px !important;}" custom_src="http://boo.themerella.com/wp-content/uploads/2017/06/pf08-about-02-1.jpg"][/vc_column_inner][vc_column_inner][ra_particles items="%5B%7B%22image%22%3A%22http%3A%2F%2Fboo.themerella.com%2Fwp-content%2Fuploads%2F2017%2F06%2FPolygon.svg%22%2C%22top_pos%22%3A%22-50px%22%2C%22left_pos%22%3A%22-40%25%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%200%2C%20%5C%22x%5C%22%3A%200%2C%20%5C%22rotationZ%5C%22%3A%2045%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-350%2C%20%5C%22x%5C%22%3A%20-100%22%2C%22prlx_duration%22%3A%22100%25%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Landing Banner
	$data = array();
	$data['name'] = esc_html__( 'Banner Landing', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/landing-banner-banners.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" full_height="yes" columns_placement="bottom" gradient_bg="yes" gradient_bg_color="linear-gradient(to bottom left,rgba(70, 25, 251, 0.89) 0%,rgba(156, 60, 255, 0.88) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column el_class="particles-wrapper"][ra_particles items="%5B%7B%22image%22%3A%22http://boolanding.themerella.com/wp-content/uploads/2017/10/oval-big-left.svg%22%2C%22top_pos%22%3A%2225vh%22%2C%22left_pos%22%3A%22-380px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20-180%2C%20%5C%22x%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20300%2C%20%5C%22x%5C%22%3A%200%22%2C%22prlx_duration%22%3A%22200%25%22%7D%2C%7B%22image%22%3A%22http://boolanding.themerella.com/wp-content/uploads/2017/10/oval-big-left.svg%22%2C%22top_pos%22%3A%2212vh%22%2C%22right_pos%22%3A%22-450px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20-290%2C%20%5C%22x%5C%22%3A%20-110%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20400%2C%20%5C%22x%5C%22%3A%20150%22%2C%22prlx_duration%22%3A%22200%25%22%7D%5D"][/vc_column][vc_column enable_responsive_options="yes" css=".vc_custom_1508408258303{margin-top: 5% !important;margin-bottom: 5% !important;padding-right: 4vw !important;padding-left: 4vw !important;}" responsive_css="padding_top_tablet:150|padding_bottom_tablet:150|padding_top_mobile:100|padding_bottom_mobile:100"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1508407815063{padding-top: 0px !important;}"][vc_column_inner offset="vc_col-lg-8 vc_col-md-7" align="text-sm-center text-xs-center"][vc_custom_heading text="Have your dream<br /> site in minutes." font_container="tag:h2|font_size:90px|text_align:left|color:%23ffffff|line_height:1.1875em" use_theme_fonts="yes" enable_fittext="yes" css=".vc_custom_1508957475675{margin-top: 0px !important;margin-bottom: 0.25em !important;}" fittex_size="80px"][vc_column_text]<span style="color: rgba(255, 255, 255, 0.75); letter-spacing: 0.015em; font-size: 18px;">The most powerful yet the easiest theme ever.</span>[/vc_column_text][/vc_column_inner][vc_column_inner enable_responsive_options="yes" offset="vc_col-lg-4 vc_col-md-5" css=".vc_custom_1508408338361{margin-left: 1.65vw !important;}" align="text-lg-right text-md-center text-sm-center text-xs-center" responsive_css="margin_right_desktop:-80|margin_right_tablet:0|margin_right_mobile:0"][ra_button style="btn-default" lightbox="yes" lightbox_type="video" shape="circle" size="btn-lg" border="border-thick" text="text-uppercase" others="wide" i_type="fontawesome" title="See how it works" i_icon_fontawesome="fa fa-play" primary_color="rgba(255,255,255,0.49)" hbg="#ffffff" text_color="#ffffff" css=".vc_custom_1508957355974{padding-top: 1.5em !important;padding-right: 7.5vw !important;padding-bottom: 1.5em !important;padding-left: 7.5vw !important;}" i_mr="15px" fs="15px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" htext_color="#6f14f1" fw="700"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1508407489374{padding-right: 4vw !important;padding-left: 4vw !important;}"][vc_row_inner equal_height="yes"][vc_column_inner width="1/2" align="text-lg-left" offset="vc_col-md-3" css=".vc_custom_1508408144347{padding-right: 10% !important;}"][ra_icon_box template="" heading_size="icon-box-heading-sm" heading_weight="weight-bold" i_type="linea" title="No Coding Skills Required" i_icon_linea="icon-basic_magic_mouse" el_class="text-left" content_color="rgba(255,255,255,0.4)" icon_color="rgba(255,255,255,0.7)" title_color="#ffffff" content_size="16px" title_size="18px"]Build any site you can imagine with no coding skills. Sky is the limit![/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" align="text-lg-left" offset="vc_col-md-3" css=".vc_custom_1508408144347{padding-right: 10% !important;}"][ra_icon_box template="" heading_size="icon-box-heading-sm" heading_weight="weight-bold" i_type="linea" title="Live Website Builder" i_icon_linea="icon-basic_webpage_multiple" el_class="text-left" content_color="rgba(255,255,255,0.4)" icon_color="rgba(255,255,255,0.7)" title_color="#ffffff" content_size="16px" title_size="18px"]Build any site you can imagine with no coding skills. Sky is the limit![/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" align="text-lg-left" offset="vc_col-md-3" css=".vc_custom_1508408144347{padding-right: 10% !important;}"][ra_icon_box template="" heading_size="icon-box-heading-sm" heading_weight="weight-bold" i_type="linea" title="Stand out from the Crowd" i_icon_linea="icon-basic_webpage_img_txt" el_class="text-left" content_color="rgba(255,255,255,0.4)" icon_color="rgba(255,255,255,0.7)" title_color="#ffffff" content_size="16px" title_size="18px"]Build any site you can imagine with no coding skills. Sky is the limit![/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" align="text-lg-left" offset="vc_col-md-3" css=".vc_custom_1508408144347{padding-right: 10% !important;}"][ra_icon_box template="" heading_size="icon-box-heading-sm" heading_weight="weight-bold" i_type="linea" title="Live Support" i_icon_linea="icon-basic_life_buoy" el_class="text-left" content_color="rgba(255,255,255,0.4)" icon_color="rgba(255,255,255,0.7)" title_color="#ffffff" content_size="16px" title_size="18px"]Customize your site in real-time and see the results instantly.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Landing CTA Banner
	$data = array();
	$data['name'] = esc_html__( 'Banner Landing CTA', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/landing-cta-banners.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" gradient_bg="yes" gradient_bg_color="linear-gradient(to top left,rgb(112, 20, 241) 0%,rgb(149, 39, 217) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" css=".vc_custom_1508411128561{padding-top: 110px !important;padding-bottom: 110px !important;}"][vc_column width="5/6" align="text-lg-center" offset="vc_col-sm-offset-1"][vc_custom_heading text="Launch your website today." font_container="tag:h2|font_size:50px|text_align:center|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" css=".vc_custom_1508411239930{margin-top: 0px !important;margin-bottom: 0.75em !important;}"][vc_column_text]<span style="font-size: 20px; line-height: 1.85em; color: #e0dff3; opacity: 0.9;">No subscription, you only pay once and it's yours forever with lifetime updates and top-notch support. On sale for a <span style="color: #3dffc7;">very limited time.</span></span>[/vc_column_text][ra_button style="btn-solid" shape="circle" size="btn-lg" text="text-uppercase" others="wide" title="Purchase Boo" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource||target:%20_blank|" primary_color="#ffffff" text_color="#6f14f1" htext_color="#6f14f1" lh="1.75em" fw="700"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Mobile Banner
	$data = array();
	$data['name'] = esc_html__( 'Banner Mobile', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/mobile-banners.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1508953028107{background-color: #f6f7fc !important;}"][vc_column offset="vc_col-md-6"][vc_custom_heading text="Mobile Ready." font_container="tag:h2|font_size:50px|text_align:left" use_theme_fonts="yes" css=".vc_custom_1508952954601{margin-top: 0px !important;margin-bottom: 0.3em !important;}"][vc_column_text]<span style="font-size: 18px;">Boo works seamlessly on any device without a single compromise. It will automatically adapt your content for the best mobile experience. You are free to disable any content for a specific device.</span>[/vc_column_text][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/09/devices.png"][vc_empty_space height="25px"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Optimised Performance" font_container="tag:h4|font_size:22px|text_align:left|color:%235b34ff" use_theme_fonts="yes" css=".vc_custom_1508958861392{margin-bottom: 0.3em !important;}"][vc_column_text]Mobile first approach provides smooth animations with an outstanding performance.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Retina Ready" font_container="tag:h4|font_size:22px|text_align:left|color:%235b34ff" use_theme_fonts="yes" css=".vc_custom_1508958872998{margin-bottom: 0.3em !important;}"][vc_column_text]Boo looks stunning on any device or platform with adaptive images, texts and videos.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-6"][vc_single_image source="external_link" external_img_size="full" alignment="center" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/10/phone-1.png"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Video Banner
	$data = array();
	$data['name'] = esc_html__( 'Banner Video', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/video-banner-banners.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1508951910590{padding-top: 130px !important;padding-bottom: 175px !important;}"][vc_column width="1/2"][ra_content_box style="s12-alt" show_button="yes" ib_style="btn-play" ib_lightbox="yes" ib_lightbox_type="video" ib_shape="circle" ib_alt_size="btn-custom" image="http://boolanding.themerella.com/wp-content/uploads/2017/10/Apple_Watch.jpg" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" ib_alt_custom_size="75px" ib_alt_custom_height="75px" primary_color="#545af7" ib_other="Play" ib_second_color="#ffffff" ib_text_color="#ffffff" ib_i_size="16px"][/ra_content_box][/vc_column][vc_column width="1/2" css=".vc_custom_1508943168124{padding-right: 10% !important;padding-left: 10% !important;}"][ra_section_title style="resolve" title="Live Builder." alignment="align-left" title_font_container="tag:h2|font_size:50px|color:%236f14f1|line_height:65px" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1508951798197{margin-bottom: 10px !important;}"]<span style="font-size: 18px; color: #7b8796; line-height: 35px;">Boo will change the way you build websites forever. It is powered by Live Website Builder which allows you to customize pre-built sites or even create unique ones even if you have no coding experience.</span>[/ra_section_title][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/09/devices.png"][ra_button style="btn-default" shape="circle" size="btn-xlg" border="border-thick" text="text-uppercase" others="wide" title="How it Works" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" fw="700" fs="12px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Video 2 Banner
	$data = array();
	$data['name'] = esc_html__( 'Banner Video 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/video-banner-2-banners.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle" gradient_bg="yes" gradient_bg_color="linear-gradient(125deg,rgb(111, 20, 237) 0%,rgb(149, 39, 217) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" css=".vc_custom_1508952050985{padding-top: 125px !important;padding-bottom: 125px !important;}"][vc_column width="1/2" css=".vc_custom_1508952009232{padding-right: 5% !important;padding-left: 15% !important;}"][ra_section_title style="resolve" title="Section Templates." alignment="align-left" title_font_container="tag:h2|font_size:50px|color:%23ffffff|line_height:1.25em" title_use_theme_fonts="yes" content_font_container="tag:p|color:rgba(255%2C255%2C255%2C0.54)" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1509005526991{margin-bottom: 0.5em !important;}"][/ra_section_title][vc_column_text]<span style="font-size: 18px; color: rgba(255, 255, 255, 0.6);">Don?t waste your time on boring shortcodes. Boo Universe contains more than 200 modular content blocks to provide all the things you need to build a unique website in minutes with zero coding.</span>[/vc_column_text][vc_row_inner][vc_column_inner offset="vc_col-md-6"][vc_custom_heading text="200+ Content Blocks" font_container="tag:h3|font_size:25px|text_align:left|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes"][vc_column_text]<span style="font-size: 16px; color: rgba(255, 255, 255, 0.6);">Import your favorite blocks with a single click from filterable categories and combine them to create unique looks. Simple yet powerful.</span>[/vc_column_text][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][vc_custom_heading text="Fully Customizable" font_container="tag:h3|font_size:25px|text_align:left|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes"][vc_column_text]<span style="font-size: 16px; color: rgba(255, 255, 255, 0.6);">No coding skills required to customize pre-built content blocks. Boo Universe is fully integrated with Live Website Builder.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1508952032467{margin-left: 75px !important;padding-top: 120px !important;padding-bottom: 120px !important;background-image: url(http://boolanding.themerella.com/wp-content/uploads/2017/10/boo-universe-video.jpg?id=237) !important;border-radius: 5px !important;}" align="text-lg-center" el_class="sm-bg-none"][ra_button style="btn-play" lightbox="yes" lightbox_type="video" alt_size="btn-custom" other="Play" alt_custom_size="105px" alt_custom_height="105px" primary_color="#6f14f1" second_color="#ffffff" text_color="#ffffff" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Wave Shape Bottom Banner
	$data = array();
	$data['name'] = esc_html__( 'Banner Wave Shape Bottom', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/wave-shape-bottom-banners.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" video_bg="yes" video_bg_url="https://www.youtube.com/watch?v=5wkGa72b_yY" bg_attachment="fixed" enable_row_dividers="yes" overlay_bg="yes" overlay_type="gradient" row_svg_divider="bottom_shape_type:waves-2|bottom_shape_color:%23ffffff|bottom_shape_height:175" gradient_overlay="linear-gradient(133deg,rgba(65, 0, 255, 0.84) 0%,rgba(255, 0, 232, 0.8) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column width="5/6" align="text-lg-center" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1" css=".vc_custom_1508337754698{padding-top: 0px !important;}"][vc_row_inner css=".vc_custom_1508337749866{padding-top: 0px !important;}"][vc_column_inner css_animation="fadeInUp" css=".vc_custom_1508497156540{margin-bottom: 0px !important;}"][ra_section_title style="default" title="Make it" items="%5B%7B%22word%22%3A%22Beautiful.%22%7D%2C%7B%22word%22%3A%22Fast.%22%7D%2C%7B%22word%22%3A%22Creative.%22%7D%2C%7B%22word%22%3A%22Solid.%22%7D%5D" effect="slide_horizontal_vertical" title_font_container="tag:div|font_size:63px|color:%23ffffff|line_height:1.2em" title_google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" effect_tag="div" autoplay="yes" use_custom_fonts_title="true" delay="2000" css=".vc_custom_1509637288809{margin-bottom: 30px !important;}"][/ra_section_title][/vc_column_inner][vc_column_inner css_animation="fadeInUp" delay="200"][vc_column_text css=".vc_custom_1508497925787{margin-bottom: 42px !important;padding-right: 11% !important;padding-left: 11% !important;}"]<span style="font-size: 20px; color: rgba(255, 255, 255, 0.62);">No coding skills required to create unique sites.</span>[/vc_column_text][/vc_column_inner][vc_column_inner css_animation="fadeInUp" delay="400"][ra_button style="btn-solid" shape="circle" size="btn-xlg" text="text-uppercase" title="Case Studies" primary_color="#ffffff" hbg="#1254fd" text_color="#000000" htext_color="#ffffff" css=".vc_custom_1509701041233{margin-right: 10px !important;margin-left: 10px !important;}" fw="700"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Wave Shape Top Banner
	$data = array();
	$data['name'] = esc_html__( 'Banner Wave Shape Top', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/wave-shape-top-banners.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" parallax="content-moving" enable_row_dividers="yes" overlay_bg="yes" overlay_type="gradient" css=".vc_custom_1509644802454{margin-top: 107px !important;margin-bottom: -1px !important;background-image: url(http://sanfrancisco.themerella.com/wp-content/uploads/2017/10/top.jpg?id=7970) !important;background-position: 0 0;background-repeat: no-repeat !important;}" row_svg_divider="top_shape_type:waves-2|top_shape_color:%23ffffff|top_shape_height:128" gradient_overlay="linear-gradient(124deg,rgba(84, 0, 255, 0.84) 0%,rgba(252, 0, 255, 0.78) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column width="2/3" offset="vc_col-md-offset-2" align="text-lg-center" css=".vc_custom_1497878293204{padding-top: 60px !important;padding-bottom: 100px !important;}"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeInOut" enable_transform="yes" parallax_duration="0%" translate_from_y="61" rotate_from_x="65"][vc_column_text] <h1 style="text-align: center;"><span style="font-size: 42px;"><strong><span style="color: #ffffff;">Build Better Websites. <span style="font-family: Playfair Display; font-style: italic;"> no coding skills</span> required.</span></strong></span></h1> [/vc_column_text][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeInOut" css=".vc_custom_1500970678989{padding-top: 0px !important;}" parallax_duration="0%" translate_from_y="61" rotate_from_x="65"][ra_button style="btn-solid" lightbox="yes" lightbox_type="video" shape="circle" size="btn-xlg" border="border-thicker" text="text-uppercase" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" title="See How it Works" text_color="#ffffff" bc="rgba(255,255,255,0.78)" primary_color="rgba(255,255,255,0.01)" hbg="#1254fd" htext_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//About Banner 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner About 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/about-2-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" full_height="yes" equal_height="yes" content_placement="middle" css=".vc_custom_1496946061791{background-color: #2932f6 !important;}"][vc_column width="1/2" css=".vc_custom_1496945860191{background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/about-1.jpg?id=5954) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_row_inner full_height="yes" equal_height="yes" content_placement="middle"][vc_column_inner width="2/3" css=".vc_custom_1496945933967{padding-top: 0px !important;padding-bottom: 0px !important;}" offset="vc_col-md-offset-2" align="text-lg-center"][vc_empty_space height="200px"][vc_custom_heading text="I?m John Sanchez." font_container="tag:h2|font_size:72px|text_align:center|color:%23ffffff|line_height:82px" google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1496944752077{margin-bottom: 40% !important;}"][vc_custom_heading text="DESIGNER & DEVELOPER" font_container="tag:p|font_size:14px|text_align:center|color:%23ffffff" use_theme_fonts="yes" letter_spacing="0.2em" css=".vc_custom_1496944780994{margin-bottom: 0px !important;}"][vc_column_text]<a class="skewed-underline" href="mailto:works@themerella.com" target=""><span style="color: #d9d9d9;">works@themerella.com</span></a>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1496946096818{padding-right: 15% !important;padding-left: 15% !important;}"][vc_custom_heading text="About me" font_container="tag:h6|font_size:55px|text_align:left|color:%23ffffff|line_height:1.2em" google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1496945536557{margin-bottom: 90px !important;}"][vc_column_text css=".vc_custom_1496945448167{margin-bottom: 50px !important;}"] <h3><span style="color: #ffffff;">Nice to meet you</span></h3> <span style="color: #a9adfb; font-size: 16px;">Endeavor bachelor but add eat pleasure doubtful sociable. Age forming covered you entered the examine. Blessing scarcely confined her contempt wondered shy.</span>[/vc_column_text][vc_column_text] <h3><span style="color: #ffffff;">What I Do</span></h3> <span style="color: #a9adfb; font-size: 16px;">Endeavor bachelor but add eat pleasure doubtful sociable. Age forming covered you entered the examine. Blessing scarcely confined her contempt wondered shy. Dashwoods contented sportsmen.</span>[/vc_column_text][ra_button style="btn-naked" i_type="fontawesome" i_align="right" title="Hire me" i_icon_fontawesome="fa fa-long-arrow-right" text_color="#ffffff" fs="16px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//About Banner 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner About 3', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/about-3-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" enable_responsive_options="yes" css=".vc_custom_1505203647714{padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(http://four.modern.themerella.com/wp-content/uploads/sites/9/2017/08/double-exposure-2-1.jpg?id=5919) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_tablet:70|padding_top_mobile:35"][vc_column width="11/12" enable_responsive_options="yes" offset="vc_col-md-7" css=".vc_custom_1503508385564{padding-top: 0px !important;padding-right: 10% !important;padding-left: 10% !important;}" responsive_css="padding_right_tablet:15|padding_left_tablet:15|padding_right_mobile:15|padding_left_mobile:15"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="fadeInUpShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" css=".vc_custom_1503428449860{padding-top: 40px !important;}" parallax_duration="0%" parallax_trigger_number="0.7"][vc_custom_heading text="Discover New" font_container="tag:h2|font_size:55px|text_align:left" use_theme_fonts="yes" css=".vc_custom_1503425756277{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInUpShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" parallax_duration="0%" parallax_trigger_number="0.7"][vc_custom_heading text="horizons." font_container="tag:h2|font_size:50px|text_align:left|line_height:65px" google_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20italic%3A700%3Aitalic" letter_spacing="-0.027em" css=".vc_custom_1503481895434{margin-top: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInUpShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" parallax_duration="0%" parallax_trigger_number="0.7"][vc_column_text]<span style="font-size: 21px; line-height: 40px;">Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or impression by terminated. Old pleasure required removing elegance him had. Down she bore sing saw calm high. Of an or game gate west face shed. </span>[/vc_column_text][vc_single_image source="external_link" external_img_size="full" custom_src="http://four.modern.themerella.com/wp-content/uploads/sites/9/2017/08/signature-1.png"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//About Banner 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner About 4', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/about-4-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" enable_responsive_options="yes" bg_position="right center" css=".vc_custom_1508138268025{border-right-width: 50px !important;border-bottom-width: 50px !important;border-left-width: 50px !important;background-image: url(http://one.portfolio.themerella.com/wp-content/uploads/sites/3/2017/05/pf01-about.jpg?id=5511) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;border-bottom-color: #ffffff !important;border-bottom-style: solid !important;}" responsive_css="border_right_tablet:0|border_bottom_tablet:0|border_left_tablet:0|border_right_mobile:0|border_bottom_mobile:0|border_left_mobile:0"][vc_column width="1/2" align="text-left"][vc_column_text css=".vc_custom_1496236110034{margin-bottom: 40px !important;}"] <h4>I am Thomas, freelance nature photographer based in San Francisco.</h4> <h4>Currently, I'm looking for a 6 month internship.</h4> <h4>I am also available for freelance work. <span style="color: #613ad6;"><a style="color: #613ad6;" href="mailto:works@themerella.com"><mark>works@themerella.com</mark></a></span></h4> [/vc_column_text][vc_single_image source="external_link" css=".vc_custom_1508138455285{padding-bottom: 15px !important;}" custom_src="http://one.portfolio.themerella.com/wp-content/uploads/sites/3/2017/05/signature-dark-1-230x70.png"][ra_social_icons style="" visibility="faded" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column][vc_column width="1/2" align="text-left"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//App Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner App', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/app-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" enable_responsive_options="yes" bg_position="right center" css=".vc_custom_1508138268025{border-right-width: 50px !important;border-bottom-width: 50px !important;border-left-width: 50px !important;background-image: url(http://one.portfolio.themerella.com/wp-content/uploads/sites/3/2017/05/pf01-about.jpg?id=5511) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;border-bottom-color: #ffffff !important;border-bottom-style: solid !important;}" responsive_css="border_right_tablet:0|border_bottom_tablet:0|border_left_tablet:0|border_right_mobile:0|border_bottom_mobile:0|border_left_mobile:0"][vc_column width="1/2" align="text-left"][vc_column_text css=".vc_custom_1496236110034{margin-bottom: 40px !important;}"] <h4>I am Thomas, freelance nature photographer based in San Francisco.</h4> <h4>Currently, I'm looking for a 6 month internship.</h4> <h4>I am also available for freelance work. <span style="color: #613ad6;"><a style="color: #613ad6;" href="mailto:works@themerella.com"><mark>works@themerella.com</mark></a></span></h4> [/vc_column_text][vc_single_image source="external_link" css=".vc_custom_1508138455285{padding-bottom: 15px !important;}" custom_src="http://one.portfolio.themerella.com/wp-content/uploads/sites/3/2017/05/signature-dark-1-230x70.png"][ra_social_icons style="" visibility="faded" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column][vc_column width="1/2" align="text-left"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	
	//Big Button Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Big Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/big-button-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="content-moving" parallax_image="" parallax_speed_bg="1.25" css=".vc_custom_1497516239658{margin-bottom: 30px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/sports.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1496938344736{padding-left: 17% !important;}"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``y``: 40, ``rotationX``: -50, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%" parallax_offset="-200"][vc_custom_heading text="FAST." font_container="tag:h3|font_size:100px|text_align:left|color:%23000000|line_height:1.2em" google_fonts="font_family:Rajdhani%3A300%2Cregular%2C500%2C600%2C700|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``y``: 40, ``rotationX``: -50, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_offset="-200" parallax_duration="0%"][vc_custom_heading text="Humorously perilous business for both of us. For, before we proceed further, it must be said that the monkey-rope was fast at both ends; fast to broad." font_container="tag:p|font_size:22px|text_align:left|color:%23000000|line_height:1.5em" google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal" letter_spacing="0.025em"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1496938920651{margin-top: 70px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_button style="btn-solid" size="btn-lg" others="btn-block" title="Buy Now" primary_color="#80ffea" fs="22px" text_color="#0a0a0a" hbg="#0a0a0a"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Colorful Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Colorful', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/colorful-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1496943878777{margin-bottom: 30px !important;padding-top: 210px !important;padding-bottom: 250px !important;background-color: #f4f4f4 !important;}"][vc_column][ra_particles items="%5B%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-23.svg%22%2C%22top_pos%22%3A%22-148px%22%2C%22left_pos%22%3A%22200px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20180%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-280%22%2C%22prlx_duration%22%3A%22120%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-18.svg%22%2C%22top_pos%22%3A%22-118px%22%2C%22right_pos%22%3A%22150%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-280%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3.svg%22%2C%22top_pos%22%3A%22-20px%22%2C%22left_pos%22%3A%2290px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%2080%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-280%22%2C%22prlx_duration%22%3A%22150%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-26.svg%22%2C%22top_pos%22%3A%2250%22%2C%22left_pos%22%3A%2260px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%2080%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-280%22%2C%22prlx_time%22%3A%221.75%22%2C%22prlx_duration%22%3A%22180%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-25.svg%22%2C%22top_pos%22%3A%22120px%22%2C%22left_pos%22%3A%22250px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%2080%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-280%22%2C%22prlx_duration%22%3A%22180%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-6.svg%22%2C%22top_pos%22%3A%2270px%22%2C%22left_pos%22%3A%22650px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20150%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-280%22%2C%22prlx_time%22%3A%220.9%22%2C%22prlx_duration%22%3A%22120%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-11.svg%22%2C%22top_pos%22%3A%22100px%22%2C%22right_pos%22%3A%2250px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%2010%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-300%22%2C%22prlx_time%22%3A%223%22%2C%22prlx_duration%22%3A%22150%25%22%7D%5D"][/vc_column][vc_column width="1/3" offset="vc_col-md-offset-4"][vc_single_image source="external_link" alignment="center" custom_src="http://boo.themerella.com/wp-content/uploads/2017/06/Untitled-2.jpg"][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-2"][vc_custom_heading text="``Creativity is to discover a question that has never been asked. if one brings up an idiosyncratic question, the answer he gives will necessarily be unique as well.``" font_container="tag:p|font_size:28px|text_align:center|color:%23000000|line_height:1.5em" google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal"][/vc_column][vc_column][ra_particles items="%5B%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-2.svg%22%2C%22top_pos%22%3A%22-250px%22%2C%22left_pos%22%3A%22200px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%2080%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-400%22%2C%22prlx_duration%22%3A%22150%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-20.svg%22%2C%22top_pos%22%3A%22-50px%22%2C%22right_pos%22%3A%22250px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-100%22%2C%22prlx_time%22%3A%221.5%22%2C%22prlx_duration%22%3A%22150%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-23.svg%22%2C%22top_pos%22%3A%22-10px%22%2C%22right_pos%22%3A%2250px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-200%22%2C%22prlx_time%22%3A%220.85%22%2C%22prlx_duration%22%3A%22200%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-22.svg%22%2C%22top_pos%22%3A%2210px%22%2C%22left_pos%22%3A%2230px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%2050%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-300%22%2C%22prlx_time%22%3A%221.2%22%2C%22prlx_duration%22%3A%22120%25%22%7D%2C%7B%22image%22%3A%22http://boo.themerella.com/wp-content/uploads/2017/06/Oval-3-Copy-22.svg%22%2C%22top_pos%22%3A%220%22%2C%22right_pos%22%3A%22350px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22y%5C%22%3A%20150%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-250%22%2C%22prlx_time%22%3A%221.2%22%2C%22prlx_duration%22%3A%22150%25%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Call to action Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Call to Action', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/call-to-action-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" columns_placement="bottom" enable_responsive_options="yes" fullpage_brightness="dark" css=".vc_custom_1507540769744{padding-top: 50px !important;padding-bottom: 0px !important;background: #5a60f1 url(http://one.themerella.com/wp-content/uploads/2017/10/fullpage-bg-3.jpg?id=39) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" fullpage_title="Experience" responsive_css="padding_top_tablet:100|padding_top_mobile:100"][vc_column enable_responsive_options="yes" css=".vc_custom_1507541431870{padding-top: 0px !important;}" responsive_css="margin_bottom_desktop:70"][vc_row_inner el_id="experience-column" css=".vc_custom_1507541447646{margin-top: 14% !important;margin-bottom: 14% !important;}"][vc_column_inner width="5/6" css_animation="bottom-to-top" offset="vc_col-md-offset-2 vc_col-md-8 vc_col-sm-offset-1"][ra_section_title style="resolve" title="Build your VR. " title_font_container="tag:h2|font_size:60px|color:%23ffffff|line_height:1.1em" title_use_theme_fonts="yes" content_font_container="tag:p|color:rgba(255%2C255%2C255%2C0.56)" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1507542432879{margin-bottom: 8% !important;padding-right: 1% !important;padding-left: 1% !important;}"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_section_title][/vc_column_inner][vc_column_inner css_animation="fadeInUp" delay="150"][ra_button style="btn-solid" curtain_hover="bottom" shape="semi-round" size="btn-md" others="btn-block" i_type="fontawesome" i_align="right" fix_v_line="fix-v-align" title="Buy Now on Amazon" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource||target:%20_blank|rel:nofollow" i_icon_fontawesome="fa fa-amazon" i_ml="20px" primary_color="rgba(0,0,0,0.4)" hbg="rgba(0,0,0,0.4)" curtain_hbg="#ffffff" text_color="#ffffff" htext_color="#0c0c0c" fs="18px" bc="rgba(0,0,0,0)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1507535988526{padding-top: 0px !important;}"][vc_row_inner full_width="stretch_row_content" equal_height="yes" css=".vc_custom_1507538261107{margin-bottom: 0px !important;border-top-width: 1px !important;padding-top: 0px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}"][vc_column_inner css_animation="bottom-to-top" enable_responsive_options="yes" offset="vc_col-md-4" css=".vc_custom_1507634815571{border-right-width: 1px !important;padding-right: 23% !important;padding-bottom: 30px !important;padding-left: 18% !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}" responsive_css="padding_right_tablet:30|padding_left_tablet:30|padding_right_mobile:15|padding_left_mobile:15" delay="300"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" position="icon-box-inline" title="Secure Checkout." i_icon_fontawesome="fa fa-lock" icon_color="#ffffff" icon_fs="35px" content_color="rgba(255,255,255,0.5)" title_size="20px" title_color="#ffffff"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column_inner][vc_column_inner css_animation="bottom-to-top" enable_responsive_options="yes" offset="vc_col-md-4" css=".vc_custom_1507634825312{border-right-width: 1px !important;padding-right: 23% !important;padding-bottom: 30px !important;padding-left: 18% !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}" responsive_css="padding_right_tablet:30|padding_left_tablet:30|padding_right_mobile:15|padding_left_mobile:15" delay="450"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" position="icon-box-inline" title="30 Day Money Back" i_icon_fontawesome="fa fa-credit-card" icon_color="#ffffff" icon_fs="35px" content_color="rgba(255,255,255,0.5)" title_size="20px" title_color="#ffffff"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column_inner][vc_column_inner css_animation="bottom-to-top" enable_responsive_options="yes" offset="vc_col-md-4" css=".vc_custom_1507634834855{padding-right: 23% !important;padding-bottom: 30px !important;padding-left: 18% !important;}" responsive_css="padding_right_tablet:30|padding_left_tablet:30|padding_right_mobile:15|padding_left_mobile:15" delay="600"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" position="icon-box-inline" title="Live Support" i_icon_fontawesome="fa fa-phone" icon_color="#ffffff" icon_fs="35px" content_color="rgba(255,255,255,0.5)" title_size="20px" title_color="#ffffff"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Checkmarks Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Checkmarks', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/checkmarks-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" enable_responsive_options="yes" css=".vc_custom_1504013651606{padding-top: 65px !important;padding-bottom: 110px !important;}" responsive_css="padding_top_tablet:30|padding_bottom_tablet:100|padding_top_mobile:30|padding_bottom_mobile:50"][vc_column offset="vc_col-lg-5 vc_col-md-6" css=".vc_custom_1504013612513{margin-bottom: 50px !important;}"][ra_section_title style="classic" title="Better Performance." alignment="align-left" title_font_container="tag:h2|font_size:45px|line_height:1.5em" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1504286173292{margin-bottom: 25px !important;}"][/ra_section_title][vc_column_text css=".vc_custom_1504287053435{margin-bottom: 10px !important;}"] <hr /> <h6><span style="color: #747e80; font-size: 15px;">Sed est tellus, vulputate sit amet justo non, varimalesa ahamesa ulamas malesuada dolor.</span></h6> [/vc_column_text][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" position="icon-box-inline" title="Sed est tellus, vulputate sit amet justo" i_icon_fontawesome="fa fa-check" title_size="15px" title_color="#747e80" css=".vc_custom_1504286999192{margin-bottom: -20px !important;}" icon_fs="18px" icon_color="#80c673"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" position="icon-box-inline" title="Nullam ullamcorper, metus" i_icon_fontawesome="fa fa-check" title_size="15px" css=".vc_custom_1504286981860{margin-bottom: -20px !important;}" icon_fs="18px" icon_color="#80c673" title_color="#747e80"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" position="icon-box-inline" title="Aron rhoncus placerat auctor nibh" i_icon_fontawesome="fa fa-check" title_size="15px" title_color="#747e80" css=".vc_custom_1504287014232{margin-bottom: 20px !important;}" icon_fs="18px" icon_color="#80c673"][/ra_icon_box][ra_button style="btn-solid" curtain_hover="bottom" shape="semi-round" size="btn-sm" i_type="fontawesome" i_align="right" title="Purchase" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource||target:%20_blank|rel:nofollow" i_icon_fontawesome="fa fa-angle-right" fs="16px"][/vc_column][vc_column offset="vc_col-lg-7 vc_col-md-6"][vc_single_image source="external_link" alignment="center" custom_src="http://two.classic.themerella.com/wp-content/uploads/sites/2/2017/08/landing-1.jpg"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Darl Video Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Dark Video', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/dark-video-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1503482330534{padding-top: 0px !important;background-color: #16211a !important;}"][vc_column parallax="yes" parallax_preset="fadeInLeftShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" css=".vc_custom_1503429029593{padding-top: 0px !important;}" offset="vc_col-lg-6 vc_col-md-12" parallax_trigger_number="0.85" parallax_duration="0%"][ra_lightbox lightbox_type="video" image="http://chester.themerella.com/wp-content/uploads/2017/08/lightbox.jpg" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||rel:nofollow"][/vc_column][vc_column enable_responsive_options="yes" css=".vc_custom_1503490860528{padding-top: 4% !important;padding-right: 14% !important;padding-bottom: 5% !important;padding-left: 14% !important;}" offset="vc_col-lg-6 vc_col-md-12" responsive_css="padding_top_tablet:45|padding_bottom_tablet:60|padding_top_mobile:30|padding_bottom_mobile:40"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="custom" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" enable_reverse="no" translate_from_x="25" rotate_from_z="10" from_torigin_x_custom="15%" parallax_trigger_number="0.85" parallax_duration="0%"][vc_custom_heading text="Showcase of" font_container="tag:h2|font_size:55px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1503425783777{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="custom" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" translate_from_x="25" rotate_from_z="10" from_torigin_x_custom="10%" parallax_trigger_number="0.85" parallax_duration="0%"][vc_custom_heading text="landscape." font_container="tag:h2|font_size:50px|text_align:left|color:%23ffffff|line_height:65px" google_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20italic%3A900%3Aitalic" letter_spacing="-0.027em" css=".vc_custom_1503313693751{margin-top: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="custom" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" translate_from_x="25" rotate_from_z="7" from_torigin_x_custom="12%" parallax_trigger_number="0.85" parallax_duration="0%"][vc_column_text]<span style="color: #747e80; font-size: 21px; line-height: 40px;">Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or impression by terminated. Old pleasure required removing elegance him had. Down she bore sing saw calm high.</span>[/vc_column_text][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInUpShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" parallax_trigger_number="0.85" parallax_duration="0%"][ra_button style="btn-default" size="btn-md" title="GET IN TOUCH" primary_color="#ffffff" fs="14px" ls="0.15em" lh="1.25em" bc="rgba(255,255,255,0.22)" hbc="#ffffff" htext_color="#16211a"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Dark Video Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Dual Buttons', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/dual-buttons-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="67" parallax_speed_bg="1.25" css=".vc_custom_1508144592880{margin-bottom: -1px !important;padding-top: 40px !important;padding-bottom: 90px !important;background-image: url(http://three.landing.themerella.com/wp-content/uploads/sites/3/2017/09/bg.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-md-offset-2 vc_col-md-8" align="text-lg-center"][vc_custom_heading text="The Ultimate Site Builder." font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1506339343204{margin-top: 0px !important;margin-bottom: 0.3em !important;}"][vc_column_text css=".vc_custom_1506339674489{padding-right: 15% !important;padding-left: 15% !important;}"] <p style="text-align: center;"><span style="font-size: 18px; color: rgba(255,255,255,0.65);">Celebrated her had sentiments understood are projection set. Possession unaffected remarkably.</span></p> [/vc_column_text][ra_button style="btn-solid" shape="round" size="btn-md" border="border-thick" others="wide" title="Buy now" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" primary_color="#ffffff" hbg="#000000" text_color="#0c0c0c" htext_color="#ffffff" fw="500" fs="17px" css=".vc_custom_1506339635706{margin-right: 8px !important;margin-left: 8px !important;}"][ra_button style="btn-default" shape="round" size="btn-md" border="border-thick" others="wide" title="Free Trial" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" primary_color="rgba(255,255,255,0.06)" hbg="#ffffff" text_color="#ffffff" htext_color="#000000" fs="17px" fw="500" css=".vc_custom_1506339627213{margin-right: 8px !important;margin-left: 8px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Dark Video Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Video', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/video-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" equal_height="yes" content_placement="middle" enable_responsive_options="yes" responsive_css="padding_top_tablet:80|padding_bottom_tablet:60|padding_top_mobile:60|padding_bottom_mobile:40" fullpage_title="Customizer"][vc_column enable_responsive_options="yes" offset="vc_col-md-5" responsive_css="margin_bottom_tablet:30|margin_bottom_mobile:30"][vc_custom_heading text="Live Customizer." use_theme_fonts="yes" css=".vc_custom_1506336726932{margin-top: 0px !important;margin-bottom: 0.3em !important;}"][vc_column_text]<span style="font-size: 18px;">Proin fermentum metus at blandit muspendisse aliquet, libero non dictum mollis amelia.</span>[/vc_column_text][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="Sed est tellus, vulputate sit amet justo" i_icon_fontawesome="fa fa-check" icon_color="#5d63f8" icon_fs="18px" title_color="#8b98a9" css=".vc_custom_1506411717217{margin-bottom: 10px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="Nullam ullamcorper, metus" i_icon_fontawesome="fa fa-check" icon_color="#5d63f8" icon_fs="18px" title_color="#8b98a9" css=".vc_custom_1506411727434{margin-bottom: 10px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="Aron rhoncus placerat auctor nibh" i_icon_fontawesome="fa fa-check" icon_color="#5d63f8" icon_fs="18px" title_color="#8b98a9" css=".vc_custom_1506411768720{margin-bottom: 30px !important;}"][/ra_icon_box][ra_button style="btn-default" curtain_hover="left" shape="circle" size="btn-md" border="border-thick" others="wide" title="Learn More" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" hbg="rgba(255,255,255,0.01)" curtain_hbg="#545af7" hbc="#545af7" htext_color="#ffffff" fw="500"][/vc_column][vc_column offset="vc_col-md-7"][ra_content_box style="s12-alt" show_button="yes" ib_style="btn-play" ib_lightbox="yes" ib_lightbox_type="video" ib_shape="circle" ib_alt_size="btn-custom" image="http://saas.themerella.com/wp-content/uploads/2017/10/watch.jpg" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" ib_alt_custom_size="75px" ib_alt_custom_height="75px" primary_color="#545af7" ib_other="Play" ib_second_color="#ffffff" ib_text_color="#ffffff" ib_i_size="16px"][/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Dark Video Banner vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Banner Image with Heading', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/image-with-heading-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="67" parallax_speed_bg="1.25" css=".vc_custom_1508144592880{margin-bottom: -1px !important;padding-top: 40px !important;padding-bottom: 90px !important;background-image: url(http://three.landing.themerella.com/wp-content/uploads/sites/3/2017/09/bg.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-md-offset-2 vc_col-md-8" align="text-lg-center"][vc_custom_heading text="The Ultimate Site Builder." font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1506339343204{margin-top: 0px !important;margin-bottom: 0.3em !important;}"][vc_column_text css=".vc_custom_1506339674489{padding-right: 15% !important;padding-left: 15% !important;}"] <p style="text-align: center;"><span style="font-size: 18px; color: rgba(255,255,255,0.65);">Celebrated her had sentiments understood are projection set. Possession unaffected remarkably.</span></p> [/vc_column_text][ra_button style="btn-solid" shape="round" size="btn-md" border="border-thick" others="wide" title="Buy now" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" primary_color="#ffffff" hbg="#000000" text_color="#0c0c0c" htext_color="#ffffff" fw="500" fs="17px" css=".vc_custom_1506339635706{margin-right: 8px !important;margin-left: 8px !important;}"][ra_button style="btn-default" shape="round" size="btn-md" border="border-thick" others="wide" title="Free Trial" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" primary_color="rgba(255,255,255,0.06)" hbg="#ffffff" text_color="#ffffff" htext_color="#000000" fs="17px" fw="500" css=".vc_custom_1506339627213{margin-right: 8px !important;margin-left: 8px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/

	//Minimal Split Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Minimal Split', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/minimal-split-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" css=".vc_custom_1495392719244{margin-top: 100px !important;margin-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1494345414334{padding-top: 60px !important;padding-right: 10% !important;padding-bottom: 100px !important;padding-left: 10% !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/04/5-1.jpg?id=4815) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" css=".vc_custom_1494345571765{padding-top: 60px !important;padding-right: 10% !important;padding-bottom: 45px !important;padding-left: 10% !important;background-color: #f5f4f9 !important;}"][ra_section_title style="default" title="Taking Brands Further." title_font_container="tag:h2|font_size:43px" title_google_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" show_button="yes" ib_style="btn-linethrough" ib_text="text-uppercase" use_custom_fonts_title="true" ib_title="Work With Us" ib_text_color="#000000" ib_bc="rgba(0,0,0,0.38)"][/ra_section_title][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Split Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Split', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/split-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" css=".vc_custom_1495392719244{margin-top: 100px !important;margin-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1494345414334{padding-top: 60px !important;padding-right: 10% !important;padding-bottom: 100px !important;padding-left: 10% !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/04/5-1.jpg?id=4815) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" css=".vc_custom_1494345571765{padding-top: 60px !important;padding-right: 10% !important;padding-bottom: 45px !important;padding-left: 10% !important;background-color: #f5f4f9 !important;}"][ra_section_title style="default" title="Taking Brands Further." title_font_container="tag:h2|font_size:43px" title_google_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" show_button="yes" ib_style="btn-linethrough" ib_text="text-uppercase" use_custom_fonts_title="true" ib_title="Work With Us" ib_text_color="#000000" ib_bc="rgba(0,0,0,0.38)"][/ra_section_title][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Split big button Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Split Big Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/split-big-button-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes"][vc_column width="1/2" css=".vc_custom_1501690331649{background-image: url(http://one.corporate.themerella.com/wp-content/uploads/sites/2/2016/11/Corporate21.jpg?id=4366) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image source="external_link" alignment="center" invisible="yes" custom_src="http://one.corporate.themerella.com/wp-content/uploads/sites/2/2016/11/Corporate21.jpg?id=4366"][/vc_column][vc_column width="1/2" css=".vc_custom_1501683219240{padding-top: 0px !important;background-color: #002c5b !important;}"][ra_banner style="s4"][vc_custom_heading text="Building the Future." font_container="tag:h2|text_align:left|color:%23ffffff" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" letter_spacing="0px"][vc_custom_heading text="Doing the right thing, at the right time." font_container="tag:h4|text_align:left|color:%23a0aec6" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" title="Premium support is always there for you!" i_icon_fontawesome="fa fa-check" icon_color="rgba(255,255,255,0.7)" icon_fs="17px" title_size="17px" title_color="rgba(255,255,255,0.7)"][/ra_icon_box][ra_icon_box template="`{`object Object`}`" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="Exclusive demos helps you to create your website in a few click." i_icon_fontawesome="fa fa-check" icon_color="rgba(255,255,255,0.7)" icon_fs="17px" title_size="17px" title_color="rgba(255,255,255,0.7)"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title=" Flexible theme options allow you to create your unique layout." i_icon_fontawesome="fa fa-check" icon_color="rgba(255,255,255,0.7)" icon_fs="17px" title_size="17px" title_color="rgba(255,255,255,0.7)"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="Extended documentation assits you to find you answer." i_icon_fontawesome="fa fa-check" icon_color="rgba(255,255,255,0.7)" icon_fs="17px" title_size="17px" title_color="rgba(255,255,255,0.7)"][/ra_icon_box][ra_button style="btn-solid" shape="round" size="btn-lg" text="text-uppercase" others="btn-block" i_align="right" title="Read Our Story" primary_color="#28ba56" text_color="#ffffff" fw="700" hbg="#ffffff" htext_color="#0c0c0c"][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Product Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Product', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/product-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" gradient_bg="yes" css=".vc_custom_1500897675453{padding-top: 50px !important;padding-bottom: 80px !important;}" gradient_bg_color="linear-gradient(160deg,rgb(219, 243, 250) 0%,rgb(243, 247, 255) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column css=".vc_custom_1497441915291{margin-bottom: 0px !important;}"][ra_section_title style="sub-underlined" title="Introducing Concept X" title_font_container="tag:h2|font_size:60px|color:%234354e9" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1500558501396{margin-bottom: 0px !important;}"]Explore Mountain Bikes[/ra_section_title][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-3" css=".vc_custom_1498232089605{margin-top: 0px !important;padding-right: -100px !important;padding-left: -100px !important;}" align="text-lg-center"][ra_tooltiped_image image="http://universe-presentation-2.boo.themerella.com/wp-content/uploads/sites/88/2017/06/mtb-banner-2.png"][ra_pointer_tooltip title="Ultimate UX" top="25%" left="28%"]Boo provides complete solutions for both one and multi page websites.[/ra_pointer_tooltip][ra_pointer_tooltip position="align-left" title="Ultimate UX" top="52%" left="6%"]Boo provides complete solutions for both one and multi page websites.[/ra_pointer_tooltip][ra_pointer_tooltip title="Ultimate UX" top="35%" right="30%"]Boo provides complete solutions for both one and multi page websites.[/ra_pointer_tooltip][ra_pointer_tooltip position="align-bottom" title="Ultimate UX" right="10%" bottom="15%"]Boo provides complete solutions for both one and multi page websites.[/ra_pointer_tooltip][/ra_tooltiped_image][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-3" align="text-lg-center" css=".vc_custom_1496935695087{padding-right: 6% !important;padding-left: 6% !important;}"][vc_column_text]
<h5><span style="color: #9b9a9b;">Age forming covered you entered the examine. Blessing scarcely confined her contempt wondered shy. Dashwoods contented sportsmen.</span></h5>
[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Shop Split Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Shop Split', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/shop-split-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" css=".vc_custom_1495392744405{margin-top: 100px !important;margin-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1494346956558{padding-top: 100px !important;padding-right: 10% !important;padding-bottom: 140px !important;padding-left: 10% !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/05/women-3.jpg?id=5517) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_custom_heading text="Women's Collection" font_container="tag:h2|text_align:left|color:%23000000" use_theme_fonts="yes"][vc_custom_heading text="Donec eleifend libero eu tortor mattis, vesti esa tortor finibus. Pellentesque mattis dapibus." font_container="tag:p|text_align:left|color:rgba(2%2C2%2C2%2C0.6)" use_theme_fonts="yes" css=".vc_custom_1494336864059{margin-right: 20% !important;margin-bottom: 30px !important;}"][ra_button style="btn-underlined" text="text-uppercase" i_type="fontawesome" i_align="right" title="Shop now" i_icon_fontawesome="fa fa-angle-right" fw="700" i_ml="15px" text_color="#000000" bc="rgba(0,0,0,0.37)"][/vc_column][vc_column width="1/2" css=".vc_custom_1494346932379{padding-top: 100px !important;padding-right: 10% !important;padding-bottom: 140px !important;padding-left: 10% !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/05/men-2.jpg?id=5519) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_custom_heading text="Men's Collection" font_container="tag:h2|text_align:left|color:%23000000" use_theme_fonts="yes"][vc_custom_heading text="Donec eleifend libero eu tortor mattis, vesti Pellentesque mattis dapibus." font_container="tag:p|text_align:left|color:rgba(0%2C0%2C0%2C0.6)" use_theme_fonts="yes" css=".vc_custom_1494344037161{margin-right: 20% !important;margin-bottom: 30px !important;}"][ra_button style="btn-underlined" text="text-uppercase" i_type="fontawesome" i_align="right" title="Shop now" i_icon_fontawesome="fa fa-angle-right" fw="700" i_ml="15px" text_color="#000000" bc="rgba(0,0,0,0.37)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Simple Mobile Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Simple Mobile', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/simple-mobile-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_height="yes" content_placement="middle" enable_responsive_options="yes" responsive_css="padding_top_tablet:50|padding_bottom_tablet:80|padding_top_mobile:50|padding_bottom_mobile:50" fullpage_title="Exclusive"][vc_column offset="vc_col-md-offset-1 vc_col-md-4" align="text-lg-center"][vc_single_image source="external_link" external_img_size="full" alignment="center" css=".vc_custom_1508149690913{margin-bottom: 0px !important;}" custom_src="http://esperance.themerella.com/wp-content/uploads/2017/10/iphone-2.png"][/vc_column][vc_column css=".vc_custom_1507640960910{padding-right: 10% !important;}" offset="vc_col-md-offset-1 vc_col-md-6"][vc_custom_heading text="Follow your friends." use_theme_fonts="yes" css=".vc_custom_1507630534227{margin-top: 0px !important;}"][vc_column_text]<span style="font-size: 18px;">At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque. Eallentesque sagittis neque vel consectetur suscipit. Quisque vel nisi est. Sed a egestas ante. Nam rhoncus sit amet sem ut suscipit. Etiam convallis odio.</span>[/vc_column_text][vc_single_image image_type="svg" source="external_link" external_img_size="full" custom_src="http://esperance.themerella.com/wp-content/uploads/2017/10/responsive@2x-1.svg"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Small Heading Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Small Heading', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/small-headings-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1506339903551{padding-top: 30px !important;padding-bottom: 30px !important;background-color: #f6f7fc !important;}"][vc_column offset="vc_col-md-6"][vc_custom_heading text="Super Retina." use_theme_fonts="yes" css=".vc_custom_1506336146372{margin-top: 0px !important;margin-bottom: 0.3em !important;}"][vc_column_text]<span style="font-size: 18px;">Celebrated her had sentiments understood are projection set. Possession unaffected remarkably at. Talking settled at pleased an of me brother weather.</span>[/vc_column_text][vc_single_image source="external_link" custom_src="http://three.landing.themerella.com/wp-content/uploads/sites/3/2017/09/devices.png"][vc_empty_space height="25px"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Section Templates" font_container="tag:h4|text_align:left" use_theme_fonts="yes" css=".vc_custom_1506336249194{margin-bottom: 0.3em !important;}"][vc_column_text]No coding skills required to create unique sites. Customize your site in real-time.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Live Photos" font_container="tag:h4|text_align:left" use_theme_fonts="yes" css=".vc_custom_1506336309310{margin-bottom: 0.3em !important;}"][vc_column_text]No coding skills required to create unique sites. Customize your site in real-time.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-6"][vc_single_image source="external_link" alignment="center" custom_src="http://three.landing.themerella.com/wp-content/uploads/sites/3/2017/09/image-2.png"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Call to action Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Checkmarks with Tooltips', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/checkmarks-with-tooltips-banners.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" enable_responsive_options="yes" fullpage_brightness="dark" css=".vc_custom_1507579116432{padding-top: 50px !important;padding-bottom: 50px !important;background-color: #574bfc !important;}" fullpage_title="Features" responsive_css="padding_top_tablet:100|padding_bottom_tablet:100|padding_top_mobile:60|padding_bottom_mobile:60" el_id="features"][vc_column enable_responsive_options="yes" offset="vc_col-md-5" responsive_css="margin_bottom_tablet:60|margin_bottom_mobile:60" css=".vc_custom_1507291025447{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css_animation="fadeInUp"][vc_custom_heading text="Hyper-Reality." font_container="tag:h2|font_size:55px|text_align:left|color:%23ffffff|line_height:71px" use_theme_fonts="yes" css=".vc_custom_1507222055260{margin-top: 0px !important;margin-bottom: 0.3em !important;}"][/vc_column_inner][vc_column_inner css_animation="fadeInUp" delay="300"][vc_column_text]<span style="color: rgba(255, 255, 255, 0.65); font-size: 18px;">Proin fermentum metus at blandit muspendisse aliquet, libero non dictum mollis amelia.</span>[/vc_column_text][/vc_column_inner][vc_column_inner css_animation="fadeInUp" delay="550"][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="Sed est tellus, vulputate sit amet justo" i_icon_fontawesome="fa fa-check" icon_color="#2ce6a2" icon_fs="18px" title_color="rgba(255,255,255,0.65)" css=".vc_custom_1507222252230{margin-bottom: 10px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="Nullam ullamcorper, metus" i_icon_fontawesome="fa fa-check" icon_color="#2ce6a2" icon_fs="18px" title_color="rgba(255,255,255,0.65)" css=".vc_custom_1507222271975{margin-bottom: 10px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="Aron rhoncus placerat auctor nibh" i_icon_fontawesome="fa fa-check" icon_color="#2ce6a2" icon_fs="18px" title_color="rgba(255,255,255,0.65)" css=".vc_custom_1507222291576{margin-bottom: 30px !important;}"][/ra_icon_box][vc_empty_space height="10px"][/vc_column_inner][vc_column_inner css_animation="fadeInUp" delay="850"][ra_button style="btn-default" lightbox="yes" lightbox_type="video" curtain_hover="left" size="btn-lg" border="border-thicker" i_type="fontawesome" i_align="right" title="Play Video" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" hbg="rgba(255,255,255,0.01)" curtain_hbg="#ffffff" htext_color="#6258fc" fw="600" primary_color="#ffffff" hbc="#ffffff" i_icon_fontawesome="fa fa-youtube-play" i_ml="10px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css_animation="bottom-to-top" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1507273780098{padding-top: 0px !important;}"][ra_tooltiped_image image="http://one.themerella.com/wp-content/uploads/2017/10/vr.svg"][ra_pointer_tooltip title="Hyper-reality" top="24%" left="24%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][ra_pointer_tooltip position="align-bottom" title="Premium Steel" top="50%" left="28%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][ra_pointer_tooltip title="Natural gestures" top="73%" left="65%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][ra_pointer_tooltip position="align-bottom" title="Premium Steel" top="10%" right="16%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][/ra_tooltiped_image][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Lightbox Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Lightbox', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/lightbox-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1496940485066{margin-bottom: 30px !important;background-color: #ea3a71 !important;}"][vc_column width="5/12" css=".vc_custom_1496939799519{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_lightbox lightbox_type="video" image="http://boo.themerella.com/wp-content/uploads/2017/06/vr.jpg" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Da38_qR-S8Yo|||"][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1" css=".vc_custom_1496940364496{padding-top: 0px !important;padding-right: 10% !important;}"][vc_custom_heading text="Virtual Reality." font_container="tag:h2|font_size:70px|text_align:left|color:%23ffffff|line_height:1.2em" google_fonts="font_family:Rajdhani%3A300%2Cregular%2C500%2C600%2C700|font_style:700%20bold%20regular%3A700%3Anormal" css=".vc_custom_1496940203929{margin-top: 0px !important;}"][vc_custom_heading text="Humorously perilous business for both of us. For, before we proceed further, it must be said that the monkey-rope was fast at both ends; fast to broad canvas belt, and fast to my narrow leather one." font_container="tag:p|font_size:20px|text_align:left|color:rgba(255%2C255%2C255%2C0.6)|line_height:32px" google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1496940091674{margin-top: 30px !important;}"][ra_button style="btn-underlined" border="border-thick" title="See How It Works" text_color="#ffffff" fs="19px" ls="0.025em"][/vc_column][/vc_row][vc_row][vc_column][vc_empty_space height="800px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Mobile Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Mobile', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/mobile-2-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="bottom" css=".vc_custom_1497023084954{margin-bottom: 30px !important;padding-top: 30px !important;background-color: #ffd267 !important;}"][vc_column css=".vc_custom_1497024454282{padding-bottom: 50px !important;}" offset="vc_col-md-7"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" parallax_duration="0%"][vc_custom_heading text="MOBILE FIRST APPROACH." font_container="tag:p|font_size:14px|text_align:left|color:%231a1a1a|line_height:1.5em" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal" letter_spacing="0.15em" css=".vc_custom_1497022199989{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" css=".vc_custom_1497022377402{padding-top: 0px !important;}" parallax_duration="%"][vc_custom_heading text="200+ Templates." font_container="tag:h3|font_size:60px|text_align:left|color:%231a1a1a|line_height:1.5em" google_fonts="font_family:Hind%3A300%2Cregular%2C500%2C600%2C700|font_style:500%20bold%20regular%3A500%3Anormal" css=".vc_custom_1497022190542{margin-top: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" css=".vc_custom_1497022398010{margin-bottom: 15px !important;}" parallax_duration="0%"][vc_custom_heading text="INTEGRATED WITH LIVE CUSTOMIZER." font_container="tag:p|font_size:14px|text_align:left|color:%231a1a1a|line_height:1.5em" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal" letter_spacing="0.15em"][vc_custom_heading text="Being the savage's bowsman, that is, the person who pulled the bow-oar in his boat was my cheerful duty." font_container="tag:p|font_size:16px|text_align:left|color:rgba(26%2C26%2C26%2C0.8)|line_height:30px" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" parallax_duration="0%"][vc_custom_heading text="CREATIVE APPROACH." font_container="tag:p|font_size:14px|text_align:left|color:%231a1a1a|line_height:1.5em" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal" letter_spacing="0.15em"][vc_custom_heading text="Being the savage's bowsman, that is, the person who pulled the bow-oar in his boat was my cheerful duty." font_container="tag:p|font_size:16px|text_align:left|color:rgba(26%2C26%2C26%2C0.8)|line_height:30px" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" parallax_duration="0%"][ra_button style="btn-solid" shape="circle" size="btn-lg" border="border-thick" text="text-uppercase" title="SEE HOW IT WORKS" primary_color="#ffd267" text_color="#1a1a1a" bc="#1a1a1a" hbg="#0a0a0a" htext_color="#ffffff" hbc="#1a1a1a"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column parallax="yes" parallax_preset="fadeInDownShort" parallax_duration="20%" parallax_offset="-20" offset="vc_col-md-5"][vc_single_image source="external_link" css=".vc_custom_1499160692069{margin-bottom: 0px !important;}" custom_src="http://boo.themerella.com/wp-content/uploads/2017/06/iphone-min.png"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Music Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Music', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/music-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" parallax="content-moving" parallax_speed_bg="1.25" css=".vc_custom_1497525950383{background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/music-banner.jpg?id=) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" css=".vc_custom_1497521623133{padding-top: 0px !important;}" parallax_from="``y``: -150, ``rotationX``: -65, ``opacity``: 0, ``transformOrigin``: ``0% -10%``" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeOut``" parallax_trigger_number="0.4" parallax_offset="250"][vc_custom_heading text="marshall" font_container="tag:h2|font_size:180px|text_align:center|color:%23ffffff" google_fonts="font_family:Damion%3Aregular|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1497520280611{margin-top: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_trigger="onCenter" enable_transform="yes" css=".vc_custom_1497521416012{padding-right: 5% !important;padding-left: 5% !important;}" parallax_from="``y``: -30, ``rotationX``: -55, ``opacity``: 0, ``transformOrigin``: ``0% -10%``" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%"][vc_custom_heading text="Humorously perilous business for both of us. For, before we proceed further, it must be said that the monkey-rope was fast at both ends; fast to broad canvas belt, and fast to my narrow leather one. " font_container="tag:p|font_size:28px|text_align:center|color:rgba(215%2C169%2C169%2C0.55)|line_height:43px" google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1497520533496{margin-bottom: 40px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" align="text-lg-center" parallax_from="``y``: -30, ``rotationX``: -55, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%"][ra_button style="btn-solid" shape="circle" size="btn-sm" border="border-thick" title="Buy Ticket" text_color="#ffffff" bc="rgba(215,169,169,0.46)" primary_color="rgba(255,255,255,0.01)" hbg="#ffffff" htext_color="#000000" hbc="#ffffff" fs="25px" css=".vc_custom_1497520827228{padding-top: 0.15em !important;padding-right: 1.2em !important;padding-bottom: 0.15em !important;padding-left: 1.2em !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Video Background Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Video with background', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/video-with-background-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" parallax="content-moving" parallax_image="" parallax_speed_bg="1.25" css=".vc_custom_1497518837918{margin-bottom: 30px !important;padding-top: 30px !important;padding-bottom: 60px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/video-with-bg.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1497030567950{padding-top: 0px !important;}" offset="vc_col-md-offset-2 vc_col-md-8"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" parallax_time="1.2" parallax_duration="0%"][vc_custom_heading text="Build Better Websites `{`ra_br`}` no coding skills required." font_container="tag:h4|font_size:55px|text_align:center|color:%23ffffff|line_height:68px" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" parallax_time="1.2" parallax_duration="0%"][vc_custom_heading text="?It is not enough that we build products that function, that are understandable and usable." font_container="tag:p|font_size:22px|text_align:center|color:rgba(255%2C255%2C255%2C0.5)|line_height:40px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="2/3" parallax="yes" parallax_preset="fadeInDownShort" offset="vc_col-sm-offset-2" css=".vc_custom_1497030585879{margin-bottom: 30px !important;}" parallax_time="1.2" parallax_duration="0%"][ra_content_box style="s12" show_button="yes" ib_style="btn-play" ib_lightbox="yes" ib_lightbox_type="video" ib_alt_size="btn-md" image="http://boo.themerella.com/wp-content/uploads/2017/06/video-player.jpg" primary_color="#0a0a0a" ib_other="Play" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Da38_qR-S8Yo|||" ib_second_color="#ffffff"][/ra_content_box][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInDownShort" align="text-lg-center" parallax_time="1.2" parallax_duration="0%"][ra_button style="btn-solid" shape="circle" size="btn-xlg" border="border-thick" text="text-uppercase" title="See how it works" primary_color="rgba(255,255,255,0.01)" text_color="#ffffff" bc="#14b39f"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Travel Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Travel', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/travel-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="content-moving" parallax_image="" css=".vc_custom_1497519129116{margin-bottom: 30px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/travel-1.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/3" bg_position="center center" css=".vc_custom_1496929538745{padding-top: 140px !important;padding-bottom: 40px !important;}"][vc_row_inner css=".vc_custom_1496929560264{padding-left: 10% !important;}"][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``y``: 0, ``x``: 60, ``rotationY``: 50, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeInOut``"][vc_custom_heading text="Bahamas" font_container="tag:h5|font_size:48px|text_align:left|color:%237ffaff|line_height:1.25em" google_fonts="" css=".vc_custom_1496923322970{margin-bottom: 20px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``y``: 0, ``x``: 60, ``rotationY``: 50, ``opacity``: 0" parallax_offset="-50" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeInOut``"][vc_custom_heading text="Exotic Trip to Bahamas." font_container="tag:h2|font_size:48px|text_align:left|color:%23fffefe|line_height:54px" google_fonts="" css=".vc_custom_1496923393240{margin-top: 0px !important;margin-bottom: 25px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``y``: 0, ``x``: 60, ``rotationY``: 50, ``opacity``: 0" parallax_offset="-100" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeInOut``"][ra_button style="btn-solid" shape="circle" size="btn-md" title="Starting from $199" primary_color="#7ffaff" text_color="#288083" hbg="#ffffff" htext_color="#288083" fw="500"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Gradient Circles Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Gradient Circles', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/gradient-circles-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" full_height="yes" parallax="content-moving" parallax_image="" parallax_speed_bg="1.25" bg_position="center top" css=".vc_custom_1497516818206{background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/minimal-banner.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1497031134105{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" css=".vc_custom_1497032861904{padding-top: 0px !important;}" parallax_from="``y``: 100, ``rotationX``: -65, ``opacity``: 0, ``transformOrigin``: ``0% 0%``" parallax_offset="-150" parallax_duration="50%" parallax_to="``transformOrigin``: ``0% 0%``"][vc_custom_heading text="REDEFINE." font_container="tag:h2|font_size:200px|text_align:center|color:%23ffffff|line_height:1.5em" google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:800%20bold%20regular%3A800%3Anormal" letter_spacing="-0.02em" css=".vc_custom_1497031405440{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/3" parallax="yes" parallax_preset="custom" enable_transform="yes" offset="vc_col-sm-offset-4" parallax_from="``y``: 100, ``rotationX``: -25, ``opacity``: 0, ``transformOrigin``: ``0% 0%``" parallax_to="``transformOrigin``: ``0% 0%``" parallax_offset="-150" parallax_duration="50%"][vc_custom_heading text="Humorously perilous business for both of us. For, before we proceed further, it must be said that the monkey-rope was fast at both ends; fast to broad canvas belt, and fast to my narrow leather one. So that for better or for worse, we two, for the time, were wedded; and should poor sink to rise no more." font_container="tag:p|font_size:28px|text_align:center|color:rgba(255%2C255%2C255%2C0.8)|line_height:43px" google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Gradient Text Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Gradient Text', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/gradient-text-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" parallax="content-moving" parallax_image="" parallax_speed_bg="1.25" css=".vc_custom_1497517114007{margin-bottom: 30px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/gradient-banner-bg.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``y``: 80, ``rotationX``: -65, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="100%"][vc_row_inner full_width="stretch_row_content"][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``y``: 80, ``rotationX``: -65, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="100%" css=".vc_custom_1497279658919{padding-top: 0px !important;}"][vc_custom_heading text="Simplicity" font_container="tag:h2|font_size:200px|text_align:center|color:%23f67932" google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:800%20bold%20regular%3A800%3Anormal" enable_gradient="yes" enable_fittext="yes" css=".vc_custom_1497279453219{margin-top: 0px !important;margin-bottom: 40px !important;}" gradient_color="linear-gradient(to right,rgb(255, 82, 82) 0%,rgb(238, 165, 15) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" fittex_size="200px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/6" parallax="yes" parallax_preset="custom" parallax_from="``y``: 0, ``scale``: 0.5, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="80%" align="text-lg-center" css=".vc_custom_1497022990123{padding-top: 0px !important;}" offset="vc_col-md-offset-5"][ra_button style="btn-play" lightbox="yes" lightbox_type="video" alt_size="btn-md" other="Play" primary_color="#ffffff" second_color="#000000" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Da38_qR-S8Yo|||"][/vc_column][vc_column css=".vc_custom_1497018008573{margin-top: 80px !important;}"][vc_row_inner][vc_column_inner width="1/2" parallax="yes" parallax_preset="custom" enable_transform="yes" offset="vc_col-md-3" parallax_from="``y``: 40, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%"][vc_custom_heading text="200+ TEMPLATES" font_container="tag:h4|font_size:14px|text_align:left|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.15em" css=".vc_custom_1497016586302{margin-bottom: 25px !important;}"][vc_custom_heading text="Humorously perilous business for both of us. For, before we further
proceed broad canvas." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.75)|line_height:24px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/2" parallax="yes" parallax_preset="custom" parallax_from="``y``: 60, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%" offset="vc_col-md-3"][vc_custom_heading text="200+ TEMPLATES" font_container="tag:h4|font_size:14px|text_align:left|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.15em" css=".vc_custom_1497016586302{margin-bottom: 25px !important;}"][vc_custom_heading text="Humorously perilous business for both of us. For, before we further
proceed broad canvas." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.75)|line_height:24px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/2" parallax="yes" parallax_preset="custom" parallax_from="``y``: 80, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%" offset="vc_col-md-3"][vc_custom_heading text="200+ TEMPLATES" font_container="tag:h4|font_size:14px|text_align:left|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.15em" css=".vc_custom_1497016586302{margin-bottom: 25px !important;}"][vc_custom_heading text="Humorously perilous business for both of us. For, before we further
proceed broad canvas." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.75)|line_height:24px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/2" parallax="yes" parallax_preset="custom" parallax_from="``y``: 100, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%" offset="vc_col-md-3"][vc_custom_heading text="200+ TEMPLATES" font_container="tag:h4|font_size:14px|text_align:left|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.15em" css=".vc_custom_1497016586302{margin-bottom: 25px !important;}"][vc_custom_heading text="Humorously perilous business for both of us. For, before we further
proceed broad canvas." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.75)|line_height:24px" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Bussines Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with Button and Clients', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/business01-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1493277886350{background-image: url(http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/business-banner-bg.jpg) !important;background-position: center;background-repeat: no-repeat;background-size: cover !important;}"][vc_column align="text-center" css=".vc_custom_1487588358583{padding-top: 80px !important;padding-bottom: 65px !important;}"][vc_custom_heading text="First class business solutions since 1980." font_container="tag:h3|text_align:center|color:%23ffffff" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1487590922160{margin-top: 0px !important;margin-bottom: 40px !important;}"][ra_button style="btn-solid" shape="round" size="btn-sm" text="text-uppercase" others="wide" i_type="fontawesome" i_align="right" title="Contact Us" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff" text_color="#000000" hbg="#288fd7"][/vc_column][vc_column][vc_row_inner full_width="stretch_row" css=".vc_custom_1487587409656{background-color: #288fd7 !important;}"][vc_column_inner width="1/4" css=".vc_custom_1487588054577{border-right-width: 1px !important;padding-top: 70px !important;padding-bottom: 30px !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" logo="http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/client14.png" name="Lily" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1487588061379{border-right-width: 1px !important;padding-top: 70px !important;padding-bottom: 30px !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" logo="http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/client15.png" name="Bakeries" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1487588048145{border-right-width: 1px !important;padding-top: 70px !important;padding-bottom: 30px !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" logo="http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/client16.png" name="Fluffy" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1487587884462{padding-top: 70px !important;padding-bottom: 30px !important;}"][ra_client effect="client-opaque-inverted" logo="http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/client17.png" name="Mighty" link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Bussines Banner 02 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Plain with Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/business02-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="" css=".vc_custom_1493372599153{background-image: url(http://business-2.boo.themerella.com/wp-content/uploads/sites/19/2016/11/business-banner-2.jpg) !important;padding-top: 20px !important;padding-bottom: 100px !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}"][vc_column css_animation="none" align="text-center"][ra_banner style="default"][vc_column_text css=".vc_custom_1493372521557{margin-bottom: 40px !important;}"] <h3><span style="color: #ffffff;">First class business solutions since 1980.</span></h3> [/vc_column_text][ra_button style="btn-solid" shape="round" size="btn-xsm" text="text-uppercase" i_type="fontawesome" i_align="right" title="Contact Us" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff" text_color="#000000" htext_color="#ffffff" hbg="#000000" hbc="#000000"][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Featured Item Caroulsel', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/car-dealer-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1496047864215{padding-top: 55px !important;padding-bottom: 105px !important;}"][vc_column][ra_carousel pagedots="yes" align_dots="dots-pushed-left" size_dots="dots-lg"][ra_content_box style="s7" image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer-content-1-1.png" show_button="yes" ib_style="btn-default" ib_shape="round" ib_size="btn-xsm" ib_border="border-thick" ib_text="text-uppercase" title="Build Beautiful Banners" info="Mobile first approach" info2="From $250" ib_title="Download Now" ib_link="url:%23|||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit quis ultrices puruut feugiat augue.[/ra_content_box][ra_content_box style="s7" image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer-content-1-1.png" show_button="yes" ib_style="btn-default" ib_shape="round" ib_size="btn-xsm" ib_border="border-thick" ib_text="text-uppercase" title="Build Beautiful Banners" info="Mobile first approach" info2="From $250" ib_title="Download Now" ib_link="url:%23|||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit quis ultrices puruut feugiat augue.[/ra_content_box][ra_content_box style="s7" image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer-content-1-1.png" show_button="yes" ib_style="btn-default" ib_shape="round" ib_size="btn-xsm" ib_border="border-thick" ib_text="text-uppercase" title="Build Beautiful Banners" info="Mobile first approach" info2="From $250" ib_title="Download Now" ib_link="url:%23|||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit quis ultrices puruut feugiat augue.[/ra_content_box][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Car Dealer Banner 02 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Split', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/car-dealer-banner-2.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes"][vc_column width="1/2" css=".vc_custom_1485525512981{padding-top: 60px !important;padding-right: 10% !important;padding-bottom: 85px !important;padding-left: 10% !important;background-image: url(http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer-banner2.png?id=12) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_icon type="linea" icon_linea="icon-linear-sedan" color="white" size="xl" css=".vc_custom_1494310730681{margin-left: 25px !important;}"][vc_custom_heading text="Are you looking to buy" font_container="tag:h2|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485524939639{margin-bottom: 30px !important;}"][vc_custom_heading text="Wizard it here to help you" font_container="tag:h6|font_size:13px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485750437331{margin-bottom: 30px !important;}"][vc_custom_heading text="Donec eleifend libero eu tortor mattis, vesti esa tortor finibus. Pellentesque mattis dapibus." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css=".vc_custom_1494310786779{margin-right: 20% !important;margin-bottom: 30px !important;}"][ra_button style="btn-solid" shape="round" size="btn-xsm" text="text-uppercase" i_type="fontawesome" i_align="right" title="Buy Now" i_icon_fontawesome="fa fa-angle-right" fw="700" primary_color="#ffffff" hbg="#272b31" text_color="#000000" htext_color="#ffffff"][/vc_column][vc_column width="1/2" css=".vc_custom_1485524410829{padding-top: 60px !important;padding-right: 10% !important;padding-bottom: 85px !important;padding-left: 10% !important;background-color: #272c32 !important;}"][vc_icon type="linea" icon_linea="icon-sportcar" color="white" size="xl" css=".vc_custom_1494310717109{margin-left: 25px !important;}"][vc_custom_heading text="Sell it easily" font_container="tag:h2|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485525609606{margin-bottom: 30px !important;}"][vc_custom_heading text="Request a quote for you now." font_container="tag:h6|font_size:13px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485750451728{margin-bottom: 30px !important;}"][vc_custom_heading text="Donec eleifend libero eu tortor mattis, vesti esa tortor finibus. Pellentesque mattis dapibus." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css=".vc_custom_1494310777161{margin-right: 20% !important;margin-bottom: 30px !important;}"][ra_button style="btn-solid" shape="round" size="btn-xsm" text="text-uppercase" i_type="fontawesome" i_align="right" title="Sell Now" i_icon_fontawesome="fa fa-angle-right" fw="700" primary_color="#ffffff" hbg="#d72828" text_color="#0a0a0a" htext_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Banner 03 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with Checkmarks and Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/car-dealer-banner-3.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes"][vc_column width="7/12" offset="vc_col-lg-5"][ra_banner style="s8" css=".vc_custom_1485545214171{padding-top: 50px !important;background-color: #d72727 !important;}"][vc_row_inner equal_height="yes"][vc_column_inner css=".vc_custom_1485533898100{padding-top: 0px !important;}"][vc_custom_heading text="Trusted Experience" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485545119846{margin-top: 0px !important;margin-bottom: 25px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="Premium cars, simple pricing." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" title_color="rgba(255,255,255,0.75)" icon_fs="17px" title_size="15px" css=".vc_custom_1491981234304{margin-bottom: 20px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="Car advise from professional team." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" title_color="rgba(255,255,255,0.75)" icon_fs="17px" title_size="15px" css=".vc_custom_1491981248500{margin-bottom: 20px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="Easy financing options." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" title_color="rgba(255,255,255,0.75)" icon_fs="17px" title_size="15px" css=".vc_custom_1491981259845{margin-bottom: 20px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="Trusted experience since 2007." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" title_color="rgba(255,255,255,0.75)" icon_fs="17px" title_size="15px" css=".vc_custom_1491981271827{margin-bottom: 20px !important;}"][/ra_icon_box][ra_button style="btn-solid" shape="round" size="btn-xsm" text="text-uppercase" title="Contact Us" hbg="#0a0a0a" htext_color="#ffffff" primary_color="#ffffff" text_color="#0a0a0a"][/vc_column_inner][/vc_row_inner][/ra_banner][/vc_column][vc_column width="5/12" css=".vc_custom_1485761699135{padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer-banner3.png?id=21) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-lg-7"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with Checkmarks', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/car-rental-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485753130981{padding-top: 45px !important;padding-bottom: 100px !important;}"][vc_column css=".vc_custom_1485758868874{padding-right: 40px !important;}" offset="vc_col-lg-6"][vc_row_inner css=".vc_custom_1483612087247{margin-right: 0px !important;margin-left: 0px !important;border-bottom-width: 1px !important;padding-top: 10px !important;padding-right: 0px !important;padding-bottom: 10px !important;padding-left: 0px !important;border-bottom-color: rgba(0,0,0,0.1) !important;border-bottom-style: solid !important;}"][vc_column_inner css=".vc_custom_1483611605453{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="100+ cars available for booking." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#efa810" icon_fs="17px" title_size="18px" title_color="#063869"][/ra_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1483612280762{margin-right: 0px !important;margin-left: 0px !important;border-bottom-width: 1px !important;padding-top: 20px !important;padding-right: 0px !important;padding-bottom: 10px !important;padding-left: 0px !important;border-bottom-color: rgba(0,0,0,0.1) !important;border-bottom-style: solid !important;}"][vc_column_inner css=".vc_custom_1483611605453{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title=" Premium cars, simple pricing." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#efa810" icon_fs="17px" title_size="18px" title_color="#063869"][/ra_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1484543938329{margin-right: 0px !important;margin-left: 0px !important;border-bottom-width: 1px !important;padding-top: 20px !important;padding-right: 0px !important;padding-bottom: 10px !important;padding-left: 0px !important;border-bottom-color: rgba(0,0,0,0.1) !important;border-bottom-style: solid !important;}"][vc_column_inner css=".vc_custom_1483611605453{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title=" Flexible reservation and return hours." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#efa810" icon_fs="17px" title_size="18px" title_color="#063869"][/ra_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1484543945327{margin-right: 0px !important;margin-left: 0px !important;border-bottom-width: 1px !important;padding-top: 20px !important;padding-right: 0px !important;padding-bottom: 10px !important;padding-left: 0px !important;border-bottom-color: rgba(0,0,0,0.1) !important;border-bottom-style: solid !important;}"][vc_column_inner css=".vc_custom_1483611605453{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title=" No hidden fees, simple policy." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#efa810" icon_fs="17px" title_size="18px" title_color="#063869"][/ra_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1484543951083{margin-right: 0px !important;margin-left: 0px !important;padding-top: 20px !important;padding-right: 0px !important;padding-bottom: 10px !important;padding-left: 0px !important;}"][vc_column_inner css=".vc_custom_1483611605453{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-semibold" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title=" Car advise from professionals." i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#efa810" icon_fs="17px" title_size="18px" title_color="#063869"][/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-lg-6"][vc_single_image source="external_link" alignment="center" custom_src="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/car-rental-1.png"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Banner 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with Featured Item', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/car-rental-banner-2.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484543564447{padding-top: 55px !important;padding-bottom: 75px !important;}"][vc_column][ra_content_box style="s8" show_button="yes" ib_style="btn-default" ib_shape="round" ib_size="btn-sm" ib_border="border-thick" ib_text="text-uppercase" title="Build Beautiful Banners" info="Mobile first approach" ib_title="Download Now" ib_link="url:%23|||" info2="<strong>$200</strong> / month" image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/Untitled-1.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit quis ultrices puruut feugiat augue.[/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with Detailed Content', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/corporate01-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485779217308{background-image: url(http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/banner-bg5.png) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center" css=".vc_custom_1485779262016{padding-top: 0px !important;}"][ra_banner style="s14"][vc_custom_heading text="Business" font_container="tag:h6|text_align:center" use_theme_fonts="yes"][vc_custom_heading text="Let your business to grow with us." font_container="tag:h2|text_align:center" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1493103072448{margin-bottom: 40px !important;}"]<span style="color: #b9c3d4;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec mollis inleo sit amet dapibus.</span> <span style="color: #b9c3d4;">Ut pulvinar enim in urna rhoncus congue.</span>[/vc_column_text][ra_button style="btn-solid" shape="round" size="btn-lg" text="text-uppercase" i_type="fontawesome" i_align="right" title="Learn More" link="url:%23|||" i_icon_fontawesome="fa fa-long-arrow-right" text_color="#ffffff" primary_color="#50ba26" fw="700"][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Corporate Banner 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with Background Image, Clients and Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/corporate02-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485864420333{padding-top: 45px !important;padding-bottom: 0px !important;background-image: url(http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/banner-bg9.png?id=17) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1479470921033{padding-top: 0px !important;}"][vc_row_inner css=".vc_custom_1485864512827{padding-bottom: 25px !important;}"][vc_column_inner align="text-center"][vc_custom_heading text="Have a project in mind?" font_container="tag:h2|text_align:center|color:%23ffffff|line_height:75px" use_theme_fonts="yes" css=".vc_custom_1485864641760{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_button style="btn-solid" shape="round" size="btn-lg" text="text-uppercase" i_type="fontawesome" i_align="right" title="Work with us" i_icon_fontawesome="fa fa-angle-right" primary_color="#f2774b" text_color="#ffffff" htext_color="#ffffff" fw="bold"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][vc_row_inner full_width="stretch_row" css=".vc_custom_1485849064661{border-top-width: 1px !important;border-top-color: rgba(255,255,255,0.4) !important;border-top-style: solid !important;}"][vc_column_inner width="1/4" align="text-center" css=".vc_custom_1486125320992{border-right-width: 1px !important;padding-top: 60px !important;padding-bottom: 60px !important;border-right-color: rgba(255,255,255,0.4) !important;border-right-style: solid !important;}"][ra_client effect="" logo="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/client14.png" name="Lilys" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" align="text-center" css=".vc_custom_1486125329485{border-right-width: 1px !important;padding-top: 60px !important;padding-bottom: 60px !important;border-right-color: rgba(255,255,255,0.4) !important;border-right-style: solid !important;}"][ra_client effect="" logo="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/client15.png" name="Bakeris" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" align="text-center" css=".vc_custom_1486125343776{border-right-width: 1px !important;padding-top: 60px !important;padding-bottom: 60px !important;border-right-color: rgba(255,255,255,0.4) !important;border-right-style: solid !important;}"][ra_client effect="" logo="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/client16.png" name="Fluffy" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" align="text-center" css=".vc_custom_1486125350518{padding-top: 60px !important;padding-bottom: 60px !important;}"][ra_client effect="" logo="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/client17.png" name="Migh" link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Banner 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Plain', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/corporate02-banner-2.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485846874171{padding-top: 125px !important;padding-bottom: 120px !important;background-image: url(http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/banner-bg8.png?id=13) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css_animation="fadeInDown" css=".vc_custom_1479469127439{padding-top: 0px !important;}"][vc_custom_heading text="Improve your business with us." font_container="tag:h2|text_align:center|color:%23ffffff|line_height:75px" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Banner 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Classic Center', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/corporate03-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="" css=".vc_custom_1493134687920{padding-top: 80px !important;padding-bottom: 130px !important;background-image: url(http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/bg-39.png?id=31) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}"][vc_column css_animation="bottom-to-top" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8"][vc_custom_heading text="First class consulatation solutions." font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1487418490229{margin-top: 0px !important;margin-bottom: 30px !important;}"][vc_column_text css=".vc_custom_1493130182427{margin-right: 16% !important;margin-bottom: 45px !important;margin-left: 16% !important;}"]<span style="color: #bdddee;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. fusce lacus, egestas eget viverra lorem ipsum dolor sit amet.</span>[/vc_column_text][ra_button style="btn-solid" shape="circle" others="wide" text="text-uppercase" i_type="fontawesome" i_align="right" title="Learn More" i_icon_fontawesome="fa fa-angle-right" i_ml="15px" primary_color="#ffffff" text_color="#088ace" htext_color="#088ace" fs="13px" fw="600" ls="0.15em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Gradient with Clients and Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/elegant-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gradient_bg="yes" css=".vc_custom_1488395914875{padding-bottom: 0px !important;}" gradient_bg_color="linear-gradient(180deg,rgb(178, 137, 242) 0%,rgb(142, 84, 233) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column align="text-center" css=".vc_custom_1485764565331{padding-top: 15px !important;padding-bottom: 60px !important;}"][vc_column_text css=".vc_custom_1487143775269{margin-bottom: 32px !important;}"] <h2><span style="color: #ffffff;">Have a project in mind ?</span></h2> [/vc_column_text][ra_button style="classic-date-featured" shape="circle" size="btn-lg" border="border-thicker" text="text-uppercase" others="wide" primary_color="#ffffff" hbg="#ffffff" text_color="#ffffff" htext_color="#0a0a0a" bc="#ffffff" title="Contact us" fs="14px" fw="700"][/vc_column][vc_column][vc_row_inner full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1485775060851{border-top-width: 1px !important;border-top-color: rgba(255,255,255,0.25) !important;border-top-style: solid !important;border-radius: 1px !important;}"][vc_column_inner width="1/4" css=".vc_custom_1485775075195{border-right-width: 1px !important;padding-top: 60px !important;padding-bottom: 35px !important;border-right-color: rgba(255,255,255,0.25) !important;border-right-style: solid !important;border-radius: 1px !important;}"][ra_client effect="client-opaque-inverted" name="Lilys" logo="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/client14.png" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1485775087317{border-right-width: 1px !important;padding-top: 50px !important;padding-bottom: 35px !important;border-right-color: rgba(255,255,255,0.25) !important;border-right-style: solid !important;border-radius: 1px !important;}"][ra_client effect="client-opaque-inverted" name="Bakeris" logo="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/client15.png" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1485775100617{border-right-width: 1px !important;padding-top: 50px !important;padding-bottom: 35px !important;border-right-color: rgba(255,255,255,0.25) !important;border-right-style: solid !important;border-radius: 1px !important;}"][ra_client effect="client-opaque" name="Fluffy" logo="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/FLUFFY.png" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1484755636690{padding-top: 50px !important;padding-bottom: 35px !important;}"][ra_client effect="client-opaque-inverted" name="Migh" logo="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/tailormadeiea.png" link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with Text Boxes', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/lawyer-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1486023896156{border-bottom-width: 3px !important;padding-top: 135px !important;padding-bottom: 0px !important;border-bottom-color: #ef4c31 !important;border-bottom-style: solid !important;}"][vc_column css=".vc_custom_1485340317268{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 0px !important;border-left-color: #ededed !important;border-left-style: solid !important;border-right-color: #ededed !important;border-right-style: solid !important;border-top-color: #ededed !important;border-top-style: solid !important;border-bottom-color: #ededed !important;border-bottom-style: solid !important;}"][vc_row_inner][vc_column_inner width="1/2" align="text-center" css=".vc_custom_1486023845832{border-right-width: 1px !important;padding-top: 10px !important;padding-right: 20px !important;padding-bottom: 30px !important;padding-left: 20px !important;border-right-color: #ededed !important;border-right-style: solid !important;}" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0"][vc_custom_heading text="Boo History" font_container="tag:h4|text_align:center|color:%23000000" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485420064367{margin-bottom: 20px !important;}"] <p style="text-align: center;">Claritas est etiam processus dynamicus, sequitur muationem consuetudium lectorum.</p> [/vc_column_text][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Boo about" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" fs="15px" htext_color="#333333" fw="600"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" css=".vc_custom_1486023838850{border-right-width: 1px !important;padding-top: 10px !important;padding-right: 20px !important;padding-bottom: 30px !important;padding-left: 20px !important;border-right-color: #ededed !important;border-right-style: solid !important;}" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6"][vc_custom_heading text="Boo Vision" font_container="tag:h4|text_align:center|color:%23000000" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485420214682{margin-bottom: 20px !important;}"] <p style="text-align: center;">Claritas est etiam processus dynamicus, sequitur muationem consuetudium lectorum.</p> [/vc_column_text][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Boo Vision" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" fs="15px" htext_color="#333333" fw="600"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" css=".vc_custom_1486023658944{border-right-width: 1px !important;padding-top: 10px !important;padding-right: 20px !important;padding-bottom: 30px !important;padding-left: 20px !important;border-right-color: #ededed !important;border-right-style: solid !important;}" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6"][vc_custom_heading text="Boo Mission" font_container="tag:h4|text_align:center|color:%23000000" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485420225436{margin-bottom: 20px !important;}"] <p style="text-align: center;">Claritas est etiam processus dynamicus, sequitur muationem consuetudium lectorum.</p> [/vc_column_text][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Boo Mission" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" fs="15px" htext_color="#333333" fw="600"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" css=".vc_custom_1486020628945{border-bottom-width: 1px !important;padding-top: 10px !important;padding-right: 20px !important;padding-bottom: 30px !important;padding-left: 20px !important;}" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6"][vc_custom_heading text="Boo History" font_container="tag:h4|text_align:center|color:%23000000" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485420234305{margin-bottom: 20px !important;}"] <p style="text-align: center;">Claritas est etiam processus dynamicus, sequitur muationem consuetudium lectorum.</p> [/vc_column_text][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Boo Trust" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" fs="15px" htext_color="#333333" fw="600"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1486025056234{margin-bottom: 160px !important;border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 30px !important;border-left-color: #ededed !important;border-left-style: solid !important;border-right-color: #ededed !important;border-right-style: solid !important;border-top-color: #ededed !important;border-top-style: solid !important;border-bottom-color: #ededed !important;border-bottom-style: solid !important;}"][vc_column css=".vc_custom_1486024934584{padding-top: 0px !important;}" offset="vc_col-md-3"][vc_single_image source="external_link" alignment="center" custom_src="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/lawyer-person1.png"][/vc_column][vc_column css=".vc_custom_1486024948869{padding-top: 0px !important;}" offset="vc_col-md-9"][vc_custom_heading text="Boo is here to help you." font_container="tag:p|font_size:18px|text_align:left|color:%23e34025" use_theme_fonts="yes" css=".vc_custom_1486024248087{margin-top: 30px !important;margin-bottom: 10px !important;}"][vc_custom_heading text="Free consultation from attorneys." font_container="tag:h2|text_align:left|color:%23000000" use_theme_fonts="yes" css=".vc_custom_1485432773465{margin-top: 0px !important;margin-bottom: 10px !important;}"][vc_column_text css=".vc_custom_1485437461622{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vieu eleifend massa congue sed.[/vc_column_text][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1486025335205{padding-bottom: 70px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-3 vc_col-md-4"][ra_button style="btn-default" shape="round" size="btn-sm2" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" i_icon_fontawesome="fa fa-angle-right" htext_color="#ffffff" title="Consult Boo" fs="16px" fw="600" ls="0.1em" i_ml="15px"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-9 vc_col-md-8"][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-semibold" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" i_icon_fontawesome="fa fa-phone" icon_fs="16px" icon_color="#000000" content_size="16px" content_color="#000000" title="CALL US 233 99 22" title_size="16px" css=".vc_custom_1487256703311{margin-bottom: 0px !important;margin-left: 20px !important;}"][/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Minimal with Call to Action', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/main-banner-2.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces"][vc_column align="text-center" css=".vc_custom_1489502385447{margin-bottom: 160px !important;}"][ra_button style="btn-v-line" vline_direction="line-bottom" text="text-uppercase" title="Like what you see?" link="url:%23|||" text_color="#000000"][/vc_column][vc_column align="text-center"][ra_button style="btn-solid" others="btn-block" i_type="linea" i_align="right" enable_gradient="yes" enable_hover_gradient="yes" title="Build Your Dream Site Today." link="url:%23|||" fs="25px" lh="3.65em" i_ml="20px" i_icon_linea="icon-linear-checkmark-circle" i_color="#ffffff" fw="400" ls="-0.6px" gradient_color="linear-gradient(137deg,rgb(244, 41, 89) 0%,rgb(232, 66, 39) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" hbg_gradient="linear-gradient(137deg,rgb(232, 66, 39) 0%,rgb(244, 41, 89) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Banner 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Classic Left', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/mobile-banner-3.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485969292726{padding-top: 45px !important;padding-bottom: 80px !important;background-color: #fcfcfc !important;}"][vc_column css_animation="none" css=".vc_custom_1485354740085{padding-top: 0px !important;}"][ra_banner style="s1"][vc_row_inner][vc_column_inner width="1/2" css=".vc_custom_1485969285805{padding-top: 45px !important;}"][vc_column_text] <h6>Cross Platform</h6> <h4>Available on all platforms.</h4> At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque. Eallentesque sagittis neque vel consectetur suscipit. Quisque vel nisi est. Sed a egestas ante. Nam rhoncus sit amet sem ut suscipit. Etiam convallis odio.[/vc_column_text][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Purchase" i_icon_fontawesome="fa fa-angle-right" fs="14px" fw="500"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485356825864{margin-top: 60px !important;}"][vc_single_image source="external_link" alignment="center" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/watch.png"][/vc_column_inner][/vc_row_inner][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Banner 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Video Player', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/mobile-banner-4.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gradient_bg="yes" css=".vc_custom_1485969152699{padding-top: 30px !important;padding-bottom: 0px !important;}" gradient_bg_color="linear-gradient(to bottom right,rgb(114, 142, 249) 1.6%,rgb(57, 165, 248) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column css_animation="none"][ra_banner style="s1"][vc_row_inner][vc_column_inner width="5/12" css=".vc_custom_1485356934763{margin-top: 50px !important;}"][ra_button style="btn-play" lightbox="yes" lightbox_type="video" alt_size="btn-md" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWVPRkcczXCY|||"][vc_column_text] <h6><span style="color: #ffffff;">FREE SUPPORT</span></h6> [/vc_column_text][ra_section_title style="classic6" title="Easy to install." alignment="align-left" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:rgba(255%2C255%2C255%2C0.6)" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, eiusmod tempor incididunt ut labore et dolore enim,[/ra_section_title][/vc_column_inner][vc_column_inner width="7/12" css=".vc_custom_1485355673251{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_single_image source="external_link" alignment="center" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/mobile-img-4.png"][/vc_column_inner][/vc_row_inner][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Restaurant Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Elegant', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/restaurant-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="" parallax_speed_bg="1.2" css=".vc_custom_1484124850550{margin-bottom: 100px !important;background-image: url(http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/restaurant-bg1.jpg?id=13) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="5/6" offset="vc_col-sm-offset-1" css=".vc_custom_1480060616610{padding-top: 0px !important;}"][ra_banner style="s9"][vc_column_text]<span style="color: #ffffff;">Best in Town</span> <h2><span style="color: #ffffff;">Good Food is our Passion.</span></h2> <h3><span style="color: #ffffff;">it is all about food.</span></h3> [/vc_column_text][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Minimal Banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Minimal', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/shop-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="" parallax_speed_bg="1.2" css=".vc_custom_1492518608333{padding-top: 95px !important;padding-bottom: 110px !important;background-image: url(http://womens-shop.boo.themerella.com/wp-content/uploads/sites/22/2016/12/womens-shop-bg1.jpg?id=17) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}"][vc_column width="1/3" el_class="align-center" css=".vc_custom_1484648807739{padding-top: 0px !important;}"][ra_banner style="default" el_class="text-center"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499159990135{margin-top: 0px !important;margin-bottom: 0px !important;}" custom_src="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/banner-logo.png"][vc_column_text]2 0 1 7 <h4>Autumn Collection</h4> [/vc_column_text][/ra_banner][ra_button style="btn-underlined" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="Shop now" i_icon_fontawesome="fa fa-long-arrow-right" text_color="#0a0a0a" htext_color="#0a0a0a" bc="#0a0a0a" hbc="#0a0a0a" el_class="mt-20" i_ml="10px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//With play button banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with play button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/with-play-button-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" parallax="content-moving" css=".vc_custom_1498152270830{margin-bottom: 60px !important;background-image: url(http://universe-presentation.boo.themerella.com/wp-content/uploads/sites/87/2017/06/universe-presentation.jpg?id=331) !important;background-position: 0 0;background-repeat:-repeat !important;}"][vc_column parallax="yes" width="5/6" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="0" parallax_trigger="number" enable_transform="yes" parallax_duration="70%" parallax_trigger_number="0.2" offset="vc_col-md-offset-0 vc_col-md-7 vc_col-sm-offset-1" translate_to_y="151" rotate_to_x="35"][vc_column_text] <h1><span style="color: #ffffff;">Build Better Websites. <br/><span style="font-family: Playfair Display; font-style: italic;">no coding skills</span> Required.</span></h1> [/vc_column_text][vc_custom_heading text="Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or impression by terminated. Old pleasure." font_container="tag:p|font_size:23px|text_align:left|color:rgba(255%2C255%2C255%2C0.7)|line_height:1.73em" use_theme_fonts="yes" css=".vc_custom_1497260651285{margin-right: 15% !important;}" letter_spacing="0.37px"][/vc_column][vc_column parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_responsive_options="yes" align="text-lg-center" css=".vc_custom_1497946484923{padding-top: 170px !important;}" parallax_from="``y``: 0, ``opacity``: 1" parallax_to="``y``: 150, ``opacity``: 0, ``ease``: ``Linear.easeNone``" parallax_duration="70%" parallax_trigger_number="0.2" offset="vc_col-md-5 vc_hidden-sm vc_hidden-xs" responsive_css="padding_top_tablet:30|padding_top_mobile:30"][ra_button style="btn-play" lightbox="yes" lightbox_type="video" alt_size="btn-md" other="Play" primary_color="#1254fd" text_color="#ffffff" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
//With play button banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with play button 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/with-play-button-2-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" parallax="content-moving" parallax_speed_bg="1.25" css=".vc_custom_1499170122668{margin-bottom: 45px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/woman.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="2/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" css=".vc_custom_1497445738608{margin-left: 0px !important;padding-left: 0px !important;}" parallax_from="``y``: 0, ``opacity``: 1" parallax_to="``y``: 150, ``opacity``: 0" parallax_trigger_number="0.3" parallax_duration="70%"][vc_custom_heading text="?Simplicity is about subtracting the obvious and adding the meaningful.?" font_container="tag:h1|font_size:50px|text_align:left|color:%2346dfb4|line_height:1.2363em" use_theme_fonts="yes"][vc_custom_heading text="?It is not enough that we build products that function, that are understandable and usable, we also need to build products that bring joy and excitement." font_container="tag:h3|font_size:18px|text_align:left|color:rgba(255%2C255%2C255%2C0.7)|line_height:1.73em" use_theme_fonts="yes" css=".vc_custom_1497358442562{margin-right: 15% !important;}"][/vc_column][vc_column width="1/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" align="text-lg-center" parallax_from="``y``: 0, ``opacity``: 1" parallax_to="``y``: 150, ``opacity``: 0" parallax_trigger_number="0.3" parallax_duration="70%"][ra_button style="btn-play" alt_size="btn-md" other="Play" primary_color="#2333dd" text_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

//With play button 3 banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with play button 3', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/with-play-button-3-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row parallax="content-moving" parallax_image="" css=".vc_custom_1497515175315{margin-bottom: 30px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/video-banner.jpg?id=) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="2/3" offset="vc_col-md-offset-2" align="text-lg-center" css=".vc_custom_1496933429657{padding-top: 60px !important;padding-bottom: 80px !important;}"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``rotationX``: 65, ``y``: 60, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeInOut``"][vc_custom_heading text="Build Better Websites" font_container="tag:h5|font_size:34px|text_align:center|color:%23ffffff|line_height:1.2em" google_fonts="font_family:Muli%3A300%2C300italic%2Cregular%2Citalic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1496931421045{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``rotationX``: 65, ``y``: 60, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeInOut``" css=".vc_custom_1496929913113{padding-top: 0px !important;}"][vc_custom_heading text="no coding skills <b>required.</b>" font_container="tag:h5|font_size:34px|text_align:center|color:%23ffffff|line_height:1.2em" google_fonts="font_family:Muli%3A300%2C300italic%2Cregular%2Citalic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1496931440845{margin-top: 10px !important;margin-bottom: 30px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``rotationX``: 65, ``y``: 60, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeInOut``" css=".vc_custom_1496929920509{padding-top: 0px !important;}"][vc_custom_heading text="It is not enough that we build products that function, that are understandable and usable." font_container="tag:p|font_size:18px|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes" css=".vc_custom_1496931277616{margin-top: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" css=".vc_custom_1496930185256{padding-top: 0px !important;}" parallax_from="``rotationX``: 65, ``y``: 60, ``opacity``: 0" parallax_duration="0%" parallax_to="``ease``: ``Quint.easeInOut``"][ra_button style="btn-play" lightbox="yes" lightbox_type="video" alt_size="btn-md" other="Play" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Da38_qR-S8Yo|||" primary_color="#1254fd" second_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//With rounded button banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner with rounded button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/with-rounded-button-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" css=".vc_custom_1497281617527{margin-top: 107px !important;margin-bottom: -1px !important;background-image: url(http://universe-presentation.boo.themerella.com/wp-content/uploads/sites/87/2017/06/daniel-frank-225183@2x.jpg?id=116) !important;background-position: center;background-repeat: no-repeat;background-size:cover;}"][vc_column width="2/3" offset="vc_col-md-offset-2" align="text-lg-center" css=".vc_custom_1497878293204{padding-top: 60px !important;padding-bottom: 100px !important;}"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeInOut" enable_transform="yes" parallax_duration="0%" translate_from_y="61" rotate_from_x="65"][vc_column_text] <h1 style="text-align: center;"><span style="color: #ffffff; font-size: 42px;">Build Better Websites. <span style="font-family: Playfair Display; font-style: italic;">no coding skills</span> Required.</span></h1> [/vc_column_text][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeInOut" css=".vc_custom_1500970678989{padding-top: 0px !important;}" parallax_duration="0%" translate_from_y="61" rotate_from_x="65"][ra_button style="btn-solid" lightbox="yes" lightbox_type="video" shape="circle" size="btn-xlg" border="border-thick" text="text-uppercase" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" title="See How it Works" text_color="#ffffff" bc="#1254fd" primary_color="rgba(255,255,255,0.01)" hbg="#1254fd" htext_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Zig zag banner vc-template
	$data = array();
	$data['name'] = esc_html__( 'Banner Zig Zag', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/banners/zig-zag-banner.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column css=".vc_custom_1497275709661{margin-bottom: 0px !important;}" offset="vc_col-md-6"][ra_content_box style="s12" image="http://boo.themerella.com/wp-content/uploads/2017/06/zig-zag-1.jpg" primary_color="#ffffff"][/ra_content_box][/vc_column][vc_column css=".vc_custom_1497275717669{padding-right: 12% !important;padding-left: 12% !important;background-color: #f6f8fb !important;}" offset="vc_col-md-6"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" css=".vc_custom_1500970475604{padding-top: 0px !important;}" parallax_duration="0%" parallax_time="2" translate_from_y="151"][vc_custom_heading text="MODERNISM REDEFINED" font_container="tag:h5|font_size:14px|text_align:left|color:rgba(0%2C0%2C0%2C0.35)|line_height:1.5em" google_fonts="font_family:Nunito%3A300%2Cregular%2C600%2C700|font_style:400%20regular%3A400%3Anormal" letter_spacing="0.15em"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" css=".vc_custom_1500970489785{padding-top: 0px !important;}" parallax_duration="0%" parallax_time="2" translate_from_y="151"][vc_custom_heading text="Simplicity is about adding the meaningful." font_container="tag:h2|font_size:42px|text_align:left|color:%23000000|line_height:62px" use_theme_fonts="yes" css=".vc_custom_1497262369093{margin-bottom: 25px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" css=".vc_custom_1500970508031{padding-top: 0px !important;}" parallax_duration="0%" parallax_time="2" translate_from_y="151"][vc_custom_heading text="Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or impression by terminated. Old pleasure required removing elegance him had. Down she bore sing saw calm high." font_container="tag:p|font_size:16px|text_align:left|color:%23737e80|line_height:32px" google_fonts="font_family:Muli%3A300%2C300italic%2Cregular%2Citalic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1497270909854{margin-bottom: 0px !important;}"][vc_column css=".vc_custom_1497275728950{padding-right: 12% !important;padding-left: 12% !important;background-color: #f6f8fb !important;}" offset="vc_col-md-6"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" css=".vc_custom_1500970524295{padding-top: 0px !important;}" parallax_duration="0%" parallax_time="2" translate_from_y="150"][vc_custom_heading text="MODERNISM REDEFINED" font_container="tag:h5|font_size:14px|text_align:left|color:rgba(0%2C0%2C0%2C0.35)|line_height:1.5em" google_fonts="font_family:Nunito%3A300%2Cregular%2C600%2C700|font_style:400%20regular%3A400%3Anormal" letter_spacing="0.15em"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" css=".vc_custom_1500970551843{padding-top: 0px !important;}" parallax_duration="0%" parallax_time="2" translate_from_y="151"][vc_custom_heading text="Simplicity is about adding the meaningful." font_container="tag:h2|font_size:42px|text_align:left|color:%23000000|line_height:62px" use_theme_fonts="yes" css=".vc_custom_1497262369093{margin-bottom: 25px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" css=".vc_custom_1500970566935{padding-top: 0px !important;}" parallax_duration="0%" parallax_time="2" translate_from_y="151"][vc_custom_heading text="Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or impression by terminated. Old pleasure required removing elegance him had. Down she bore sing saw calm high." font_container="tag:p|font_size:16px|text_align:left|color:%23737e80|line_height:32px" google_fonts="font_family:Muli%3A300%2C300italic%2Cregular%2Citalic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" css=".vc_custom_1496947065122{padding-right: 0px !important;padding-left: 0px !important;}"][ra_content_box style="s12" show_button="yes" ib_style="btn-solid" ib_shape="circle" ib_size="btn-lg" ib_text="text-uppercase" image="http://boo.themerella.com/wp-content/uploads/2017/06/zig-zag-2.jpg" primary_color="#ffffff" ib_title="Read about us" ib_text_color="#000000" ib_hbg="#000000" ib_htext_color="#ffffff" ib_link="url:http%3A%2F%2Funiverse-presentation.boo.themerella.com%2Fstudio%2F|||"][/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Blog Category
	//Agency Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Shadow', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/agency-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484838110180{margin-bottom: 100px !important;padding-top: 22px !important;padding-bottom: 50px !important;background-color: #fafafa !important;}"][vc_column][ra_section_title style="classic" title="News" css=".vc_custom_1478773782932{padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][ra_latest_posts style="agency" post_type="post" posts_per_page="3" post_excerpt_length="24"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/business01-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484548530336{margin-top: 65px !important;margin-bottom: 60px !important;}"][vc_column][ra_section_title style="default" title="Latest Posts" css=".vc_custom_1493279580365{margin-bottom: 50px !important;}"]<span style="color: #c3c8c8;">around the world</span>[/ra_section_title][ra_latest_posts style="classic" post_type="post" posts_per_page="3" post_excerpt_length="17"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Review', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/car-dealer-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485546445610{padding-top: 160px !important;padding-bottom: 130px !important;}"][vc_column][ra_section_title style="underline6" title=" Latest Reviews"][/ra_section_title][ra_latest_posts style="rhombus" post_type="post" posts_per_page="3" post_excerpt_length="20"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Featured Date', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/car-rental-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485752359682{padding-top: 75px !important;padding-bottom: 120px !important;}"][vc_column][ra_section_title style="underline5" title="Latest Posts"][/ra_section_title][ra_latest_posts style="rental" post_type="post" posts_per_page="3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Cloud Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Light', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/cloud-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485513827999{padding-top: 20px !important;padding-bottom: 40px !important;background-color: #fbfbfb !important;}"][vc_column][ra_section_title style="big" title="Latest Posts." title_font_container="tag:h2" title_use_theme_fonts="yes" show_button="yes" ib_style="btn-naked" ib_i_type="fontawesome" ib_i_align="right" use_custom_fonts_title="true" ib_title="See all stories" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#30c2f9" ib_i_size="16px" ib_i_ml="9px" ib_fs="20px" css=".vc_custom_1485512957753{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
incididunt ut labore et dolore.aliqua.[/ra_section_title][ra_latest_posts style="cloud" post_type="post" posts_per_page="3" post_excerpt_length="28"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Colored Meta', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/corporate01-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1493110166653{padding-top: 110px !important;padding-bottom: 145px !important;}"][vc_column][ra_section_title style="thick" title="latest." content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1479401185196{margin-bottom: 100px !important;}"]Office News.[/ra_section_title][ra_latest_posts style="corporate" post_type="post" posts_per_page="3" post_excerpt_length="15"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Blog 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Carousel', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/corporate02-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479481011124{padding-top: 165px !important;padding-bottom: 200px !important;}"][vc_column][ra_latest_posts style="carousel" sub_style="sb1" post_type="post" posts_per_page="4" title="latest" desc="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt." post_excerpt_length="25"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Blog 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Carousel 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/elegant-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484742690970{padding-top: 115px !important;padding-bottom: 150px !important;}"][vc_column][ra_latest_posts style="carousel" sub_style="sb3" post_type="post" posts_per_page="4" title="Latest" desc="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia" subtitle="Stories" post_excerpt_length="30"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Featured Title', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/hostingblue-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1489566790734{padding-top: 25px !important;padding-bottom: 120px !important;}"][vc_column][ra_section_title style="underline" title="Latest News" title_font_container="tag:h2|font_size:32px|line_height:50px" title_google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" title_css_animation="fadeInUp" use_custom_fonts_title="true" css=".vc_custom_1489564938811{margin-bottom: 60px !important;}"]<span style="color: #01b8fe;">KNOW THIS FIRST</span>[/ra_section_title][ra_latest_posts style="hosting" post_type="post" posts_per_page="3" post_excerpt_length="25"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Featured Date 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/lawyer-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485438118218{padding-top: 40px !important;padding-bottom: 105px !important;}"][vc_column][ra_section_title style="underline4" title="Latest Posts" ib_style="classic-date-featured" css=".vc_custom_1485438086428{margin-bottom: 70px !important;}"]Latest news about justice.[/ra_section_title][ra_latest_posts style="lawyer" post_type="post" posts_per_page="3" post_excerpt_length="28"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Gradient Boxes', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/main-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1493674368231{padding-top: 85px !important;padding-bottom: 130px !important;}" responsive_css="padding_top_desktop:100|padding_bottom_desktop:100|padding_top_tablet:50|padding_bottom_tablet:50"][vc_column][ra_section_title style="resolve" title="Latest Stories" use_resolve_effect="yes" resolve_effect_seperator="chars" css=".vc_custom_1490019960028{margin-bottom: 0px !important;padding-bottom: 80px !important;}"][/ra_section_title][ra_latest_posts style="3d-hover" post_type="post" posts_per_page="3" post_excerpt_length="7"][vc_row_inner css=".vc_custom_1489152737312{margin-top: 90px !important;}"][vc_column_inner align="text-center"][ra_button style="btn-underlined" text="text-uppercase" title="see latest stor?es" link="url:%23|||" primary_color="#000000"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/mobile-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485359006839{margin-bottom: 80px !important;padding-top: 20px !important;}"][vc_column][ra_section_title style="classic6" title="Latest Posts." content_font_container="tag:p" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1479228028153{margin-bottom: 40px !important;}"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem
accusantium doloremque laudantium, totam.[/ra_section_title][ra_latest_posts style="mobile" post_type="post" posts_per_page="3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Restaurant Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Puzzle', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/restaurant-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485163862513{padding-top: 120px !important;padding-bottom: 95px !important;}"][vc_column][ra_latest_posts style="restaurant" post_type="post" posts_per_page="2"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Overlay', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/shop-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484668119478{padding-top: 65px !important;padding-bottom: 60px !important;}"][vc_column][ra_section_title style="sub-underlined" title="Latest Posts" i_align="right" css=".vc_custom_1484667248602{margin-bottom: 80px !important;}"]Fashion News[/ra_section_title][ra_latest_posts style="shop" post_type="post" posts_per_page="3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University Blog vc-template
	$data = array();
	$data['name'] = esc_html__( 'Blog Badge', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/blog/university-blog.jpg' );
	$data['sort_name'] = 'Blog';
	$data['custom_class'] = 'general blog';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479310572795{padding-top: 60px !important;padding-bottom: 100px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-bg1.png?id=26) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][ra_section_title style="classic2" title="Latest Posts" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true"]Boo News[/ra_section_title][ra_latest_posts style="university" post_type="post" posts_per_page="3" post_excerpt_length="28"][vc_row_inner css=".vc_custom_1485438326404{padding-top: 20px !important;}"][vc_column_inner align="text-center"][ra_button style="classic-date-featured" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" scheme="btn-inverse" title="Go to news" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff" text_color="#ffffff" htext_color="#1271b3" fw="700" ls="0.075em"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients Category
	//Corporate clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'Clents Classic with Solid Background', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/clients/corporate01-clients.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general client';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484503611524{padding-top: 30px !important;padding-bottom: 10px !important;background-color: #f9f9f9 !important;}"][vc_column css=".vc_custom_1479399553030{padding-top: 0px !important;}"][ra_carousel columns="col-md-3 col-sm-6 col-xs-12"][ra_client effect="client-opaque-inverted" name="Burbbery" logo=""][ra_client effect="client-opaque-inverted" name="Giorgio Armani" logo=""][ra_client effect="client-opaque-inverted" name="DNKY" logo=""][ra_client effect="client-opaque-inverted" name="Dolce Gabban" logo=""][ra_client effect="client-opaque-inverted" name="Burbbery" logo=""][ra_client effect="client-opaque-inverted" name="Giorgio Armani" logo=""][ra_client effect="client-opaque-inverted" name="DNKY" logo=""][ra_client effect="client-opaque-inverted" name="Dolce Gabban" logo=""][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate clients 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Clients Inverse with Background Image', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/clients/corporate03-clients.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general client';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="" css=".vc_custom_1493134844218{padding-top: 25px !important;padding-bottom: 60px !important;background-image: url(http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/bg-38.png?id=15) !important;background-position: center;background-repeat: no-repeat;background-size: cover !important;}"][vc_column align="text-center"][ra_carousel columns="col-md-3"][ra_client effect="" name="Bakkeries" logo=""][ra_client effect="" name="Fluffy" logo=""][ra_client effect="" name="Migh" logo=""][ra_client effect="" name="Lilys" logo=""][ra_client effect="" name="Bakkeries" logo=""][ra_client effect="" name="Fluffy" logo=""][ra_client effect="" name="Migh" logo=""][ra_client effect="" name="Lilys" logo=""][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting red clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'Clients Plain', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/clients/hostingred-clients.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general client';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485269906547{margin-bottom: 90px !important;}"][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="Burbbery" logo=""][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="Giorgio Armani" logo=""][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="DKNY" logo=""][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="Dolce gabbana" logo=""][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="Boss" logo=""][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="Channel" logo=""][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="Mont Blanc" logo=""][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6"][ra_client effect="client-opaque-inverted" name="Ralph" logo=""][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'Clients Border Separator', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/clients/mobile-clients.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general client';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1485437747372{padding-top: 42px !important;}"][vc_column width="1/4" css=".vc_custom_1485347160009{border-right-width: 1px !important;border-right-color: rgba(0,0,0,0.07) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" name="Lily's" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client1.png"][/vc_column][vc_column width="1/4" css=".vc_custom_1485351053579{border-right-width: 1px !important;border-right-color: rgba(0,0,0,0.07) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" name="NC" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client2.png"][/vc_column][vc_column width="1/4" css=".vc_custom_1485347173972{border-right-width: 1px !important;border-right-color: rgba(0,0,0,0.07) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" name="Fluffy" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client3.png"][/vc_column][vc_column width="1/4"][ra_client effect="client-opaque-inverted" name="Strong as Steel" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client4.png"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1485347296580{border-top-width: 1px !important;padding-bottom: 160px !important;border-top-color: rgba(0,0,0,0.07) !important;border-top-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1485347212721{border-right-width: 1px !important;border-right-color: rgba(0,0,0,0.07) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" name="McQueen" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client5.png"][/vc_column][vc_column width="1/4" css=".vc_custom_1485347228624{border-right-width: 1px !important;border-right-color: rgba(0,0,0,0.07) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" name="Originals" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client6.png"][/vc_column][vc_column width="1/4" css=".vc_custom_1485347248548{border-right-width: 1px !important;border-right-color: rgba(0,0,0,0.07) !important;border-right-style: solid !important;}"][ra_client effect="client-opaque-inverted" name="Bakeries" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client7.png"][/vc_column][vc_column width="1/4"][ra_client effect="client-opaque-inverted" name="Pacific Coast" logo="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/client8.png"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop clients vc-template
	$data = array();
	$data['name'] = esc_html__( 'Clients Border Top', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/clients/shop-clients.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general client';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484667814550{border-top-width: 1px !important;border-top-color: #f2f2f2 !important;border-top-style: solid !important;}"][vc_column css=".vc_custom_1484667926349{padding-top: 30px !important;}"][ra_carousel columns="col-md-3"][ra_client effect="client-opaque-inverted" logo=""][ra_client effect="client-opaque-inverted" logo=""][ra_client effect="client-opaque-inverted" logo=""][ra_client effect="client-opaque-inverted" logo="128"][ra_client effect="client-opaque-inverted" logo=""][ra_client effect="client-opaque-inverted" logo=""][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters Category
	//Agency Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Uno', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/agency-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484837086514{padding-top: 35px !important;background-image: url(http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/bg7.jpg) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][ra_section_title style="classic" title="Fun Facts" css=".vc_custom_1484839973148{margin-bottom: 40px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner css=".vc_custom_1484840134825{padding-bottom: 150px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column_inner width="1/3"][ra_counter style="s2" size="xxlg" align="text-center" label="projects launched" count="420" text_color="#000000"][/vc_column_inner][vc_column_inner width="1/3"][ra_counter style="s2" size="xxlg" align="text-center" counter_weight="weight-medium" label="cl?ents sat?sf?ed" count="680" text_color="#000000"][/vc_column_inner][vc_column_inner width="1/3"][ra_counter style="s2" size="xxlg" align="text-center" label="work?ng hours" count="770" text_color="#000000"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Bussines Cpunter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Due', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/business02-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="" css=".vc_custom_1493369182227{padding-top: 50px !important;padding-bottom: 125px !important;background-image: url(http://business-2.boo.themerella.com/wp-content/uploads/sites/19/2016/11/business-banner-1.jpg?id=8) !important;background-position: center;background-repeat: no-repeat;background-size: cover !important;}"][vc_column css_animation="none"][ra_section_title style="classic7" title="Global Leaders in Business" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true"]Trusted Experience[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_counter style="s1" size="xlg4" align="text-center" label="Dealers" count="8340" text_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_counter style="s1" size="xlg4" align="text-center" label="Employees" count="3808" text_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_counter style="s1" size="xlg4" align="text-center" label="Dealers" count="8340" text_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_counter style="s1" size="xlg4" align="text-center" label="Employees" count="8030" text_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css_animation="none" css=".vc_custom_1493369198606{background-color: #dd5959 !important;}"][vc_column css_animation="none" css=".vc_custom_1493369832888{margin-top: 0px !important;padding-top: 0px !important;}"][ra_banner style="s5"][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="5/6"][vc_column_text]
<h5><span style="color: #ffffff;">increase sales thanks to the first class business solutions from boo.</span></h5>
[/vc_column_text][/vc_column_inner][vc_column_inner width="1/6" align="text-right"][ra_button style="btn-underlined" text="text-uppercase" i_type="fontawesome" i_align="right" title="Work with us" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff"][/vc_column_inner][/vc_row_inner][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Bussines Cpunter 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Tre', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/business08-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1493392217120{padding-top: 70px !important;padding-bottom: 200px !important;background-image: url(http://business-3.boo.themerella.com/wp-content/uploads/sites/21/2016/12/business-3-bg.jpg?id=14) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/3"][ra_counter style="s1" size="custom" align="text-center" counter_weight="weight-bold" label="projects launched" count="420" text_color="#ffffff" custom_size="80px"][/vc_column][vc_column width="1/3"][ra_counter style="s1" size="custom" align="text-center" counter_weight="weight-bold" label="cl?ents sat?sf?ed" count="680" text_color="#ffffff" custom_size="80px"][/vc_column][vc_column width="1/3"][ra_counter style="s1" size="custom" align="text-center" counter_weight="weight-bold" label="work?ng hours" count="770" text_color="#ffffff" custom_size="80px"][/vc_column][/vc_row][vc_row full_width="stretch_row" row_overflow="yes" css=".vc_custom_1493392111895{padding-bottom: 40px !important;background-color: #f3ece9 !important;}"][vc_column width="1/3" css=".vc_custom_1493392118327{margin-top: -150px !important;}"][ra_icon_box template="boxed-alt5" heading_size="icon-box-heading-sm" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-solid" ib_shape="round" ib_size="btn-sm2" ib_others="wide" ib_text="text-uppercase" i_icon_linea="icon-basic_sheet_txt" title="No Hidden Fees" ib_title="Read More" ib_link="url:%23|||" icon_bg="#ffffff" primary_color="#2f43a9" icon_color="#2f43a9" title_color="#2f43a9" title_size="17px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1493392123931{margin-top: -150px !important;}"][ra_icon_box template="boxed-alt5" heading_size="icon-box-heading-sm" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-solid" ib_shape="round" ib_size="btn-sm2" ib_others="wide" ib_text="text-uppercase" title="Pick Up Anytime" icon_color="#2f43a9" ib_title="Read More" ib_link="url:%23|||" primary_color="#2f43a9" icon_bg="#ffffff" title_color="#2f43a9" title_size="17px" i_icon_linea="icon-basic_gear"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][vc_column width="1/3" css=".vc_custom_1493392488619{margin-top: -150px !important;}"][ra_icon_box template="boxed-alt5" heading_size="icon-box-heading-sm" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-solid" ib_shape="round" ib_size="btn-sm2" ib_others="wide" ib_text="text-uppercase" i_icon_linea="icon-linear-checkmark-circle" title="Repair Included" icon_color="#2f43a9" ib_title="Read More" ib_link="url:%23|||" primary_color="#2f43a9" icon_bg="#ffffff" title_color="#2f43a9" title_size="17px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Quattro', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/car-rental-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485549048225{padding-bottom: 80px !important;background-image: url(http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/car-rental-bg1.png?id=8) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1485548660788{padding-top: 0px !important;}"][ra_banner style="s3" css=".vc_custom_1485548912226{padding-bottom: 66px !important;}"][vc_custom_heading text="Trusted experience since 2003." font_container="tag:h6|font_size:30px|text_align:left" use_theme_fonts="yes" css=".vc_custom_1485551818477{padding-top: 10px !important;padding-bottom: 10px !important;}"][/ra_banner][vc_row_inner css=".vc_custom_1485522690208{padding-bottom: 40px !important;}"][vc_column_inner width="1/4" offset="vc_col-xs-6"][ra_counter style="s1" weight="weight-semibold" size="sm" align="text-center" label="Dealers" count="300" suffix="+" text_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-xs-6"][ra_counter style="" weight="weight-semibold" size="sm" align="text-center" label="Cars" count="200" suffix="+" text_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-xs-6"][ra_counter style="" weight="weight-semibold" size="sm" align="text-center" label="Dealers" count="500" suffix="+" text_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-xs-6"][ra_counter style="" weight="weight-semibold" size="sm" align="text-center" label="Customers" count="100" suffix="K" text_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Cinque', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/corporate02-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485849243501{padding-top: 70px !important;padding-bottom: 70px !important;background-image: url(http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/bg-35.png?id=23) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1485850209932{padding-top: 0px !important;}" offset="vc_col-lg-3"][ra_counter style="s5" weight="weight-bold" size="xlg" align="text-center" percent="85" start_color="rgba(255,255,255,0.5)" end_color="rgba(255,255,255,0.5)" label="Clients" count="10" suffix="K" text_color="#ffffff"][/vc_column][vc_column width="1/2" css=".vc_custom_1485850223170{padding-top: 0px !important;}" offset="vc_col-lg-3"][ra_counter style="s5" weight="weight-bold" size="xlg" align="text-center" percent="85" start_color="rgba(255,255,255,0.5)" end_color="rgba(255,255,255,0.5)" label="Clients" count="50" suffix="K" text_color="#ffffff"][/vc_column][vc_column width="1/2" css=".vc_custom_1485850232731{padding-top: 0px !important;}" offset="vc_col-lg-3"][ra_counter style="s5" weight="weight-bold" size="xlg" align="text-center" percent="85" start_color="rgba(255,255,255,0.5)" end_color="rgba(255,255,255,0.5)" label="Clients" count="60" suffix="K" text_color="#ffffff"][/vc_column][vc_column width="1/2" css=".vc_custom_1485850243375{padding-top: 0px !important;}" offset="vc_col-lg-3"][ra_counter style="s5" weight="weight-bold" size="xlg" align="text-center" percent="85" start_color="rgba(255,255,255,0.5)" end_color="rgba(255,255,255,0.5)" label="Clients" count="80" suffix="K" text_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Counter 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter  Sei', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/corporate03-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" parallax="content-moving" parallax_image="" css=".vc_custom_1493134804689{background-image: url(http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/bg-37.png?id=11) !important;background-position: center;background-repeat: no-repeat;background-size: cover !important;}"][vc_column width="1/2" css=".vc_custom_1492002487512{border-right-width: 1px !important;padding-top: 60px !important;padding-bottom: 15px !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-user" counter="5300" icon_color="#ffffff" counter_color="#ffffff" title_color="#ffffff" counter_size="50px" content_color="#ffffff"]Employees[/ra_icon_box][/vc_column][vc_column width="1/2" css=".vc_custom_1492002497217{border-right-width: 1px !important;padding-top: 60px !important;padding-bottom: 15px !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-briefcase" counter="8000" icon_color="#ffffff" counter_color="#ffffff" counter_size="50px" content_color="#ffffff"]Cases[/ra_icon_box][/vc_column][vc_column width="1/2" css=".vc_custom_1492002508894{border-right-width: 1px !important;padding-top: 60px !important;padding-bottom: 15px !important;border-right-color: rgba(255,255,255,0.2) !important;border-right-style: solid !important;}" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-money" counter="3000" icon_color="#ffffff" counter_color="#ffffff" counter_size="50px" content_color="#ffffff"]Deals[/ra_icon_box][/vc_column][vc_column width="1/2" css=".vc_custom_1492002521459{padding-top: 60px !important;padding-bottom: 15px !important;}" offset="vc_col-md-3"][ra_icon_box template="" i_type="linea" counter="9000" icon_color="#ffffff" counter_color="#ffffff" i_icon_linea="icon-presentation" counter_size="50px" content_color="#ffffff"]Stocks[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Red Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Sette', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/hostingred-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485283367512{margin-bottom: 100px !important;padding-top: 60px !important;padding-bottom: 40px !important;background-image: url(http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/hosting-red-pattern.png?id=25) !important;}"][vc_column][ra_section_title style="underline3" title="Fun Facts" scheme="inverse" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:div|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1485338764242{margin-bottom: 30px !important;}"]Infographs[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_weight="weight-semibold" i_type="fontawesome" shape_size="xsm" position="icon-box-side" i_icon_fontawesome="fa fa-briefcase" counter="98000" icon_color="#ffffff" counter_color="#ffffff" counter_size="2.8em" content_color="#ffffff"]Worldwide Customers[/ra_icon_box][ra_icon_box template="" heading_weight="weight-semibold" i_type="fontawesome" shape_size="xsm" position="icon-box-side" i_icon_fontawesome="fa fa-coffee" counter="2300" icon_color="#ffffff" counter_color="#ffffff" counter_size="2.8em" content_color="#ffffff"]Cups of Coffee[/ra_icon_box][ra_icon_box template="" heading_weight="weight-semibold" i_type="fontawesome" shape_size="xsm" position="icon-box-side" i_icon_fontawesome="fa fa-user-secret" counter="55000" icon_color="#ffffff" counter_color="#ffffff" counter_size="2.8em" content_color="#ffffff"]Websites Protected[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_hidden-sm vc_hidden-xs"][vc_single_image source="external_link" alignment="center" custom_src="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/hosting-r-server.png"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_weight="weight-semibold" i_type="fontawesome" shape_size="xsm" position="icon-box-side" alignment="align-right" i_icon_fontawesome="fa fa-globe" counter="5000" icon_color="#ffffff" counter_color="#ffffff" counter_size="2.8em" content_color="#ffffff"]Domains Registered[/ra_icon_box][ra_icon_box template="" heading_weight="weight-semibold" i_type="fontawesome" shape_size="xsm" position="icon-box-side" alignment="align-right" i_icon_fontawesome="fa fa-life-ring" counter="22000" icon_color="#ffffff" counter_color="#ffffff" counter_size="2.8em" content_color="#ffffff"]Tickets Answered[/ra_icon_box][ra_icon_box template="" heading_weight="weight-semibold" i_type="fontawesome" shape_size="xsm" position="icon-box-side" alignment="align-right" i_icon_fontawesome="fa fa-thumbs-o-up" counter="30000" icon_color="#ffffff" counter_color="#ffffff" counter_size="2.8em" content_color="#ffffff"]Subscribers[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Lawyer Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Otto', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/lawyer-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485437966724{padding-top: 30px !important;padding-bottom: 60px !important;background-image: url(http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/lawyer-bg1.png?id=26) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-2 vc_col-xs-8"][ra_counter style="s5" size="sm" align="text-center" counter_weight="weight-light" percent="43" start_color="rgba(255,255,255,0.8)" end_color="rgba(255,255,255,0.8)" label="Clients" count="6500" text_color="#ffffff"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-2 vc_col-xs-8"][ra_counter style="s5" size="sm" align="text-center" percent="60" start_color="rgba(255,255,255,0.8)" end_color="rgba(255,255,255,0.8)" label="Documents" count="3000" text_color="#ffffff"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-2 vc_col-xs-8"][ra_counter style="s5" size="sm" align="text-center" percent="73" start_color="rgba(255,255,255,0.8)" end_color="rgba(255,255,255,0.8)" label="Partners" count="7000" text_color="#ffffff"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-2 vc_col-xs-8"][ra_counter style="s5" size="sm" align="text-center" percent="68" start_color="rgba(255,255,255,0.8)" end_color="rgba(255,255,255,0.8)" label="Plans" count="3600" text_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Nove', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/main2-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" el_class="mb70" css=".vc_custom_1490277498819{margin-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1492075651175{padding-top: 0px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-3 vc_col-xs-12"][ra_counter style="s3" size="xxlg2" align="text-center" count="10" label="projects launched" suffix="+"][/vc_column][vc_column width="1/2" css=".vc_custom_1492075661126{padding-top: 0px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-3 vc_col-xs-12"][ra_counter style="s3" size="xxlg2" align="text-center" count="130" label="projects launched"][/vc_column][vc_column width="1/2" css=".vc_custom_1492075674720{padding-top: 0px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-3 vc_col-xs-12"][ra_counter style="s3" size="xxlg2" align="text-center" count="800" label="Client Satisfied"][/vc_column][vc_column width="1/2" css=".vc_custom_1492075696691{padding-top: 0px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-3 vc_col-xs-12"][ra_counter style="s3" size="xxlg2" align="text-center" count="730" label="Client Satisfied" suffix="+"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Counter vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Diece', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/mobile-counter.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479215823075{padding-top: 120px !important;padding-bottom: 140px !important;}"][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="card" heading_size="icon-box-heading-xsm" i_type="fontawesome" shape_size="lg" title="Google Users" i_icon_fontawesome="fa fa-google" counter="50000" title_color="#425fca" icon_color="#425fca" counter_size="40px" icon_color2="#8224e3" content_color="#dd3333"][/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="card" heading_size="icon-box-heading-xsm" i_type="fontawesome" shape_size="lg" title="IOS Users" i_icon_fontawesome="fa fa-apple" counter="870000" title_color="#425fca" icon_color="#425fca" counter_size="40px"][/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="card" heading_size="icon-box-heading-xsm" i_type="fontawesome" shape_size="lg" title="User Ratings" i_icon_fontawesome="fa fa-star" counter="30000" title_color="#425fca" icon_color="#425fca" counter_size="40px"][/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="card" heading_size="icon-box-heading-xsm" i_type="fontawesome" shape_size="lg" title="User Reviews" i_icon_fontawesome="fa fa-pencil" counter="25000" title_color="#425fca" icon_color="#425fca" counter_size="40px"][/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Counter 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Counter Undici', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/counter/mobile-counter-2.jpg' );
	$data['sort_name'] = 'Counters';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479218815207{padding-top: 60px !important;padding-bottom: 100px !important;background-image: url(http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/mobile-bg2.png?id=9) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css_animation="fadeIn" align="text-center"][ra_section_title style="classic6" title=" Grab your app." title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1485344943257{margin-bottom: 60px !important;}"][/ra_section_title][ra_counter style="s4" counter_weight="weight-light" count=" 3250000" text_color="#ffffff"][vc_empty_space][vc_column_text css=".vc_custom_1485421701269{margin-bottom: 40px !important;}"]<i class="fa fa-download"></i><span style="color: #b8b8b7;"> download since its first lauch.</span>[/vc_column_text][/vc_column][vc_column align="text-center"][ra_button style="btn-app" border="border-thick" i_type="fontawesome" title="Google Play" other="Get it on" i_icon_fontawesome="fa fa-google" primary_color="#ffffff" bc="rgba(255,255,255,0.3)" hbc="#ffffff" second_color="rgba(130,36,227,0.01)"][ra_button style="btn-app" border="border-thick" i_type="fontawesome" title="App store" other="Get it on" i_icon_fontawesome="fa fa-apple" primary_color="#ffffff" bc="rgba(255,255,255,0.3)" hbc="#ffffff" css=".vc_custom_1487865754549{margin-right: -5px !important;margin-left: -5px !important;}"][ra_button style="btn-app" border="border-thick" others="disabled" i_type="fontawesome" title="Windows" other="Coming Soon" i_icon_fontawesome="fa fa-windows" primary_color="#ffffff" bc="rgba(255,255,255,0.3)" hbc="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//FAQ category
	//Car Rental FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'FAQ Car Rental', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/faq/car-rental-faq.jpg' );
	$data['sort_name'] = 'FAQ';
	$data['custom_class'] = 'general faq';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479374176245{padding-top: 80px !important;}"][vc_column][ra_section_title style="underline5" title="Questions" show_button="yes" ib_style="btn-default" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_align="right" class="``btn" css=".vc_custom_1486053108579{margin-bottom: 15px !important;}" ib_title="Privacy Policy" ib_fw="600"][/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1485549841758{padding-top: 70px !important;padding-bottom: 65px !important;}"][vc_column offset="vc_col-lg-6"][vc_accordion style="big-square" alignment="accordion-right" active_tab="1"][vc_accordion_tab title="Does your policy cover insurance ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you need any document ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="What happens if I don't return my car ?"][vc_column_text] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column offset="vc_col-lg-6"][vc_accordion style="big-square" alignment="accordion-right" active_tab="-1" color_border="rgba(10,10,10,0.1)"][vc_accordion_tab title="Does your policy cover insurance ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you need any document ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="What happens if I don't return my car ?"][vc_column_text] Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Classic FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'FAQ Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/faq/classic-faq.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'FAQ';
	$data['custom_class'] = 'general faq';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1506367023109{padding-top: 110px !important;padding-bottom: 90px !important;}" responsive_css="padding_bottom_tablet:50|padding_bottom_mobile:50" el_id="help"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Do I need any coding knowledge to customize Boo?" font_container="tag:h3|font_size:20px|text_align:left|color:%235a6370" use_theme_fonts="yes" css=".vc_custom_1508960967561{margin-bottom: 25px !important;padding-right: 30% !important;}"][vc_column_text css=".vc_custom_1508954093405{padding-right: 30% !important;}"]<span style="font-size: 18px;">Coding knowledge is not required to create your dream website. Live Website Builder is the key tool to achieve your dream.</span>[/vc_column_text][vc_separator][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][vc_custom_heading text="Can I use different templates from different pre-built websites?" font_container="tag:h3|font_size:20px|text_align:left|color:%235a6370" use_theme_fonts="yes" css=".vc_custom_1508961071243{margin-bottom: 25px !important;padding-right: 30% !important;}"][vc_column_text css=".vc_custom_1508954093405{padding-right: 30% !important;}"]<span style="font-size: 18px;">Coding knowledge is not required to create your dream website. Live Website Builder is the key tool to achieve your dream.</span>[/vc_column_text][vc_separator][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][vc_custom_heading text="What do i do if I have problems?" font_container="tag:h3|font_size:20px|text_align:left|color:%235a6370" use_theme_fonts="yes" css=".vc_custom_1508961082745{margin-bottom: 25px !important;padding-right: 30% !important;}"][vc_column_text css=".vc_custom_1508954093405{padding-right: 30% !important;}"]<span style="font-size: 18px;">Coding knowledge is not required to create your dream website. Live Website Builder is the key tool to achieve your dream.</span>[/vc_column_text][vc_separator][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	

	//Cloud FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'FAQ Cloud', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/faq/cloud-faq.jpg' );
	$data['sort_name'] = 'FAQ';
	$data['custom_class'] = 'general faq';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479389759575{padding-top: 80px !important;padding-bottom: 20px !important;}"][vc_column][ra_section_title style="big" title="Questions." title_font_container="tag:h2" title_use_theme_fonts="yes" show_button="yes" ib_style="btn-naked" ib_i_type="fontawesome" ib_i_align="right" use_custom_fonts_title="true" ib_title="Jump to forums" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#30c2f9" ib_i_size="16px" ib_i_ml="9px" ib_fs="20px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
incididunt ut labore et dolore.aliqua.[/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1478521019315{padding-bottom: 130px !important;}"][vc_column offset="vc_col-md-6"][vc_accordion style="facebook" alignment="accordion-right" active_tab="1"][vc_accordion_tab title="Do I have permission to access cPanel?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you provide backups?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I crease internal store ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you provide documentation ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column offset="vc_col-md-6"][vc_accordion style="facebook" alignment="accordion-right" active_tab="-1"][vc_accordion_tab title="Do I have permission to access cPanel?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you provide backups?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I crease internal store ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you provide documentation ?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Blue FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'FAQ Hosting Blue', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/faq/hostingblue-faq.jpg' );
	$data['sort_name'] = 'FAQ';
	$data['custom_class'] = 'general faq';
	$data['content'] = <<<CONTENT
[vc_row][vc_column css=".vc_custom_1484130645138{padding-top: 0px !important;}"][ra_section_title style="classic2" title="Find Your Answer" title_font_container="tag:h2" title_google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" title_css_animation="fadeInUp" use_custom_fonts_title="true" css=".vc_custom_1489564952265{margin-bottom: 60px !important;}" description="Far far away behind the word mountains,far from the countries Vokalia and Consonantia"]KNOW THIS FIRST[/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1484130718583{margin-bottom: 130px !important;}"][vc_column width="1/2"][vc_accordion style="highlight" alignment="accordion-right" active_tab="1"][vc_accordion_tab title="Are your servers secure?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Should I register my hosting?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Is there a community forum?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="How can I purchase multiple domain?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column width="1/2"][vc_accordion style="highlight" alignment="accordion-right" active_tab="-1"][vc_accordion_tab title="Are your servers secure?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Should I register my hosting?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Is there a community forum?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="How can I purchase multiple domain?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce ut felis rhoncus, rutrum metus nec, vestibulum est.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting RED FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'FAQ Hosting Red', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/faq/hostingred-faq.jpg' );
	$data['sort_name'] = 'FAQ';
	$data['custom_class'] = 'general faq';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485280882097{padding-top: 60px !important;padding-bottom: 80px !important;background-color: #fafafa !important;}"][vc_column][ra_section_title style="underline3" title="Frequently Asked Question" content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1479142372448{margin-bottom: 0px !important;padding-bottom: 0px !important;}"]Documentation[/ra_section_title][/vc_column][vc_column width="1/2"][vc_accordion style="square" alignment="accordion-right" el_class="accordion-red"][vc_accordion_tab title="Should I apply for an expiry domain ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute. [/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I use multiple domains ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Should I have SSL Certificate ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Will you protect my data ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you provide support over phone ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column width="1/2"][vc_accordion style="square" alignment="accordion-right" color_toggler="#eb3659" el_class="accordion-red"][vc_accordion_tab title="What's the difference between Linux and PHP ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do you provide support over phone ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="What does monthly traffic mean ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Should I have SSL Certificate from you ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="I lost my password and / or username ?"][vc_column_text]Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'FAQ Lawyer', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/faq/lawyer-faq.jpg' );
	$data['sort_name'] = 'FAQ';
	$data['custom_class'] = 'general faq';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479290263587{padding-top: 70px !important;}"][vc_column][ra_section_title style="underline4" title="Questions" css=".vc_custom_1485428265637{margin-bottom: 75px !important;}"]Just ask and we will answer.[/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1485437957604{padding-bottom: 145px !important;}"][vc_column offset="vc_col-lg-offset-0 vc_col-lg-6"][vc_accordion style="facebook" alignment="accordion-right" active_tab="1"][vc_accordion_tab title="Do you provide a policy ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do I have to fill a form as a client ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Should I wait for a call back ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I trust your privacy ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column offset="vc_col-lg-offset-0 vc_col-lg-6"][vc_accordion style="facebook" alignment="accordion-right" active_tab="4"][vc_accordion_tab title="Do you provide a policy ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Do I have to fill a form as a client ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Should I wait for a call back ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I trust your privacy ?"][vc_column_text]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University FAQ vc-template
	$data = array();
	$data['name'] = esc_html__( 'FAQ University', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/faq/university-faq.jpg' );
	$data['sort_name'] = 'FAQ';
	$data['custom_class'] = 'general faq';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485509912281{padding-top: 65px !important;padding-bottom: 40px !important;}"][vc_column offset="vc_col-md-4" css=".vc_custom_1485509867051{margin-bottom: 30px !important;}"][ra_section_title style="side-line" title="Questions"][/ra_section_title][vc_accordion style="minimal-alt" alignment="accordion-right" i_add_icon="true" i_type="fontawesome" active_add_icon="true" active_type="fontawesome" i_icon_fontawesome="fa fa-chevron-down" active_icon_fontawesome="fa fa-chevron-up"][vc_accordion_tab title="Should I apply before registration?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vestibulum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I see my schedule?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vestibulum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Is there a post-graduate program?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vestibulum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I work outside the school?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vestibulum.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Can I see my schedule?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vestibulum.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_section_title style="side-line" title="University Radio"][/ra_section_title][ra_video title="Students" video_mp4_url="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/11/timelapse.m4v" video_url_webm="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/11/timelapse.webm" poster="" fallback="28" height="203px"][vc_column_text] <h4>Working places around our campus</h4> <span style="color: #939292;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vestibulum.</span>[/vc_column_text][vc_empty_space height="15px"][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Start radio" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" fw="700"][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_section_title style="side-line" title="Announcements"][/ra_section_title][ra_banner style="s7" css=".vc_custom_1485459242348{margin-bottom: 17px !important;}"][vc_single_image source="external_link" alignment="center" onclick="zoom" custom_src="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-banner1.png"][vc_column_text] <h6>Admission Open</h6> <h5>For 2017</h5> [/vc_column_text][ra_button style="classic-date-featured" size="btn-xsm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View Details" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff" hbg="#ffffff" text_color="#ffffff" htext_color="#0a0a0a" bc="#ffffff" hbc="#ffffff" fs="13px" fw="700" ls="0.075em"][/ra_banner][ra_banner style="s7"][vc_single_image source="external_link" alignment="center" onclick="zoom" custom_src="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-banner2.png"][vc_column_text] <h6>Student</h6> <h5>Orientation</h5> [/vc_column_text][ra_button style="classic-date-featured" size="btn-xsm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View Details" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff" hbg="#ffffff" text_color="#ffffff" htext_color="#0a0a0a" bc="#ffffff" hbc="#ffffff" fs="13px" fw="700" ls="0.075em"][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Footers
	//Agency Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Agency', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/agency-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" svg_separator="yes" css=".vc_custom_1488474516871{background-color: #088ace !important;}" svg_color="#ffffff"][vc_column][ra_section_title style="classic" title="Get in Touch" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1484838369525{margin-top: 60px !important;margin-bottom: 40px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476878909317{background-color: #088ace !important;}"][vc_column width="5/6" offset="vc_col-md-offset-1 vc_col-sm-offset-1"][vc_row_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Call us" i_icon_fontawesome="fa fa-phone" icon_background_color="#ffffff" icon_color="#2595cf" title_color="#ffffff" content_color="#ffffff" icon_bg="#ffffff" title_size="17px" content_size="17px"]1-234-567-890[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Mail us" i_icon_fontawesome="fa fa-envelope-o" icon_background_color="#ffffff" icon_color="#2595cf" title_color="#ffffff" content_color="#ffffff" icon_bg="#ffffff" title_size="17px" content_size="17px"]info@boo.com[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Visit us" i_icon_fontawesome="fa fa-map-marker" icon_background_color="#ffffff" icon_color="#2595cf" title_color="#ffffff" content_color="#ffffff" icon_bg="#ffffff" title_size="17px" content_size="17px"]5th Avenue, Manhattan[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476878836421{background-color: #088ace !important;}"][vc_column][ra_cf7 style="s16" id="2717" btn=""][/vc_column][vc_column align="text-center" css=".vc_custom_1485762835322{padding-top: 20px !important;padding-bottom: 50px !important;}"][ra_social_icons style="" shape="circle" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff" hover_color="#46a7da" hbg_color="#ffffff" bg_color="#46a7da"][/vc_column][/vc_row][vc_row][vc_column align="text-center" css=".vc_custom_1485762813362{padding-top: 20px !important;padding-bottom: 20px !important;}"][vc_column_text]<span style="color: #818181;">Boo Theme, 2016. All rights reserved.</span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Black Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Black', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/black-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" css_animation="none" css=".vc_custom_1497272784608{padding-left: 100px !important;}"][vc_column width="1/4" css=".vc_custom_1493911087548{padding-top: 57px !important;}"][vc_single_image image="" img_size="full"][/vc_column][vc_column width="1/4"][vc_column_text] <h6>3rd Avenue, Stockholm +1 800 977 78 80 <a href="mailto:info@boolondon.com">info@boolondon.com</a></h6> [/vc_column_text][/vc_column][vc_column width="1/4"][vc_column_text] <h6><a href="#">Facebook</a> <a href="mailto:info@boolondon.com">Linkedin</a> <a href="mailto:info@boolondon.com">Instagram</a></h6> [/vc_column_text][/vc_column][vc_column width="1/4"][vc_column_text] <h6><a href="#">Behance</a> <a href="mailto:info@boolondon.com">Dribbble</a></h6> [/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Business', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/business01-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes"][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1493283055388{margin-bottom: 30px !important;}"][vc_custom_heading text="About Us" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484524208734{margin-top: 0px !important;margin-bottom: 30px !important;}"][vc_column_text css=".vc_custom_1493282630286{margin-bottom: 35px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi faucibus ut turpis at commodo.[/vc_column_text][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="1800 843 33 33" i_icon_fontawesome="fa fa-phone" icon_color="rgba(255,255,255,0.6)" icon_fs="21px" title_size="13px" title_color="rgba(255,255,255,0.6)" css=".vc_custom_1493282129043{margin-bottom: 20px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="info@boo.com" i_icon_fontawesome="fa fa-envelope-o" icon_color="rgba(255,255,255,0.6)" icon_fs="21px" title_size="13px" title_color="rgba(255,255,255,0.6)" css=".vc_custom_1493282138616{margin-bottom: 20px !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-xsm" heading_weight="weight-normal" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title=" 5th Avenue, Manhattan" i_icon_fontawesome="fa fa-map-marker" icon_color="rgba(255,255,255,0.6)" icon_fs="21px" title_size="13px" title_color="rgba(255,255,255,0.6)" css=".vc_custom_1493282151218{margin-bottom: 0px !important;}"][/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1493283065018{margin-bottom: 30px !important;}"][vc_custom_heading text="Need Help" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484525272489{margin-top: 0px !important;margin-bottom: 30px !important;}"][vc_wp_custommenu nav_menu="8"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1493283072097{margin-bottom: 30px !important;}"][vc_custom_heading text="Latest Posts" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484525289107{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_latest_posts style="excerpt-only" post_type="post" posts_per_page="2"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1493283078680{margin-bottom: 30px !important;}"][vc_custom_heading text="Get In Touch" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484525305818{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_cf7 style="s15" id="25" btn="" i_type="fontawesome" i_align="right" i_icon_fontawesome="fa fa-angle-right"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1493283088495{margin-top: 20px !important;padding-top: 25px !important;padding-bottom: 25px !important;background-color: #414248 !important;}"][vc_column width="1/2" css=".vc_custom_1484525588123{padding-top: 0px !important;}"][vc_column_text css=".vc_custom_1493282175713{margin-bottom: 0px !important;}"] 2016, Boo Business, by Themerella. [/vc_column_text][/vc_column][vc_column width="1/2" align="text-right" css=".vc_custom_1493282164709{padding-top: 5px !important;}"][ra_social_icons style="" visibility="faded" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Business 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/business02-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3" css=".vc_custom_1493377411985{padding-right: 5% !important;}"][vc_single_image image="" img_size="full" css=".vc_custom_1484303520352{margin-bottom: 20px !important;}"][vc_column_text css=".vc_custom_1493362860865{margin-bottom: 20px !important;}"]Lorem ipsum dolor sit amet, consectetur adipisicing elit,d tempor incididunt ut laboet dolore magna alminim veniam. exercitation.gna almin.[/vc_column_text][ra_button style="btn-underlined" size="btn-sm2" text="text-uppercase" i_type="fontawesome" i_align="right" title="Our History" primary_color="#ffffff" bc="#9b9b9b" text_color="#ffffff" htext_color="#ffffff" hbc="#ffffff" i_icon_fontawesome="fa fa-angle-right" fs="13px"][vc_empty_space height="55px"][vc_column_text css=".vc_custom_1493376609124{margin-bottom: 25px !important;}"]
<h5><span style="color: #ffffff;"><i class="fa fa-twitter"></i>Latest Tweets</span></h5>
[/vc_column_text][ra_tweet ib_style="btn-default" tweet="https://twitter.com/envato/status/857832411274428416"][/vc_column][vc_column width="2/3"][vc_row_inner css=".vc_custom_1493377696356{margin-bottom: 65px !important;background-color: #2a2b2f !important;border-radius: 4px !important;}"][vc_column_inner width="1/2" align="text-center" css=".vc_custom_1493377746076{border-right-width: 1px !important;border-right-color: rgba(255,255,255,0.05) !important;border-right-style: solid !important;}"][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="0 800 380 38 83" i_icon_fontawesome="fa fa-phone" icon_color="#ffffff" title_color="#ffffff" icon_fs="25px" title_size="18px"][/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" align="text-center"][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-normal" i_type="fontawesome" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="info@boobusiness.com" i_icon_fontawesome="fa fa-envelope" icon_color="#ffffff" title_color="#ffffff" icon_fs="25px" title_size="18px"][/ra_icon_box][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/4" css=".vc_custom_1493378298315{padding-top: 0px !important;}"][vc_column_text]
<h5><span style="color: #ffffff;">Help Centre</span></h5>
[/vc_column_text][vc_wp_custommenu nav_menu="7"][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1493378291887{padding-top: 0px !important;}"][vc_column_text]
<h5><span style="color: #ffffff;">Useful Links</span></h5>
[/vc_column_text][vc_wp_custommenu nav_menu="8"][/vc_column_inner][vc_column_inner width="1/2" bg_position="center center" css=".vc_custom_1493379112430{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 55px !important;padding-bottom: 12px !important;background-image: url(http://business-2.boo.themerella.com/wp-content/uploads/sites/19/2017/04/world-map.png?id=4192) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;border-left-color: rgba(255,255,255,0.1) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.1) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.1) !important;border-bottom-style: solid !important;}"][ra_icon_box template="" heading_weight="weight-normal" i_type="fontawesome" title="5th Avenue, Ocean Shades" icon_fs="50px" title_size="18px" title_color="#ffffff" content_color="rgba(255,255,255,0.45)" i_icon_fontawesome="fa fa-map-marker" icon_color="#ffffff" content_size="15px"]Monday to Friday: 8am - 7pm
Sunday: Closed
[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1493377321384{margin-top: 40px !important;padding-top: 18px !important;background-color: #2a2b2f !important;}"][vc_column width="2/3" css=".vc_custom_1493377245899{padding-top: 0px !important;}"][ra_social_icons style="" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#bcbcbc" hover_color="#ffffff"][/vc_column][vc_column width="1/3" css=".vc_custom_1493377240729{padding-top: 0px !important;}"][ra_newsletter template="underlined" newsletter_id="2" inputs_size="xs" i_type="fontawesome" btn_display="icon" i_add_icon="true" brd_color="rgba(255,255,255,0.24)" brd_f_color="#ffffff" btn_txt_color="#ffffff" i_icon_fontawesome="fa fa-long-arrow-right"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Footer 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Business 3', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/business08-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" equal_height="yes"][vc_column width="1/2" css=".vc_custom_1493408906545{margin-bottom: 30px !important;padding-right: 16% !important;padding-left: 16% !important;}" offset="vc_col-md-3"][vc_single_image image="" img_size="full" css=".vc_custom_1484232945714{margin-bottom: 25px !important;}"][vc_column_text css=".vc_custom_1493390644639{margin-bottom: 30px !important;}"]Lorem ipsum dolor sit amet, consectetur adipisicing elit,d tempor incididunt[/vc_column_text][ra_button style="btn-solid" shape="semi-round" size="btn-lg" others="wide" text="text-uppercase" i_align="right" title="send a message" primary_color="#3045b2" text_color="#ffffff" htext_color="#ffffff" fs="13px"][/vc_column][vc_column width="1/2" css=".vc_custom_1493408913083{margin-bottom: 30px !important;padding-right: 16% !important;padding-left: 16% !important;}" offset="vc_col-md-3"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipisicing elit,d tempor incididunt ut

( 272 ) 283 82 73

5th Avenue, 87[/vc_column_text][ra_button style="btn-underlined" border="border-thick" title="hello@boo.com" fs="25px"][/vc_column][vc_column width="1/2" css=".vc_custom_1493408919878{margin-bottom: 30px !important;padding-top: 0px !important;padding-right: 16% !important;padding-left: 16% !important;}" offset="vc_col-md-3"][ra_custom_menu style="col2" menu_id="6" cm_style="" cm_text_color="rgba(10,10,10,0.61)" cm_htext_color="#2f43a9" primary_color="#0a0a0a"][/vc_column][vc_column width="1/2" css=".vc_custom_1493408927085{margin-bottom: 30px !important;padding-right: 16% !important;padding-left: 16% !important;}" offset="vc_col-md-3"][ra_newsletter template="underlined" newsletter_id="2" inputs_size="md" i_type="fontawesome" i_align="right" btn_display="label_icon" btn_position="subscribe-button-block" i_add_icon="true" txt_color="rgba(10,10,10,0.6)" brd_color="rgba(0,0,0,0.25)" txt_f_color="#2f43a9" brd_f_color="#2f43a9" i_icon_fontawesome="fa fa-angle-right" btn_txt_color="#2f43a9"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Car Dealer', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/car-dealer-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row gap="20"][vc_column offset="vc_col-lg-3"][vc_single_image image="" img_size="full" css=".vc_custom_1484403156587{margin-bottom: 30px !important;}"][vc_column_text css=".vc_custom_1484403171271{margin-bottom: 30px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate.[/vc_column_text][ra_newsletter template="" newsletter_id="2" inputs_size="xs" i_type="fontawesome" i_align="right" btn_display="only_icon" i_add_icon="true" brd_color="#dddddd" brd_f_color="#d72828" txt_color="#000000" txt_f_color="#0a0a0a" bg_f_color="#ffffff" btn_txt_color="#bbbbbb" i_icon_fontawesome="fa fa-angle-right" bg_color="#ffffff"][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][vc_custom_heading text="Need Help?" font_container="tag:h3|font_size:20px|text_align:left|color:%230a0a0a" use_theme_fonts="yes" css=".vc_custom_1484402525650{margin-top: 0px !important;margin-bottom: 30px !important;}"][vc_wp_custommenu nav_menu="7"][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][vc_custom_heading text="Latest Posts" font_container="tag:h3|font_size:20px|text_align:left|color:%230a0a0a" use_theme_fonts="yes" css=".vc_custom_1484402534136{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_latest_posts style="excerpt-only" post_type="post" posts_per_page="2"][/vc_column][vc_column offset="vc_col-lg-3"][vc_custom_heading text="Get in Touch" font_container="tag:h3|font_size:20px|text_align:left|color:%230a0a0a" use_theme_fonts="yes" css=".vc_custom_1484402541766{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_cf7 style="s14" id="34" btn="" hbrd_color="#d72727"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1486048962882{margin-top: 0px !important;padding-top: 20px !important;padding-bottom: 15px !important;background-color: #d72828 !important;}"][vc_column width="1/2" css=".vc_custom_1484216390934{padding-top: 0px !important;}"][vc_column_text css=".vc_custom_1491929898248{margin-bottom: 0px !important;}"]
<p style="color: rgba(255,255,255,0.5);">2016, BooCar, by Themerella.</p>
[/vc_column_text][/vc_column][vc_column width="1/2" align="text-right" css=".vc_custom_1486152987099{padding-top: 5px !important;}"][ra_social_icons style="" visibility="faded" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Car Rental', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/car-rental-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column offset="vc_col-lg-offset-0 vc_col-lg-3" css=".vc_custom_1485759976227{padding-bottom: 40px !important;}"][vc_single_image image="" img_size="full"][vc_column_text css=".vc_custom_1483603208850{margin-top: 30px !important;margin-bottom: 30px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate.[/vc_column_text][ra_newsletter template="inverted-minimal" newsletter_id="2" inputs_size="xxs" i_type="fontawesome" i_align="right" btn_display="label_icon" i_add_icon="true" i_icon_fontawesome="fa fa-angle-right" bg_color="#0d2d4c" txt_color="rgba(255,255,255,0.4)" brd_color="#0d2d4c" txt_f_color="#ffffff" bg_f_color="#0d2d4c" brd_f_color="#0d2d4c" btn_txt_color="#ffffff" btn_bg_color="#12406d" i_size="11px"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3" css=".vc_custom_1485759983562{padding-bottom: 40px !important;}"][vc_custom_heading text="Need Help?" font_container="tag:h2|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484545203038{margin-top: 0px !important;margin-bottom: 35px !important;}"][vc_wp_custommenu nav_menu="6"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3" css=".vc_custom_1485759989556{padding-bottom: 40px !important;}"][vc_custom_heading text="Latest Posts" font_container="tag:h2|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484545212686{margin-top: 0px !important;margin-bottom: 35px !important;}"][ra_latest_posts style="excerpt-only" post_type="post" posts_per_page="2"][/vc_column][vc_column offset="vc_col-lg-offset-0 vc_col-lg-3" css=".vc_custom_1485759995485{padding-bottom: 40px !important;}"][vc_custom_heading text="Contact Us" font_container="tag:h2|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484545221754{margin-top: 0px !important;margin-bottom: 35px !important;}"][ra_cf7 style="s15" id="32" btn="" i_type="fontawesome" i_align="right" primary_color="#0d2d4c" i_icon_fontawesome="fa fa-angle-right"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1486053922074{margin-top: 0px !important;padding-top: 17px !important;padding-bottom: 13px !important;background-color: #efa80f !important;}"][vc_column width="1/2" css=".vc_custom_1483609469728{padding-top: 0px !important;}"][vc_column_text css=".vc_custom_1491995301772{margin-bottom: 0px !important;}"]
<p style="text-align: left;">2016, BooCar, by Themerella.</p>
[/vc_column_text][/vc_column][vc_column width="1/2" align="text-right" css=".vc_custom_1486053845680{padding-top: 5px !important;}"][ra_social_icons style="" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%7D%5D" primary_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Cloud Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Cloud', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/cloud-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes"][vc_column offset="vc_col-md-4"][vc_custom_heading text="About Boo" font_container="tag:h3|font_size:30px|text_align:left|color:%23ffffff" use_theme_fonts="yes"][vc_empty_space height="25px"][vc_column_text css=".vc_custom_1485520028754{margin-bottom: 40px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliqu.[/vc_column_text][vc_single_image image="" img_size="full"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_custom_heading text="Shortcodes" font_container="tag:h3|font_size:30px|text_align:left|color:%23ffffff" use_theme_fonts="yes"][vc_empty_space height="25px"][vc_wp_custommenu nav_menu="6"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_custom_heading text="Account" font_container="tag:h3|font_size:30px|text_align:left|color:%23ffffff" use_theme_fonts="yes"][vc_empty_space height="25px"][vc_wp_custommenu nav_menu="7"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_custom_heading text="Resources" font_container="tag:h3|font_size:30px|text_align:left|color:%23ffffff" use_theme_fonts="yes"][vc_empty_space height="25px"][vc_wp_custommenu nav_menu="8"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_custom_heading text="Support" font_container="tag:h3|font_size:30px|text_align:left|color:%23ffffff" use_theme_fonts="yes"][vc_empty_space height="25px"][vc_wp_custommenu nav_menu="9"][/vc_column][/vc_row][vc_row css=".vc_custom_1483615166447{padding-top: 0px !important;}"][vc_column][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485527760499{border-top-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-top-color: rgba(255,255,255,0.3) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.3) !important;border-bottom-style: solid !important;}"][vc_column_inner css=".vc_custom_1485528144881{padding-top: 0px !important;}" offset="vc_col-md-2"][vc_custom_heading text="Subscribe" font_container="tag:h3|font_size:30px|text_align:left|color:%23ffffff" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner css=".vc_custom_1485528150722{padding-top: 0px !important;}" offset="vc_col-md-4"][ra_newsletter template="3d" newsletter_id="1" inputs_size="xs" i_type="fontawesome" i_align="right" btn_display="label_icon" i_add_icon="true" i_icon_fontawesome="fa fa-angle-right" txt_color="#0a0a0a"][/vc_column_inner][vc_column_inner align="text-right" css=".vc_custom_1490084260056{padding-top: 0px !important;}" offset="vc_col-md-6"][vc_column_text]We Accept     <img class="alignnone wp-image-74 size-full" src="http://cloud.boo.themerella.com/wp-content/uploads/sites/14/2017/01/payment-cards2.png" width="414" height="31" />[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1483615191006{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner align="text-center" css=".vc_custom_1485521480274{padding-top: 0px !important;}"][vc_column_text css=".vc_custom_1489333678314{margin-bottom: 30px !important;}"]Boo Infinite Clouds, 2017.[/vc_column_text][ra_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Corporate', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/corporate01-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-sm-offset-0" css=".vc_custom_1485847860074{margin-bottom: 40px !important;}"][vc_single_image image="" img_size="full" css=".vc_custom_1485843854095{margin-bottom: 30px !important;}"][vc_column_text css=".vc_custom_1485843749371{margin-bottom: 24px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate.[/vc_column_text][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="<strong>Learn more</strong>" i_icon_fontawesome="fa fa-long-arrow-right" i_ml="10px" text_color="#ffffff" htext_color="#ffffff"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3"][vc_custom_heading text="need help?" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484504955550{margin-top: 0px !important;margin-bottom: 30px !important;}"][vc_wp_custommenu nav_menu="12"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3"][vc_custom_heading text="latest posts" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484505191587{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_latest_posts style="excerpt-only" post_type="post" posts_per_page="2"][/vc_column][vc_column width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3"][vc_custom_heading text="get in touch" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484505207063{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_cf7 style="s15" id="54" btn="" i_type="fontawesome" i_align="right" i_icon_fontawesome="fa fa-angle-right"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1490937879120{margin-top: 30px !important;border-top-width: 1px !important;padding-top: 20px !important;padding-bottom: 15px !important;background-color: #12223d !important;border-top-color: rgba(255,255,255,0.15) !important;border-top-style: solid !important;}"][vc_column width="1/2" css=".vc_custom_1483454274712{padding-top: 0px !important;}"][vc_column_text css=".vc_custom_1490937888947{margin-bottom: 0px !important;}"]
<p class="mb-0">2016, Boo Business, by Themerella.</p>
[/vc_column_text][/vc_column][vc_column width="1/2" align="text-right" css=".vc_custom_1485842894543{padding-top: 5px !important;}"][ra_social_icons style="" visibility="faded" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Corporate 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/corporate02-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2" offset="vc_col-lg-3"][vc_single_image image="" img_size="full" css=".vc_custom_1485844973404{margin-bottom: 25px !important;}"][vc_column_text css=".vc_custom_1485844176316{margin-bottom: 24px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate.[/vc_column_text][vc_column_text css=".vc_custom_1485844840286{margin-bottom: 20px !important;border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 0.5em !important;padding-right: 1.2em !important;padding-bottom: 0.5em !important;padding-left: 1.2em !important;border-left-color: rgba(255,255,255,0.1) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.1) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.1) !important;border-bottom-style: solid !important;}"]Monday - Saturday: 8-5pm
Sunday: Closed[/vc_column_text][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="<strong>Learn more</strong>" i_icon_fontawesome="fa fa-long-arrow-right" i_ml="10px"][/vc_column][vc_column width="1/2" css=".vc_custom_1485847327868{padding-left: 30px !important;}" offset="vc_col-lg-3"][vc_custom_heading text="need help?" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484506924555{margin-top: 0px !important;margin-bottom: 30px !important;}"][vc_wp_custommenu nav_menu="8"][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][vc_custom_heading text="latest posts" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484507038271{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_latest_posts style="excerpt-only" post_type="post" posts_per_page="2"][/vc_column][vc_column width="1/2" offset="vc_col-lg-3"][vc_custom_heading text="get in touch" font_container="tag:h3|font_size:21px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484507045689{margin-top: 0px !important;margin-bottom: 30px !important;}"][ra_cf7 style="s15" id="39" btn="" i_type="fontawesome" i_align="right" i_icon_fontawesome="fa fa-angle-right"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1486130193673{margin-top: 60px !important;padding-top: 25px !important;padding-bottom: 25px !important;background-color: #f2784b !important;}"][vc_column width="1/2" css=".vc_custom_1483456248325{padding-top: 0px !important;}"][vc_column_text css=".vc_custom_1493618887635{margin-bottom: 0px !important;}"]<span style="color: #ffffff;">002016, Boo Business, by Themerella.</span>[/vc_column_text][/vc_column][vc_column width="1/2" align="text-right" css=".vc_custom_1486130168987{padding-top: 5px !important;}"][ra_social_icons style="" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff" hover_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Elegant', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/elegant-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gradient_bg="yes" css=".vc_custom_1488401383627{margin-top: 0px !important;padding-top: 320px !important;padding-bottom: 40px !important;}" gradient_bg_color="linear-gradient(175deg,rgb(178, 137, 242) 0%,rgb(142, 84, 233) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column width="1/3"][vc_single_image image="" img_size="full" css=".vc_custom_1488401542208{padding-bottom: 30px !important;}"][vc_column_text css=".vc_custom_1478894235376{margin-bottom: 30px !important;}"]

Lorem ipsum dolor sit amet, consectetur
adipiscing elit, sed do eiusmod tempor
incididunt consectetur adipiscing elit.[/vc_column_text][ra_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D"][/vc_column][vc_column width="1/3" css=".vc_custom_1484073506968{padding-top: 0px !important;}"][ra_custom_menu style="col2" menu_id="12" cm_style="classic-date-featured" el_class="text-white"][/vc_column][vc_column width="1/3"][ra_newsletter template="elegant" newsletter_id="1" inputs_size="sm" i_type="fontawesome" i_align="right" btn_display="label_icon" i_add_icon="true" i_icon_fontawesome="fa fa-angle-right" txt_color="#ffffff" brd_color="rgba(255,255,255,0.25)" txt_f_color="#ffffff" btn_txt_color="#ffffff" brd_f_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Blue Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Hosting Blue', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/hostingblue-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes"][vc_column width="1/2" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="Useful Pages" font_container="tag:h3|font_size:17px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484556848341{margin-top: 0px !important;margin-bottom: 24px !important;}"][vc_wp_custommenu nav_menu="7"][/vc_column][vc_column width="1/2" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="Domain" font_container="tag:h3|font_size:17px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484556871721{margin-top: 0px !important;margin-bottom: 24px !important;}"][vc_wp_custommenu nav_menu="8"][/vc_column][vc_column width="1/2" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="Account" font_container="tag:h3|font_size:17px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484556886652{margin-top: 0px !important;margin-bottom: 24px !important;}"][vc_wp_custommenu nav_menu="9"][/vc_column][vc_column width="1/2" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="Other Pages" font_container="tag:h3|font_size:17px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484556908553{margin-top: 0px !important;margin-bottom: 24px !important;}"][vc_wp_custommenu nav_menu="10"][/vc_column][vc_column width="1/2" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="Follow" font_container="tag:h3|font_size:17px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1484556931296{margin-top: 0px !important;margin-bottom: 24px !important;}"][vc_wp_custommenu nav_menu="11"][/vc_column][vc_column width="1/2" offset="vc_col-md-2 vc_col-xs-6"][vc_single_image image=""][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1485249833717{margin-top: 40px !important;padding-top: 35px !important;padding-bottom: 35px !important;background-color: #2a3337 !important;}" el_class="bottom-footer"][vc_column align="text-center" css=".vc_custom_1490854158983{padding-top: 0px !important;}"][vc_column_text css=".vc_custom_1490854164095{margin-bottom: 0px !important;}"](C) 2015 Boo Theme by Themerella.[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Red Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Hosting Red', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/hostingred-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1485285670463{padding-top: 40px !important;padding-bottom: 48px !important;}"][vc_column offset="vc_col-md-4"][vc_column_text css=".vc_custom_1485285616328{margin-bottom: 25px !important;}"]
<h5><span style="color: #ffffff;">About Us</span></h5>
[/vc_column_text][vc_column_text]<span style="color: #999999;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliqu.</span>[/vc_column_text][vc_column_text]
<h3 class="widget-title"><img class="mt-30 alignnone size-medium wp-image-32" src="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2017/01/logo22-147x20.png" alt="" width="147" height="20" /></h3>
[/vc_column_text][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_column_text css=".vc_custom_1485285622173{margin-bottom: 25px !important;}"]
<h5><span style="color: #ffffff;">Main Menu</span></h5>
[/vc_column_text][vc_wp_custommenu nav_menu="6"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_column_text css=".vc_custom_1485285628529{margin-bottom: 25px !important;}"]
<h5><span style="color: #ffffff;">Account</span></h5>
[/vc_column_text][vc_wp_custommenu nav_menu="7"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_column_text css=".vc_custom_1485285637963{margin-bottom: 25px !important;}"]
<h5><span style="color: #ffffff;">Resources</span></h5>
[/vc_column_text][vc_wp_custommenu nav_menu="8"][/vc_column][vc_column width="1/2" offset="vc_col-md-2"][vc_column_text css=".vc_custom_1485285644315{margin-bottom: 25px !important;}"]
<h5><span style="color: #ffffff;">Support</span></h5>
[/vc_column_text][vc_wp_custommenu nav_menu="9"][/vc_column][/vc_row][vc_row css=".vc_custom_1485285519023{border-top-width: 1px !important;padding-top: 28px !important;padding-bottom: 60px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"][vc_column align="text-center"][vc_column_text css=".vc_custom_1485285690784{margin-bottom: 50px !important;}"]Use of this Site is subject to express terms of use. By using this site, you signify that you agree to be bound by these Universal Terms of Service.
(C) 1999 - 2015 BOOHOST Operating Company, LLC. All Rights Reserved.[/vc_column_text][vc_single_image image="" img_size="full" alignment="center" el_class="align-center"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Newsletter Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Main Newsletter', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/main-newsletter-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column align="text-center"][vc_custom_heading text="Stories in your pocket." font_container="tag:h3|font_size:21px|text_align:center" use_theme_fonts="yes" css=".vc_custom_1490202230924{margin-bottom: 35px !important;}"][/vc_column][vc_column offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1499437915517{margin-top: 15px !important;margin-bottom: 35px !important;padding-right: 60px !important;padding-left: 60px !important;}"][ra_newsletter newsletter_id="1" style="solid" inputs_shadow="subscribe-form--input-shadow-2" btn_style="naked" btn_display="icon" btn_position="subscribe-form--button-inside" i_type="fontawesome" i_align="right" i_add_icon="true" template="shadowed" i_icon_fontawesome="fa fa-long-arrow-right" btn_txt_color="#dd0000" txt_color="#939393"][/vc_column][vc_column align="text-center" css=".vc_custom_1490202265470{margin-top: 10px !important;}"][ra_custom_menu style="inline" menu_id="341"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Mobile', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/mobile-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gradient_bg="yes" gradient_bg_color="linear-gradient(to bottom right,rgb(37, 128, 217) 1.6%,rgb(147, 73, 255) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" css=".vc_custom_1485364318352{padding-top: 60px !important;padding-bottom: 20px !important;}"][vc_column offset="vc_col-md-4" css=".vc_custom_1485362409332{margin-bottom: 30px !important;}"][vc_single_image image="" img_size="full" css=".vc_custom_1484389267854{margin-bottom: 35px !important;}"][vc_column_text css=".vc_custom_1483538669949{margin-bottom: 35px !important;}"]At vero eos et accusamus et iusto odio
dignissimos ducimus qui blanditiis praesentium[/vc_column_text][ra_icon_box template="" heading_size="icon-box-heading-sm" heading_weight="weight-medium" i_type="fontawesome" shape_size="sm" position="icon-box-side" ib_style="" title="232 772 28 82" icon_color="#ffffff" title_color="#ffffff" i_icon_fontawesome="fa fa-phone" icon_fs="22px" title_size="13px" el_class="mb-10"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-sm" heading_weight="weight-medium" i_type="fontawesome" shape_size="sm" position="icon-box-side" ib_style="" title="info@boo.com" icon_color="#ffffff" title_color="#ffffff" i_icon_fontawesome="fa fa-envelope-o" icon_fs="22px" title_size="13px" el_class="mb-10"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-sm" heading_weight="weight-medium" i_type="fontawesome" shape_size="sm" position="icon-box-side" ib_style="" title="5th Avenue, Manhattan" icon_color="#ffffff" title_color="#ffffff" i_icon_fontawesome="fa fa-map-marker" icon_fs="22px" title_size="13px" el_class="mb-30"][/ra_icon_box][ra_social_icons style="" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="17px"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][vc_custom_heading text="Useful Links" font_container="tag:h3|font_size:20px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485360908973{margin-top: 0px !important;margin-bottom: 25px !important;}" el_class="weight-medium"][ra_custom_menu style="col2" menu_id="6" cm_style=""][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-4"][vc_custom_heading text="Get in Touch" font_container="tag:h3|font_size:20px|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485360915827{margin-top: 0px !important;margin-bottom: 25px !important;}" el_class="weight-medium"][ra_cf7 style="s11" id="67" btn="" i_type="fontawesome" i_align="right" i_icon_fontawesome="fa fa-angle-right"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Portfolio', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/pf04-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row css_animation="none" css=".vc_custom_1491326236114{margin-left: 125px !important;}"][vc_column width="1/4"][vc_single_image image="" img_size="full"][/vc_column][vc_column width="1/4"][vc_column_text]<span style="color: #999999;">3rd Avenue, Upper East Side</span>
<span style="color: #000000;">1 800 977 78 80</span>
<span style="color: #000000;"><a style="color: #000000;" href="mailto:info@boolondon.com">info@boolondon.com</a></span>[/vc_column_text][/vc_column][vc_column width="1/4"][vc_column_text]<a href="#">Facebook</a>
<a href="mailto:info@boolondon.com">Linkedin</a>
<a href="mailto:info@boolondon.com">Instagram</a>[/vc_column_text][/vc_column][vc_column width="1/4"][vc_column_text]<a href="#">Behance</a>
<a href="mailto:info@boolondon.com">Dribbble</a>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio Footer 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Portfolio 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/pf05-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="2/3"][vc_column_text]
<h5><strong>Drop us a line below, we?d love to talk.</strong>
<strong>ecommerce flagships, and branded content that</strong>
<span style="color: #a7adf1;"><strong><a href="#">works@themerella.com  <i class="fa fa-long-arrow-right" style="font-size: 19px;"></i></a></strong></span></h5>
[/vc_column_text][vc_separator color="custom" align="align_left" style="dashed" el_width="80" accent_color="rgba(167,173,241,0.52)"][vc_column_text]
<h6><strong><span style="color: #a7adf1;">P: </span>+ 800 330 38 83,  <span style="color: #a7adf1;">P: </span>+ 800 770 38 87</strong>
<strong><span style="color: #a7adf1;">A:</span> 5th Avenue, Upper East, Boston</strong></h6>
[/vc_column_text][ra_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="25px" primary_color="#a7adf1" hover_color="#ffffff"][/vc_column][vc_column width="1/3" css=".vc_custom_1489856438472{padding-top: 25px !important;padding-right: 50px !important;}"][ra_content_box style="s12" show_button="yes" ib_style="btn-underlined" ib_border="border-thicker" ib_text="text-uppercase" image="" ib_title="Join us" ib_text_color="#ffffff" ib_bc="#ffffff" ib_hbc="#ffffff" ib_second_color="#ffffff" el_class="jobs-shadow" ib_htext_color="#ffffff"][/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer University', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/university-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes"][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="NAVIGATION" font_container="tag:h3|font_size:15px|text_align:left|color:%23ffffff|line_height:25px" use_theme_fonts="yes" css=".vc_custom_1485460578090{margin-top: 0px !important;margin-bottom: 20px !important;}"][vc_wp_custommenu nav_menu="7"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="COURSE" font_container="tag:h3|font_size:15px|text_align:left|color:%23ffffff|line_height:25px" use_theme_fonts="yes" css=".vc_custom_1485460583036{margin-top: 0px !important;margin-bottom: 20px !important;}"][vc_wp_custommenu nav_menu="8"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="FACILITY" font_container="tag:h3|font_size:15px|text_align:left|color:%23ffffff|line_height:25px" use_theme_fonts="yes" css=".vc_custom_1485460589873{margin-top: 0px !important;margin-bottom: 20px !important;}"][vc_wp_custommenu nav_menu="9"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="STUDENT" font_container="tag:h3|font_size:15px|text_align:left|color:%23ffffff|line_height:25px" use_theme_fonts="yes" css=".vc_custom_1485460608161{margin-top: 0px !important;margin-bottom: 20px !important;}"][vc_wp_custommenu nav_menu="10"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="CAMPUS" font_container="tag:h3|font_size:15px|text_align:left|color:%23ffffff|line_height:25px" use_theme_fonts="yes" css=".vc_custom_1485460613020{margin-top: 0px !important;margin-bottom: 20px !important;}"][vc_wp_custommenu nav_menu="11"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6"][vc_custom_heading text="FACULTY" font_container="tag:h3|font_size:15px|text_align:left|color:%23ffffff|line_height:25px" use_theme_fonts="yes" css=".vc_custom_1485460618931{margin-top: 0px !important;margin-bottom: 20px !important;}"][vc_wp_custommenu nav_menu="12"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1491979769745{margin-top: 40px !important;padding-top: 60px !important;padding-bottom: 20px !important;background-color: #222323 !important;}"][vc_column align="text-center" css=".vc_custom_1485459993839{padding-top: 0px !important;}"][ra_custom_menu style="inline2" menu_id="13" cm_style="" primary_color="rgba(10,10,10,0.4)" cm_htext_color="#ffffff"][vc_column_text css=".vc_custom_1485460210815{padding-top: 20px !important;}"]<span style="color: #5a5a5a;">(C) 2015 Boo - The PSD!. All Rights Reserved.</span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//University Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Portfolio05', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/portfolio05-footer.jpg' );
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1497372139404{margin-bottom: 38px !important;}"][vc_column width="2/3"][vc_column_text] <h3><span style="color: #ffffff;">Drop us a line below, we?d love to talk.</span> <span style="color: #ffffff;">ecommerce management, and branded content that</span> <span style="color: #a7adf1;"><a href="#">works@themerella.com <i class="fa fa-long-arrow-right" style="font-size: 19px;"></i></a></span></h3> [/vc_column_text][vc_separator color="custom" align="align_left" style="dashed" el_width="80" accent_color="rgba(167,173,241,0.52)"][vc_column_text] <h5><span style="color: #a7adf1;">P: </span><span style="color: #ffffff;">+ 800 330 38 83,</span> <span style="color: #a7adf1;">P: </span><span style="color: #ffffff;">+ 800 770 38 87</span> <span style="color: #a7adf1;">A:</span> <span style="color: #ffffff;">5th Avenue, Upper East, Boston</span></h5> [/vc_column_text][ra_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="21px" primary_color="#a7adf1" hover_color="#ffffff"][/vc_column][vc_column width="1/3" css=".vc_custom_1497374784144{padding-top: 20px !important;padding-right: 35px !important;}"][ra_content_box style="s12" show_button="yes" ib_style="btn-underlined" ib_border="border-thick" ib_text="text-uppercase" ib_title="Join us" ib_text_color="#ffffff" ib_bc="#ffffff" ib_hbc="#ffffff" el_class="jobs-shadow" ib_htext_color="#ffffff" image="111" title_size="11px"][/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Footer vc-template
	$data = array();
	$data['name'] = esc_html__( 'Footer Shop', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/footers/shop-footer-footers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Footer';
	$data['custom_class'] = 'general footer';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces"][vc_column][ra_instagram limit="6" show_button="yes" ib_style="btn-solid" ib_curtain_hover="bottom" ib_shape="semi-round" ib_size="btn-md" ib_text="text-uppercase" username="fashionforall" ib_title="Shop Collection" ib_link="url:%23|||" ib_primary_color="#0c0c0c" ib_hbg="#000000" ib_curtain_hbg="#ffffff" ib_text_color="#ffffff" ib_htext_color="#000000" ib_fs="12px"][/vc_column][/vc_row][vc_row css=".vc_custom_1510227073722{padding-top: 80px !important;padding-bottom: 45px !important;}"][vc_column width="1/2" offset="vc_col-md-3"][vc_single_image image_type="svg" image="4375" img_size="full"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][vc_custom_heading text="NEWSLETTER" font_container="tag:h3|font_size:12px|text_align:left|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.1em" css=".vc_custom_1510226859885{margin-top: 0px !important;}"][vc_column_text]<span style="font-size: 15px; line-height: 35px; color: #9c9c9c;">Phone: +1 800 383 90 30</span> <span style="font-size: 15px; line-height: 35px; color: #9c9c9c;"> Address: 3rd Avenue, 83, US</span> <span style="font-size: 15px; line-height: 35px; color: #9c9c9c;"> Mail: orders@boo.com</span>[/vc_column_text][/vc_column][vc_column width="1/3" offset="vc_col-md-2"][vc_custom_heading text="STORES" font_container="tag:h3|font_size:12px|text_align:left|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.1em" css=".vc_custom_1510226872548{margin-top: 0px !important;}"][vc_wp_custommenu nav_menu="18"][/vc_column][vc_column width="1/3" offset="vc_col-md-2"][vc_custom_heading text="ABOUT US" font_container="tag:h3|font_size:12px|text_align:left|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.1em" css=".vc_custom_1510226895600{margin-top: 0px !important;}"][vc_wp_custommenu nav_menu="19"][/vc_column][vc_column width="1/3" offset="vc_col-md-2"][vc_custom_heading text="SOCIAL" font_container="tag:h3|font_size:12px|text_align:left|line_height:1.5em" use_theme_fonts="yes" letter_spacing="0.1em" css=".vc_custom_1510226916672{margin-top: 0px !important;}"][ra_social_icons style="" shape="circle" scheme="scheme-dark" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="17px" primary_color="#ffffff" hover_color="#0c0c0c" bg_color="#0c0c0c" hbg_color="#ffffff"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Header
	//Dark Vertical Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Dark Vertical', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/dark-vertical-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" vertical_nav="yes" mainbar_container_style="no-side-spacing" mainbar_style="round" css=".vc_custom_1507575843919{border-right-width: 1px !important;background-color: #212121 !important;border-right-color: #424242 !important;border-right-style: solid !important;}"][vc_row enable_responsive_options="yes" responsive_css="padding_top_tablet:0|padding_right_tablet:0|padding_bottom_tablet:0|padding_left_tablet:0|padding_top_mobile:0|padding_right_mobile:0|padding_bottom_mobile:0|padding_left_mobile:0"][vc_column][ra_header_main_nav menu_id="7" menu_slug="main-nav"][ra_header_container module_padding="0px"][ra_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_column_text css=".vc_custom_1507575496520{margin-top: -8px !important;}"]<span style="font-size: 14px;">All rights reserved. Boo Theme.</span>[/vc_column_text][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Essential One Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Essential One', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/essential-one-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="shadowed,always_sticky,shrink_sticky" mainbar_style="round" css=".vc_custom_1504954798552{padding-top: 0px !important;padding-bottom: 0px !important;background-color: #ffffff !important;}" stickybar_color="rgba(255,255,255,0.88)"][vc_row][vc_column][ra_header_main_nav style="s3" menu_slug="primary"][ra_header_container module_padding="23px"][ra_header_search style="ghost" trigger_size="sm"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Essential Two Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Essential Two', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/essential-two-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" secondary_bar_style=""][vc_row equal_height="yes" content_placement="middle" zindex="90"][vc_column width="3/4"][ra_header_container][ra_icon_box template="" heading_size="custom" i_type="fontawesome" position="icon-box-inline" title="Phone: " i_icon_fontawesome="fa fa-phone" icon_color="#000000" title_color="#000000" content_color="#919191" icon_fs="13px" title_size="13px" content_size="13px"]+ 1800 377 80 80[/ra_icon_box][ra_icon_box template="" heading_size="custom" i_type="fontawesome" position="icon-box-inline" title="Mail: " i_icon_fontawesome="fa fa-envelope-o" icon_color="#000000" title_color="#000000" content_color="#919191" icon_fs="13px" title_size="13px" content_size="13px"]support@boo.com[/ra_icon_box][ra_icon_box template="" heading_size="custom" i_type="fontawesome" position="icon-box-inline" title="Hours: " i_icon_fontawesome="fa fa-clock-o" icon_color="#000000" title_color="#000000" content_color="#919191" icon_fs="13px" title_size="13px" content_size="13px"]Mon-Fri 8am - 7pm[/ra_icon_box][ra_lang_chooser trigger_color="#0c0c0c"][/ra_header_container][/vc_column][vc_column width="1/4" align="text-lg-right"][ra_header_container][ra_social_icons style="" visibility="faded" size="social-icon-md" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22flickr%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22skype%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="shadowed,always_sticky,sticky2" mainbar_style="round" css=".vc_custom_1504268150598{border-top-width: 1px !important;padding-top: 0px !important;padding-bottom: 0px !important;background-color: #ffffff !important;border-top-color: #eeeeee !important;border-top-style: solid !important;}"][vc_row][vc_column][ra_header_main_nav menu_slug="main-nav"][ra_header_container module_padding="10px"][ra_button style="btn-solid" lightbox="yes" lightbox_type="inline" shape="round" size="btn-xsm" title="Hire Us" link="url:%23quote_button|||" fs="13px"][ra_header_search style="simple"][/ra_header_container][ra_modal_window el_id="quote_button"][ra_section_title style="classic" title="Contact Us"]User Claritas est etiam processus dynamicus, qui sequitur mutationem.[/ra_section_title][ra_cf7 style="s21" id="3052" btn="full-width-submit" primary_color="#60af51"][/ra_modal_window][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Fashion Blog Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Fashion Blor', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/fashion-blog-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,shadowed,header-fullwidth-justified,modules-fullscreen,modules-fullscreen-alt-3" mainbar_style="nav-left" mainbar_color="#ffffff" stickybar_color="#ffffff"][vc_row css=".vc_custom_1495036726901{margin-right: 30px !important;margin-left: 30px !important;}"][vc_column][ra_header_main_nav style="off-canvas" caret_visibility="show" add_divider="yes" menu_id="35" menu_slug="footer"][ra_header_container][ra_custom_menu style="inline" t_transform="uppercase" menu_id="35" color="#000000" l_height="2em" f_size="12px" l_spacing="0.12em"][/ra_header_container][ra_header_container][ra_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(2,2,2,0.37)" hover_color="#000000"][ra_header_search style="offcanvas" i_type="fontawesome" i_icon_fontawesome="fa fa-search" logo="5617" retina_logo="5617" primary_color="#000000"][/ra_header_container][ra_header_container position="off-canvas" off_canvas="right"][vc_single_image image="5645" alignment="center"][vc_single_image image="5623" alignment="center"][vc_column_text] <p style="text-align: center;">I am Clara, motion fashion based in San Francisco. Let the stories unfold and unleash yourself.</p> [/vc_column_text][ra_newsletter newsletter_id="1" style="underlined" btn_style="naked" btn_display="icon" btn_position="subscribe-form--button-inside" i_type="fontawesome" i_icon_fontawesome="fa fa-long-arrow-right"][ra_social_icons style="" shape="circle" scheme="scheme-dark" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22rss%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Landing Three Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Landing Three', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/landing-three-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="no-side-spacing,always_sticky,shrink_sticky" mainbar_style="round" stickybar_color="rgba(246,247,252,0.95)"][vc_row][vc_column][ra_header_main_nav local_scroll="true" menu_slug="main-nav"][ra_header_container module_padding="25px"][ra_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22github%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="22px" primary_color="rgba(255,255,255,0.64)" hover_color="#ffffff"][ra_button style="btn-default" curtain_hover="bottom" shape="semi-round" size="btn-xsm" border="border-thick" others="wide" title="Free Trial" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" primary_color="rgba(255,255,255,0.45)" curtain_hbg="#ffffff" htext_color="#000000" hbc="#ffffff" hbg="rgba(255,255,255,0.01)" text_color="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Landing Two Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Landing Two', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/landing-two-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="shadowed,always_sticky" mainbar_style="round" css=".vc_custom_1504785794370{padding-top: 0px !important;padding-bottom: 0px !important;}" stickybar_color="rgba(255,255,255,0.88)"][vc_row][vc_column][ra_header_main_nav local_scroll="true" menu_slug="inner-page-nav"][ra_header_container module_padding="10px"][ra_button style="btn-solid" shape="round" size="btn-sm" text="text-uppercase" title="Free Trial" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource||target:%20_blank|" fs="14px" fw="700"][ra_button style="btn-default" shape="round" size="btn-sm" text="text-uppercase" title="Buy Now" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource||target:%20_blank|" primary_color="#d8d8d8" hbg="#000000" text_color="#999999" htext_color="#ffffff" fs="14px" fw="700"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Light Vertical Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Light Vertical', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/light-vertical-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" vertical_nav="yes" mainbar_container_style="no-side-spacing,sticky2" mainbar_style="round" css=".vc_custom_1507394738850{border-bottom-width: 1px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;border-bottom-color: rgba(78,42,132,0.08) !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ra_header_main_nav menu_slug="menu-1" logo="5660"][ra_header_container][ra_social_icons style="" size="social-icon-md" identities="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(50,58,61,0.39)" hover_color="#323a3d" font_size="21px"][vc_column_text]<span style="color: #cdcdcd; font-size: 12px;">All rights reserved. Boo Theme.</span>[/vc_column_text][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Modern Four Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Modern Four', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/modern-four-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="modules-fullscreen,modules-fullscreen-alt-2" mainbar_style="round"][vc_row content_placement="middle" enable_responsive_options="yes" css=".vc_custom_1503328997509{padding-top: 95px !important;padding-right: 10% !important;padding-bottom: 95px !important;padding-left: 10% !important;}" responsive_css="padding_top_tablet:0|padding_right_tablet:0|padding_bottom_tablet:0|padding_left_tablet:0|padding_top_mobile:0|padding_right_mobile:0|padding_bottom_mobile:0|padding_left_mobile:0"][vc_column align="text-lg-center text-md-center text-sm-center text-xs-center"][ra_header_main_nav style="fs3" menu_id="7" logo="14" menu_slug="main-nav" nav_bg_color="#21241f"][ra_header_container module_padding="0px"][ra_button style="btn-default" text="text-uppercase" i_align="right" title="Get in touch" text_color="#ffffff" fs="14px" htext_color="#000000" fw="500" ls="0.15em" bc="rgba(255,255,255,0.17)" hbc="#ffffff" primary_color="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Separated Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Separated', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/separated-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="header-fullwidth-justified header-logo-centered" mainbar_style="round" css=".vc_custom_1508341227235{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}" stickybar_color="#ffffff"][vc_row css=".vc_custom_1508434122927{margin-top: 20px !important;}"][vc_column][ra_header_main_nav style="dm" menu_slug="menu-left" second_menu_slug="main-right"][ra_header_container_mobile][vc_column_text]<span style="font-size: 13px; font-weight: 500; line-height: 35px; color: #6d6d6d;">E: mail@boo.com</span> <span style="font-size: 13px; color: #6d6d6d;">P: +1 838 708 83 30</span> <span style="font-size: 13px; color: #6d6d6d;">A: Upper East Side, San Francisco</span>[/vc_column_text][/ra_header_container_mobile][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Shop Two Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Shop Two', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/shop-two-header-headers.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" secondary_bar_style="" css=".vc_custom_1510588941275{border-bottom-width: 1px !important;padding-top: 0px !important;padding-bottom: 0px !important;background-color: #ffffff !important;border-bottom-color: #f2f2f2 !important;border-bottom-style: solid !important;}"][vc_row css=".vc_custom_1510150754067{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column align="text-lg-center" css=".vc_custom_1510148908123{padding-top: 19px !important;padding-bottom: 19px !important;}"][vc_single_image image_type="svg" image="4375" img_size="full" alignment="center" onclick="custom_link" css=".vc_custom_1510558915904{margin-top: 0px !important;margin-bottom: 0px !important;}" link="http://shoptwo.themerella.com"][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,shadowed,always_sticky,sticky2,header-fullwidth-justified" mainbar_style="round" css=".vc_custom_1510589503133{padding-top: 0px !important;padding-right: 20px !important;padding-left: 30px !important;background-color: #ffffff !important;}"][vc_row][vc_column css=".vc_custom_1510147558173{padding-top: 0px !important;}"][ra_header_container module_padding="0px"][ra_header_search style="fullscreen" i_type="fontawesome" i_icon_fontawesome="fa fa-search"][/ra_header_container][ra_header_main_nav style="s3" logo_visibility="hide" menu_slug="main-nav"][ra_header_container module_padding="10px"][ra_header_cart amount_visibility="hide" i_type="fontawesome" i_icon_fontawesome="fa fa-shopping-cart"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Agency Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Agency', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/agency-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1484816524025{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_row content_placement="middle"][vc_column offset="vc_col-md-9"][ra_header_container][ra_custom_menu style="underline2" menu_id="185" cm_style="btn-default" color="#ffffff" cm_sh_icon="" cm_sh_css_box="" cm_sh_label="" cm_sh_border=""][/ra_header_container][/vc_column][vc_column el_class="text-right" offset="vc_col-md-3"][ra_header_container][ra_social_icons style="" size="social-icon-lg" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22pinterest%22%2C%22url%22%3A%22%23%22%7D%5D" el_class="faded"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_style="round,solid,shadowed" mainbar_color="#ffffff"][vc_row][vc_column][ra_header_main_nav style="s6" logo=""][ra_header_container][vc_separator el_class="v-sep"][ra_button style="btn-linethrough" text="text-uppercase" title="Hire us" primary_color="#05baef" el_class="weight-bold"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Barber Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Barber', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/barber-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="modules-fullscreen,modules-fullscreen-alt"][vc_row content_placement="middle"][vc_column][ra_header_main_nav menu_id="7" style="fs2" logo="53"][ra_header_container][vc_row_inner][vc_column_inner css=".vc_custom_1500016448238{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 70px !important;padding-bottom: 70px !important;border-left-style: solid !important;border-right-style: solid !important;border-top-style: solid !important;border-bottom-style: solid !important;}" align="text-lg-center"][ra_icon_box template="" i_type="fontawesome" shape_size="sm" position="icon-box-inline" title="5th Avenue, Salon 1010 Wien, Wallnerst 512." i_icon_fontawesome="fa fa-map-marker" icon_fs="19px" icon_color="#8f8f8f" title_color="#8f8f8f"][/ra_icon_box][vc_empty_space][ra_icon_box template="ci" i_type="fontawesome" shape_size="sm" position="icon-box-inline" title="+43 ( 1 ) 535 53 53" i_icon_fontawesome="fa fa-phone" icon_fs="19px" icon_color="#8f8f8f" title_color="#8f8f8f"][/ra_icon_box][vc_empty_space][ra_icon_box template="ci" i_type="fontawesome" shape_size="sm" position="icon-box-inline" title="info@boo.com" i_icon_fontawesome="fa fa-envelope-o" icon_fs="19px" icon_color="#8f8f8f" title_color="#8f8f8f"][/ra_icon_box][vc_empty_space][ra_icon_box template="ci" i_type="fontawesome" shape_size="sm" position="icon-box-inline" title="From monday to Friday: 8am - 5pm" i_icon_fontawesome="fa fa-clock-o" icon_fs="19px" icon_color="#8f8f8f" title_color="#8f8f8f"][/ra_icon_box][vc_empty_space height="70px"][ra_social_icons style="text-only" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube%22%2C%22url%22%3A%22%23%22%7D%5D" hover_color="rgba(255,255,255,0.85)"][/vc_column_inner][/vc_row_inner][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Business 01 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Business 01', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/business01-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,header-fullwidth-justified" css=".vc_custom_1492003491469{border-bottom-width: 1px !important;padding-top: 0px !important;border-bottom-color: rgba(255,255,255,0.1) !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ra_header_main_nav menu_id="6" style="s6" caret_visibility="show" logo="44"][ra_header_container][ra_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_separator vertical="yes" color="white" css=".vc_custom_1493718127841{background-color: rgba(255,255,255,0.1) !important;*background-color: rgb(255,255,255) !important;}"][ra_header_search style="fullscreen" primary_color="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Business 04 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Business 04', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/business04-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1493213122926{padding-top: 44px !important;padding-bottom: 44px !important;}"][vc_row content_placement="middle"][vc_column width="1/4"][ra_header_container][vc_single_image image="48"][/ra_header_container][/vc_column][vc_column width="3/4"][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="no-side-spacing" mainbar_style="solid,shadowed,nav-left" mainbar_color="#ffffff"][vc_row][vc_column][ra_header_main_nav menu_id="7" style="s6" logo_visibility="hide" caret_visibility="show"][ra_header_container][ra_icon_box template="" i_type="linea" position="icon-box-side" valignment="icon-middle" use_theme_fonts="" heading_font="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal" title="1 800 551 88 90" i_icon_linea="icon-flaticon-phone6" title_size="15px" title_color="#1e4554" icon_fs="22px" icon_color="#1e4554"][/ra_icon_box][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Business 08 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Business 08', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/business08-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing" mainbar_style="round" css=".vc_custom_1493384361771{padding-top: 0px !important;}"][vc_row][vc_column][ra_header_main_nav menu_id="6" style="s5" logo="38"][ra_header_container][ra_button style="btn-solid" shape="round" size="btn-lg" text="text-uppercase" i_type="fontawesome" i_align="right" title="Hire Us" i_icon_fontawesome="fa fa-angle-right" primary_color="#2f43a9" text_color="#ffffff" fs="13px" htext_color="#ffffff" css=".vc_custom_1493384539506{margin-right: -30px !important;}" ls="0.2em"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Car Dealer Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Car Dealer', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/car-dealer-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1483126595286{border-bottom-width: 1px !important;padding-top: 15px !important;padding-bottom: 15px !important;background-color: #ffffff !important;border-bottom-color: #f2f2f2 !important;border-bottom-style: solid !important;}"][vc_row content_placement="middle"][vc_column width="1/4"][ra_header_container][vc_single_image image="60" img_size="full" onclick="custom_link" link="#"][/ra_header_container][/vc_column][vc_column width="3/4" align="text-right"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="mon-fri: 08.00 - 18.00" i_icon_linea="icon-flaticon-clock3" icon_color="#d72828" icon_fs="33px"]live chat available[/ra_icon_box][vc_separator vertical="yes"][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="800 288 80 90" i_icon_linea="icon-flaticon-phone6" icon_color="#d72828" icon_fs="33px"]toll free[/ra_icon_box][ra_button style="" shape="round" size="btn-md" border="border-thick" text="text-uppercase" title="See Your Car" htext_color="#ffffff" fs="13px" primary_color="#d72828"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="shadowed,sticky2" mainbar_style="nav-left" css=".vc_custom_1485173955180{padding-top: 0px !important;background-color: #ffffff !important;}"][vc_row][vc_column][ra_header_main_nav menu_id="8" style="s3" logo_visibility="hide" caret_visibility="show" logo="3102"][ra_header_container][ra_social_icons style="" size="social-icon-md" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_separator vertical="yes" sep_height="v-sep short"][ra_header_search style="simple"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;
	
	//Car Rental Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Car Rental', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/car-rental-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1483129015771{padding-top: 28px !important;padding-bottom: 28px !important;}"][vc_row content_placement="middle"][vc_column width="1/4"][ra_header_container][vc_single_image image="44" img_size="full" onclick="custom_link" link="#"][/ra_header_container][/vc_column][vc_column width="3/4" align="text-right"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-semibold" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="<sub>mon-fri:</sub> 08.00 - 18.00" icon_color="#efa80f" icon_fs="30px" title_color="#21377d" i_icon_linea="icon-flaticon-clock3"]live chat available[/ra_icon_box][vc_separator vertical="yes"][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-semibold" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="800 388 80 90" icon_color="#efa80f" icon_fs="30px" title_color="#21377d" i_icon_linea="icon-flaticon-phone6"]toll free[/ra_icon_box][vc_separator vertical="yes"][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-semibold" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="info@boo.com" icon_color="#efa80f" icon_fs="30px" title_color="#21377d" i_icon_linea="icon-flaticon-placeholder"]reservations[/ra_icon_box][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_style="nav-left" css=".vc_custom_1483129341303{padding-top: 0px !important;background-color: #eeeff3 !important;}"][vc_row][vc_column][ra_header_main_nav menu_id="7" style="s7" logo_visibility="hide" logo="3102"][ra_header_container][ra_social_icons style="" visibility="faded" size="social-icon-md" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#12406d"][vc_separator vertical="yes" sep_height="v-sep shorter"][ra_header_search style="simple" primary_color="#12406d"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Classic Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/classic-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="sticky2,modules-fullscreen" css=".vc_custom_1484931538420{margin-top: 65px !important;}"][vc_row content_placement="middle" css=".vc_custom_1495794009523{padding-left: 45px !important;}"][vc_column][ra_header_main_nav menu_id="9" style="fs1" nav_bg="89"][ra_header_container position="top-right"][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Hire us" text_color="#b3977e" htext_color="#0a0a0a" i_icon_fontawesome="fa fa-long-arrow-right" fs="14px"][/ra_header_container][ra_header_container position="mid-right"][ra_icon_box template="" position="icon-box-inline" title="phone: 1 800 380 38 30" title_size="14px"][/ra_icon_box][ra_icon_box template="" position="icon-box-inline" title="5TH AVENUE, 87" title_size="14px"][/ra_icon_box][/ra_header_container][ra_header_container position="mid-left"][ra_social_icons style="text-only" identities="%5B%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#555450" hover_color="#b3977e" el_class="text-uppercase" font_size="13px"][/ra_header_container][ra_header_container position="bottom" orientation="horizontal"][ra_button style="btn-underlined" border="border-thicker" text="text-lowercase" title="hello@boo.com" text_color="#493f39" fs="30px" lh="0.75em" ls="0px" bc="#493f39"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Classic 2 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Classic 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/classic-2-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" css=".vc_custom_1482961148436{padding-top: 0px !important;}"][vc_row content_placement="middle" css_animation="fadeIn"][vc_column][ra_header_main_nav menu_id="2" style="s2" logo="41" retina_logo="41"][ra_header_container][ra_button style="btn-solid" shape="circle" size="btn-md" border="border-thick" text="text-uppercase" title="Build Yours" fs="12px" ls="0.1em" text_color="#ffffff" fw="700" primary_color="rgba(255,255,255,0.01)" bc="rgba(255,255,255,0.24)" hbg="#ffffff" htext_color="#1c1c1c"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Cloud Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Cloud', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/cloud-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1484647749198{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_row content_placement="middle"][vc_column width="1/4"][ra_header_container][vc_single_image image="77" img_size="full"][/ra_header_container][/vc_column][vc_column width="3/4" align="text-right"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="md" position="icon-box-side" valignment="icon-middle" title="Start Live Chat" i_icon_linea="icon-flaticon-multimedia" icon_color="#29aaeb" title_color="#c7dbef" content_color="#81a8c4" icon_fs="34px"]available[/ra_icon_box][vc_separator color="white" vertical="yes"][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="md" position="icon-box-side" valignment="icon-middle" title="mon - fri: 08am - 5pm" i_icon_linea="icon-flaticon-clock3" icon_color="#29aaeb" title_color="#c7dbef" content_color="#81a8c4" icon_fs="34px"]customer support[/ra_icon_box][ra_custom_menu style="dropdown" menu_id="9" i_align="right" cm_style="btn-solid" cm_shape="round" cm_size="btn-xxsm" cm_i_type="fontawesome" cm_i_align="right" primary_color="#1e73be" cm_text_color="rgba(255,255,255,0.75)" cm_i_icon_fontawesome="fa fa-angle-down" cm_title="Support"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_style="round,solid,shadowed,nav-left" mainbar_color="#ffffff"][vc_row][vc_column][ra_header_main_nav menu_id="10" style="s6" logo_visibility="hide" logo="77"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-bold" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="800 388 80 90" i_icon_linea="icon-flaticon-phone6" icon_color="#1e4554" icon_fs="30px" title_size="17px" title_color="#1e4554"][/ra_icon_box][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Corporate Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Corporate', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/corporate01-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="pulled-up" mainbar_style="round,solid,shadowed" css=".vc_custom_1502680358593{padding-top: 0px !important;}" mainbar_color="#002954"][vc_row][vc_column][ra_header_main_nav caret_visibility="show" menu_id="178" retina_logo="4337" menu_slug="mainmenu"][ra_header_search style="simple" primary_color="#ffffff"][/vc_column][/vc_row][/vc_section][vc_section section_type="secondary-bar" css=".vc_custom_1493098917863{padding-top: 35px !important;padding-bottom: 73px !important;background-color: #ffffff !important;}"][vc_row content_placement="middle"][vc_column offset="vc_col-md-4"][ra_header_container][ra_lang_chooser transform="text-capitalize" trigger_color="#1a3055" fw="700"][ra_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="20px" primary_color="rgba(40,51,84,0.3)" hover_color="#002954"][/ra_header_container][/vc_column][vc_column offset="vc_col-md-8"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="works.boo.com" i_icon_linea="icon-basic_elaboration_message_dots" icon_color="#50ba26" icon_fs="30px" title_color="#1a3055" css=".vc_custom_1501674322219{margin-right: 30px !important;}"]appointment[/ra_icon_box][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="mon-fri: 08.00 - 18.00" i_icon_linea="icon-basic_clock" icon_color="#50ba26" icon_fs="30px" title_color="#1a3055" css=".vc_custom_1505800932226{margin-right: 30px !important;}"]sun-fri: off[/ra_icon_box][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="+1 800 188 80 90" i_icon_linea="icon-phone5" icon_color="#50ba26" icon_fs="30px" title_color="#1a3055" css=".vc_custom_1505801079416{margin-right: 30px !important;}"]toll free[/ra_icon_box][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Corporate 2 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Corporate 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/corporate02-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1483132216163{padding-top: 0px !important;background-color: #3b3e79 !important;}" el_class="text-light"][vc_row equal_height="yes" content_placement="middle"][vc_column offset="vc_col-lg-8 vc_col-md-7"][ra_header_container][ra_icon_box template="" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="1 800 801 27 18" i_icon_fontawesome="fa fa-phone" icon_color="#f2784b" title_size="15px" title_color="#ffffff" icon_fs="20px"][/ra_icon_box][vc_separator vertical="yes" css=".vc_custom_1501702285528{background-color: rgba(255,255,255,0.1) !important;*background-color: rgb(255,255,255) !important;}"][ra_icon_box template="" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="sales.boo.com" i_icon_fontawesome="fa fa-envelope" icon_color="#f2784b" title_color="#ffffff" title_size="15px" icon_fs="20px"][/ra_icon_box][vc_separator vertical="yes" css=".vc_custom_1501702302436{background-color: rgba(255,255,255,0.1) !important;*background-color: rgb(255,255,255) !important;}"][ra_icon_box template="" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="1st Avenue, Boston" i_icon_fontawesome="fa fa-map-marker" icon_color="#f2784b" title_size="15px" title_color="#ffffff" icon_fs="20px"][/ra_icon_box][/ra_header_container][/vc_column][vc_column el_class="text-right" offset="vc_col-lg-4 vc_col-md-5"][ra_header_container module_padding="0px"][ra_social_icons style="" shape="square side-border" visibility="faded" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="18px" border_color="rgba(255,255,255,0.13)"][ra_button style="btn-solid" size="btn-md" i_type="fontawesome" i_align="right" title="work with us " i_icon_fontawesome="fa fa-angle-right" primary_color="#f2784b" fs="15px" text_color="#ffffff" htext_color="#ffffff" el_class="weight-bold"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="shadowed,sticky2" css=".vc_custom_1484229896882{padding-top: 0px !important;background-color: rgba(255,255,255,0.75) !important;*background-color: rgb(255,255,255) !important;}"][vc_row][vc_column][ra_header_main_nav caret_visibility="show" menu_id="177" logo="40" menu_slug="primary" retina_logo="4406"][ra_header_cart i_type="linea" i_color="#3b3e79" i_icon_linea="icon-ecommerce_cart_content"][ra_header_search style="simple" i_type="fontawesome" primary_color="#3b3e79" i_icon_fontawesome="fa fa-search"][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Corporate 3 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Corporate 3', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/corporate03-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1483132764794{border-bottom-width: 1px !important;padding-top: 0px !important;background-color: #f7f7f7 !important;border-bottom-color: #f0f0f0 !important;border-bottom-style: solid !important;}" el_class="text-light"][vc_row][vc_column offset="vc_col-md-8"][ra_header_container][ra_lang_chooser trigger_color="#333333"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="1 800 301 23 38" i_icon_fontawesome="fa fa-phone" title_size="15px" icon_color="#088ace" icon_fs="21px"][/ra_icon_box][vc_separator color="custom" vertical="yes" accent_color="#f0f0f0"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="sales@boo.com" i_icon_fontawesome="fa fa-envelope" title_size="15px" icon_color="#088ace" icon_fs="21px"][/ra_icon_box][vc_separator color="custom" vertical="yes" accent_color="#f0f0f0"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="3rd Avenue, Boston" i_icon_fontawesome="fa fa-map-marker" title_size="15px" icon_color="#088ace" icon_fs="21px"][/ra_icon_box][/ra_header_container][/vc_column][vc_column el_class="text-right" offset="vc_col-md-4"][ra_header_container][ra_social_icons style="" shape="square side-border" size="social-icon-lg" scheme="scheme-dark" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="16px" hover_color="#088ace" border_color="#f0f0f0" el_class="faded" primary_color="#949494"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="sticky2" mainbar_style="round" css=".vc_custom_1484515267687{padding-top: 0px !important;background-color: #ffffff !important;}"][vc_row][vc_column][ra_header_main_nav menu_id="9" style="s2" caret_visibility="show" logo="56"][vc_separator color="custom" vertical="yes" sep_height="v-sep shortest" accent_color="#f0f0f0"][ra_header_search style="default" trigger_size="sm" primary_color="#b2b2b2"][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Elegant Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Elegant', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/elegant-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_style="nav-left"][vc_row][vc_column css_animation="none"][ra_header_main_nav menu_id="6" style="s6" add_divider="yes"][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Hosting Blue Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Hosting Blue', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/hostingblue-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1483134120516{padding-top: 20px !important;padding-bottom: 20px !important;background-color: #ffffff !important;}"][vc_row content_placement="middle"][vc_column offset="vc_col-md-7"][ra_header_container][ra_promo i_type="fontawesome" i_align="right" title="Promo" i_icon_fontawesome="fa fa-long-arrow-right" content_color="#0a0a0a"]It?s Black Friday! Grab your coupon before it?s sold out lorem ipsum![/ra_promo][/ra_header_container][/vc_column][vc_column align="text-right" offset="vc_col-md-5"][ra_header_container][ra_lang_chooser trigger_color="#000000"][ra_custom_menu style="dropdown" menu_id="299" i_type="fontawesome" i_align="right" cm_style="" title="Help Center" i_icon_fontawesome="fa fa-angle-down" primary_color="#000000" cm_text_color="#000000"][ra_button style="btn-solid" shape="round" size="btn-xsm" i_type="fontawesome" title="My Account" i_size="15px" htext_color="#ffffff" i_icon_fontawesome="fa fa-user"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="secondary-bar" css=".vc_custom_1483134126336{padding-top: 20px !important;padding-bottom: 58px !important;background-color: #ffffff !important;}"][vc_row content_placement="middle"][vc_column width="1/4"][ra_header_container][vc_single_image image="98" img_size="full" onclick="custom_link" link="#"][/ra_header_container][/vc_column][vc_column width="3/4" align="text-right"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-semibold" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="mon-fri: 08.00 - 18.00" i_icon_linea="icon-basic_clock" title_color="#12406d" icon_color="#29aaeb" icon_fs="35px"]live chat available[/ra_icon_box][vc_separator vertical="yes"][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-semibold" i_type="linea" shape_size="sm" position="icon-box-side" valignment="icon-middle" title="800 388 80 90" i_icon_linea="icon-flaticon-phone6" title_color="#12406d" icon_color="#29aaeb" icon_fs="32px"]toll free[/ra_icon_box][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="pulled-up" mainbar_style="round,solid,nav-left" mainbar_color_type="gradient" css=".vc_custom_1493632463020{padding-top: 0px !important;}" mainbar_gradient="linear-gradient(to right,rgb(36, 160, 232) 0%,rgb(55, 178, 215) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_row content_placement="middle"][vc_column][ra_header_main_nav style="s6" logo_visibility="hide" caret_visibility="show" logo="3139"][ra_header_container][ra_social_icons style="" size="social-icon-md" scheme="scheme-white" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D"][vc_separator vertical="yes" sep_height="v-sep short"][ra_header_search style="simple" primary_color="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Hosting Red Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Hosting Red', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/hostingred-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1483134332827{padding-top: 20px !important;background-color: #ffffff !important;}"][vc_row content_placement="middle"][vc_column offset="vc_col-md-8"][ra_header_container][ra_promo i_type="fontawesome" i_align="right" title="REMINDER" i_icon_fontawesome="fa fa-long-arrow-right" content_color="#000000" primary_color="#d24d57"]You must remove your device from find my phone before the repair.[/ra_promo][/ra_header_container][/vc_column][vc_column align="text-right" offset="vc_col-md-4"][ra_header_container][ra_lang_chooser trigger_color="#0a0a0a"][ra_button style="btn-solid" shape="round" size="btn-xsm" text="text-uppercase" i_type="fontawesome" i_align="right" title="Hire us" i_icon_fontawesome="fa fa-long-arrow-right" primary_color="#d84947" fs="14px" text_color="#ffffff" htext_color="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="secondary-bar" css=".vc_custom_1483134346519{padding-top: 20px !important;padding-bottom: 58px !important;background-color: #ffffff !important;}"][vc_row content_placement="middle"][vc_column width="1/4"][ra_header_container][vc_single_image image="66" img_size="full" onclick="custom_link" link="#"][/ra_header_container][/vc_column][vc_column width="3/4" align="text-right"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-semibold" i_type="linea" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="mon-fri: 08.00 - 18.00" i_icon_linea="icon-flaticon-clock3" title_color="#333333" icon_color="#d73c35"]live chat available[/ra_icon_box][ra_icon_box template="ci" heading_size="icon-box-heading-sm" heading_weight="weight-semibold" i_type="linea" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="3rd Avenue, 83" i_icon_linea="icon-flaticon-placeholder" title_color="#333333" icon_color="#d73c35"]Manhattan[/ra_icon_box][ra_social_icons style="" visibility="faded" size="social-icon-lg" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="21px"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="no-side-spacing,pulled-up" mainbar_style="round,solid,nav-left" css=".vc_custom_1493629953222{padding-top: 0px !important;}" mainbar_color="#d73e37"][vc_row][vc_column][ra_header_main_nav menu_id="279" logo_visibility="hide" caret_visibility="show" logo="3139"][ra_header_container][ra_icon_box template="ci" heading_size="icon-box-heading-sm" i_type="linea" shape_size="sm" position="icon-box-inline" title="800 388 80 90" i_icon_linea="icon-linear-phone-handset" title_color="#ffffff" icon_color="#ffffff" icon_fs="29px"][/ra_icon_box][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Lawyer Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Lawyer', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/lawyer-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,shadowed" css=".vc_custom_1489163869658{padding-top: 0px !important;background-color: rgba(255,255,255,0.85) !important;*background-color: rgb(255,255,255) !important;}"][vc_row content_placement="middle"][vc_column][ra_header_main_nav menu_id="8" style="s5" logo="58"][ra_header_container][vc_separator vertical="yes" ][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Request a quote" primary_color="#ef4c31" fs="15px" i_icon_fontawesome="fa fa-angle-right" ls="0.1em"][vc_separator vertical="yes"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="linea" shape_size="sm" position="icon-box-inline" title="0 800 288 80 90" i_icon_linea="icon-flaticon-phone6" icon_color="#ef4c31" title_size="17px" icon_fs="30px"][/ra_icon_box][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Main Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Main', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/main-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,sticky2" css=".vc_custom_1484062869606{border-bottom-width: 1px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;border-bottom-color: rgba(78,42,132,0.08) !important;border-bottom-style: solid !important;}" stickybar_color="#ffffff"][vc_row][vc_column][ra_header_main_nav style="s6" logo="3458"][ra_header_container][vc_separator el_class="v-sep" css=".vc_custom_1495278559092{margin-left: 15px !important;}"][ra_social_icons style="" visibility="faded" size="social-icon-lg" scheme="scheme-dark" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D" el_class="faded" primary_color="#1e1231"][vc_separator el_class="v-sep"][ra_header_cart badge_style="icon-sup" amount_visibility="hide" i_type="linea" i_icon_linea="icon-ecommerce_cart_content"][vc_separator el_class="v-sep"][ra_header_search style="" i_type="linea" i_icon_linea="icon-flaticon-magnifying-glass2"][/ra_header_container][ra_header_container_mobile][vc_custom_heading text="E: works@themerella.com" font_container="tag:p|font_size:14px|text_align:left|color:%23484848|line_height:1.964em" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal" css=".vc_custom_1495557669087{margin-bottom: 0px !important;}"][vc_custom_heading text="P: +1 838 708 83 30" font_container="tag:p|font_size:14px|text_align:left|color:%23484848|line_height:1.964em" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal" css=".vc_custom_1495557651260{margin-bottom: 0px !important;}"][vc_custom_heading text="A: Upper East Side, San Francisco" font_container="tag:p|font_size:14px|text_align:left|color:%23484848|line_height:1.964em" google_fonts="font_family:Poppins%3Aregular|font_style:500%20regular%3A500%3Anormal" css=".vc_custom_1495557866005{margin-bottom: 25px !important;}"][ra_social_icons style="" visibility="faded" size="social-icon-md" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D"][/ra_header_container_mobile][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;	

	//Mobile Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Mobile', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/mobile-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" css=".vc_custom_1482961148436{padding-top: 0px !important;}"][vc_row content_placement="middle"][vc_column][ra_header_main_nav menu_id="7" style="s1" logo="83"][ra_header_container][ra_button style="btn-solid" shape="round" size="btn-lg" text="text-uppercase" title="Get the app" primary_color="#ffffff" text_color="#425fca" fs="13px" ls="0.25em" hbc="#425fca"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Photography Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Photography', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/photogrpahy-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="sticky2,modules-fullscreen" mainbar_style="round" css=".vc_custom_1496072621512{margin-top: 30px !important;padding-left: 35px !important;}"][vc_row content_placement="middle" css=".vc_custom_1494007816902{margin-left: -55px !important;}"][vc_column][ra_header_main_nav menu_id="4" style="fs4" logo="14" nav_bg="50"][ra_header_container position="mid-right"][ra_button style="btn-underlined" text="text-lowercase" title="hireme@boo.com" text_color="rgba(255,255,255,0.64)" fs="23px" lh="0.75em" ls="0px" bc="rgba(255,255,255,0.58)" htext_color="#ffffff" hbc="#ffffff"][/ra_header_container][ra_header_container position="bottom"][vc_column_text css_animation="none"]
<h4 style="text-align: center;"><span style="color: #999999;">I am Thomas, motion designer based in San Francisco. I stepped outside and Sophia came closer, she could see the sore glint in her eye.</span></h4>
[/vc_column_text][/ra_header_container][ra_header_container position="mid-left" orientation="horizontal"][ra_social_icons style="" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="22px" primary_color="rgba(255,255,255,0.44)" hover_color="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio 01 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Portfolio 01', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/portfolio01-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,sticky2" mainbar_style="nav-left" stickybar_color="#ffffff" css=".vc_custom_1494249007154{margin-top: 8px !important;padding-top: 0px !important;background-color: #ffffff !important;}"][vc_row css=".vc_custom_1494241922937{margin-right: 25px !important;margin-left: 50px !important;padding-top: 0px !important;}"][vc_column css=".vc_custom_1493736958309{padding-top: 0px !important;}"][ra_header_main_nav menu_id="2" logo="5501"][ra_header_container][ra_social_icons style="" visibility="faded" size="social-icon-md" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#969696" hover_color="#020202"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio 02 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Portfolio 02', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/portfolio02-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,sticky2" mainbar_style="round" css=".vc_custom_1495893592294{padding-top: 0px !important;background-color: #ffffff !important;}"][vc_row css=".vc_custom_1494808171507{padding-right: 50px !important;padding-left: 50px !important;}"][vc_column css=".vc_custom_1494599769630{margin-top: 15px !important;}"][ra_header_main_nav menu_id="19" style="off-canvas" logo="5473"][ra_header_container position="off-canvas" off_canvas="right wide"][vc_row_inner full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column_inner width="1/4"][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Hire us" link="url:%23|||" i_icon_fontawesome="fa fa-long-arrow-right"][/vc_column_inner][vc_column_inner width="3/4"][/vc_column_inner][vc_column_inner][ra_custom_menu style="main-menu" use_theme_fonts="" menu_font="font_family:Poppins%3Aregular|font_style:600%20bold%20regular%3A600%3Anormal" cm_style="btn-default" color="#0a0a0a" f_size="45px" l_height="45px" l_spacing="0px" h_color="#df0749"][/vc_column_inner][vc_column_inner][vc_column_text css=".vc_custom_1494602118111{margin-bottom: 50px !important;}"]
<h6><span style="color: #000000;"><a class="curtain-hover" style="color: #000000;" href="mailto:hello@boo.com" target="">hello@boo.com</a></span></h6>
<span style="color: #808080;">I am Thomas, motion designer based in San Francisco. I stepped outside and Sophia came closer in her eye</span>[/vc_column_text][ra_social_icons style="" size="social-icon-lg" scheme="scheme-dark" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#adadad" hover_color="#000000"][/vc_column_inner][/vc_row_inner][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio 03 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Portfolio 03', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/portfolio03-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,modules-fullscreen" mainbar_style="round" stickybar_color="#ffffff" css=".vc_custom_1493903537090{margin-top: 80px !important;}"][vc_row css=".vc_custom_1493901587267{padding-right: 65px !important;padding-left: 65px !important;}"][vc_column][ra_header_main_nav menu_id="2" style="fs3" logo_visibility="hide" logo="5471" link="|||" retina_logo="5471" nav_bg="5489"][ra_header_container][vc_single_image image="" img_size="full" alignment="right"][/ra_header_container][ra_header_container position="bottom" orientation="horizontal"][ra_button style="btn-underlined" border="border-thick" text="text-lowercase" title="hello@boo.com" link="url:%23|||" fs="25px" ls="0.025em" text_color="#ffffff" htext_color="#ffffff" bc="rgba(255,255,255,0.53)" hbc="#ffffff"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio 04 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Portfolio 04', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/portfolio04-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="sticky2" css_animation="none" css=".vc_custom_1491485561229{margin-top: 15px !important;}"][vc_row content_placement="middle"][vc_column][ra_header_main_nav menu_id="2" style="onepage" logo="4305"][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio 05 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Portfolio 05', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/portfolio05-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="no-side-spacing" mainbar_style="nav-right" mainbar_color="rgba(2,2,2,0.01)"][vc_row css=".vc_custom_1489768244701{margin-top: 25px !important;}"][vc_column][ra_header_main_nav menu_id="2" style="s1" logo="4225"][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio 06 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Portfolio 06', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/portfolio06-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="no-side-spacing,sticky2" mainbar_style="round" css=".vc_custom_1494004927367{padding-top: 0px !important;}"][vc_row css=".vc_custom_1494273956327{padding-right: 50px !important;padding-left: 50px !important;}"][vc_column css=".vc_custom_1494004944762{margin-top: 18px !important;}"][ra_header_main_nav menu_id="19" style="off-canvas" logo="5502"][ra_header_container position="off-canvas" off_canvas="right wide"][vc_row_inner full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1494274494868{margin-top: -25px !important;}"][vc_column_inner width="2/4"][ra_custom_menu style="main-menu" show_button="" cm_style="btn-naked" color="#100060" f_size="40px" l_height="42px" l_spacing="-0.12px" h_color="#613ad6" cm_title="Hire me" cm_link="url:%23|||" cm_fs="45px" cm_bc="#613ad6"][/vc_column_inner][vc_column_inner width="2/4"][/vc_column_inner][vc_column_inner][/vc_column_inner][vc_column_inner css=".vc_custom_1494274522763{margin-bottom: 10px !important;}"][vc_column_text css=".vc_custom_1494274646606{margin-bottom: 25px !important;padding-bottom: 20px !important;}"]
<h6><mark>I am Thomas, motion designer based in
San Francisco. I stepped outside and Sophia
came closer in her eye<mark></mark></mark></h6>
[/vc_column_text][ra_social_icons style="" visibility="faded" size="social-icon-lg" scheme="scheme-dark" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="#858198" hover_color="#190099" font_size="22px"][/vc_column_inner][/vc_row_inner][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio 08 Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Portfolio 08', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/portfolio08-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_style="nav-right" mainbar_color="rgba(2,2,2,0.01)"][vc_row css=".vc_custom_1489768244701{margin-top: 25px !important;}"][vc_column][ra_header_main_nav menu_id="2" style="s1" logo="5465"][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Restaurant Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Restaurant', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/restaurant-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="main-bar-container" mainbar_container_style="modules-fullscreen,modules-fullscreen-alt-2"][vc_row content_placement="middle"][vc_column align="text-lg-center text-md-center text-sm-center text-xs-center"][ra_header_main_nav menu_id="7" style="fs3" logo="32" fs_menu_title="Menu"][ra_header_container][ra_button style="btn-naked" text="text-uppercase" i_type="linea" i_align="right" title="Book a table" i_icon_linea="icon-linear-alarm2" i_size="25px" text_color="#ffffff" fs="13px" htext_color="#ffffff" i_ml="20px"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Shop Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header Shop', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/shop-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" main_full_width="stretch_row" css=".vc_custom_1492517417581{border-bottom-width: 1px !important;padding-top: 4px !important;padding-bottom: 4px !important;background-color: #ffffff !important;border-bottom-color: #f2f2f2 !important;border-bottom-style: solid !important;}"][vc_row content_placement="middle" enable_responsive_options="yes" css=".vc_custom_1495783704410{padding-right: 55px !important;padding-left: 55px !important;}" responsive_css="padding_right_desktop:15|padding_left_desktop:15"][vc_column offset="vc_col-md-6"][ra_header_container][vc_custom_heading text="FREE SHIPPING FOR ORDERS OVER $100" font_container="tag:p|font_size:12px|text_align:left|color:%23000000|line_height:1.5em" google_fonts="font_family:Karla%3Aregular|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1495697369944{margin-bottom: 0px !important;}" letter_spacing="0.12em"][vc_custom_heading text="2017 AUTOMN WOMEN COLLECTION" font_container="tag:div|font_size:12px|text_align:left|color:%23000000|line_height:1.5em" google_fonts="font_family:Karla%3Aregular|font_style:400%20regular%3A400%3Anormal" class="``btn" css=".vc_custom_1495723073549{margin-bottom: 0px !important;}" letter_spacing="0.12em"][/ra_header_container][/vc_column][vc_column align="text-right" offset="vc_col-md-6"][ra_header_container][ra_social_icons style="" visibility="faded" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="14p"][ra_lang_chooser trigger_color="#000000" fs="12px" ls="0.12em !important"][ra_custom_menu style="dropdown" menu_id="18" i_type="fontawesome" i_align="right" t_transform="uppercase" show_button="" cm_style="btn-default" title="My Account" i_icon_fontawesome="fa fa-angle-down" f_size="12px" l_spacing="0.12em" color="#000000"][ra_custom_menu style="inline2" menu_id="19" t_transform="uppercase" cm_style="btn-default" f_size="12px" l_spacing="0.12em"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" main_full_width="stretch_row" mainbar_container_style="shadowed,sticky2,header-fullwidth-justified" css=".vc_custom_1484556706989{padding-top: 0px !important;background-color: #ffffff !important;}"][vc_row content_placement="middle" enable_responsive_options="yes" css=".vc_custom_1495783632336{padding-right: 70px !important;padding-left: 70px !important;}" responsive_css="padding_right_desktop:30|padding_left_desktop:30"][vc_column][ra_header_main_nav menu_id="17" style="s6" logo="103"][ra_header_container module_padding="10px"][ra_header_search style="default" i_type="linea" primary_color="#000000" i_icon_linea="icon-search"][vc_separator vertical="yes" sep_height="v-sep shorter"][ra_header_wishlist][vc_separator vertical="yes" sep_height="v-sep shorter"][ra_header_cart badge_style="icon-sup" amount_visibility="hide" i_type="linea" i_icon_linea="icon-flaticon-commerce"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//University Header vc-template
	$data = array();
	$data['name'] = esc_html__( 'Header University', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/headers/university-header.jpg' );
	$data['sort_name'] = 'Header';
	$data['custom_class'] = 'general header';
	$data['content'] = <<<CONTENT
[vc_section section_type="secondary-bar" css=".vc_custom_1485162650231{border-bottom-width: 1px !important;padding-top: 15px !important;padding-bottom: 15px !important;background-color: #ffffff !important;border-bottom-color: #f2f2f2 !important;border-bottom-style: solid !important;}"][vc_row content_placement="middle"][vc_column offset="vc_col-md-7"][ra_header_container][ra_lang_chooser trigger_color="#0a0000"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="1 800 301 23 38" i_icon_fontawesome="fa fa-phone" icon_color="#ff326f" title_size="15px" icon_fs="20px"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" title="student@boo.com" i_icon_fontawesome="fa fa-envelope" icon_color="#ff326f" title_size="15px" icon_fs="20px"][/ra_icon_box][vc_separator vertical="yes" sep_height="v-sep short"][ra_social_icons style="" visibility="faded" size="social-icon-md" scheme="scheme-gray" identities="%5B%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22youtube-play%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D"][/ra_header_container][/vc_column][vc_column offset="vc_col-md-5"][ra_header_container][ra_custom_menu style="inline2" menu_id="14" show_button="" cm_style="btn-naked" cm_text_color="#000000" cm_htext_color="#f63a5d" cm_fs="17px" cm_title="Toggle" h_color="#f63a5d"][ra_button style="btn-solid" shape="round" size="btn-xxsm" text="text-uppercase" title="Apply now" text_color="#ffffff" htext_color="#ffffff" fs="14px" ls="0.075em" primary_color="#f63a5d"][/ra_header_container][/vc_column][/vc_row][/vc_section][vc_section section_type="main-bar-container" mainbar_container_style="shadowed" mainbar_style="round" css=".vc_custom_1493625817754{padding-top: 0px !important;background-color: rgba(255,255,255,0.88) !important;*background-color: rgb(255,255,255) !important;}"][vc_row content_placement="middle"][vc_column][ra_header_main_nav menu_id="15" logo="107"][ra_header_container][ra_button style="btn-naked" size="btn-md" i_type="fontawesome" title="Price Quotation" fs="17px" i_icon_fontawesome="fa fa-long-arrow-right" i_mr="15px" i_color="#f63a5d" i_size="22px" htext_color="#f63a5d" text_color="#272951"][/ra_header_container][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Icon Boxes Category

	//Circle with Buttons Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Circle with Buttons', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/circle-with-button-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" enable_responsive_options="yes" css=".vc_custom_1507533947056{padding-top: 75px !important;padding-bottom: 50px !important;background-color: #f6f6f6 !important;}" fullpage_title="Interaction" responsive_css="padding_top_tablet:100|padding_bottom_tablet:100|padding_top_mobile:60|padding_bottom_mobile:60"][vc_column css_animation="bottom-to-top" width="5/6" css=".vc_custom_1507276408202{padding-top: 0px !important;}" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-1"][ra_section_title style="resolve" title="Ready to" items="%5B%7B%22word%22%3A%22Interact%22%7D%2C%7B%22word%22%3A%22Play%22%7D%2C%7B%22word%22%3A%22Share%22%7D%5D" effect="slide_horizontal_vertical" title_font_container="tag:h2|font_size:60px|line_height:1.1em" title_use_theme_fonts="yes" autoplay="yes" use_custom_fonts_title="true"][/ra_section_title][/vc_column][vc_column css=".vc_custom_1507533937944{padding-top: 15px !important;}"][vc_row_inner][vc_column_inner width="1/2" css_animation="bottom-to-top" offset="vc_col-md-3" delay="150"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-bold" i_type="fontawesome" background_shape="circle" shape_size="xlg" title="Smart Installer" primary_color="#545af7" icon_fs="55px" title_size="20px" content_color="rgba(0,54,61,0.66)" title_color="#00363d" i_icon_fontawesome="fa fa-wrench"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css_animation="bottom-to-top" offset="vc_col-md-3" delay="300"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-bold" i_type="fontawesome" background_shape="circle" shape_size="xlg" title="WooCommerce" primary_color="#545af7" icon_fs="55px" title_size="20px" content_color="rgba(0,54,61,0.66)" title_color="#00363d" i_icon_fontawesome="fa fa-credit-card"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css_animation="bottom-to-top" offset="vc_col-md-3" delay="450"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-bold" i_type="fontawesome" background_shape="circle" shape_size="xlg" title="Social" primary_color="#545af7" icon_fs="55px" title_size="20px" content_color="rgba(0,54,61,0.66)" title_color="#00363d" i_icon_fontawesome="fa fa-spotify"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css_animation="bottom-to-top" offset="vc_col-md-3" delay="600"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-bold" i_type="fontawesome" background_shape="circle" shape_size="xlg" title="Solid Code" primary_color="#545af7" icon_fs="55px" title_size="20px" content_color="rgba(0,54,61,0.66)" title_color="#00363d" i_icon_fontawesome="fa fa-bolt"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css_animation="bottom-to-top" delay="750"][ra_button style="btn-default" curtain_hover="bottom" size="btn-lg" border="border-thicker" others="btn-block" title="Full Technical Specifications" link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fboo-responsive-multipurpose-theme-%2F16993787%2F%3Flicense%3Dregular%26open_purchase_for_item_id%3D16993787%26purchasable%3Dsource|||" hbg="rgba(255,255,255,0.01)" curtain_hbg="#6c63ff" htext_color="#ffffff" fw="600" primary_color="#6c63ff" hbc="#6c63ff" text_color="#00363d"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Classic Outlines Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Classic Outlines', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/classic-outlines-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504704282319{padding-top: 125px !important;padding-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-lg" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle-bordered" shape_size="custom" position="icon-box-side" title="Featured on Envato" i_icon_fontawesome="fa fa-check" shape_custom="65px" icon_fs="28px" title_size="19px" h_icon_color="#ffffff" h_icon_bg="#e44e62"]Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mused suscipit massa venenatis et.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-lg" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle-bordered" shape_size="custom" position="icon-box-side" title="Font Icon Packs" i_icon_fontawesome="fa fa-laptop" shape_custom="65px" icon_fs="28px" title_size="19px" h_icon_color="#ffffff" h_icon_bg="#e44e62"]Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mused suscipit massa venenatis et.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-lg" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle-bordered" shape_size="custom" position="icon-box-side" title="Ultra Fast" i_icon_fontawesome="fa fa-bolt" shape_custom="65px" icon_fs="28px" title_size="19px" h_icon_color="#ffffff" h_icon_bg="#e44e62"]Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mused suscipit massa venenatis et.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-lg" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle-bordered" shape_size="custom" position="icon-box-side" title="Secure and Reliable" i_icon_fontawesome="fa fa-credit-card" shape_custom="65px" icon_fs="28px" title_size="19px" h_icon_color="#ffffff" h_icon_bg="#e44e62"]Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mused suscipit massa venenatis et.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-lg" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle-bordered" shape_size="custom" position="icon-box-side" title="Progressive Load" i_icon_fontawesome="fa fa-spinner" shape_custom="65px" icon_fs="28px" title_size="19px" h_icon_color="#ffffff" h_icon_bg="#e44e62"]Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mused suscipit massa venenatis et.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-lg" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle-bordered" shape_size="custom" position="icon-box-side" title="Modal Buttons" i_icon_fontawesome="fa fa-chain-broken" shape_custom="65px" icon_fs="28px" title_size="19px" h_icon_color="#ffffff" h_icon_bg="#e44e62"]Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mused suscipit massa venenatis et.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Colorful Backgrounds Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Colorful Backgrounds', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/colorful-backgrounds-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1503990714941{padding-top: 120px !important;padding-bottom: 100px !important;}" el_id="specs"][vc_column width="1/2" align="text-left"][ra_section_title style="resolve" title="Stunning" items="%5B%7B%22word%22%3A%22Sound%22%7D%2C%7B%22word%22%3A%22Performance%22%7D%2C%7B%22word%22%3A%22Design%22%7D%5D" alignment="align-left" effect="slide_horizontal_vertical" autoplay="yes" css=".vc_custom_1492265373163{margin-bottom: 40px !important;}"] Hush, the babies are sleeping, the farmers, the fishers, the tradesmen and pensioners, cobbler. [/ra_section_title][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-inline" title="Long Battery Life" icon_color="#ffffff" title_size="18px" i_icon_linea="icon-music_microphone_old" icon_fs="25px" icon_bg="#2437e5" css=".vc_custom_1493151833322{margin-bottom: 20px !important;}"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-inline" title="Online Community" icon_color="#ffffff" title_size="18px" i_icon_linea="icon-music_record" icon_fs="25px" icon_bg="#2437e5" css=".vc_custom_1493151855105{margin-bottom: 20px !important;}"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-inline" title="Audio Streaming" icon_color="#ffffff" title_size="18px" i_icon_linea="icon-music_volume_up" icon_fs="25px" icon_bg="#2437e5"][/ra_icon_box][/vc_column][vc_column width="1/2"][vc_single_image d_effect="yes" source="external_link" alignment="center" css=".vc_custom_1508236366906{padding-top: 60px !important;}" custom_src="http://landing.themerella.com/wp-content/uploads/2017/07/drawing.jpg"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Colorful Lines Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Colorful Lines', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/colorful-lines-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" enable_responsive_options="yes" fullpage_brightness="dark" css=".vc_custom_1507641102383{background-color: #6955e8 !important;}" responsive_css="padding_top_tablet:80|padding_bottom_tablet:80|padding_top_mobile:50|padding_bottom_mobile:50"][vc_column align="text-lg-right" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" i_type="linea" shape_size="xlg" title="Woocommerce" i_icon_linea="icon-ecommerce_bag_check" icon_color="rgba(255,255,255,0.65)" h_icon_color="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)" title_size="28px" icon_fs="68px" content_size="17px" el_class="text-right"]Humorously perilous business for both of us. For, before we further proceed broad[/ra_icon_box][vc_empty_space][ra_icon_box template="" heading_size="icon-box-heading-md" i_type="linea" shape_size="xlg" title="One Click Instaill" i_icon_linea="icon-basic_webpage_img_txt" icon_color="rgba(255,255,255,0.65)" h_icon_color="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)" title_size="28px" icon_fs="68px" content_size="18px" el_class="text-right" css=".vc_custom_1507630061068{margin-bottom: 0px !important;}"]Humorously perilous business for both of us. For, before we further proceed broad[/ra_icon_box][/vc_column][vc_column offset="vc_col-md-4"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1508236612659{padding-right: 2% !important;padding-left: 2% !important;}" custom_src="http://esperance.themerella.com/wp-content/uploads/2017/10/iphone-white.png"][/vc_column][vc_column offset="vc_col-md-4" align="text-lg-left"][ra_icon_box template="" heading_size="icon-box-heading-md" i_type="linea" shape_size="xlg" title="Multiple Marker" i_icon_linea="icon-software_layers2" icon_color="rgba(255,255,255,0.65)" h_icon_color="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)" title_size="28px" icon_fs="68px" content_size="18px" el_class="text-left"]Humorously perilous business for both of us. For, before we further proceed broad[/ra_icon_box][vc_empty_space][ra_icon_box template="" heading_size="icon-box-heading-md" i_type="linea" shape_size="xlg" title="Happy Customers" i_icon_linea="icon-basic_elaboration_message_happy" icon_color="rgba(255,255,255,0.65)" h_icon_color="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)" title_size="28px" icon_fs="68px" content_size="18px" el_class="text-left" css=".vc_custom_1507630070060{margin-bottom: 0px !important;}"]Humorously perilous business for both of us. For, before we further proceed broad[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Dark Icons Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Dark Icons', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/dark-icons-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="35" css=".vc_custom_1508237009634{background-color: #050017 !important;}"][vc_column width="1/3" align="text-lg-left text-md-left text-sm-left text-xs-left"][vc_icon type="linea" icon_linea="icon-basic_lightbulb" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415074198{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Digital Innovation</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="linea" icon_linea="icon-basic_watch" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415082163{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Branding Strategy</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="linea" icon_linea="icon-basic_picture" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415090854{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Live Customizer</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//With Pointers Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box With Pointers', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/icon-box-with-pointers-icon-boxes.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" enable_responsive_options="yes" fullpage_brightness="dark" css=".vc_custom_1508956097991{padding-top: 50px !important;padding-bottom: 50px !important;}" fullpage_title="Features" responsive_css="padding_top_tablet:100|padding_bottom_tablet:100|padding_top_mobile:60|padding_bottom_mobile:60" el_id="features"][vc_column enable_responsive_options="yes" offset="vc_col-md-5" responsive_css="margin_bottom_tablet:60|margin_bottom_mobile:60" css=".vc_custom_1507291025447{padding-top: 0px !important;}"][ra_tooltiped_image image="http://boolanding.themerella.com/wp-content/uploads/2017/10/image-map-s-1.jpg"][ra_pointer_tooltip title="Hyper-reality" top="24%" left="24%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][ra_pointer_tooltip position="align-bottom" title="Premium Steel" top="50%" left="28%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][ra_pointer_tooltip title="Natural gestures" top="73%" left="65%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][ra_pointer_tooltip position="align-bottom" title="Premium Steel" top="10%" right="16%"]Lorem ipsum pisaci volupt atem accusa saes ntisdumtiu loperm asaerks.[/ra_pointer_tooltip][/ra_tooltiped_image][/vc_column][vc_column css_animation="bottom-to-top" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1507273780098{padding-top: 0px !important;}"][ra_section_title style="resolve" title="Start Writing." alignment="align-left" title_font_container="tag:h2|font_size:55px|line_height:1.05em" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1508961834016{margin-bottom: 0px !important;padding-left: 20px !important;}"]Impress your visitors and let your audience grow with the most unique looking blog ever built.[/ra_section_title][ra_icon_box template="shadowed" heading_weight="weight-bold" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="12 Unique Blog Layouts" icon_color="#ffffff" icon_bg="#6e2aed" css=".vc_custom_1509007458533{margin-bottom: 25px !important;}" shape_custom="70px" title_size="18px" title_color="#1e3c56" icon_color2="#ffffff" i_icon_linea="icon-basic_webpage_multiple" primary_color="#6e2aed" icon_fs="32px"][/ra_icon_box][ra_icon_box template="shadowed" heading_weight="weight-bold" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="Social Integration" icon_color="#ffffff" icon_bg="#6e2aed" css=".vc_custom_1509007499362{margin-bottom: 25px !important;}" shape_custom="70px" title_size="18px" title_color="#1e3c56" icon_color2="#ffffff" i_icon_linea="icon-basic_message_txt" primary_color="#6e2aed" icon_fs="35px"][/ra_icon_box][ra_icon_box template="shadowed" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="MailPoet Newsletter" icon_color="#ffffff" icon_bg="#6e2aed" css=".vc_custom_1509007515974{margin-bottom: 25px !important;}" shape_custom="70px" title_size="18px" title_color="#1e3c56" icon_color2="#ffffff" i_icon_linea="icon-basic_mail_open_text" primary_color="#6e2aed" icon_fs="35px"][/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Dark Icons Icon Boxes vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Lines', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/lines-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="35" css=".vc_custom_1508237009634{background-color: #050017 !important;}"][vc_column width="1/3" align="text-lg-left text-md-left text-sm-left text-xs-left"][vc_icon type="linea" icon_linea="icon-basic_lightbulb" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415074198{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Digital Innovation</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="linea" icon_linea="icon-basic_watch" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415082163{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Branding Strategy</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="linea" icon_linea="icon-basic_picture" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415090854{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Live Customizer</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/


	//Minimal Circles Icon Boxes vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Lines', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/minimal-circles-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="35" css=".vc_custom_1508237009634{background-color: #050017 !important;}"][vc_column width="1/3" align="text-lg-left text-md-left text-sm-left text-xs-left"][vc_icon type="linea" icon_linea="icon-basic_lightbulb" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415074198{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Digital Innovation</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="linea" icon_linea="icon-basic_watch" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415082163{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Branding Strategy</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="linea" icon_linea="icon-basic_picture" color="custom" size="xl" custom_color="#a9a9b4"][vc_column_text css=".vc_custom_1502415090854{border-left-width: 100px !important;}"] <h6><span style="color: #e8e8e8;">Live Customizer</span></h6> <span style="color: #a9a9b4;">General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought friendly you. </span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/


	//Mobile Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Mobile', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/mobile-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" enable_responsive_options="yes" css=".vc_custom_1503498282726{padding-top: 0px !important;padding-bottom: 30px !important;background-color: #e9eeeb !important;}"][vc_column][ra_section_title style="default" title="Incredible features" transform="text-capitalize" title_font_container="tag:h2|font_size:55px|line_height:1.5em" title_use_theme_fonts="yes" subtitle_transform="text-uppercase" content_font_container="tag:p|font_size:14px|color:%23282d25|line_height:1.15em" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1503322258377{margin-bottom: 0px !important;}"]The best experience[/ra_section_title][/vc_column][vc_column parallax="yes" width="1/2" parallax_preset="fadeInLeftShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" css=".vc_custom_1503429909639{padding-top: 0px !important;}" parallax_trigger_number="0.85" parallax_duration="0%"][vc_single_image source="external_link" alignment="center" custom_src="http://four.modern.themerella.com/wp-content/uploads/sites/9/2017/08/phone2-370x668.png"][/vc_column][vc_column width="1/2" css=".vc_custom_1503492971623{padding-top: 0px !important;padding-right: 10% !important;padding-left: 10% !important;}"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="fadeInLeftShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" to_delay="0.15" parallax_trigger_number="0.85" parallax_duration="0%"][ra_icon_box template="" heading_weight="weight-bold" i_type="fontawesome" background_shape="circle" shape_size="custom" position="icon-box-side" i_icon_fontawesome="fa fa-shopping-bag" title="WooCommerce" css=".vc_custom_1503496304268{margin-bottom: 35px !important;}" title_size="21px" icon_bg="#282d25" shape_custom="62px" icon_fs="30px" content_size="18px"]Humorously perilous business for both of us. For, before we further proceed broad usly perilous business for canvas.[/ra_icon_box][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInLeftShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" to_delay="0.3" parallax_trigger_number="0.85" parallax_duration="0%"][ra_icon_box template="" heading_weight="weight-bold" i_type="fontawesome" background_shape="circle" shape_size="custom" position="icon-box-side" i_icon_fontawesome="fa fa-cube" title="200+ Section Templates" css=".vc_custom_1503496529270{margin-bottom: 35px !important;}" title_size="21px" icon_bg="#282d25" shape_custom="62px" icon_fs="30px" content_size="18px"]Humorously perilous business for both of us. For, before we further proceed broad usly perilous business for canvas.[/ra_icon_box][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="fadeInLeftShort" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" to_delay="0.45" parallax_trigger_number="0.85" parallax_duration="0%"][ra_icon_box template="" heading_weight="weight-bold" i_type="fontawesome" background_shape="circle" shape_size="custom" position="icon-box-side" i_icon_fontawesome="fa fa-gitlab" title="Live Website Builder" css=".vc_custom_1503496437063{margin-bottom: 35px !important;}" title_size="21px" icon_bg="#282d25" shape_custom="62px" icon_fs="30px" content_size="18px"]Humorously perilous business for both of us. For, before we further proceed broad usly perilous business for canvas.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Separators Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Separators', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/separators-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes"][vc_column enable_responsive_options="yes" offset="vc_col-md-4" css=".vc_custom_1504077950862{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 35px !important;padding-right: 25% !important;padding-bottom: 15px !important;padding-left: 20% !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_css="padding_right_desktop:30|padding_left_desktop:30|padding_right_tablet:30|padding_left_tablet:30|padding_right_mobile:15|padding_left_mobile:15"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" position="icon-box-inline" title="Live Builder" i_icon_fontawesome="fa fa-cube" icon_color="#c5c5c5" icon_fs="35px" content_color="rgba(12,12,12,0.4)" title_size="20px"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column][vc_column enable_responsive_options="yes" offset="vc_col-md-4" css=".vc_custom_1504077956308{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 35px !important;padding-right: 25% !important;padding-bottom: 15px !important;padding-left: 20% !important;background-color: #f4f4f4 !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_css="padding_right_desktop:30|padding_left_desktop:30|padding_right_tablet:15|padding_left_tablet:15|padding_right_mobile:15|padding_left_mobile:15"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" position="icon-box-inline" title="Real-Time Analytics" i_icon_fontawesome="fa fa-plane" icon_color="#c5c5c5" icon_fs="35px" content_color="rgba(12,12,12,0.4)" title_size="20px"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column][vc_column enable_responsive_options="yes" offset="vc_col-md-4" css=".vc_custom_1504077962079{border-bottom-width: 1px !important;padding-top: 35px !important;padding-right: 25% !important;padding-bottom: 15px !important;padding-left: 20% !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_css="padding_right_desktop:30|padding_left_desktop:30|padding_right_tablet:15|padding_left_tablet:15|padding_right_mobile:15|padding_left_mobile:15"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" position="icon-box-inline" title="Secure and Reliable" i_icon_fontawesome="fa fa-lock" icon_color="#c5c5c5" icon_fs="35px" content_color="rgba(12,12,12,0.4)" title_size="20px"]No coding skills required to create unique sites. Customize your site in real-time.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Simple circle Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Simple circle', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/simple-circle-boxes-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504269179359{padding-top: 20px !important;padding-bottom: 40px !important;background-color: #f6f6f6 !important;}" el_id="extra"][vc_column width="2/3" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-2"][ra_section_title style="resolve" title="Watch of Steel" title_font_container="tag:h2|font_size:50px|line_height:1.5em" title_use_theme_fonts="yes" content_font_container="tag:h6|color:rgba(0%2C0%2C0%2C0.52)" content_use_theme_fonts="yes" show_button="yes" ib_style="btn-default" ib_shape="circle" ib_border="border-thick" ib_others="wide" ib_i_type="fontawesome" ib_i_align="right" use_custom_fonts_title="true" use_custom_fonts_content="true" ib_title="Free Trial" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_i_ml="10px" ib_fs="15px" ib_fw="500" ib_css=".vc_custom_1504081131571{margin-top: 15px !important;}"]Our team discussed every single detail to make sure Boo is the most versatile and unique theme created so far.[/ra_section_title][/vc_column][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="right" from_torigin_y="custom" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" translate_from_x="52" translate_from_y="-27" rotate_from_z="-15" from_torigin_y_custom="40%" rotate_from_x="0" offset="vc_col-sm-offset-3" rotate_from_y="-12" parallax_trigger_number="0.9"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1508240286591{margin-bottom: 20px !important;}" custom_src="http://three.classic.themerella.com/wp-content/uploads/sites/3/2017/08/watch-2.png"][/vc_column][vc_column][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle" shape_size="custom" title="Unlimited Style" i_icon_fontawesome="fa fa-tint" title_size="16px" shape_custom="56px" icon_fs="24px" css=".vc_custom_1504293613470{margin-bottom: 30px !important;}"][/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle" shape_size="custom" title="Top Notch Support" i_icon_fontawesome="fa fa-credit-card" title_size="16px" shape_custom="56px" icon_fs="24px" css=".vc_custom_1504293619323{margin-bottom: 30px !important;}"][/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle" shape_size="custom" title="Regular Updates" i_icon_fontawesome="fa fa-shopping-bag" title_size="16px" shape_custom="56px" icon_fs="24px" css=".vc_custom_1504293626665{margin-bottom: 30px !important;}"][/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="circle" shape_size="custom" title="Multilingual Structure" i_icon_fontawesome="fa fa-lock" title_size="16px" shape_custom="56px" icon_fs="24px" css=".vc_custom_1504293632569{margin-bottom: 30px !important;}"][/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Square Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Square', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/square-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504779390507{margin-bottom: 90px !important;}" el_id="features"][vc_column][ra_section_title style="default" title="Premium Features" css=".vc_custom_1476439126977{margin-bottom: 40px !important;}"]We're Different[/ra_section_title][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="+30 Demos" image="http://mainone.landing.themerella.com/wp-content/uploads/sites/2/2017/09/software_layers2.svg" icon_color="#ffffff" icon_bg="#e5432a"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="SEO Optimized" image="46" icon_color="#ffffff" icon_background_color="#ffa11b" animation_delay="300" icon_bg="#ffa11b"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Customizable" image="45" icon_color="#ffffff" icon_background_color="#1db7ff" animation_delay="600" icon_bg="#1db7ff"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Hight Performance" image="49" icon_color="#ffffff" icon_background_color="#d168d5" icon_bg="#7767ca"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Free Support" image="41" icon_color="#ffffff" icon_background_color="#7767ca" animation_delay="300" icon_bg="#d168d5"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Affordable" image="48" icon_color="#ffffff" icon_background_color="#f26c6c" animation_delay="600" icon_bg="#eb6d72"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Step Icon Boxes vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Step', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/steps-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504779390507{margin-bottom: 90px !important;}" el_id="features"][vc_column][ra_section_title style="default" title="Premium Features" css=".vc_custom_1476439126977{margin-bottom: 40px !important;}"]We're Different[/ra_section_title][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="+30 Demos" image="http://mainone.landing.themerella.com/wp-content/uploads/sites/2/2017/09/software_layers2.svg" icon_color="#ffffff" icon_bg="#e5432a"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="SEO Optimized" image="46" icon_color="#ffffff" icon_background_color="#ffa11b" animation_delay="300" icon_bg="#ffa11b"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Customizable" image="45" icon_color="#ffffff" icon_background_color="#1db7ff" animation_delay="600" icon_bg="#1db7ff"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Hight Performance" image="49" icon_color="#ffffff" icon_background_color="#d168d5" icon_bg="#7767ca"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Free Support" image="41" icon_color="#ffffff" icon_background_color="#7767ca" animation_delay="300" icon_bg="#d168d5"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" type="svg" animation="yes" background_shape="square" title="Affordable" image="48" icon_color="#ffffff" icon_background_color="#f26c6c" animation_delay="600" icon_bg="#eb6d72"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium dolorem que laudantium[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/


	//Title Rotator Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Title Rotator', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/title-rotators-icon-boxes.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" enable_responsive_options="yes" css=".vc_custom_1507108045017{margin-top: 100px !important;padding-top: 35px !important;background-color: #f6f8f9 !important;}" responsive_css="padding_top_desktop:180|padding_top_tablet:130"][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ra_section_title style="resolve" title="Need to start a project?" use_resolve_effect="yes" resolve_effect_seperator="chars" css=".vc_custom_1507137525011{margin-bottom: -35px !important;padding-bottom: 0px !important;}"]Celebrated her had sentiments understood are projection set. Possession unaffected remarkably.[/ra_section_title][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" enable_responsive_options="yes" css=".vc_custom_1507056753168{padding-bottom: 45px !important;background-color: #f6f8f9 !important;}" responsive_css="padding_bottom_desktop:200|padding_bottom_tablet:180"][vc_column css_animation="none" width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2 vc_col-xs-12"][ra_icon_box template="shadow" heading_size="icon-box-heading-md" heading_weight="weight-semibold" effect="slide_horizontal_vertical" i_type="linea" shape_size="md" autoplay="yes" use_title_effects="yes" title="Exclusive" delay="2000" items="%5B%7B%22word%22%3A%22Blog%22%7D%2C%7B%22word%22%3A%22Portfolio%22%7D%2C%7B%22word%22%3A%22Shop%22%7D%5D" i_icon_linea="icon-ecommerce_bag_check" icon_fs="60px" title_size="25px" content_size="15px" icon_color="#2ecc71"]Extreme attention to detail is the essence of Boo's unique design concepts.[/ra_icon_box][/vc_column][vc_column css_animation="none" width="1/2" offset="vc_col-md-4" delay="200"][ra_icon_box template="shadow" heading_size="icon-box-heading-md" heading_weight="weight-semibold" effect="slide_horizontal_vertical" i_type="linea" shape_size="md" autoplay="yes" use_title_effects="yes" title="Web" delay="2000" items="%5B%7B%22word%22%3A%22Design%22%7D%2C%7B%22word%22%3A%22Development%22%7D%2C%7B%22word%22%3A%22Apps%22%7D%5D" i_icon_linea="icon-basic_webpage_multiple" icon_fs="60px" title_size="25px" content_size="15px" icon_color="#2ecc71"]Stunning animations and parallax effects will impress your visitors.[/ra_icon_box][/vc_column][vc_column css_animation="none" width="1/2" offset="vc_col-md-4"][ra_icon_box template="shadow" heading_size="icon-box-heading-md" heading_weight="weight-semibold" effect="slide_horizontal_vertical" i_type="linea" shape_size="md" autoplay="yes" use_title_effects="yes" title="App" i_icon_linea="icon-basic_spread_text" icon_fs="60px" title_size="25px" content_size="15px" icon_color="#2ecc71" items="%5B%7B%22word%22%3A%22Development%22%7D%2C%7B%22word%22%3A%22Design%22%7D%2C%7B%22word%22%3A%22Optimization%22%7D%5D"]Boost your site performance and achieve higher rankings on Google.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Mobile Presentation Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Mobile Presentation', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/mobile-presentation-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1497038067755{padding-top: 70px !important;padding-bottom: 70px !important;}"][vc_column][ra_section_title style="classic2" title="Built for All Devices." transform="text-capitalize" title_font_container="tag:h3|font_size:50px|color:%23000000|line_height:1.15em" title_google_fonts="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal" content_font_container="tag:p|font_size:16px|color:rgba(0%2C0%2C0%2C0.15)|line_height:1.15em" content_google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_title="true" use_custom_fonts_content="true"]RESPONSIVE &amp; RETINA[/ra_section_title][/vc_column][vc_column width="1/2"][vc_single_image source="external_link" alignment="center" custom_src="http://boo.themerella.com/wp-content/uploads/2017/06/screens.jpg"][/vc_column][vc_column width="1/2"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xsm" position="icon-box-side" title="OPTIMIZED IMAGES &amp; ICONS" css=".vc_custom_1497038102396{margin-bottom: 35px !important;}"]Humorously perilous business for both of us. For, before we further proceed broad usly perilous business for canvas.[/ra_icon_box][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xsm" position="icon-box-side" title="SHARP &amp; PIXEL PERFECT" css=".vc_custom_1497038117684{margin-bottom: 35px !important;}"]Humorously perilous business for both of us. For, before we further proceed broad usly perilous business for canvas.[/ra_icon_box][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xsm" position="icon-box-side" title="FAST AS LIGHT"]Humorously perilous business for both of us. For, before we further proceed broad usly perilous business for canvas.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;



	//Agency Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Process with Counter', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/agency-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content" css=".vc_custom_1476867499329{margin-bottom: 120px !important;border-top-width: 2px !important;border-bottom-width: 2px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-top-color: #f2f2f2 !important;border-top-style: dashed !important;border-bottom-color: #f2f2f2 !important;border-bottom-style: dashed !important;}"][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-6"][ra_icon_box template="process" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" ib_style="btn-naked" ib_text="text-uppercase" show_counter="yes" show_btn="yes" title="The idea" button_text="Learn more" button_link="url:%23||" serial="01" ib_title="Learn More"]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-6"][ra_icon_box template="process" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" position="icon-box-inline" ib_style="btn-naked" ib_text="text-uppercase" show_counter="yes" show_btn="yes" title="Development" button_text="Learn more" button_link="url:%23||" serial="02" ib_title="Lear more"]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-6"][ra_icon_box template="process" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" show_counter="yes" show_btn="yes" title="Launch" button_text="Learn more" button_link="url:%23||" image="" ib_title="Lear more" ib_link="url:%23||" serial="03"]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][/vc_column][vc_column width="1/2" align="text-right" css=".vc_custom_1485762051202{margin-top: 50px !important;padding-right: 0px !important;}" offset="vc_col-lg-3 vc_col-md-6"][ra_button style="btn-boxed" title="Let's Work Together" second_color="#02a3d2" primary_color="#05baef"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Agency Icon Boxes 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/agency-icon-box-2.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1476880040875{margin-bottom: 100px !important;}"][vc_column][ra_section_title style="classic" title="Features" css=".vc_custom_1476879936191{margin-bottom: 100px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" css=".vc_custom_1484846395054{padding-right: 24% !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" position="icon-box-side" alignment="align-right" title="Seo Optimization" image=""]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" position="icon-box-side" alignment="align-right" title="Responsive Layout" image=""]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" position="icon-box-side" alignment="align-right" title="Domain Registration" image=""]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3" offset="vc_hidden-sm vc_hidden-xs"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499177557014{margin-top: 60px !important;}" custom_src="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/mid-image.jpg"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1484846411301{padding-left: 24% !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" position="icon-box-side" title="Visual Composer" image=""]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" position="icon-box-side" title="High Performance" image=""]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" position="icon-box-side" title="Unique Layouts" image=""]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod tempor.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Agency Icon Boxes 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Rounde Shape', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/agency-icon-box-3.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" svg_separator="yes" css=".vc_custom_1488474516871{background-color: #088ace !important;}" svg_color="#ffffff"][vc_column][ra_section_title style="classic" title="Get in Touch" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1484838369525{margin-top: 60px !important;margin-bottom: 40px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476878909317{background-color: #088ace !important;}"][vc_column width="5/6" offset="vc_col-md-offset-1 vc_col-sm-offset-1"][vc_row_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Call us" i_icon_fontawesome="fa fa-phone" icon_background_color="#ffffff" icon_color="#2595cf" title_color="#ffffff" content_color="#ffffff" icon_bg="#ffffff" title_size="17px" content_size="17px"]1-234-567-890[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Mail us" i_icon_fontawesome="fa fa-envelope-o" icon_background_color="#ffffff" icon_color="#2595cf" title_color="#ffffff" content_color="#ffffff" icon_bg="#ffffff" title_size="17px" content_size="17px"]info@boo.com[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Visit us" i_icon_fontawesome="fa fa-map-marker" icon_background_color="#ffffff" icon_color="#2595cf" title_color="#ffffff" content_color="#ffffff" icon_bg="#ffffff" title_size="17px" content_size="17px"]5th Avenue, Manhattan[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Agency Icon Boxes 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Big Rounded Border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/agency-icon-box-4.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css_animation="none" css=".vc_custom_1488808402614{padding-top: 200px !important;padding-bottom: 100px !important;}"][vc_column offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" background_shape="circle-bordered" shape_size="xxxlg" ib_style="btn-default" ib_shape="round" ib_border="border-thick" ib_text="text-uppercase" show_btn="yes" btn_size="btn-md weight-bold text-uppercase" btn_style="round" btn_border="border-thick" title="High Performance" button_text="I want this" button_link="url:%23||" image="" ib_title="I want this" ib_bc="#05baef" ib_hbc="#05baef" ib_hbg="#05baef" ib_text_color="#000000" ib_htext_color="#ffffff" brd_color="#f2f2f2"]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod adipiscing elit tempor.[/ra_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" background_shape="circle-bordered" shape_size="xxxlg" ib_style="btn-default" ib_shape="round" ib_border="border-thick" ib_text="text-uppercase" show_btn="yes" btn_size="btn-md weight-bold text-uppercase" btn_style="round" btn_border="border-thick" title="User Experience" button_text="I want this" button_link="url:%23||" image="" ib_title="I want this" ib_link="url:%23||" ib_hbg="#05baef" ib_text_color="#000000" ib_htext_color="#ffffff" ib_bc="#05baef" ib_hbc="#05baef" brd_color="#f2f2f2"]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod adipiscing elit tempor.[/ra_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" background_shape="circle-bordered" shape_size="xxxlg" ib_style="btn-default" ib_shape="round" ib_border="border-thick" ib_text="text-uppercase" show_btn="yes" btn_size="btn-md weight-bold text-uppercase" btn_style="round" btn_border="border-thick" title="SEO Optimisation" button_text="I want this" button_link="url:%23||" image="" ib_title="I want this" ib_link="url:%23||" ib_hbg="#05baef" ib_text_color="#000000" ib_htext_color="#ffffff" ib_bc="#05baef" ib_hbc="#05baef" brd_color="#f2f2f2"]Lorem ipsum dolor sit amet consec tetur adipiscing elit sed do eiusmod adipiscing elit tempor.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box with Banner', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/business01-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1493277837946{margin-top: 135px !important;margin-bottom: 155px !important;}"][vc_column width="1/2" offset="vc_col-md-3"][ra_banner style="s15"][vc_column_text]
<h2>Smart Solutions for you.</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1487582715331{margin-bottom: 30px !important;}"]
<ul>
	<li>Special Discounts</li>
	<li>Weekly Reports</li>
	<li>Easy to use Tools</li>
</ul>
[/vc_column_text][ra_button style="btn-solid" size="btn-md" text="text-uppercase" i_type="fontawesome" i_align="right" title="see pr?c?ng" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff" text_color="#000000" hbg="#288fd7" htext_color="#ffffff"][/ra_banner][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="boxed-alt3" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Years of Experience." ib_title="See Pricing" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_color="#288fd7" title_size="17px" i_icon_linea="icon-basic_paperplane"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="boxed-alt3" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Years of Experience." ib_title="See Pricing" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_color="#288fd7" title_size="17px" i_icon_linea="icon-linear-thumbs-up2" icon_fs="70px"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="boxed-alt3" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Years of Experience." ib_title="See Pricing" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_color="#288fd7" title_size="17px" i_icon_linea="icon-basic_todolist_pen"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Icon Boxes 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Rounded 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/business02-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css_animation="none" css=".vc_custom_1493369742251{padding-top: 75px !important;padding-bottom: 95px !important;}"][vc_column offset="vc_col-md-4"][ra_icon_box template="" heading_weight="weight-medium" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Virtual Document Assistant." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" i_icon_linea="icon-basic_elaboration_browser_search" icon_color="#ffffff" icon_bg="#3e3e43" ib_text_color="#000000"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_weight="weight-medium" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Flexible Payment Solutions." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" i_icon_linea="icon-basic_case" icon_color="#ffffff" icon_bg="#3e3e43" ib_text_color="#000000"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_weight="weight-medium" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Annual Sales `{`ra_br`}` Report." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" i_icon_linea="icon-ecommerce_graph2" icon_color="#ffffff" icon_bg="#3e3e43" ib_text_color="#000000"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Icon Boxes 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Border Dark', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/business02-icon-box-2.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1483112999182{padding-top: 120px !important;padding-bottom: 150px !important;}"][vc_column css_animation="none"][ra_section_title style="classic7" title="Business Solutions" css=".vc_custom_1493370564747{margin-bottom: 70px !important;}"]Trusted Partners[/ra_section_title][vc_row_inner][vc_column_inner offset="vc_col-md-4"][ra_icon_box template="boxed" heading_size="icon-box-heading-xxlg" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxxlg" ib_style="btn-naked" ib_size="btn-xxlg" ib_i_type="fontawesome" ib_i_align="right" title="Secure." i_icon_linea="icon-linear-map-marker" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#d94747" ib_fs="20px" icon_color="#000000" title_size="27px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="boxed" heading_size="icon-box-heading-xxlg" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxxlg" ib_style="btn-naked" ib_size="btn-xxlg" ib_i_type="fontawesome" ib_i_align="right" title="Reliable." i_icon_linea="icon-ecommerce_graph2" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#d94747" ib_fs="20px" icon_color="#000000" title_size="27px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="boxed" heading_size="icon-box-heading-xxlg" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxxlg" ib_style="btn-naked" ib_size="btn-xxlg" ib_i_type="fontawesome" ib_i_align="right" title="Fast." i_icon_linea="icon-linear-bubble" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#d94747" ib_fs="20px" icon_color="#000000" title_size="27px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Icon Boxes 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box with Heading', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/business08-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1493387168601{padding-top: 55px !important;padding-bottom: 20px !important;background-color: #eedfda !important;}"][vc_column align="text-right" css=".vc_custom_1493387272307{padding-right: 80px !important;}" offset="vc_col-md-6"][vc_column_text fill="yes" tag="h2"]
<h2>we design exclusive
themes for huge
impact on ux.</h2>
- THEMERELLA[/vc_column_text][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="sm" position="icon-box-inline" title="Exclusive Concepts" image="" icon_color="#2f43a9" icon_color2="#6179f1" css=".vc_custom_1493386503714{margin-bottom: 65px !important;}"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="sm" position="icon-box-inline" title="Exclusive Concepts" image="" icon_color="#2f43a9" icon_color2="#6179f1" css=".vc_custom_1493386511479{margin-bottom: 65px !important;}"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="sm" position="icon-box-inline" title="Exclusive Concepts" image="" icon_color="#2f43a9" icon_color2="#6179f1" css=".vc_custom_1493386518565{margin-bottom: 65px !important;}"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="sm" position="icon-box-inline" title="Exclusive Concepts" image="" icon_color="#2f43a9" icon_color2="#6179f1" css=".vc_custom_1493386529198{margin-bottom: 65px !important;}"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Border with Button ', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/car-dealer-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485442805598{padding-top: 165px !important;padding-bottom: 140px !important;}"][vc_column width="1/3"][ra_icon_box template="boxed-alt4" heading_size="icon-box-heading-md" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Easy Financing" ib_title="See price table" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" content_color="rgba(0,0,0,0.65)" ib_fs="14px" ib_ls="0.075em" i_icon_linea="icon-ecommerce_dollar"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][vc_column width="1/3"][ra_icon_box template="boxed-alt4" heading_size="icon-box-heading-md" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Trusted Experience" ib_title="See our Team" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" content_color="rgba(0,0,0,0.65)" i_icon_linea="icon-basic_headset" ib_fs="14px" ib_ls="0.075em"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][vc_column width="1/3"][ra_icon_box template="boxed-alt4" heading_size="icon-box-heading-md" heading_weight="weight-normal" show_button="yes" i_type="linea" shape_size="xxlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="High Quality Products" ib_title="Shop Now" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" content_color="rgba(0,0,0,0.65)" i_icon_linea="icon-basic_gear" ib_fs="14px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Expanding Shadow', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/car-rental-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485548570865{padding-top: 120px !important;padding-bottom: 110px !important;}"][vc_column width="1/3"][ra_icon_box template="boxed-alt5" heading_size="icon-box-heading-sm" show_button="yes" i_type="linecons" shape_size="xxlg" ib_style="btn-solid" ib_shape="round" ib_size="btn-xsm" ib_others="wide" ib_text="text-uppercase" title="No Hidden Fees" ib_title="Read more" ib_link="url:%23|||" content_color="rgba(0,0,0,0.65)" ib_fs="13px" ib_lh="21px" i_icon_linecons="vc_li vc_li-key" title_size="17px" ib_fw="600" ib_ls="0.07em" ib_second_color="#dd3333" ib_bc="#dd3333"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][vc_column width="1/3"][ra_icon_box template="boxed-alt5" heading_size="icon-box-heading-sm" show_button="yes" i_type="linecons" shape_size="xxlg" ib_style="btn-solid" ib_shape="round" ib_size="btn-xsm" ib_others="wide" ib_text="text-uppercase" title="Pick Up Anytime" ib_title="Read more" ib_link="url:%23|||" content_color="rgba(0,0,0,0.65)" ib_fs="13px" ib_lh="21px" i_icon_linecons="vc_li vc_li-heart" title_size="17px" ib_fw="600" ib_ls="0.07em"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][vc_column width="1/3"][ra_icon_box template="boxed-alt5" heading_size="icon-box-heading-sm" show_button="yes" i_type="linecons" shape_size="xxlg" ib_style="btn-solid" ib_shape="round" ib_size="btn-xsm" ib_others="wide" ib_text="text-uppercase" title="Repair Included" ib_title="Read more" ib_link="url:%23|||" content_color="rgba(0,0,0,0.65)" ib_fs="13px" ib_lh="21px" i_icon_linecons="vc_li vc_li-settings" title_size="17px" ib_fw="600" ib_ls="0.07em"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices puruut feugiat augue.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Cloud Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Border Boxed', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/cloud-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485505898450{padding-top: 15px !important;padding-bottom: 35px !important;}"][vc_column][ra_section_title style="big" title="Innovative Clouds." title_font_container="tag:h2" title_use_theme_fonts="yes" show_button="yes" ib_style="btn-naked" ib_i_type="fontawesome" ib_i_align="right" use_custom_fonts_title="true" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#30c2f9" ib_fs="20px" ib_fw="300" ib_i_size="16px" ib_i_ml="9px" css=".vc_custom_1485505936665{margin-bottom: 70px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
incididunt ut labore et dolore.aliqua.[/ra_section_title][vc_row_inner][vc_column_inner offset="vc_col-md-4"][ra_icon_box template="boxed-alt" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xxlg" show_button="yes" shape_size="xlg" ib_style="btn-naked" ib_size="btn-xxlg" ib_i_type="fontawesome" ib_i_align="right" title="Secure." image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_i_size="16px" ib_i_ml="9px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="boxed-alt" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xxlg" show_button="yes" shape_size="xlg" ib_style="btn-naked" ib_size="btn-xxlg" ib_i_type="fontawesome" ib_i_align="right" title="Reliable." image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_i_size="16px" ib_i_ml="9px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="boxed-alt" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xxlg" show_button="yes" shape_size="xlg" ib_style="btn-naked" ib_size="btn-xxlg" ib_i_type="fontawesome" ib_i_align="right" title="Fast." image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_i_size="16px" ib_i_ml="9px"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Cloud Icon Boxes 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Horizontal', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/cloud-icon-box-2.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485509752172{padding-top: 10px !important;padding-bottom: 120px !important;}"][vc_column][ra_section_title style="big" title="Better Clouds." title_font_container="tag:h2" title_use_theme_fonts="yes" show_button="yes" ib_style="btn-naked" ib_i_type="fontawesome" ib_i_align="right" use_custom_fonts_title="true" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#30c2f9" ib_i_size="16px" ib_i_ml="9px" ib_fs="20px" css=".vc_custom_1485508177391{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
incididunt ut labore et dolore.aliqua.[/ra_section_title][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="boxed-alt2" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-lg" shape_size="lg" position="icon-box-side" valignment="icon-middle" title="Secure." image=""]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="boxed-alt2" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-lg" shape_size="md2" position="icon-box-side" valignment="icon-middle" title="Reliable." image=""]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="boxed-alt2" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-lg" shape_size="xlg" position="icon-box-side" valignment="icon-middle" title="Solid Drives." image=""]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485518105394{padding-top: 0px !important;}" offset="vc_col-md-4"][ra_icon_box template="boxed-alt2" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-lg" position="icon-box-side" valignment="icon-middle" title="Protected."]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485518111851{padding-top: 0px !important;}" offset="vc_col-md-4"][ra_icon_box template="boxed-alt2" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-lg" position="icon-box-side" valignment="icon-middle" title="International." image=""]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485518118716{padding-top: 0px !important;}" offset="vc_col-md-4"][ra_icon_box template="boxed-alt2" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-lg" position="icon-box-side" valignment="icon-middle" title="Free Support." image=""]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Rounded', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/corporate01-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1493104105287{padding-top: 10px !important;padding-bottom: 150px !important;}"][vc_column][ra_section_title style="thick" title="services." content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1493102226927{margin-bottom: 65px !important;}"]Let us help you[/ra_section_title][vc_row_inner gap="20"][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_size="btn-sm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Extended `{`ra_br`}` Documentation." i_icon_linea="icon-basic_sheet_txt" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_fw="700" title_size="20px" h_icon_bg="#50ba26" ib_htext_color="#50ba26" css=".vc_custom_1493104184933{margin-bottom: 30px !important;}"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_size="btn-sm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Business `{`ra_br`}` Infographics." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" i_icon_linea="icon-ecommerce_graph_increase" ib_fw="700" title_size="20px" h_icon_bg="#50ba26" ib_htext_color="#50ba26" css=".vc_custom_1493104059435{margin-bottom: 30px !important;}"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_size="btn-sm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Exclusive `{`ra_br`}` Theme Support." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" i_icon_linea="icon-flaticon-phone6" ib_fw="700" title_size="20px" h_icon_bg="#50ba26" ib_htext_color="#50ba26" css=".vc_custom_1493104067373{margin-bottom: 30px !important;}"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485533741211{padding-top: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_size="btn-sm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="$1000 worth `{`ra_br`}` Plugins included." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" i_icon_linea="icon-flaticon-shopping-bag2" ib_fw="700" title_size="20px" h_icon_bg="#50ba26" ib_htext_color="#50ba26" css=".vc_custom_1493104075619{margin-bottom: 30px !important;}"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485533748095{padding-top: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_size="btn-sm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Satisfied `{`ra_br`}` Customers." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" i_icon_linea="icon-linear-star2" ib_fw="700" title_size="20px" h_icon_bg="#50ba26" ib_htext_color="#50ba26" css=".vc_custom_1493104084020{margin-bottom: 30px !important;}"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485533754740{padding-top: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="linea" background_shape="circle" shape_size="sm" position="icon-box-side" ib_style="btn-naked" ib_size="btn-sm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Ultra Flexible `{`ra_br`}` Theme Options." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" i_icon_linea="icon-basic_gear" ib_fw="700" title_size="20px" h_icon_bg="#50ba26" ib_htext_color="#50ba26" css=".vc_custom_1493104092663{margin-bottom: 30px !important;}"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row
CONTENT;
	$templates[] = $data;

	//Corporate Icon Boxes 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Hexagon', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/corporate02-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479469005517{padding-top: 50px !important;padding-bottom: 80px !important;}"][vc_column][ra_section_title style="thick2" title="services." css=".vc_custom_1484231284901{margin-bottom: 90px !important;}"] <hr /> [/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="linea" background_shape="hexagon" shape_size="md" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Extended Documentation." i_icon_linea="icon-file3" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" icon_bg="#443675" icon_fs="50px" title_color="#3b3e79" h_icon_bg="#f2784b" ib_htext_color="#f2784b"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="fontawesome" background_shape="hexagon" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Business `{`ra_br`}` Infographics." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" icon_bg="#443675" i_icon_fontawesome="fa fa-bar-chart" icon_fs="50px" title_color="#3b3e79" h_icon_bg="#f2784b" ib_htext_color="#f2784b"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="fontawesome" background_shape="hexagon" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Exclusive `{`ra_br`}` Theme Support." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" icon_bg="#443675" i_icon_fontawesome="fa fa-phone" icon_fs="50px" title_color="#3b3e79" h_icon_bg="#f2784b" ib_htext_color="#f2784b"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1492002121452{padding-top: 50px !important;}" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="fontawesome" background_shape="hexagon" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="$1000 worth `{`ra_br`}` Plugins included." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" icon_bg="#443675" i_icon_fontawesome="fa fa-shopping-bag" icon_fs="50px" title_color="#3b3e79" h_icon_bg="#f2784b" ib_htext_color="#f2784b"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1492002132161{padding-top: 50px !important;}" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="fontawesome" background_shape="hexagon" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Satisfied `{`ra_br`}` Customers." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" icon_bg="#443675" i_icon_fontawesome="fa fa-trophy" icon_fs="50px" title_color="#3b3e79" h_icon_bg="#f2784b" ib_htext_color="#f2784b"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1492002142147{padding-top: 50px !important;}" offset="vc_col-md-4"][ra_icon_box template="" heading_size="icon-box-heading-md" show_button="yes" i_type="fontawesome" background_shape="hexagon" position="icon-box-side" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Ultra Flexible `{`ra_br`}` Theme Options." ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" icon_bg="#443675" i_icon_fontawesome="fa fa-cog" icon_fs="50px" title_color="#3b3e79" h_icon_bg="#f2784b" ib_htext_color="#f2784b"]Lorem ipsum dolor simaet, consec adipiscing elit. Duis consecteturease auctor elit eros in selectus.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Icon Boxes 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Classic with Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/corporate03-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1493121731388{padding-top: 70px !important;padding-bottom: 90px !important;}"][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-sm1" show_button="yes" i_type="linea" shape_size="md" ib_style="btn-naked" ib_shape="round" ib_text="text-uppercase" title="Real Time Analytics" ib_title="Learn More" ib_link="url:%23|||" ib_fs="13px" title_size="23px" ib_fw="bold" i_icon_linea="icon-ecommerce_graph3" ib_ls="0.15em" icon_fs="70px" title_color="#000000"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-sm1" show_button="yes" i_type="linea" shape_size="md" ib_style="btn-naked" ib_shape="round" ib_text="text-uppercase" title="Latest Equipments" ib_title="Learn More" ib_link="url:%23|||" ib_fs="13px" title_size="23px" ib_fw="bold" i_icon_linea="icon-basic_display" ib_ls="0.15em" icon_fs="70px" title_color="#000000"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-sm1" show_button="yes" i_type="linea" shape_size="md" ib_style="btn-naked" ib_shape="round" ib_text="text-uppercase" title="Approved Documents" ib_title="Learn More" ib_link="url:%23|||" ib_fs="13px" title_size="23px" ib_fw="bold" i_icon_linea="icon-basic_sheet_pen" ib_ls="0.15em" icon_fs="70px" title_color="#000000"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-sm1" show_button="yes" i_type="linea" shape_size="md" ib_style="btn-naked" ib_shape="round" ib_text="text-uppercase" title="Quick Paycheck" ib_title="Learn More" ib_link="url:%23|||" ib_fs="13px" title_size="23px" ib_fw="bold" i_icon_linea="icon-ecommerce_creditcard" ib_ls="0.15em" icon_fs="70px" title_color="#000000"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Classic 4 Columns', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/elegant-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484724148018{padding-top: 150px !important;padding-bottom: 95px !important;}"][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="xxlg" title="Visual Composer" image="" icon_color="#376ae3" icon_color_two="#00b9ff" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="xxlg" title="Free Support" image="" icon_color="#3f6fe0" icon_color_two="#00b9ff" animation_delay="300" icon_color2="#8e54e9" primary_color="#ffffff"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="xxlg" title="E-Commerce" image="" icon_color="#3f6fe0" icon_color_two="#00b9ff" animation_delay="600" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" shape_size="xxlg" title="Analytics" image="" icon_color="#3f6fe0" icon_color_two="#00b9ff" animation_delay="900" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Icon Boxes 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Small Rounded with Image', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/elegant-icon-box-2.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" content_placement="middle" css_animation="bottom-to-top" gradient_bg="yes" css=".vc_custom_1485619415372{padding-top: 0px !important;padding-bottom: 60px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" gradient_bg_color="linear-gradient(137deg,rgba(245, 235, 235, 0.63) 0%,rgba(247, 243, 237, 0.6) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column offset="vc_col-md-6 vc_col-xs-12"][ra_section_title style="underline" title="Activity monitor." alignment="align-left" content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true"]<span style="color: #bcb3c9;">STAY HEALTHY.</span>[/ra_section_title][vc_row_inner][vc_column_inner width="1/2"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" background_shape="circle" shape_size="xsm" position="icon-box-side" title="Visual Composer" image="" icon_color="#3f6fe0" icon_color2="#8e54e9" icon_bg="#ffffff" title_color="#251242" content_color="#7c7884"]<span style="color: #898592;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt.</span>[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" background_shape="circle" shape_size="xsm" position="icon-box-side" title="Front-end Builder" image="" icon_color="#3f6fe0" icon_color2="#8e54e9" icon_bg="#ffffff" title_color="#251242" content_color="#7c7884"]<span style="color: #898592;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt.</span>[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" background_shape="circle" shape_size="xsm" position="icon-box-side" title="Visual Composer" image="" icon_color="#3f6fe0" icon_color2="#8e54e9" icon_bg="#ffffff" title_color="#251242" content_color="#7c7884"]<span style="color: #898592;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt.</span>[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" animation="yes" background_shape="circle" shape_size="xsm" position="icon-box-side" title="Live Customizer" image="" icon_color="#3f6fe0" icon_color2="#8e54e9" icon_bg="#ffffff" title_color="#251242" content_color="#7c7884"]<span style="color: #898592;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt.</span>[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" bg_position="center center" offset="vc_hidden-sm vc_hidden-xs"][vc_single_image source="external_link" alignment="center" css_animation="none" custom_src="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/appleWatch.png"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Icon Boxes 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Process', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/elegant-icon-box-3.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1488449535795{border-top-width: 2px !important;border-bottom-width: 2px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-top-color: #f2f2f2 !important;border-top-style: dashed !important;border-bottom-color: #f2f2f2 !important;border-bottom-style: dashed !important;}"][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-6"][ra_icon_box template="process" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" show_counter="yes" show_btn="yes" title="The idea" button_text="Learn more" button_link="url:%23||" image="" serial="01" ib_title="Learn More"]Far far away, behind the word mountains, far from the countries Vokalia and Con[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-6"][ra_icon_box template="process" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" position="icon-box-inline" ib_style="btn-naked" ib_text="text-uppercase" show_counter="yes" show_btn="yes" title="Development" button_text="Learn more" button_link="url:%23||" image="" serial="02" ib_title="Lear more"]Far far away, behind the word mountains, far from the countries Vokalia and Con[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-lg-3 vc_col-md-6"][ra_icon_box template="process" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-xlg" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" show_counter="yes" show_btn="yes" title="Launch" button_text="Learn more" button_link="url:%23||" image="" ib_title="Lear more" ib_link="url:%23||" serial="03"]Far far away, behind the word mountains, far from the countries Vokalia and Con[/ra_icon_box][/vc_column][vc_column width="1/2" align="text-right" css=".vc_custom_1485762051202{margin-top: 50px !important;padding-right: 0px !important;}" offset="vc_col-lg-3 vc_col-md-6"][ra_button style="btn-boxed" title="Let's Work Together" second_color="#752ee8" primary_color="#8e54e9"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Blue Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Naked Left with Button 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/hostingblue-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1489562352362{margin-top: 100px !important;}"][vc_column][ra_section_title style="classic2" title="Innovative Hosting" title_font_container="tag:h2" title_google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" title_css_animation="fadeInUp" use_custom_fonts_title="true" css=".vc_custom_1489561905216{margin-bottom: 120px !important;}" description="Far far away behind the word mountains,far from the countries Vokalia and Consonantia"]KNOW THIS FIRST[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="High Performance" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)" ib_fw="700"]Lorem ipsum dolor sit amet, cotetur adipiscing elit.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Secure Servers" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)" ib_fw="700"]Lorem ipsum dolor sit amet, cotetur adipiscing elit.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Time Machine" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)" ib_fw="700"]Lorem ipsum dolor sit amet, cotetur adipiscing elit.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1489562204669{margin-bottom: 120px !important;}"][vc_column width="1/3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Free Backups" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)" ib_fw="700"]Lorem ipsum dolor sit amet, cotetur adipiscing elit.[/ra_icon_box][/vc_column][vc_column width="1/3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="SEO Optimisation" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)" ib_fw="700"]Lorem ipsum dolor sit amet, cotetur adipiscing elit.[/ra_icon_box][/vc_column][vc_column width="1/3"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Cloud Storage" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)" ib_fw="700"]Lorem ipsum dolor sit amet, cotetur adipiscing elit.[/ra_icon_box][/vc_column][/vc_row
CONTENT;
	$templates[] = $data;

	//Hosting Red Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Naked Left with Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/hostingred-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485266944525{padding-top: 40px !important;padding-bottom: 95px !important;}"][vc_column][ra_section_title style="underline3" title="Overall Features" content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" el_class="mb-0"]The Fastest Servers[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" css=".vc_custom_1485266818357{margin-bottom: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="IT Support" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)"]Far far away behind the word mountains far from.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485266833822{margin-bottom: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Private Cloud" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)"]Far far away behind the word mountains far from.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485266840533{margin-bottom: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Hardware Setup" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)"]Far far away behind the word mountains far from.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485266853920{margin-bottom: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Data Backup" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)"]Far far away behind the word mountains far from.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1485266895832{margin-bottom: 25px !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Telephone Systems" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)"]Far far away behind the word mountains far from.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1485266901912{margin-bottom: 25px !important;}"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" show_button="yes" background_shape="circle" shape_size="lg" position="icon-box-side" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Wide Networking" image="" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" icon_bg="rgba(255,255,255,0.01)"]Far far away behind the word mountains far from.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box with Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/lawyer-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485438005083{padding-top: 75px !important;padding-bottom: 35px !important;}"][vc_column][ra_section_title style="underline4" title="Approach" title_font_container="tag:h2" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23000000" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1486020554565{margin-bottom: 75px !important;}"]Our trust policy protects you.[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10"][ra_icon_box template="boxed-alt3" heading_size="icon-box-heading-md2" show_button="yes" i_type="fontawesome" shape_size="xlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Years of experience." i_icon_fontawesome="fa fa-clock-o" ib_title="see pract?ce" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10"][ra_icon_box template="boxed-alt3" heading_size="icon-box-heading-md2" show_button="yes" i_type="fontawesome" shape_size="xlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Trusted Partners." i_icon_fontawesome="fa fa-balance-scale" ib_title="see pract?ce" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10"][ra_icon_box template="boxed-alt3" heading_size="icon-box-heading-md2" show_button="yes" i_type="fontawesome" shape_size="xlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Satisfied Clients." i_icon_fontawesome="fa fa-users" ib_title="see pract?ce" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10"][ra_icon_box template="boxed-alt3" heading_size="icon-box-heading-md2" show_button="yes" i_type="fontawesome" shape_size="xlg" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Privacy Protection." i_icon_fontawesome="fa fa-thumbs-o-up" ib_title="see pract?ce" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Shadow Hover', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/main-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1493673706345{padding-top: 150px !important;}" responsive_css="padding_top_desktop:180|padding_top_tablet:130"][vc_column offset="vc_col-md-offset-3 vc_col-md-6"][ra_section_title style="resolve" title="Outstanding" effect="slide_horizontal_vertical" autoplay="yes" use_resolve_effect="yes" resolve_effect_seperator="chars" css=".vc_custom_1493670788680{margin-bottom: 0px !important;padding-bottom: 80px !important;}" items="%5B%7B%22word%22%3A%22Features%22%7D%2C%7B%22word%22%3A%22Elements%22%7D%2C%7B%22word%22%3A%22Websites%22%7D%5D"]
<h6> No coding skills required to create unique sites. Customize your site in real-time and see the results instantly.</h6>
[/ra_section_title][/vc_column][/vc_row][vc_row equal_height="yes" enable_responsive_options="yes" css=".vc_custom_1493674066025{padding-bottom: 200px !important;}" responsive_css="padding_bottom_desktop:200|padding_bottom_tablet:180"][vc_column css_animation="fadeIn" width="1/2" align="text-left" offset="vc_col-md-4"][ra_icon_box template="shadow" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" animation="yes" hover_animation="yes" shape_size="lg" title="Unique Elements" css=".vc_custom_1491296501573{margin-right: 1.55vw !important;margin-left: 1.55vw !important;}" image=""]Extreme attention to detail is the essence of Boo?s unique design concepts.[/ra_icon_box][/vc_column][vc_column css_animation="fadeIn" width="1/2" align="text-left" offset="vc_col-md-4" delay="200"][ra_icon_box template="shadow" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" heading_weight="weight-medium" effect="slide_horizontal_vertical" animation="yes" hover_animation="yes" shape_size="md" title="Live" css=".vc_custom_1493672640893{margin-right: 1.55vw !important;margin-left: 1.55vw !important;}" h_icon_color="#f13c46" items="%5B%7B%22word%22%3A%22Customize%22%7D%2C%7B%22word%22%3A%22Editor%22%7D%2C%7B%22word%22%3A%22Builder%22%7D%5D" image=""]No coding skills required to customize and create unique websites with Boo.[/ra_icon_box][/vc_column][vc_column css_animation="fadeIn" width="1/2" align="text-left" offset="vc_col-md-4" delay="2000"][ra_icon_box template="shadow" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" animation="yes" hover_animation="yes" title="High Performance" css=".vc_custom_1493672253692{margin-right: 1.55vw !important;margin-left: 1.55vw !important;}" image=""]Boost your site performance and achieve higher rankings on Google.[/ra_icon_box][/vc_column][vc_column width="1/2" align="text-left" offset="vc_col-md-4"][ra_icon_box template="shadow" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" heading_weight="weight-medium" animation="yes" hover_animation="yes" shape_size="lg" title="Premium Plugins" css=".vc_custom_1493678141409{margin-right: 1.55vw !important;margin-left: 1.55vw !important;}" h_icon_color="#f13c46" icon_color="#8224e3" icon_color2="#dd3333" image=""]$389 worth ready-to-use Extensions are included in the package.[/ra_icon_box][/vc_column][vc_column width="1/2" align="text-left" offset="vc_col-md-4"][ra_icon_box template="shadow" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" heading_weight="weight-medium" effect="slide_horizontal_vertical" animation="yes" hover_animation="yes" shape_size="md" autoplay="yes" use_title_effects="yes" title="Exclusive" css=".vc_custom_1493678026888{margin-right: 1.55vw !important;margin-left: 1.55vw !important;}" h_icon_color="#f13c46" image="" svg_width="60px" delay="2000" items="%5B%7B%22word%22%3A%22Blog%22%7D%2C%7B%22word%22%3A%22Portfolio%22%7D%2C%7B%22word%22%3A%22Shop%22%7D%5D"]Stunning animations and parallax effects will impress your visitors.[/ra_icon_box][/vc_column][vc_column width="1/2" align="text-left" offset="vc_col-md-4"][ra_icon_box template="shadow" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-md" heading_weight="weight-medium" animation="yes" hover_animation="yes" shape_size="xxxlg" title="Live Support" css=".vc_custom_1493678273488{margin-right: 1.55vw !important;margin-left: 1.55vw !important;}" h_icon_color="#f13c46" image="" svg_width="57px"]Need support? Dedicated support team is here to help you.[/ra_icon_box][/vc_column][vc_column align="text-center" css=".vc_custom_1490017304974{margin-top: 35px !important;}"][ra_button style="btn-underlined" text="text-uppercase" title="Explore all Features" link="url:%23|||" text_color="#000000" bc="#000000"][/vc_column][vc_column][ra_particles items="%5B%7B%22image%22%3A%224199%22%2C%22top_pos%22%3A%22-750px%22%2C%22left_pos%22%3A%22-50px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%20170%2C%20%5C%22scale%5C%22%3A%201.5%2C%20%5C%22y%5C%22%3A%20150%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-400%22%2C%22prlx_time%22%3A%222%22%2C%22prlx_duration%22%3A%222775%22%7D%2C%7B%22image%22%3A%224198%22%2C%22top_pos%22%3A%22-400px%22%2C%22right_pos%22%3A%22400px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%2045%2C%20%5C%22y%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-400%22%2C%22prlx_time%22%3A%222%22%2C%22prlx_duration%22%3A%222000%22%7D%2C%7B%22image%22%3A%224200%22%2C%22top_pos%22%3A%22-150px%22%2C%22right_pos%22%3A%22-10px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%20150%2C%20%5C%22scaleX%5C%22%3A%202.5%2C%20%5C%22y%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-400%22%2C%22prlx_time%22%3A%222%22%2C%22prlx_duration%22%3A%22925%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Icon Boxes 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Inverse', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/main-icon-box-2' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css_animation="none" css=".vc_custom_1490742272483{margin-bottom: 120px !important;border-right-width: 25px !important;border-left-width: 25px !important;padding-top: 75px !important;padding-bottom: 125px !important;background-color: #0e0e1d !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;}"][vc_column width="1/3" align="text-left"][ra_icon_box template="shadow" i_type="linea" title="Capabilities" icon_color="#9797aa" h_icon_color="#ffffff" title_color="#ffffff" content_color="#9797aa" i_icon_linea="icon-basic_watch" icon_color2="#6363aa"]Customize your site in real-time and see the results instantly. No coding skills required.[/ra_icon_box][ra_icon_box template="shadow" i_type="linea" use_title_effects="yes" title="Capabilities" icon_color="#9797aa" h_icon_color="#ffffff" title_color="#ffffff" content_color="#9797aa" i_icon_linea="icon-basic_watch" icon_color2="#6363aa"]Customize your site in real-time and see the results instantly. No coding skills required.[/ra_icon_box][/vc_column][vc_column width="1/3" align="text-left"][ra_icon_box template="shadow" i_type="linea" use_title_effects="yes" title="Capabilities" icon_color="#9797aa" h_icon_color="#ffffff" title_color="#ffffff" content_color="#9797aa" i_icon_linea="icon-basic_watch" icon_color2="#6363aa"]Customize your site in real-time and see the results instantly. No coding skills required.[/ra_icon_box][ra_icon_box template="shadow" i_type="linea" use_title_effects="yes" title="Capabilities" icon_color="#9797aa" h_icon_color="#ffffff" title_color="#ffffff" content_color="#9797aa" i_icon_linea="icon-basic_watch" icon_color2="#6363aa"]Customize your site in real-time and see the results instantly. No coding skills required.[/ra_icon_box][vc_row_inner][vc_column_inner align="text-center"][ra_button style="btn-underlined" text="text-uppercase" title="View our Projects" text_color="rgba(255,255,255,0.7)" htext_color="#ffffff" bc="rgba(255,255,255,0.7)" hbc="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" align="text-left"][ra_icon_box template="shadow" i_type="linea" use_title_effects="yes" title="Capabilities" icon_color="#9797aa" h_icon_color="#ffffff" title_color="#ffffff" content_color="#9797aa" i_icon_linea="icon-basic_watch" icon_color2="#6363aa"]Customize your site in real-time and see the results instantly. No coding skills required.[/ra_icon_box][ra_icon_box template="shadow" i_type="linea" use_title_effects="yes" title="Capabilities" icon_color="#9797aa" h_icon_color="#ffffff" title_color="#ffffff" content_color="#9797aa" i_icon_linea="icon-basic_watch" icon_color2="#6363aa"]Customize your site in real-time and see the results instantly. No coding skills required.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Icon Boxes 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Rounded Border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/main-icon-box-3.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/4"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="circle-bordered" shape_size="sm" position="icon-box-inline" title="0 800 300 30 90" icon_color="#f13c46" i_icon_fontawesome="fa fa-phone" icon_fs="26px"]Lorem ipsum dolor sit amet, consec do eiusmod temsor incididunt.[/ra_icon_box][/vc_column][vc_column width="1/4"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="circle-bordered" shape_size="sm" position="icon-box-inline" title="info@rella.com" icon_color="#f13c46" i_icon_fontawesome="fa fa-envelope-o" icon_fs="26px"]Lorem ipsum dolor sit amet, consec do eiusmod temsor incididunt.[/ra_icon_box][/vc_column][vc_column width="1/4"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="circle-bordered" shape_size="sm" position="icon-box-inline" title="Support Forums" icon_color="#f13c46" i_icon_fontawesome="fa fa-thumbs-o-up" icon_fs="30px"]Lorem ipsum dolor sit amet, consec do eiusmod temsor incididunt.[/ra_icon_box][/vc_column][vc_column width="1/4"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="circle-bordered" shape_size="sm" position="icon-box-inline" title="Mon-Fri: 8am - 7pm" icon_color="#f13c46" i_icon_fontawesome="fa fa-clock-o" icon_fs="30px"]Lorem ipsum dolor sit amet, consec do eiusmod temsor incididunt.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main 2 Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Classic 3 Columns', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/main2-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1490278171876{margin-top: 100px !important;}"][vc_column][ra_section_title style="default" title="The Ultimate Package"]UNIQUE LAYOUTS[/ra_section_title][/vc_column][/vc_row][vc_row el_class="mb80" css=".vc_custom_1490277439775{margin-bottom: 100px !important;}"][vc_column align="align-center" offset="vc_col-md-4" css=".vc_custom_1476207737282{padding-right: 35px !important;padding-left: 35px !important;}"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" animation="yes" shape_size="xxlg" title="The Most Unique Websites" image="" icon_color="#ee0979" icon_color2="#ff3700"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column align="align-center" offset="vc_col-md-4" css=".vc_custom_1476207750474{padding-right: 35px !important;padding-left: 35px !important;}"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" animation="yes" shape_size="xxlg" title="Infinite Possibilities" image="" icon_color="#ee0979" animation_delay="300" icon_color2="#ff3700"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][vc_column align="align-center" offset="vc_col-md-4" css=".vc_custom_1476207757905{padding-right: 35px !important;padding-left: 35px !important;}"][ra_icon_box template="" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" animation="yes" shape_size="xxlg" title="Best Support Ever" image="" icon_color="#ee0979" animation_delay="600" icon_color2="#ff3700"]Lorem ipsum dolor sit amet, consectetu do eiusmod tempor incididunt labore.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Icon 2 Boxes 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Square', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/main2-icon-box-3.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1490782406770{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/6" parallax="yes" parallax_preset="custom" parallax_from="``y``:200" parallax_time="4" parallax_duration="450" css=".vc_custom_1490781691425{margin-top: 300px !important;margin-right: -100px !important;}"][vc_single_image source="external_link" alignment="right" css=".vc_custom_1499179181650{margin-right: -30px !important;}" custom_src="http://main-3.boo.themerella.com/wp-content/uploads/sites/28/2017/03/showcase-3.png"][/vc_column_inner][vc_column_inner width="5/12" parallax="yes" parallax_preset="custom" parallax_from="``y``:50" parallax_time="1.2" parallax_duration="800" css=".vc_custom_1492075803932{margin-left: -50px !important;}" offset="vc_hidden-sm vc_col-xs-12 vc_hidden-xs"][vc_single_image source="external_link" custom_src="http://main-3.boo.themerella.com/wp-content/uploads/sites/28/2017/03/showcase-2.png"][/vc_column_inner][vc_column_inner css=".vc_custom_1492075790001{margin-top: 35px !important;}" offset="vc_col-md-5"][ra_icon_box template="" heading_size="icon-box-heading-md1" i_type="linea" background_shape="square" shape_size="sm1" position="icon-box-inline" enable_bg="yes" title="Shop &amp; Store" icon_background_color="#e5432a" icon_color="#ffffff" el_class="mb-30" i_icon_linea="icon-ecommerce_bag" icon_bg="#e5432a" gradient_bg="linear-gradient(119deg,rgb(252, 0, 124) 0%,rgb(255, 55, 0) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"]Lorem ipsum dolor sit amet, consectetur elit, sed do eiusmod tempor incididunt ut labore.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md1" i_type="linea" background_shape="square" shape_size="sm1" position="icon-box-inline" enable_bg="yes" title="100+ Page Elements" icon_background_color="#e5432a" icon_color="#ffffff" el_class="mb-30" i_icon_linea="icon-software_font_leading" icon_bg="#e5432a" gradient_bg="linear-gradient(119deg,rgb(252, 0, 124) 0%,rgb(255, 55, 0) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"]Lorem ipsum dolor sit amet, consectetur elit, sed do eiusmod tempor incididunt ut labore.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md1" i_type="linea" background_shape="square" shape_size="sm1" position="icon-box-inline" enable_bg="yes" title="Unique Demos" icon_background_color="#e5432a" icon_color="#ffffff" el_class="mb-30" i_icon_linea="icon-software_layout_header_complex" icon_bg="#e5432a" gradient_bg="linear-gradient(119deg,rgb(252, 0, 124) 0%,rgb(255, 55, 0) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"]Lorem ipsum dolor sit amet, consectetur elit, sed do eiusmod tempor incididunt ut labore.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Border Left', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/mobile-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1485956527114{padding-top: 130px !important;padding-bottom: 90px !important;}"][vc_column css_animation="none" width="1/2" css=".vc_custom_1485364545185{margin-bottom: 15px !important;}" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" background_shape="square-bordered" position="icon-box-side" title="Easy to Install" icon_color="#4776e6" icon_color2="#8e54e9" i_icon_fontawesome="fa fa-tachometer"]Lorem ipsum dolor sit amet conctetur adipiscingd temp incididunt.[/ra_icon_box][/vc_column][vc_column css_animation="none" width="1/2" css=".vc_custom_1485364552020{margin-bottom: 15px !important;}" offset="vc_col-md-4" delay="200"][ra_icon_box template="" i_type="fontawesome" background_shape="square-bordered" position="icon-box-side" title="Online Community" i_icon_fontawesome="fa fa-hand-pointer-o" icon_color="#4776e6" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet conctetur adipiscingd temp incididunt.[/ra_icon_box][/vc_column][vc_column css_animation="none" width="1/2" css=".vc_custom_1485364559352{margin-bottom: 15px !important;}" offset="vc_col-md-4" delay="400"][ra_icon_box template="" i_type="fontawesome" background_shape="square-bordered" position="icon-box-side" title="Exclusive Features" i_icon_fontawesome="fa fa-bolt" icon_color="#4776e6" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet conctetur adipiscingd temp incididunt.[/ra_icon_box][/vc_column][vc_column css_animation="none" width="1/2" offset="vc_col-md-4"][ra_icon_box template="" i_type="fontawesome" background_shape="square-bordered" position="icon-box-side" title="Cross Platform" i_icon_fontawesome="fa fa-file-o" icon_color="#4776e6" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet conctetur adipiscingd temp incididunt.[/ra_icon_box][/vc_column][vc_column css_animation="none" width="1/2" offset="vc_col-md-4" delay="200"][ra_icon_box template="" i_type="fontawesome" background_shape="square-bordered" position="icon-box-side" title="Forums" i_icon_fontawesome="fa fa-futbol-o" icon_color="#4776e6" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet conctetur adipiscingd temp incididunt.[/ra_icon_box][/vc_column][vc_column css_animation="none" width="1/2" offset="vc_col-md-4" delay="400"][ra_icon_box template="" i_type="fontawesome" background_shape="square-bordered" position="icon-box-side" title="Customisable" i_icon_fontawesome="fa fa-tasks" icon_color="#4776e6" icon_color2="#8e54e9"]Lorem ipsum dolor sit amet conctetur adipiscingd temp incididunt.[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Icon Boxes 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Inverse Square', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/mobile-icon-box-2.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gradient_bg="yes" css=".vc_custom_1485966923921{padding-top: 100px !important;padding-bottom: 170px !important;}" gradient_bg_color="linear-gradient(to bottom right,rgb(71, 118, 230) 1.6%,rgb(142, 84, 233) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column][ra_section_title style="classic6" title="Amazing Features" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:rgba(255%2C255%2C255%2C0.5)" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem
accusantium doloremque laudantium, totam.[/ra_section_title][vc_row_inner css=".vc_custom_1479222255743{margin-top: 40px !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352820466{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Easy to Install" i_icon_fontawesome="fa fa-rocket" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352830495{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Community" i_icon_fontawesome="fa fa-thumbs-o-up" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352838220{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Documentation" i_icon_fontawesome="fa fa-file-o" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352855238{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Easy to Install" i_icon_fontawesome="fa fa-camera" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352865983{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Social Circle" i_icon_fontawesome="fa fa-facebook-official" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352882062{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Retina Ready" i_icon_fontawesome="fa fa-forumbee" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352898515{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Special Discounts" i_icon_fontawesome="fa fa-tree" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485352906869{margin-bottom: 10px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-medium" i_type="fontawesome" background_shape="square" title="Customizable" i_icon_fontawesome="fa fa-bolt" icon_color="#4a7ccc" icon_bg="#ffffff" title_color="#ffffff" content_color="rgba(255,255,255,0.6)"]Lorem ipsum dolor sit amet consectetur do eiusmod tempor tmepo incididunt.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Mobile Icon Boxes 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box with Ratings', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/mobile-icon-box-3.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485358981557{padding-top: 120px !important;padding-bottom: 80px !important;}"][vc_column][ra_section_title style="classic6" title="You might like." show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" ib_title="View Boo On Appstore" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="14px" ib_fw="500"][/ra_section_title][vc_row_inner css=".vc_custom_1479226660456{padding-top: 40px !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="app" i_type="fontawesome" i_icon_fontawesome="fa fa-star-o" heading_size="icon-box-heading-sm2" shape_size="xsm" position="icon-box-side" valignment="icon-middle" title="Boo Weather" image="" rating="5"]Stock[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Minimal Rounded', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/shop-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484645265161{padding-top: 30px !important;background-color: #f5f5f5 !important;}" el_class="icon-box-fonts"][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-xxxsm" i_type="linea" background_shape="circle" shape_size="md2" position="icon-box-side" valignment="icon-middle" title="Free Shipping" icon_color="#000000" h_icon_color="#ffffff" icon_bg="#ffffff" h_icon_bg="#d72828" i_icon_linea="icon-linear-rocket3"]for orders over $100[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-xxxsm" i_type="linea" background_shape="circle" shape_size="md2" position="icon-box-side" valignment="icon-middle" title="2 Year Guarantee" icon_color="#000000" h_icon_color="#ffffff" icon_bg="#ffffff" h_icon_bg="#d72828" i_icon_linea="icon-flaticon-commerce"]100% Original[/ra_icon_box][/vc_column][vc_column width="1/4"][ra_icon_box template="" heading_size="icon-box-heading-xxxsm" i_type="linea" background_shape="circle" shape_size="md2" position="icon-box-side" valignment="icon-middle" title="Secure Shopping" icon_color="#000000" h_icon_color="#ffffff" icon_bg="#ffffff" h_icon_bg="#d72828" i_icon_linea="icon-ecommerce_creditcard"]128 Bit SSL Certificate[/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_icon_box template="" heading_size="icon-box-heading-xxxsm" i_type="linea" background_shape="circle" shape_size="md2" position="icon-box-side" valignment="icon-middle" title="Free Returns" icon_color="#000000" h_icon_color="#ffffff" icon_bg="#ffffff" h_icon_bg="#d72828" i_icon_linea="icon-linear-upload4"]For 28 Days[/ra_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University Icon Boxes vc-template
	$data = array();
	$data['name'] = esc_html__( 'Icon Box Colorful', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/icon-boxes/university-icon-box.jpg' );
	$data['sort_name'] = 'Icon Boxes';
	$data['custom_class'] = 'general icon-box';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485508696481{padding-top: 85px !important;padding-bottom: 25px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column][vc_row_inner bg_position="center bottom" css=".vc_custom_1485509396161{padding-top: 190px !important;padding-bottom: 65px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-bg-min.png?id=114) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="20 Academics" i_icon_fontawesome="fa fa-suitcase" primary_color="#2ecc71" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/4" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner width="1/4" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Library Collection" i_icon_fontawesome="fa fa-book" primary_color="#167495" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445158606{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="5000+ Students" i_icon_fontawesome="fa fa-users" primary_color="#0dcdc0" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445163772{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="250 Medals" i_icon_fontawesome="fa fa-trophy" primary_color="#f85b9c" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445289677{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="50+ Professors" i_icon_fontawesome="fa fa-briefcase" primary_color="#f5b433" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445297804{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="500K Students" i_icon_fontawesome="fa fa-graduation-cap" primary_color="#9b59b6" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445303184{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Experience" i_icon_fontawesome="fa fa-hand-peace-o" primary_color="#3291d2" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445309678{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="3,083 Acres" i_icon_fontawesome="fa fa-university" primary_color="#ff6d3a" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445314542{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="$3.4 Billion" i_icon_fontawesome="fa fa-money" primary_color="#807fff" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3" css=".vc_custom_1485445319808{padding-top: 0px !important;}"][ra_icon_box template="filled" heading_size="icon-box-heading-sm" show_button="yes" i_type="fontawesome" shape_size="xsm" position="icon-box-inline" ib_style="btn-naked" ib_size="btn-xsm" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="250 Fields" i_icon_fontawesome="fa fa-graduation-cap" primary_color="#8d708e" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Lorem ipsum dolor sit amet, consect etura lumasa.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Maps Category
	//Corporate Map vc-template
	$data = array();
	$data['name'] = esc_html__( 'Map Greyscale with tooltip', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/maps/corporate01-maps.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes"][vc_column width="1/2" css=".vc_custom_1478599329676{background-image: url(http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/banner-bg7.png?id=28) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2"][ra_google_map style="ultraLight" map_marker="map-pin" content_style="contents-style4 alt" si_style="" zoom="14" address="Swinburne University of Technology, John Street, Hawthorn VIC, Australia" si_identities="%5B%7B%22network%22%3A%22facebook%22%7D%5D"]
[ra_icon icon="fa fa-phone" span=true] 232 788 27 90
[ra_icon icon="fa fa-envelope-o" span=true] info@boocar.com
[ra_icon icon="fa fa-map-marker" span=true] 5th Avenue, Manhattan
[/ra_google_map][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Map vc-template
	$data = array();
	$data['name'] = esc_html__( 'Map Circle with Tooltip', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/maps/main-maps.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_column_text]
<h4 class="h3 mb-35"><span style="color: #000000;">Send a message</span></h4>
[/vc_column_text][ra_cf7 style="s21" id="3052" btn=""][/vc_column][vc_column width="1/2"][vc_column_text]
<h4 class="h3 mb-35"><span style="color: #000000;">Send a message</span></h4>
[/vc_column_text][ra_google_map style="desaturated" map_marker="map-pin3" content_style="contents-style4" si_style="" zoom="14" map_height="380px" address="15 Cole Street Brighton VIC 3186, Australia" si_identities="%5B%7B%22network%22%3A%22facebook%22%7D%5D"]
<p style="text-align: center;"> 3rd Avenue, Upper East Side, San Francisco</p>

[/ra_google_map][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Map 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Map Pastel with image', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/maps/main-maps-2.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1490020160633{padding-bottom: 150px !important;}"][vc_column offset="vc_col-md-6"][ra_content_box style="s12" show_button="yes" ib_style="btn-solid" ib_shape="semi-round" ib_size="btn-lg" ib_text="text-uppercase" ib_others="wide" image="http://boo.themerella.com/wp-content/uploads/2016/12/cover-1.jpg" primary_color="#ffffff" ib_title="get to know our team" ib_link="url:%23|||" ib_hbg="#000000" ib_text_color="#000000" ib_htext_color="#ffffff"][/ra_content_box][/vc_column][vc_column offset="vc_col-md-6"][ra_google_map style="pastel" map_marker="html_marker" zoom="14" map_controls="fullscreenControl" map_height="487px" address="-37.925966,144.989729"][/ra_google_map][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Map 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Map Greyscale with marker', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/maps/main-maps-3.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1492112765563{margin-bottom: 75px !important;}"][vc_column][ra_google_map style="ultraLight" map_marker="map-pin2" si_style="" zoom="14" map_height="400px" address="15 Cole Street Brighton VIC 3186, Australia" si_identities="%5B%7B%22network%22%3A%22facebook%22%7D%5D"][/ra_google_map][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Map 4 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Map Blue with marker', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/maps/main-maps-4.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1480929260231{margin-top: -5.35714em !important;margin-bottom: 50px !important;}"][vc_column][ra_google_map style="flatPale" map_marker="map-pin" si_style="" zoom="14" map_height="450" address="15 Cole Street Brighton VIC 3186, Australia" si_identities="%5B%7B%22network%22%3A%22facebook%22%7D%5D"][/ra_google_map][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Restaurant Map vc-template
	$data = array();
	$data['name'] = esc_html__( 'Map Shadow box', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/maps/restaurant-maps.jpg' );
	$data['sort_name'] = 'Maps';
	$data['custom_class'] = 'general map';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces"][vc_column][ra_google_map style="fuse" content_style="contents-style3" si_style="" zoom="14" si_identities="%5B%7B%22network%22%3A%22behance%22%7D%5D" address="Swinburne University of Technology, John Street, Hawthorn VIC, Australia"]
<h3 class="weight-bold">Find Us</h3>
<strong>Phone:</strong> 1 800 987 654 321
<strong>Address:</strong> 5th Avenue, Manhattan
<strong>Hours:</strong> MON-FRI: 8AM - 9PM.
<a class="btn btn-underlined btn-sm" href="#">See Opening Hours</a>[/ra_google_map][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Misc

	//Address and form vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Address and form', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/address-and-form-misc.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504719918182{padding-bottom: 55px !important;background-image: url(http://four.classic.themerella.com/wp-content/uploads/sites/4/2017/08/contact-four.jpg?id=7857) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="contact"][vc_column width="5/6" offset="vc_col-md-offset-1 vc_col-sm-offset-1"][ra_section_title style="classic" title="Contact Us" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1504720828839{margin-top: 60px !important;margin-bottom: 40px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Call us" i_icon_fontawesome="fa fa-phone" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]1-234-567-890[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Mail us" i_icon_fontawesome="fa fa-envelope-o" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]info@boo.com[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Visit us" i_icon_fontawesome="fa fa-map-marker" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]5th Avenue, Manhattan[/ra_icon_box][/vc_column_inner][/vc_row_inner][ra_cf7 style="s10" id="2668" btn="full-width-submit"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Dark Contact misc vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Misc Dark Contact', 'boo' );
	$data['new'] = true;
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/dark-contact-misc.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504719918182{padding-bottom: 55px !important;background-image: url(http://four.classic.themerella.com/wp-content/uploads/sites/4/2017/08/contact-four.jpg?id=7857) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="contact"][vc_column width="5/6" offset="vc_col-md-offset-1 vc_col-sm-offset-1"][ra_section_title style="classic" title="Contact Us" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1504720828839{margin-top: 60px !important;margin-bottom: 40px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Call us" i_icon_fontawesome="fa fa-phone" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]1-234-567-890[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Mail us" i_icon_fontawesome="fa fa-envelope-o" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]info@boo.com[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Visit us" i_icon_fontawesome="fa fa-map-marker" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]5th Avenue, Manhattan[/ra_icon_box][/vc_column_inner][/vc_row_inner][ra_cf7 style="s10" id="2668" btn="full-width-submit"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/

	//Graphic misc vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Graphic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/graphic-misc.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1504719918182{padding-bottom: 55px !important;background-image: url(http://four.classic.themerella.com/wp-content/uploads/sites/4/2017/08/contact-four.jpg?id=7857) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="contact"][vc_column width="5/6" offset="vc_col-md-offset-1 vc_col-sm-offset-1"][ra_section_title style="classic" title="Contact Us" title_font_container="tag:h2|color:%23ffffff" title_use_theme_fonts="yes" content_font_container="tag:p|color:%23ffffff" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1504720828839{margin-top: 60px !important;margin-bottom: 40px !important;padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Call us" i_icon_fontawesome="fa fa-phone" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]1-234-567-890[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Mail us" i_icon_fontawesome="fa fa-envelope-o" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]info@boo.com[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_icon_box template="" heading_size="icon-box-heading-xsm" i_type="fontawesome" background_shape="circle" shape_size="lg" title="Visit us" i_icon_fontawesome="fa fa-map-marker" icon_background_color="#ffffff" icon_color="#ffffff" title_color="#ffffff" content_color="#ffffff" icon_bg="#e44e62" title_size="17px" content_size="17px"]5th Avenue, Manhattan[/ra_icon_box][/vc_column_inner][/vc_row_inner][ra_cf7 style="s10" id="2668" btn="full-width-submit"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lines misc vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Lines', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/lines-misc.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1504779400662{padding-top: 100px !important;padding-bottom: 40px !important;}" el_id="about"][vc_column][ra_section_title style="default" title="The Ultimate Package"]<strong>UNIQUE LAYOUTS</strong>[/ra_section_title][ra_line_guide image="http://mainone.landing.themerella.com/wp-content/uploads/sites/2/2017/09/layers.png" items="%5B%7B%22label%22%3A%2235%2B%20Demos%22%2C%22direction%22%3A%22left%20top%22%2C%22position%22%3A%22top%22%2C%22position_value%22%3A%2220px%22%7D%2C%7B%22label%22%3A%22%20SEO%20Optimized%22%2C%22direction%22%3A%22right%20top%22%2C%22position%22%3A%22top%22%2C%22position_value%22%3A%2220px%22%7D%2C%7B%22label%22%3A%22250%2B%20Elements%22%2C%22direction%22%3A%22left%20center%22%2C%22position%22%3A%22left%22%2C%22position_value%22%3A%22-30px%22%7D%2C%7B%22label%22%3A%22Live%20Builder%22%2C%22direction%22%3A%22right%20center%22%2C%22position%22%3A%22right%22%2C%22position_value%22%3A%2250px%22%7D%2C%7B%22label%22%3A%22Header%20Bulder%22%2C%22direction%22%3A%22left%20bottom%22%2C%22position%22%3A%22bottom%22%2C%22position_value%22%3A%2210px%22%7D%2C%7B%22label%22%3A%225%20Star%20Theme%22%2C%22direction%22%3A%22right%20bottom%22%2C%22position%22%3A%22bottom%22%2C%22position_value%22%3A%2210px%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Agency Timeline 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Timeline', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/agency-timeline-alt.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" svg_separator="yes" css=".vc_custom_1494596536783{margin-bottom: 80px !important;}" svg_color="#97decf" responsive_css="margin_bottom_mobile:50"][vc_column css=".vc_custom_1484837941219{margin-top: -5px !important;padding-top: 0px !important;}"][ra_history style="s1" title="2800 Projects Completed" year="2017" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/history1.jpg" color2="#35dec8" color1="#a5dd6c"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/ra_history][ra_history style="s1" title="2800 Projects Completed" year="2016" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/timeline02.png" color2="#86deaf" color1="#34dec8"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/ra_history][ra_history style="s1" title="2800 Projects Completed" year="2015" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/history3.jpg" color2="#ffcf79" color1="#86deaf"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/ra_history][ra_history style="s1" title="2800 Projects Completed" year="2014" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/history4.jpg" color2="#ffa179" color1="#ffd279"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.[/ra_history][/vc_column][vc_column width="5/6" offset="vc_col-sm-offset-1" css=".vc_custom_1497964251036{padding-top: 0px !important;}"][vc_single_image source="external_link" external_img_size="full" alignment="center" custom_src="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/mid.jpg"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Business Banner Laptop Carousel vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Laptop Carousel with Buttons', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/business08-banner-laptop-carousel.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1493390359256{padding-top: 50px !important;padding-bottom: 120px !important;background: #f3ece9 url(http://business-3.boo.themerella.com/wp-content/uploads/sites/21/2016/12/bg-bussiness.png?id=17) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column align="text-center"][vc_column_text css=".vc_custom_1493389200181{margin-bottom: 25px !important;}"]<span style="color: #ae9d95;">SKILLED PEOPLE</span>
<h2>our works</h2>
[/vc_column_text][/vc_column][vc_column css=".vc_custom_1493389079516{padding-top: 0px !important;}"][ra_carousel style="device" image=""][vc_single_image source="external_link" custom_src="http://classic.boo.themerella.com/wp-content/uploads/sites/4/2016/10/classic-device-slide.jpg"][vc_single_image source="external_link" custom_src="http://classic.boo.themerella.com/wp-content/uploads/sites/4/2016/10/classic-device-slide.jpg"][vc_single_image source="external_link" custom_src="http://classic.boo.themerella.com/wp-content/uploads/sites/4/2016/10/classic-device-slide.jpg"][vc_single_image source="external_link" custom_src="http://classic.boo.themerella.com/wp-content/uploads/sites/4/2016/10/classic-device-slide.jpg"][/ra_carousel][/vc_column][vc_column align="text-center" css=".vc_custom_1493389743947{padding-top: 0px !important;}"][vc_column_text]
<h3><strong>video production</strong></h3>
Lorem ipsum dolor sit amet, consectetur adipisicin elit, sed do eiusmod
tempor incididunt ut labore et dolore mana aliqua.[/vc_column_text][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][vc_row_inner css=".vc_custom_1493390414580{margin-top: 10px !important;}"][vc_column_inner offset="vc_col-md-6"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="Exclusive Sliders, Shortcodes and Plugins." i_icon_fontawesome="fa fa-check" icon_bg="#baada5" title_color="#1d3d5c" icon_fs="17px" css=".vc_custom_1493389936148{margin-bottom: 15px !important;}"][/ra_icon_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="Exclusive Sliders, Shortcodes and Plugins." i_icon_fontawesome="fa fa-check" icon_bg="#baada5" title_color="#1d3d5c" icon_fs="17px" css=".vc_custom_1493390247468{margin-bottom: 15px !important;}"][/ra_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_hidden-sm vc_hidden-xs"][vc_separator color="custom" accent_color="rgba(0,0,0,0.1)" css=".vc_custom_1493390324048{margin-bottom: 20px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_hidden-sm vc_hidden-xs"][vc_separator color="custom" accent_color="rgba(0,0,0,0.1)" css=".vc_custom_1493390329823{margin-bottom: 20px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="Exclusive Sliders, Shortcodes and Plugins." i_icon_fontawesome="fa fa-check" icon_bg="#baada5" title_color="#1d3d5c" icon_fs="17px" css=".vc_custom_1493391884237{margin-bottom: 20px !important;}"][/ra_icon_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="Exclusive Sliders, Shortcodes and Plugins." i_icon_fontawesome="fa fa-check" icon_bg="#baada5" title_color="#1d3d5c" icon_fs="17px" css=".vc_custom_1493389858348{margin-bottom: 20px !important;padding-bottom: 15px !important;}"][/ra_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Filter vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Misc Filter', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/car-dealer-filter.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_message color="alert-info" style="rounded"]I am message box. Click edit button to change this text.[/vc_message][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/

	//Cloud Domain Input vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Misc Domain', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/cloud-domain-input.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_message color="alert-info" style="rounded"]I am message box. Click edit button to change this text.[/vc_message][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/

	//Corporate Graph vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Graph', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/corporate02-graph.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479470343240{padding-top: 15px !important;padding-bottom: 90px !important;background-color: #f7f7f7 !important;}"][vc_column offset="vc_col-md-6"][vc_custom_heading text="Increase your
sales." use_theme_fonts="yes" css=".vc_custom_1485863448066{margin-bottom: 20px !important;}"][vc_column_text css=".vc_custom_1485863457743{margin-bottom: 35px !important;}"]Lorem ipsum dolor sit amet, adipiscing elit. Duis consectetur
auctor elit vehicula onec conse tetur.[/vc_column_text][ra_button style="btn-solid" shape="round" size="btn-sm" text="text-uppercase" i_type="fontawesome" i_align="right" title="Learn More" i_icon_fontawesome="fa fa-angle-right" primary_color="#f2774b" text_color="#ffffff" htext_color="#ffffff" fw="bold"][/vc_column][vc_column offset="vc_col-md-6"][vc_custom_heading text="`{`ra_icon icon=``fa fa-line-chart```}` sales comparison" font_container="tag:h5|text_align:left|color:%233b3e79" use_theme_fonts="yes"][vc_line_chart type="line" style="modern" x_values="JAN; FEB; MAR; APR; MAY; JUN" values="%5B%7B%22title%22%3A%22Boo%20Business%22%2C%22y_values%22%3A%2227%3B%2022%3B%2028%3B%2037%3B%2035%3B%2039%3B%2020%3B%2046%3B%2035%3B%2044%22%2C%22color%22%3A%22blue%22%7D%2C%7B%22title%22%3A%22Others%22%2C%22y_values%22%3A%2215%3B%2016%3B%2015%3B%2021%3B%2018%3B%2022%3B%2015%3B%2023%3B%2028%3B%2027%22%2C%22color%22%3A%22pink%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Graph 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Graph 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/corporate03-graph.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1493127629734{padding-top: 20px !important;padding-bottom: 90px !important;background-color: #f7f7f7 !important;}"][vc_column width="1/2"][vc_custom_heading text="Increase your sales
today." font_container="tag:h2|text_align:left|color:%23000000" use_theme_fonts="yes" css=".vc_custom_1487411281142{margin-top: 20px !important;margin-bottom: 25px !important;}"][vc_column_text css=".vc_custom_1487411889420{margin-bottom: 30px !important;}"]Lorem ipsum dolor sit amet, adipiscing elit. Duis consectetur
auctor elit vehicula onec conse tetur.[/vc_column_text][ra_button style="btn-solid" shape="circle" size="btn-md" text="text-uppercase" i_type="fontawesome" i_align="right" title="Learn More" i_icon_fontawesome="fa fa-angle-right" primary_color="#088ace" text_color="#ffffff" i_ml="15px" fw="600" fs="13px" ls="0.15em"][/vc_column][vc_column width="1/2"][ra_icon_box template="" i_type="fontawesome" position="icon-box-side" valignment="icon-middle" title="Sales Comparison" icon_color="#088ace" icon_fs="30px" title_size="23px" i_icon_fontawesome="fa fa-bar-chart"][/ra_icon_box][vc_line_chart type="line" style="custom" x_values="JAN; FEB; MAR; APR; MAY; JUN" values="%5B%7B%22title%22%3A%22Boo%20Business%22%2C%22y_values%22%3A%2228%3B32%3B29%3B36%3B34%3B39%22%2C%22color%22%3A%22blue%22%2C%22custom_color%22%3A%22%232095d3%22%7D%2C%7B%22title%22%3A%22Others%22%2C%22y_values%22%3A%2215%3B13%3B22%3B18%3B23%3B16%22%2C%22color%22%3A%22pink%22%2C%22custom_color%22%3A%22%233b3e79%22%7D%5D" animation="easeinOutQuint"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Blue Input vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Misc Domain 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/hostingblue-domain-input.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_message color="alert-info" style="rounded"]I am message box. Click edit button to change this text.[/vc_message][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/

	//Main Carousel vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Infinite Scrolling', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/main-banner.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" bg_position="center center" gradient_bg="yes" css=".vc_custom_1493674661980{padding-top: 30px !important;padding-bottom: 60px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/03/showcase-bg.png?id=4240) !important;}" gradient_bg_color="linear-gradient(138deg,rgb(240, 240, 240) 0%,rgb(255, 255, 255) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column css_animation="none" css=".vc_custom_1493660321552{margin-top: -30px !important;}"][ra_carousel style="s5" columns="col-one-fifth col-sm-6 col-xs-12" contain="yes" groupcells="no" autoplay="yes" freescroll="yes" wraparound="yes" random_v_offset="yes" swipe_hint="yes" autoplaytime="2500"][ra_box_rounded title="ATTRACTIVE EFFECTS" image="http://boo.themerella.com/wp-content/uploads/2017/03/carousel-3.png" tooltip="Mobile"][ra_box_rounded title="25+ HEADERS" image="http://boo.themerella.com/wp-content/uploads/2017/03/carousel-4.png" tooltip="Restaurant"][ra_box_rounded title="attract?ve banners" image="http://boo.themerella.com/wp-content/uploads/2017/03/carousel-8.jpg" tooltip="car dealer"][ra_box_rounded title="25+ HEADERS" tooltip="Restaurant" image="http://boo.themerella.com/wp-content/uploads/2017/03/showcase-4.png"][ra_box_rounded title="WOOCOMMERCE SUPPORT" image="http://boo.themerella.com/wp-content/uploads/2017/03/showcase-2.png" tooltip="shop"][ra_box_rounded title="WOOCOMMERCE SUPPORT" image="http://boo.themerella.com/wp-content/uploads/2017/03/carousel-2.png" tooltip="shop"][ra_box_rounded title="attract?ve banners" image="http://boo.themerella.com/wp-content/uploads/2017/03/carousel-8.jpg" tooltip="car dealer"][ra_box_rounded image="http://boo.themerella.com/wp-content/uploads/2017/03/showcase-4.png" title="25+ HEADERS" tooltip="Restaurant"][ra_box_rounded title="prem?um plug?ns" image="http://boo.themerella.com/wp-content/uploads/2017/03/showcase-5.png" tooltip="Law"][ra_box_rounded title="attract?ve banners" image="http://boo.themerella.com/wp-content/uploads/2017/03/carousel-56png.png" tooltip="car dealer"][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Lightbox vc-template
	$data = array();
	$data['name'] = esc_html__( 'Misc Lightbox with Accordion', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/main-lightbox.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1497964968162{padding-top: 50px !important;padding-bottom: 225px !important;}" responsive_css="padding_top_tablet:30|padding_bottom_tablet:60|padding_top_mobile:25|padding_right_mobile:10|padding_bottom_mobile:40|padding_left_mobile:10"][vc_column parallax="yes" parallax_preset="custom" enable_responsive_options="yes" offset="vc_col-md-6" parallax_from="``y``:150" parallax_time="1.2" parallax_duration="1080" responsive_css="margin_bottom_tablet:30|margin_bottom_mobile:30"][vc_column_text fill="yes" tag="h6" css=".vc_custom_1490208954750{margin-bottom: 42px !important;}"] <h6>No coding skills required to create unique sites. Customize your site in real-time and see the results instantly.</h6> [/vc_column_text][ra_lightbox lightbox_type="video" image="http://boo.themerella.com/wp-content/uploads/2017/03/lightbox-main-final-2.jpg" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWVPRkcczXCY|||"][/vc_column][vc_column parallax="yes" parallax_preset="custom" enable_responsive_options="yes" offset="vc_col-md-offset-1 vc_col-md-4" parallax_from="``y``:250" parallax_time="1.2" parallax_duration="1080" responsive_css="padding_top_tablet:50|padding_top_mobile:50"][ra_section_title style="resolve" title="Build your entire site in minutes" alignment="align-left" effect="resolving_effect" seperator="words" use_resolve_effect="yes" css=".vc_custom_1491900733948{margin-bottom: 20px !important;}"][/ra_section_title][vc_accordion style="underline" alignment="accordion-right" show_icon=""][vc_accordion_tab title="CREATIVE APPROACH TO MULTI-PURPOSE"][vc_column_text]Our team discussed every single detail to make sure Boo is the most versatile and unique theme created so far.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="CODING KNOWLEDGE NOT REQUIRED"][vc_column_text]No coding skills required to create unique sites. Customize your site in real-time and see the results instantly.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="PREMIUM LOOK AND FEEL"][vc_column_text]Extreme attention to detail is the essence of Boo?s unique design.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="OUTSTANDING PORTFOLIO FEATURES"][vc_column_text]From unique layouts to customizable hover effects, Boo offers the most advanced portfolio on the market.[/vc_column_text][/vc_accordion_tab][/vc_accordion][vc_row_inner][vc_column_inner css=".vc_custom_1496402535983{padding-top: 20px !important;}" align="text-sm-center text-xs-center"][ra_button style="btn-default" shape="round" text="text-uppercase" i_type="fontawesome" enable_gradient="yes" enable_hover_gradient="yes" title="See how it works" i_icon_fontawesome="fa fa-play" i_color="#ffffff" i_size="11px" i_mr="15px" gradient_color="linear-gradient(137deg,rgb(244, 41, 89) 0%,rgb(232, 66, 39) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" hbg_gradient="linear-gradient(137deg,rgb(232, 66, 39) 0%,rgb(232, 66, 39) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" htext_color="#ffffff" text_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Slider vc-template
	$data = array();
	$data['name'] = esc_html__( 'Main Slider', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/main-slider.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_section section_type="scrollable" full_width="stretch_row" css=".vc_custom_1496409471573{padding-top: 0px !important;padding-bottom: 0px !important;background-color: #f7f7f7 !important;}"][vc_row full_width="stretch_row" enable_responsive_options="yes" row_overflow="yes" el_class="fade active in" responsive_css="margin_top_tablet:0|margin_bottom_tablet:0|padding_top_tablet:0|padding_bottom_tablet:0|margin_top_mobile:0|margin_bottom_mobile:0|padding_top_mobile:0|padding_right_mobile:0|padding_bottom_mobile:0|padding_left_mobile:0" css=".vc_custom_1497015975173{padding-top: 90px !important;padding-bottom: 90px !important;}"][vc_column enable_responsive_options="yes" offset="vc_col-md-5 vc_hidden-sm vc_hidden-xs" css=".vc_custom_1496402203555{margin-bottom: 43px !important;padding-top: 30px !important;}" responsive_css="margin_bottom_tablet:0|margin_bottom_mobile:0"][ra_section_title style="resolve" title="Stunning `{`ra_typed words=Portfolios|Blogs|Shops`}`" alignment="align-left" content_font_container="tag:p" content_use_theme_fonts="yes" use_custom_fonts_content="true" use_fillin_effect="yes" css=".vc_custom_1493661822251{margin-bottom: 20px !important;padding-right: 50px !important;}"]Something you haven't seen before. Explore the most advanced portfolio on the market.[/ra_section_title][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="Unique Concepts" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1493730220701{margin-bottom: 25px !important;}" i_icon_linea="icon-basic_watch" shape_custom="70px"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="Fully Customizable Layouts" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1494589758899{margin-bottom: 25px !important;}" shape_custom="70px" i_icon_linea="icon-basic_gear"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="13+ Pre Defined Hovers" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1494589782742{margin-bottom: 35px !important;}" shape_custom="70px" i_icon_linea="icon-linear-star-half"][/ra_icon_box][ra_button style="btn-solid" shape="round" size="btn-xxxlg" text="text-uppercase" i_type="fontawesome" i_align="right" enable_gradient="yes" enable_hover_gradient="yes" title="Explore Portfolio" link="url:%23|||" i_icon_fontawesome="fa fa-long-arrow-right" i_color="#ffffff" i_ml="12px" gradient_color="linear-gradient(137deg,rgb(244, 41, 89) 0%,rgb(232, 66, 39) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" hbg_gradient="linear-gradient(137deg,rgb(232, 66, 39) 0%,rgb(244, 41, 89) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" text_color="#ffffff"][/vc_column][vc_column offset="vc_col-md-7 vc_hidden-sm vc_hidden-xs"][ra_d_slider images="5386,5397,4177"][/vc_column][/vc_row][vc_row full_width="stretch_row" enable_responsive_options="yes" row_overflow="yes" el_class="fade" responsive_css="margin_bottom_tablet:0|padding_top_tablet:0|padding_bottom_tablet:0|margin_bottom_mobile:0|padding_top_mobile:0|padding_right_mobile:0|padding_bottom_mobile:0|padding_left_mobile:0" css=".vc_custom_1496403269767{padding-top: 90px !important;padding-bottom: 90px !important;}"][vc_column enable_responsive_options="yes" offset="vc_col-md-5 vc_hidden-sm vc_hidden-xs" css=".vc_custom_1496401700506{margin-bottom: 43px !important;}" responsive_css="margin_bottom_tablet:50|margin_bottom_mobile:50"][ra_section_title style="resolve" title="Stunning `{`ra_typed words=Portfolios|Blogs|Shops`}`" alignment="align-left" content_font_container="tag:h6" content_use_theme_fonts="yes" use_custom_fonts_content="true" use_resolve_effect="yes" resolve_effect_tag="h6" css=".vc_custom_1490279317665{padding-right: 20px !important;}"]Lorem ipsum dolor sisamet, consatetur adipisicing elasesa, consa ncidut laboresa dolore euismod.[/ra_section_title][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="Unique Concepts" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1493730220701{margin-bottom: 25px !important;}" i_icon_linea="icon-basic_watch" shape_custom="70px"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="Fully Customizable Layouts" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1494589758899{margin-bottom: 25px !important;}" shape_custom="70px" i_icon_linea="icon-basic_gear"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="13+ Pre Defined Hovers" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1494589782742{margin-bottom: 35px !important;}" shape_custom="70px" i_icon_linea="icon-linear-star-half"][/ra_icon_box][ra_button style="btn-solid" shape="round" size="btn-xxxlg" text="text-uppercase" i_type="fontawesome" i_align="right" enable_gradient="yes" enable_hover_gradient="yes" title="Explore Blog" link="url:%23|||" i_icon_fontawesome="fa fa-long-arrow-right" i_color="#ffffff" i_ml="12px" gradient_color="linear-gradient(137deg,rgb(244, 41, 89) 0%,rgb(232, 66, 39) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" text_color="#ffffff" hbg_gradient="linear-gradient(137deg,rgb(232, 66, 39) 0%,rgb(244, 41, 89) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][/vc_column][vc_column offset="vc_col-md-7 vc_hidden-sm vc_hidden-xs"][ra_d_slider images="5386,5397,4177"][/vc_column][/vc_row][vc_row full_width="stretch_row" enable_responsive_options="yes" row_overflow="yes" el_class="fade" css=".vc_custom_1496403318501{padding-top: 90px !important;padding-bottom: 90px !important;}" responsive_css="margin_bottom_tablet:0|padding_top_tablet:0|padding_bottom_tablet:0|margin_bottom_mobile:0|padding_top_mobile:0|padding_bottom_mobile:0"][vc_column offset="vc_col-md-5 vc_hidden-sm vc_hidden-xs" css=".vc_custom_1496401710374{margin-bottom: 43px !important;}"][ra_section_title style="resolve" title="Stunning Shop" alignment="align-left" content_font_container="tag:p" content_use_theme_fonts="yes" use_custom_fonts_content="true" use_resolve_effect="yes" css=".vc_custom_1490018325933{margin-bottom: 20px !important;}"]Lorem ipsum dolor sisamet, consatetur adipisicing eiusmod tempor incididunt ut labore.[/ra_section_title][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="Unique Concepts" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1493730220701{margin-bottom: 25px !important;}" i_icon_linea="icon-basic_watch" shape_custom="70px"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="Fully Customizable Layouts" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1494589758899{margin-bottom: 25px !important;}" shape_custom="70px" i_icon_linea="icon-basic_gear"][/ra_icon_box][ra_icon_box template="shadowed" heading_size="icon-box-heading-sm2" heading_weight="weight-normal" i_type="linea" background_shape="circle" shape_size="custom" position="icon-box-inline" title="13+ Pre Defined Hovers" icon_color="#aaaaaa" h_icon_color="#000000" icon_bg="#ffffff" css=".vc_custom_1494589782742{margin-bottom: 35px !important;}" shape_custom="70px" i_icon_linea="icon-linear-star-half"][/ra_icon_box][ra_button style="btn-solid" shape="round" size="btn-xxxlg" text="text-uppercase" i_type="fontawesome" i_align="right" enable_gradient="yes" enable_hover_gradient="yes" title="Explore Shop" link="url:%23|||" i_icon_fontawesome="fa fa-long-arrow-right" i_color="#ffffff" i_ml="12px" gradient_color="linear-gradient(137deg,rgb(244, 41, 89) 0%,rgb(232, 66, 39) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" hbg_gradient="linear-gradient(137deg,rgb(232, 66, 39) 0%,rgb(244, 41, 89) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" text_color="#ffffff"][/vc_column][vc_column offset="vc_col-md-7 vc_hidden-sm vc_hidden-xs"][ra_d_slider images="5386,5397,4177"][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Portfolio Lightbox vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio Lightbox with Accordion', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/pf05-lightbox.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1499249131063{margin-bottom: 110px !important;border-top-width: 75px !important;background-color: #000000 !important;}"][vc_column width="2/3"][ra_lightbox lightbox_type="video" image="http://portfolio05.boo.themerella.com/wp-content/uploads/sites/25/2017/03/lightboxpf05.jpg" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWVPRkcczXCY|||"][/vc_column][vc_column width="1/3" css=".vc_custom_1489785861694{margin-top: 80px !important;margin-left: 12px !important;padding-right: 50px !important;}"][vc_column_text css=".vc_custom_1489856743158{border-left-width: 100px !important;}"] <h6><strong>Digital Innovation</strong></h6> <span style="color: #a9a9b4;">Improve him believe opinion offered met and end cheered forbade. Friendly as stronger speedily by recurred. Son interest wandered sir addition. </span> [/vc_column_text][vc_column_text css=".vc_custom_1489856733259{border-left-width: 100px !important;}"] <h6><strong>Brand Communication</strong></h6> <span style="color: #a9a9b4;">Resolved to in believed desirous unpacked weddings together. Nor off for enjoyed cousins herself. Little our played lively she adieus far sussex company.</span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Portfolio Blur vc-template
	$data = array();
	$data['name'] = esc_html__( 'Portfolio Blur', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/portfolio-blur.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1499248959704{margin-top: 125px !important;background-color: #000000 !important;}"][vc_column width="2/3" css=".vc_custom_1497452742527{margin-bottom: 70px !important;}" offset="vc_col-md-offset-2"][vc_custom_heading text="WORKS" font_container="tag:h6|font_size:16px|text_align:center|color:%2346dfb4" use_theme_fonts="yes" letter_spacing="0.3em" css=".vc_custom_1497375354448{margin-bottom: 35px !important;}"][vc_custom_heading text="Endeavor bachelor but add eat pleasure doubtful sociable. Age forming covered you entered the examine. " font_container="tag:h4|font_size:26px|text_align:center|color:%23ffffff|line_height:1.333em" use_theme_fonts="yes"][/vc_column][/vc_row][vc_row css=".vc_custom_1497375826197{margin-bottom: 100px !important;}"][vc_column][ra_portfolio_listing style="grid" item_style="hover-blur" grid_columns="2" columns_gap="20" post_type="rella-portfolio" posts_per_page="4" show_summary="" show_like="" show_date="" show_link="" show_ext_link="" show_share="" enable_panr="true" enable_parallax="no" bg_type="solid" color_type="text-light" taxonomies="" color_primary="rgba(35,51,221,0.63)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Carousel Misc vc-template
	$data = array();
	$data['name'] = esc_html__( 'Carousel', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/misc/carousel-misc.jpg' );
	$data['sort_name'] = 'Misc';
	$data['custom_class'] = 'general misc';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1508952183766{padding-top: 100px !important;padding-bottom: 30px !important;background-color: #f1f1f1 !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ra_section_title style="resolve" title="300+ Templates" title_font_container="tag:h2|font_size:50px|color:%236f14f1|line_height:65px" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1508952409587{margin-bottom: 10px !important;}"]<span style="font-size: 20px; color: #7b8796; line-height: 40px;">We?ve made it ridiculously easy to add any content block and customize it with our Live Website Builder.</span>[/ra_section_title][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bg_position="center center" gradient_bg="yes" css=".vc_custom_1508952225222{padding-bottom: 60px !important;background-color: #f1f1f1 !important;}" gradient_bg_color="linear-gradient(138deg,rgb(240, 240, 240) 0%,rgb(255, 255, 255) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column css_animation="none" css=".vc_custom_1493660321552{margin-top: -30px !important;}"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12 no-padding no-margin" groupcells="no" autoplay="yes" freescroll="yes" wraparound="yes"][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/10/7@2x.jpeg"][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/10/3@2x.jpeg"][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/10/1@2x-1.jpeg"][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/10/2@2x.jpeg"][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/10/6@2x.jpeg"][vc_single_image source="external_link" external_img_size="full" custom_src="http://boolanding.themerella.com/wp-content/uploads/2017/10/4@2x.jpeg"][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Pricing Category
	//Agency Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Colorful', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/agency-pricing.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484836522100{padding-top: 35px !important;padding-bottom: 95px !important;background-color: #fafafa !important;}"][vc_column][ra_section_title style="classic" title="Pricing" css=".vc_custom_1484836434310{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s6" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_title="<strong>PURCHASE</strong>" title="des?gn" price="29" currency="$" primary_color="#fa3d3d" pt_link="url:%23||" pt_htext_color="#ffffff" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/pie-chart.svg"] <ul><li>PSD Included</li><li>Free Installation</li><li>Free One Year Domain</li><li>Free Six Months Hosting</li><li>Full Support</li></ul>[/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s6" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_title="<strong>PURCHASE</strong>" title="development" price="49" currency="$" primary_color="#0081d6" pt_link="url:%23||" pt_htext_color="#ffffff" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/browser.svg"] <ul><li>PSD Included</li><li>Free Installation</li><li>Free One Year Domain</li><li>Free Six Months Hosting</li><li>Full Support</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s6" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_title="<strong>PURCHASE</strong>" title="opt?m?zat?on" price="59" currency="$" primary_color="#47d2df" pt_link="url:%23||" pt_htext_color="#ffffff" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/computer-1-1.svg"] <ul><li>PSD Included</li><li>Free Installation</li><li>Free One Year Domain</li><li>Free Six Months Hosting</li><li>Full Support</li></ul>[/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s6" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_title="<strong>PURCHASE</strong>" title="all ?n one" price="79" currency="$" primary_color="#fcc20b" pt_link="url:%23||" pt_htext_color="#ffffff" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/diamond.svg"] <ul><li>PSD Included</li><li>Free Installation</li><li>Free One Year Domain</li><li>Free Six Months Hosting</li><li>Full Support</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Business Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Minimal with Checkmarks', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/business02-pricing-tables.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1493371889930{padding-top: 140px !important;padding-bottom: 120px !important;}"][vc_column css_animation="none" offset="vc_col-md-6"][vc_column_text css=".vc_custom_1493372282789{margin-right: 20% !important;margin-bottom: 42px !important;}"]
<h3>Perfect Solution.</h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiudunt ut labore et dolore magna aliqua.[/vc_column_text][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="Exclusive Support for premium members" i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#434348" icon_fs="17px" title_size="18px" css=".vc_custom_1493372197400{margin-bottom: 20px !important;border-bottom-width: 1px !important;padding-bottom: 15px !important;border-bottom-color: rgba(0,0,0,0.1) !important;border-bottom-style: solid !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="Weekly or Annual Reports " i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#434348" icon_fs="17px" title_size="18px" css=".vc_custom_1493372221605{margin-bottom: 20px !important;border-bottom-width: 1px !important;padding-bottom: 15px !important;border-bottom-color: rgba(0,0,0,0.1) !important;border-bottom-style: solid !important;}"][/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-sm" i_type="fontawesome" background_shape="square" shape_size="xsm" position="icon-box-inline" title="Special discounts and updates" i_icon_fontawesome="fa fa-check" icon_color="#ffffff" icon_bg="#434348" icon_fs="17px" title_size="18px" css=".vc_custom_1493372231182{margin-bottom: 30px !important;}"][/ra_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_price_table style="s20" pt_style="btn-default" pt_shape="round" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution One" description="/month" price="30" currency="$" pt_title="Apply Now" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_htext_color="#ffffff" primary_color="#d94747"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_price_table style="s20" pt_style="btn-default" pt_shape="round" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution Two" description="/month" price="80" currency="$" pt_title="Apply Now" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_htext_color="#ffffff" primary_color="#d94747"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Minimal', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/car-dealer-pricing-tables.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485526307584{padding-top: 158px !important;padding-bottom: 100px !important;}"][vc_column][ra_section_title style="underline6" title=" Finance"][/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3"][ra_price_table style="s10" pt_style="btn-default" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Basic" description="/month " price="500" currency="$" pt_title="Apply Now" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3"][ra_price_table style="s10" pt_style="btn-default" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Small" description="/month " price="600" currency="$" pt_title="Apply Now" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-3"][ra_price_table style="s10" pt_style="btn-default" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Medium" description="/month " price="800" currency="$" pt_title="Apply Now" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-3"][ra_price_table style="s10" pt_style="btn-default" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Premium" description="/month " price="900" currency="$" pt_title="Apply Now" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Cloud Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Gradient with Tabs', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/cloud-pricing-tables.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479385332285{padding-top: 45px !important;padding-bottom: 45px !important;}"][vc_column][ra_section_title style="big" title="Affordable Plans." title_font_container="tag:h2" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1479384481413{margin-bottom: 50px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
incididunt ut labore et dolore.aliqua.[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s13" pt_style="classic-date-featured" pt_shape="round" pt_size="btn-sm" pt_others="wide" pt_text="text-uppercase" title="Basic" description="/mo " price="20" currency="$" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>[ra_icon icon="fa fa-hdd-o"] 100 GB Disk Space</li><li>[ra_icon icon="fa fa-signal"] Unlimited Traffic</li><li>[ra_icon icon="fa fa-globe"] 2 Year Free Domains</li><li>[ra_icon icon="fa fa-database"] 500 MySQL Database</li><li>[ra_icon icon="fa fa-lock"] Free Privacy Protected</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s13" pt_style="" pt_shape="round" pt_size="btn-sm" pt_others="wide" pt_text="text-uppercase" title="Private" description="/mo " price="30" currency="$" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>[ra_icon icon="fa fa-hdd-o"] 100 GB Disk Space</li><li>[ra_icon icon="fa fa-signal"] Unlimited Traffic</li><li>[ra_icon icon="fa fa-globe"] 2 Year Free Domains</li><li>[ra_icon icon="fa fa-database"] 500 MySQL Database</li><li>[ra_icon icon="fa fa-lock"] Free Privacy Protected</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s13" featured="featured" pt_style="classic-date-featured" pt_shape="round" pt_size="btn-sm" pt_others="wide" pt_text="text-uppercase" title="Popular" description="/mo " price="30" currency="$" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>[ra_icon icon="fa fa-hdd-o"] 100 GB Disk Space</li><li>[ra_icon icon="fa fa-signal"] Unlimited Traffic</li><li>[ra_icon icon="fa fa-globe"] 2 Year Free Domains</li><li>[ra_icon icon="fa fa-database"] 500 MySQL Database</li><li>[ra_icon icon="fa fa-lock"] Free Privacy Protected</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s13" pt_style="" pt_shape="round" pt_size="btn-sm" pt_others="wide" pt_text="text-uppercase" title="Exclusive" description="/mo " price="50" currency="$" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>[ra_icon icon="fa fa-hdd-o"] 100 GB Disk Space</li><li>[ra_icon icon="fa fa-signal"] Unlimited Traffic</li><li>[ra_icon icon="fa fa-globe"] 2 Year Free Domains</li><li>[ra_icon icon="fa fa-database"] 500 MySQL Database</li><li>[ra_icon icon="fa fa-lock"] Free Privacy Protected</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Cloud Pricing 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Compare', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/cloud-pricint-table-2.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479389183461{padding-top: 110px !important;padding-bottom: 100px !important;}"][vc_column][ra_section_title style="big" title="Compare Plans." title_font_container="tag:h2" title_use_theme_fonts="yes" show_button="yes" ib_style="btn-naked" ib_i_type="fontawesome" ib_i_align="right" use_custom_fonts_title="true" ib_title="Pricing Tables" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#30c2f9" ib_i_size="16px" ib_i_ml="9px" ib_fs="20px" css=".vc_custom_1485510767859{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
incididunt ut labore et dolore.aliqua.[/ra_section_title][vc_row_inner equal_height="yes"][vc_column_inner width="1/4"][ra_price_table style="s14" feature_column="yes" pt_style="classic-date-featured" title="Features" image="http://cloud.boo.themerella.com/wp-content/uploads/sites/14/2016/11/server.png" primary_color="#dd9933"] <ul><li>Setup Fee</li><li>Multi Domain</li><li>Storage Space</li><li>Monthly Bandwidth</li><li>MySQL Databases</li><li>Sub Domains</li><li>EMail Accounts</li><li>Share 128bit SSL</li><li>Control Panel</li><li>24/7 Support</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/4"][ra_price_table style="s14" pt_style="" pt_shape="round" pt_size="btn-sm" pt_others="wide" pt_text="text-uppercase" pt_i_align="right" title="Basic" description="per month" price="20" currency="$" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>Free</li><li>[ra_icon icon="fa fa-check"]</li><li>1 GB</li><li>Unlimited</li><li>5</li><li>2</li><li>25</li><li>[ra_icon icon="fa fa-check"]</li><li>[ra_icon icon="fa fa-times"]</li><li>[ra_icon icon="fa fa-times"]</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/4"][ra_price_table style="s14" pt_style="classic-date-featured" pt_shape="round" pt_size="btn-sm" pt_others="wide" pt_text="text-uppercase" pt_i_align="right" title="Private" description="per month" price="30" currency="$" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>Free</li><li>[ra_icon icon="fa fa-check"]</li><li>1 GB</li><li>Unlimited</li><li>5</li><li>2</li><li>25</li><li>[ra_icon icon="fa fa-check"]</li><li>[ra_icon icon="fa fa-times"]</li><li>[ra_icon icon="fa fa-times"]</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/4"][ra_price_table style="s14" pt_style="" pt_shape="round" pt_size="btn-sm" pt_others="wide" pt_text="text-uppercase" pt_i_align="right" title="Popular" description="per month" price="40" currency="$" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>Free</li><li>[ra_icon icon="fa fa-check"]</li><li>1 GB</li><li>Unlimited</li><li>5</li><li>2</li><li>25</li><li>[ra_icon icon="fa fa-check"]</li><li>[ra_icon icon="fa fa-times"]</li><li>[ra_icon icon="fa fa-times"]</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Corporate Pricing 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Featured with Phone', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/corporate02-pricing.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485865043300{padding-top: 125px !important;padding-bottom: 200px !important;}"][vc_column][ra_section_title style="thick2" title="pricing." description="`{`ra_icon icon=``fa fa-phone```}` Contact support team for team corporate pricing." css=".vc_custom_1479472423794{margin-bottom: 60px !important;}"] <hr /> [/ra_section_title][vc_row_inner][vc_column_inner width="1/3"][ra_price_table style="s12" pt_style="" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="basic" description="per month" price="19" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-long-arrow-right"] <ul><li>Limitless concepts</li><li>Free fonts</li><li>Creative Layouts</li><li>Free Support</li><li>Expert Reviews</li><li>Community access</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s12" featured="featured" pt_style="" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="popular" description="per month" price="29" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-long-arrow-right"] <ul><li>Limitless concepts</li><li>Free fonts</li><li>Creative Layouts</li><li>Free Support</li><li>Expert Reviews</li><li>Community access</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s12" pt_style="" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="premium" description="per month" price="89" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-long-arrow-right"] <ul><li>Limitless concepts</li><li>Free fonts</li><li>Creative Layouts</li><li>Free Support</li><li>Expert Reviews</li><li>Community access</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Pricing 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Minimal Rounded with Buttons', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/corporate03-pricing.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479486712568{padding-top: 100px !important;padding-bottom: 120px !important;}"][vc_column][ra_section_title style="thick3" title="Finance" title_font_container="tag:h2|color:%23000000" title_use_theme_fonts="yes" use_custom_fonts_title="true"] <hr /> [/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="circle" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Basic" description="/month " price="20" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_fw="600" pt_i_ml="15px"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="circle" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Small" description="/month " price="30" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_fw="600" pt_i_ml="15px"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="circle" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Popular" description="/month " price="50" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_i_ml="15px" pt_fw="600"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="circle" pt_size="btn-sm" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Premium" description="/month " price="60" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_i_ml="15px" pt_fw="600"] <ul><li><strong>Sales Price:</strong> $50.000</li><li><strong>Rate:</strong> 7%</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Elegant Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Featured with Phone 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/elegant-pricing.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1478875554166{padding-top: 30px !important;background-color: #fafafa !important;}"][vc_column][ra_section_title style="underline" title="Price" content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" use_resolve_effect="yes" resolve_effect_seperator="chars" description="`{`ra_icon icon=``fa fa-phone```}` Contact support team for team subscribe prices." css=".vc_custom_1489078164272{margin-bottom: 20px !important;}"]<span style="color: #bcb3c9;">STAY HEALTHY.</span>[/ra_section_title][vc_row_inner css=".vc_custom_1484068003664{padding-top: 60px !important;padding-bottom: 10px !important;}"][vc_column_inner offset="vc_col-md-4"][ra_price_table style="s5" pt_style="classic-date-featured" pt_shape="circle" pt_size="btn-lg" pt_others="wide" pt_text="text-uppercase" title="Basic" price="39" currency="$" pt_title="PURCHASE" pt_link="url:%23||" description="PER MONTH"] <ul><li>Limitless Concepts</li><li>Free Fonts</li><li>Creative Layouts</li><li>Free Support</li><li>Express Reviews</li><li>Community Access</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ra_price_table style="s5" featured="featured" pt_style="classic-date-featured" pt_shape="circle" pt_size="btn-lg" pt_others="wide" pt_text="text-uppercase" title="Popular" price="39" currency="$" pt_title="PURCHASE" pt_link="url:%23||" description="Per Month" pt_hbg="#8224e3" primary_color="#eeee22"] <ul><li>Limitless Concepts</li><li>Free Fonts</li><li>Creative Layouts</li><li>Free Support</li><li>Express Reviews</li><li>Community Access</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner offset="vc_col-md-4"][ra_price_table style="s5" pt_style="" pt_shape="circle" pt_size="btn-lg" pt_others="wide" pt_text="text-uppercase" title="Prem?um" price="39" currency="$" pt_title="PURCHASE" pt_link="url:%23||" description="Per Month" pt_text_color="#0a0a0a"] <ul><li>Limitless Concepts</li><li>Free Fonts</li><li>Creative Layouts</li><li>Free Support</li><li>Express Reviews</li><li>Community Access</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Hosting Blue Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing with Image', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/hostingblue-pricing.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1489563869702{margin-bottom: 30px !important;padding-top: 80px !important;}"][vc_column][ra_section_title style="classic2" title="Affordable Pricing" title_font_container="tag:h2" title_google_fonts="font_family:Poppins%3Aregular|font_style:400%20regular%3A400%3Anormal" title_css_animation="fadeInUp" use_custom_fonts_title="true" css=".vc_custom_1489562610234{margin-bottom: 60px !important;}" description="Far far away behind the word mountains,far from the countries Vokalia and Consonantia"]KNOW THIS FIRST[/ra_section_title][ra_tabs style="s7"][ra_tab_section title="Hosting"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Basic" description="per month" price="39" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/server.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Classic" description="per month" price="59" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_bc="#8224e3" pt_hbg="#b51c78" pt_hbc="#22b71d" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/database.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Popular" description="per month" price="69" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/server-1.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Premium" description="per month" price="79" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/database-2.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Servers"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Basic" description="per month" price="39" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/server.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Classic" description="per month" price="59" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/database.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Popular" description="per month" price="69" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/server-1.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Premium" description="per month" price="79" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/database-2.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Domains"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Basic" description="per month" price="39" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/server.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li> <li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Classic" description="per month" price="59" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/database.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Popular" description="per month" price="69" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/server-1.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s17" pt_style="" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_others="wide" title="Premium" description="per month" price="79" currency="$" pt_title="Purchase" pt_link="url:%23|||" image="http://hosting-blue.boo.themerella.com/wp-content/uploads/sites/7/2016/10/database-2.svg"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>500 MySQL Database</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>Free Plans</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Main Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Simple', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/main2-pricing.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ra_section_title style="default" title="Simple Plans " css=".vc_custom_1490515780084{margin-bottom: 50px !important;}"]OUR PROCESS[/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1490783274384{margin-bottom: 100px !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1478874505370{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_price_table style="s19" pt_style="btn-solid" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_title="Buy Now" title="Classic" price="10" currency="$" primary_color="#ff473d" description="/month" pt_text_color="#ffffff" el_class="child-first"] <ul><li>Express Support</li><li>Hosting</li><li>Support</li><li>Font Collection</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1478874512874{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_price_table style="s19" pt_style="btn-solid" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_title="Buy Now" title="Popular" price="30" currency="$" primary_color="#ff473d" description="/month" pt_text_color="#ffffff"] <ul><li>Express Support</li><li>Hosting</li><li>Support</li><li>Font Collection</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1478874520456{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_price_table style="s19" pt_style="btn-solid" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_title="Buy Now" title="Premium" price="80" currency="$" primary_color="#ff473d" description="/month" pt_text_color="#ffffff" el_class="child-last"] <ul><li>Express Support</li><li>Hosting</li><li>Support</li><li>Font Collection</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Mobile Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Badge', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/mobile-pricing.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484136535547{padding-top: 70px !important;padding-bottom: 110px !important;}"][vc_column][ra_section_title style="classic6" title="Pricing" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" class="``btn" ib_title="Use A Coupon" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"][/ra_section_title][vc_row_inner css=".vc_custom_1479219624257{margin-top: 60px !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s9" pt_style="" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" title="Free" description=" USD Per Month " price="0." pt_title="Purchase" pt_link="url:%23|||"] <ul><li>10 registered users</li><li>5 projects</li><li>2 GB Traffic</li><li>Free Support</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s9" pt_style="btn-default" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" title="Business" description=" USD Per Month " price="29" pt_title="Purchase" pt_link="url:%23|||" primary_color="#1e73be"] <ul><li>10 registered users</li><li>5 projects</li><li>2 GB Traffic</li><li>Free Support</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s9" featured="featured" pt_style="" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" title="Business" description=" USD Per Month " price="39" pt_title="Purchase" pt_link="url:%23|||" ribbon="Popular"] <ul><li>10 registered users</li><li>5 projects</li><li>2 GB Traffic</li><li>Free Support</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s9" pt_style="" pt_shape="round" pt_size="btn-sm" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" title="Advanced" description=" USD Per Month " price="49" pt_title="Purchase" pt_link="url:%23|||"] <ul><li>10 registered users</li><li>5 projects</li><li>2 GB Traffic</li><li>Free Support</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	
	
	//Restaurant Menu Pricing vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing Menu list with image', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/restaurant-menu.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1485162222735{padding-top: 85px !important;padding-bottom: 150px !important;}"][vc_column css=".vc_custom_1485162309187{padding-top: 0px !important;padding-right: 30px !important;border-radius: 1px !important;}" offset="vc_col-md-6"][ra_restaurant_menu title="Desserts" items="%5B%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%5D"][/vc_column][vc_column width="1/2" css=".vc_custom_1485162299586{background-image: url(http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/restaurant-menu.jpg?id=9) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Restaurant Menu Pricing 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Pricing menu list', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/pricing/restaurant-menu-2.jpg' );
	$data['sort_name'] = 'Pricing';
	$data['custom_class'] = 'general pricing';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485163251511{padding-top: 50px !important;padding-bottom: 150px !important;}"][vc_column width="1/2" css=".vc_custom_1477388400959{margin-left: 1px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_restaurant_menu title="Starters" items="%5B%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%5D"][/vc_column][vc_column width="1/2" css=".vc_custom_1477388409519{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ra_restaurant_menu title="Dinner" items="%5B%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%2C%7B%22item_title%22%3A%22Fried%20Mushroom%20Chicken%22%2C%22price%22%3A%2223%22%2C%22description%22%3A%22Potato%2C%20%20Chicken%2C%20%20Olive%20oil%2C%20%20Salt%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	
	
	//Services Category
	//Cards Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Cards', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/cards-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" row_overflow="yes"][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="center" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" enable_reverse="no" css=".vc_custom_1503429454024{padding-top: 55px !important;padding-right: 13% !important;padding-bottom: 25px !important;padding-left: 18% !important;background-color: #ebf3f4 !important;}" offset="vc_col-md-3" translate_from_x="0" rotate_from_y="0" parallax_trigger_number="0.9" parallax_duration="0%" translate_from_y="35" rotate_from_x="-45"][vc_custom_heading text="01. ABOUT US" font_container="tag:h6|font_size:14px|text_align:left|color:%23000000|line_height:1.571em" use_theme_fonts="yes" letter_spacing="0.015em" css=".vc_custom_1503325195613{margin-bottom: 1.5em !important;}"][vc_column_text]<span style="color: #747e80; font-size: 19px;">Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or</span>[/vc_column_text][/vc_column][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="center" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" enable_reverse="no" css=".vc_custom_1503495947972{padding-top: 55px !important;padding-right: 13% !important;padding-bottom: 25px !important;padding-left: 18% !important;background-color: #242a2f !important;}" offset="vc_col-md-3" translate_from_x="0" rotate_from_y="0" to_delay="0.15" parallax_trigger_number="0.9" parallax_duration="0%" translate_from_y="35" rotate_from_x="-45"][vc_custom_heading text="02. CULTURE" font_container="tag:h6|font_size:14px|text_align:left|color:%23ffffff|line_height:1.571em" use_theme_fonts="yes" letter_spacing="0.015em" css=".vc_custom_1503325202471{margin-bottom: 1.5em !important;}"][vc_column_text]<span style="color: #747e80; font-size: 19px;">Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or</span>[/vc_column_text][/vc_column][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="center" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" enable_reverse="no" css=".vc_custom_1503495955463{padding-top: 55px !important;padding-right: 13% !important;padding-bottom: 25px !important;padding-left: 18% !important;background-color: #212121 !important;}" offset="vc_col-md-3" rotate_from_y="1" to_delay="0.3" parallax_trigger_number="0.9" parallax_duration="0%" translate_from_y="35" rotate_from_x="-45"][vc_custom_heading text="03. CASE STUDIES" font_container="tag:h6|font_size:14px|text_align:left|color:%23ffffff|line_height:1.571em" use_theme_fonts="yes" letter_spacing="0.015em" css=".vc_custom_1503325209667{margin-bottom: 1.5em !important;}"][vc_column_text]<span style="color: #747e80; font-size: 19px;">Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or</span>[/vc_column_text][/vc_column][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="center" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" enable_reverse="no" css=".vc_custom_1503500806547{padding-top: 55px !important;padding-right: 13% !important;padding-bottom: 25px !important;padding-left: 18% !important;background-color: #242d2f !important;}" offset="vc_col-md-3" rotate_from_y="0" to_delay="0.45" parallax_trigger_number="0.9" parallax_duration="0%" translate_from_y="35" rotate_from_x="-45"][vc_custom_heading text="04. TEAM" font_container="tag:h6|font_size:14px|text_align:left|color:%23ffffff|line_height:1.571em" use_theme_fonts="yes" letter_spacing="0.015em" css=".vc_custom_1503325220851{margin-bottom: 1.5em !important;}"][vc_column_text]<span style="color: #747e80; font-size: 19px;">Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or</span>[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content" enable_responsive_options="yes" css=".vc_custom_1503509006913{padding-top: 35px !important;padding-right: 18px !important;padding-bottom: 15px !important;padding-left: 18px !important;}" responsive_css="padding_top_tablet:15|padding_right_tablet:15|padding_bottom_tablet:15|padding_left_tablet:15|padding_top_mobile:0|padding_right_mobile:0|padding_bottom_mobile:0|padding_left_mobile:0"][vc_column][vc_column_text][rev_slider alias="modern-four"][/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Cards Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Casual', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/casual-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1503483755827{padding-top: 75px !important;padding-bottom: 145px !important;}" responsive_css="padding_top_tablet:50|padding_bottom_tablet:100|padding_top_mobile:25|padding_bottom_mobile:50"][vc_column width="2/3" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-2"][ra_section_title style="default" title="Case Studies." title_font_container="tag:h2|font_size:55px|line_height:1.5em" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1503496658375{margin-bottom: 10px !important;}"][/ra_section_title][/vc_column][vc_column width="1/3"][ra_content_box style="s10" show_button="yes" ib_style="btn-naked" ib_lightbox="yes" ib_lightbox_type="video" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Videos" image="http://four.modern.themerella.com/wp-content/uploads/sites/9/2017/08/c1-1.jpg" ib_title="Watch The Trailer" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_i_color="#ffffff" title_size="17px" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||"][/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s10" show_button="yes" ib_style="btn-naked" ib_lightbox="yes" ib_lightbox_type="video" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Photography" image="http://four.modern.themerella.com/wp-content/uploads/sites/9/2017/08/c2-1.jpg" ib_title="Watch The Trailer" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_i_color="#ffffff" title_size="17px" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||"][/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s10" show_button="yes" ib_style="btn-naked" ib_lightbox="yes" ib_lightbox_type="video" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Art Direction" image="http://four.modern.themerella.com/wp-content/uploads/sites/9/2017/08/c3-1.jpg" ib_title="Watch The Trailer" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_i_color="#ffffff" title_size="17px" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||"][/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Centered Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Centered', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/centered-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1502559519254{padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column][/vc_column][vc_column width="1/3"][ra_featured_box style="s2" title="Panoramic View" price="$3800" image="http://boo.themerella.com/wp-content/uploads/2017/04/inner-5.jpg" fb_atts="%5B%7B%22fb_label%22%3A%22Built%20in%202008%2C%22%7D%2C%7B%22fb_label%22%3A%22Residential%2C%22%7D%2C%7B%22fb_label%22%3A%224%20Bedrooms%22%7D%5D" link="url:%23|||"][/vc_column][vc_column width="1/3"][ra_featured_box style="s2" title="Villa near the beach" price="$1000" image="http://boo.themerella.com/wp-content/uploads/2017/04/inner-7.jpg" fb_atts="%5B%7B%22fb_label%22%3A%22Built%20in%202008%2C%22%7D%2C%7B%22fb_label%22%3A%22Residential%2C%22%7D%2C%7B%22fb_label%22%3A%224%20Bedrooms%22%7D%5D"][/vc_column][vc_column width="1/3"][ra_featured_box style="s2" title="Coastline View" price="$800" image="http://boo.themerella.com/wp-content/uploads/2017/04/inner-3.jpg" fb_atts="%5B%7B%22fb_label%22%3A%22Beamed%20Ceilings%2C%22%7D%2C%7B%22fb_label%22%3A%22Residential%2C%22%7D%2C%7B%22fb_label%22%3A%22Barbecue%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Featured Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Featured', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/featured-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1502559532279{padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column][/vc_column][vc_column width="1/3"][ra_featured_box style="s1" title="Panoramic View" price="$3800" image="http://boo.themerella.com/wp-content/uploads/2017/04/inner-5.jpg" fb_atts="%5B%7B%22fb_label%22%3A%22Built%20in%202008%2C%22%7D%2C%7B%22fb_label%22%3A%22Residential%2C%22%7D%2C%7B%22fb_label%22%3A%224%20Bedrooms%22%7D%5D"][/vc_column][vc_column width="1/3"][ra_featured_box style="s1" title="Villa near the beach" price="$1000" image="http://boo.themerella.com/wp-content/uploads/2017/04/inner-7.jpg" ribbon="Featured Home" fb_atts="%5B%7B%22fb_label%22%3A%22Built%20in%202008%2C%22%7D%2C%7B%22fb_label%22%3A%22Residential%2C%22%7D%2C%7B%22fb_label%22%3A%224%20Bedrooms%22%7D%5D"][/vc_column][vc_column width="1/3"][ra_featured_box style="s1" title="Coastline View" price="$800" image="http://boo.themerella.com/wp-content/uploads/2017/04/inner-3.jpg" fb_atts="%5B%7B%22fb_label%22%3A%22Beamed%20Ceilings%2C%22%7D%2C%7B%22fb_label%22%3A%22Residential%2C%22%7D%2C%7B%22fb_label%22%3A%22Barbecue%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Classic Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/classic-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1501846946087{padding-top: 25px !important;padding-bottom: 140px !important;}"][vc_column][ra_section_title style="thick2" title="case studies." css=".vc_custom_1501792048418{margin-bottom: 95px !important;}"] <hr /> [/ra_section_title][vc_row_inner][vc_column_inner width="1/3" parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" translate_from_x="-30" parallax_trigger_number="0.8" parallax_duration="0%" css=".vc_custom_1501671007654{padding-right: 20px !important;padding-left: 20px !important;}"][ra_content_box style="s0" show_button="yes" ib_style="btn-default" ib_shape="round" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Logistics and Transportation" ib_title="See Details" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" image="http://two.corporate.themerella.com/wp-content/uploads/sites/3/2016/11/Corporate15.jpg" title_size="20px" overlay_image="http://two.corporate.themerella.com/wp-content/uploads/sites/3/2016/11/content-box-1-1.jpg" ib_hbg="#f2784b" title_color="#002c5b" primary_color="rgba(242,120,75,0.19)" ib_i_ml="10px" ib_htext_color="#ffffff" ib_fs="12px" ib_css=".vc_custom_1501845443254{margin-top: 25px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/3" parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" translate_from_x="-30" to_delay="0.15" parallax_trigger_number="0.8" parallax_duration="0%" css=".vc_custom_1501671019021{padding-right: 20px !important;padding-left: 20px !important;}"][ra_content_box style="s0" show_button="yes" ib_style="btn-default" ib_shape="round" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Insurance and Finance" ib_title="See Details" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" image="http://two.corporate.themerella.com/wp-content/uploads/sites/3/2016/11/Corporate14.jpg" title_size="20px" overlay_image="http://two.corporate.themerella.com/wp-content/uploads/sites/3/2016/11/content-box-2-1.jpg" ib_hbg="#f2784b" title_color="#3b3e79" primary_color="rgba(242,120,75,0.19)" ib_i_ml="10px" ib_htext_color="#ffffff" ib_fs="12px" ib_css=".vc_custom_1501845435807{margin-top: 25px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/3" parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_reverse="no" translate_from_x="-30" to_delay="0.3" parallax_duration="0%" parallax_trigger_number="0.8" css=".vc_custom_1501671027907{padding-right: 20px !important;padding-left: 20px !important;}"][ra_content_box style="s0" show_button="yes" ib_style="btn-default" ib_shape="round" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Construction and Environment" ib_title="See Details" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" image="http://two.corporate.themerella.com/wp-content/uploads/sites/3/2016/11/content-box-3.jpg" title_size="20px" overlay_image="http://two.corporate.themerella.com/wp-content/uploads/sites/3/2016/11/Corporate13.jpg" ib_hbg="#f2784b" title_color="#3b3e79" primary_color="rgba(242,120,75,0.19)" ib_i_ml="10px" ib_htext_color="#ffffff" ib_fs="12px" ib_css=".vc_custom_1501845428456{margin-top: 25px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula.[/ra_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Classic Flipbox Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Classic Flipbox', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/classic-flipbox-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1502559541885{padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column width="1/3"][ra_flipbox][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1495730020609{padding-top: 20px !important;padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12"][ra_icon_box template="" heading_size="icon-box-heading-md" i_type="fontawesome" background_shape="circle" title="100+ Elements" i_icon_fontawesome="fa fa-500px" icon_color="#ff512f" icon_bg="#ffffff" title_color="#ffffff" css=".vc_custom_1495730590905{margin-bottom: 0px !important;}"]<span style="color: #ffffff;">Lorem ipsum dolor sit amet, sed do eiusmod tempor incididunt.</span>[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner css=".vc_custom_1495730729738{padding-top: 20px !important;}"][vc_column_inner align="text-center" offset="vc_col-xs-12"][ra_button style="btn-underlined" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="1/3"][ra_flipbox][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1495730020609{padding-top: 20px !important;padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12"][ra_icon_box template="" heading_size="icon-box-heading-md" i_type="fontawesome" background_shape="circle" title="100+ Elements" i_icon_fontawesome="fa fa-500px" icon_color="#ff512f" icon_bg="#ffffff" title_color="#ffffff" css=".vc_custom_1495730590905{margin-bottom: 0px !important;}"]<span style="color: #ffffff;">Lorem ipsum dolor sit amet, sed do eiusmod tempor incididunt.</span>[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner css=".vc_custom_1495730729738{padding-top: 20px !important;}"][vc_column_inner align="text-center" offset="vc_col-xs-12"][ra_button style="btn-underlined" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="1/3"][ra_flipbox][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1495730020609{padding-top: 20px !important;padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12"][ra_icon_box template="" heading_size="icon-box-heading-md" i_type="fontawesome" background_shape="circle" title="100+ Elements" i_icon_fontawesome="fa fa-500px" icon_color="#ff512f" icon_bg="#ffffff" title_color="#ffffff" css=".vc_custom_1495730590905{margin-bottom: 0px !important;}"]<span style="color: #ffffff;">Lorem ipsum dolor sit amet, sed do eiusmod tempor incididunt.</span>[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner css=".vc_custom_1495730729738{padding-top: 20px !important;}"][vc_column_inner align="text-center" offset="vc_col-xs-12"][ra_button style="btn-underlined" text="text-uppercase" title="Let's Work
Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Flipbox with buttons Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Flipbox with Buttons', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/flipbox-with-buttons-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1502108341312{padding-top: 100px !important;background-color: #f4ece9 !important;}"][vc_column align="text-center"][ra_section_title style="overlay" title="what we do" hr_bg_color="#f1dfd9"] <hr /> [/ra_section_title][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1502110580622{padding-bottom: 160px !important;background-color: #f4ece9 !important;}"][vc_column width="1/3" align="text-lg-center text-md-center text-sm-center text-xs-center"][ra_flipbox bg_image="http://three.business.themerella.com/wp-content/uploads/sites/3/2016/12/Business27.jpg" back_bg_color="#2f43a9"][ra_flipbox_section title="Front"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1502098484321{padding-top: 140px !important;padding-bottom: 140px !important;}"][ra_button style="btn-solid" shape="round" size="btn-md" text="text-uppercase" title="Finance" primary_color="#ffffff" text_color="#383838" fs="15px" fw="700" ls="2px"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="17px" lh="40px" css=".vc_custom_1502098965622{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="1/3" align="text-lg-center text-md-center text-sm-center text-xs-center"][ra_flipbox bg_image="http://three.business.themerella.com/wp-content/uploads/sites/3/2016/12/Business28.jpg" back_bg_color="#2f43a9"][ra_flipbox_section title="Front"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1502098484321{padding-top: 140px !important;padding-bottom: 140px !important;}"][ra_button style="btn-solid" shape="round" size="btn-md" text="text-uppercase" title="Consulting" primary_color="#ffffff" text_color="#383838" fs="15px" fw="700" ls="2px"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="17px" lh="40px" css=".vc_custom_1502098965622{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="1/3" align="text-lg-center text-md-center text-sm-center text-xs-center"][ra_flipbox bg_image="http://three.business.themerella.com/wp-content/uploads/sites/3/2016/12/Business24.jpg" back_bg_color="#2f43a9"][ra_flipbox_section title="Front"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1502098484321{padding-top: 140px !important;padding-bottom: 140px !important;}"][ra_button style="btn-solid" shape="round" size="btn-md" text="text-uppercase" title="Business" primary_color="#ffffff" text_color="#383838" fs="15px" fw="700" ls="2px"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="17px" lh="40px" css=".vc_custom_1502098965622{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Flipbox with Icons Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Flipbox with Icons', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/flipbox-with-icons-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1506971409551{padding-bottom: 150px !important;}" responsive_css="padding_top_tablet:70|padding_bottom_tablet:40|padding_top_mobile:50|padding_bottom_mobile:20"][vc_column width="2/3" css=".vc_custom_1506950225379{margin-bottom: 30px !important;}" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_flipbox bg_image="141" back_bg_color="#e59e34"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1506963884802{padding-top: 70px !important;}"][ra_icon_box template="" heading_weight="weight-semibold" i_type="linea" title="WooCommerce" icon_color="#ffffff" content_color="rgba(255,255,255,0.68)" title_size="26px" title_color="#ffffff" content_size="17px" i_icon_linea="icon-ecommerce_bag_check" icon_fs="70px"]No coding skills required to create unique sites. Customize your site.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="15px" lh="40px" css=".vc_custom_1502292131290{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="2/3" css=".vc_custom_1506950211885{margin-bottom: 30px !important;}" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_flipbox bg_image="155" back_bg_color="#e59e34"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1506963884802{padding-top: 70px !important;}"][ra_icon_box template="" heading_weight="weight-semibold" i_type="linea" title="Live Customizer" icon_color="#ffffff" content_color="rgba(255,255,255,0.68)" title_size="26px" title_color="#ffffff" content_size="17px" i_icon_linea="icon-basic_webpage_multiple" icon_fs="70px"]No coding skills required to create unique sites. Customize your site.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="15px" lh="40px" css=".vc_custom_1502292131290{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="2/3" css=".vc_custom_1506950241827{margin-bottom: 30px !important;}" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_flipbox bg_image="97" back_bg_color="#e59e34"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1506963884802{padding-top: 70px !important;}"][ra_icon_box template="" heading_weight="weight-semibold" i_type="linea" title="Extended Documentation" icon_color="#ffffff" content_color="rgba(255,255,255,0.68)" title_size="26px" title_color="#ffffff" content_size="17px" i_icon_linea="icon-basic_book_pencil" icon_fs="70px"]No coding skills required to create unique sites. Customize your site.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="15px" lh="40px" css=".vc_custom_1502292131290{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Minimal boxes Services vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Services Minimal boxes', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/minimal-boxes-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1506971409551{padding-bottom: 150px !important;}" responsive_css="padding_top_tablet:70|padding_bottom_tablet:40|padding_top_mobile:50|padding_bottom_mobile:20"][vc_column width="2/3" css=".vc_custom_1506950225379{margin-bottom: 30px !important;}" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_flipbox bg_image="141" back_bg_color="#e59e34"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1506963884802{padding-top: 70px !important;}"][ra_icon_box template="" heading_weight="weight-semibold" i_type="linea" title="WooCommerce" icon_color="#ffffff" content_color="rgba(255,255,255,0.68)" title_size="26px" title_color="#ffffff" content_size="17px" i_icon_linea="icon-ecommerce_bag_check" icon_fs="70px"]No coding skills required to create unique sites. Customize your site.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="15px" lh="40px" css=".vc_custom_1502292131290{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="2/3" css=".vc_custom_1506950211885{margin-bottom: 30px !important;}" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_flipbox bg_image="155" back_bg_color="#e59e34"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1506963884802{padding-top: 70px !important;}"][ra_icon_box template="" heading_weight="weight-semibold" i_type="linea" title="Live Customizer" icon_color="#ffffff" content_color="rgba(255,255,255,0.68)" title_size="26px" title_color="#ffffff" content_size="17px" i_icon_linea="icon-basic_webpage_multiple" icon_fs="70px"]No coding skills required to create unique sites. Customize your site.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="15px" lh="40px" css=".vc_custom_1502292131290{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="2/3" css=".vc_custom_1506950241827{margin-bottom: 30px !important;}" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_flipbox bg_image="97" back_bg_color="#e59e34"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1506963884802{padding-top: 70px !important;}"][ra_icon_box template="" heading_weight="weight-semibold" i_type="linea" title="Extended Documentation" icon_color="#ffffff" content_color="rgba(255,255,255,0.68)" title_size="26px" title_color="#ffffff" content_size="17px" i_icon_linea="icon-basic_book_pencil" icon_fs="70px"]No coding skills required to create unique sites. Customize your site.[/ra_icon_box][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="15px" lh="40px" css=".vc_custom_1502292131290{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/

	//Promo boxes Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Promo Boxes', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/promo-box-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1504716006691{padding-top: 75px !important;padding-bottom: 110px !important;}" responsive_css="padding_top_tablet:50|padding_bottom_tablet:100|padding_top_mobile:25|padding_bottom_mobile:50"][vc_column width="2/3" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-2"][ra_section_title style="resolve" title="Promo Boxes" title_font_container="tag:h2" title_use_theme_fonts="yes" content_font_container="tag:p|font_size:18px|line_height:2em" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1504715045178{margin-bottom: 35px !important;}"]Cras pellentesque odio ligula, sed suscipit massa venenatis et.[/ra_section_title][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_content_box style="s11" show_button="yes" ib_style="btn-naked" ib_lightbox="yes" ib_lightbox_type="video" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Creative" image="http://four.classic.themerella.com/wp-content/uploads/sites/4/2017/08/c1-1.jpg" ib_title="Watch The Trailer" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_i_color="#ffffff" title_size="17px" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" info="Approach" ib_text_color="#ffffff"] Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mus. [/ra_content_box][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_content_box style="s11" show_button="yes" ib_style="btn-naked" ib_lightbox="yes" ib_lightbox_type="video" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Videos" image="http://four.classic.themerella.com/wp-content/uploads/sites/4/2017/08/c2-1.jpg" ib_title="Watch The Trailer" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_i_color="#ffffff" title_size="17px" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" info="Production" ib_text_color="#ffffff"] Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mus. [/ra_content_box][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-2"][ra_content_box style="s11" show_button="yes" ib_style="btn-naked" ib_lightbox="yes" ib_lightbox_type="video" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Advertisment" image="http://four.classic.themerella.com/wp-content/uploads/sites/4/2017/08/c3-1.jpg" ib_title="Watch The Trailer" ib_i_icon_fontawesome="fa fa-long-arrow-right" ib_i_color="#ffffff" title_size="17px" ib_link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DeWeJnVFZfu4|||" info="Videos" ib_text_color="#ffffff"] Cum sociis natoque penatibus et magnis dis parturient motes, nascetur ridiculus mus. [/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Shadow Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Shadow', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/shadow-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1495620868662{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/3"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Box One" image="http://boo.themerella.com/wp-content/uploads/2017/04/4-13.jpg" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Box Two" image="http://boo.themerella.com/wp-content/uploads/2017/04/box-4.jpg" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Box Three" image="http://boo.themerella.com/wp-content/uploads/2017/04/box-5.jpg" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Split Services vc-template
/*
	$data = array();
	$data['name'] = esc_html__( 'Services Split', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/split-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1495620868662{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/3"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Box One" image="http://boo.themerella.com/wp-content/uploads/2017/04/4-13.jpg" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Box Two" image="http://boo.themerella.com/wp-content/uploads/2017/04/box-4.jpg" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Box Three" image="http://boo.themerella.com/wp-content/uploads/2017/04/box-5.jpg" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
*/
	
	//Bussines Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Classic with Banner', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/business01-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" css=".vc_custom_1493277089587{padding-top: 40px !important;padding-bottom: 140px !important;}"][vc_column width="1/2" offset="vc_col-md-3"][ra_content_box style="s0" show_button="yes" use_theme_fonts="" heading_font="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Lorem ipsum dolor sit amet consectetur adipe" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" title_size="17px" ib_text_color="#010101" ib_fw="normal" ib_css=".vc_custom_1487426801465{margin-top: 15px !important;}" ib_htext_color="#288fd7" ib_i_ml="10px" image="http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/content-box-1.jpg"]Enim adminim veniam, quis nostrud tation ullamco laboris nisiessa.[/ra_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_content_box style="s0" show_button="yes" use_theme_fonts="" heading_font="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Lorem ipsum dolor sit amet consectetur adipe" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" title_size="17px" ib_text_color="#0a0a0a" ib_fw="normal" ib_css=".vc_custom_1487426820528{margin-top: 15px !important;}" ib_htext_color="#288fd7" ib_i_ml="10px" image="http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/content-box-2.jpg"]Enim adminim veniam, quis nostrud tation ullamco laboris nisiessa.[/ra_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_content_box style="s0" show_button="yes" use_theme_fonts="" heading_font="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Lorem ipsum dolor sit amet consectetur adipe" ib_title="Learn More" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" title_size="17px" ib_text_color="#0a0a0a" ib_fw="normal" ib_css=".vc_custom_1499255871085{margin-top: 15px !important;}" ib_htext_color="#288fd7" ib_i_ml="10px" image="http://business.boo.themerella.com/wp-content/uploads/sites/18/2016/11/content-box-3.jpg"]Enim adminim veniam, quis nostrud tation ullamco laboris nisiessa.[/ra_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_banner style="s15" css=".vc_custom_1493273950009{background-color: #f2f7f8 !important;}"][vc_column_text] <h2>Smart Solutions for you.</h2> [/vc_column_text][vc_column_text css=".vc_custom_1487582715331{margin-bottom: 30px !important;}"] <ul><li>Special Discounts</li><li>Weekly Reports</li><li>Easy to use Tools</li></ul> [/vc_column_text][ra_button style="btn-solid" size="btn-md" text="text-uppercase" i_type="fontawesome" i_align="right" title="see pr?c?ng" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" primary_color="#ffffff" text_color="#000000" hbg="#288fd7" htext_color="#ffffff"][/ra_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Classic Border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/car-dealer-service.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485501431752{padding-top: 125px !important;}"][vc_column][ra_section_title style="underline6" title="Services"][/ra_section_title][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1479317392348{padding-bottom: 140px !important;}"][vc_column width="1/3"][ra_content_box style="s6" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Mechanic Auto Repair" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" content_color="rgba(0,0,0,0.75)" image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer1.png"]Donec eleifend libero eu tortor mattis, vesti esatortor finibus. Pellentesque mattis.[/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s6" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Car Insurance" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" content_color="rgba(0,0,0,0.75)" image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer2.png"]Donec eleifend libero eu tortor mattis, vesti esatortor finibus. Pellentesque mattis.[/ra_content_box][/vc_column][vc_column width="1/3"][ra_content_box style="s6" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Selling and Buying Cars" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" content_color="rgba(0,0,0,0.75)" image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer3.png"]Donec eleifend libero eu tortor mattis, vesti esatortor finibus. Pellentesque mattis.[/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Corporate Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Classic 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/corporate01-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1493104525631{padding-top: 105px !important;padding-bottom: 160px !important;}"][vc_column][ra_section_title style="thick" title="our cases." content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1484493730352{margin-bottom: 90px !important;}"]Solid Solutions[/ra_section_title][vc_row_inner][vc_column_inner width="1/3"][ra_content_box style="s0" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Leading company in product transportation" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" title_size="20px" image="http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/content-box-1.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate. dignissim justo faucibus pretium.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/3"][ra_content_box style="s0" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Leading company in product transportation" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" title_size="20px" image="http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/content-box-2.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate. dignissim justo faucibus pretium.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/3"][ra_content_box style="s0" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Leading company in product transportation" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-long-arrow-right" title_size="20px" image="http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/content-box-3.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate. dignissim justo faucibus pretium.[/ra_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Corporate Services 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/corporate03-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484515871556{padding-bottom: 135px !important;}"][vc_column][ra_section_title style="thick3" title="Our Cases" title_font_container="tag:h2|color:%23000000" title_use_theme_fonts="yes" use_custom_fonts_title="true"] <hr /> [/ra_section_title][vc_row_inner][vc_column_inner offset="vc_col-md-4"][ra_content_box style="s0" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Industry Leader in Consulatation" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="13px" ib_lh="32px" ib_fw="600" ib_ls="0.15em" ib_css=".vc_custom_1499255111669{margin-top: 20px !important;}" title_color="#000000" title_size="23px" image="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/content-box1.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_content_box style="s0" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Industry Leader in Consulatation" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="13px" ib_lh="32px" ib_fw="600" ib_ls="0.15em" ib_css=".vc_custom_1499255296249{margin-top: 20px !important;}" title_color="#000000" title_size="23px" image="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/content-box2.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4"][ra_content_box style="s0" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Industry Leader in Consulatation" ib_title="Learn more" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_fs="13px" ib_lh="32px" ib_fw="600" ib_ls="0.15em" ib_css=".vc_custom_1493127581869{margin-top: 20px !important;}" title_color="#000000" title_size="23px" image="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/content-box3.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis consectetur auctor elit vehicula vulputate.[/ra_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Lawyer Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Shadow colored border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/lawyer-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479288369296{padding-top: 15px !important;background-color: #fafafa !important;}"][vc_column][ra_section_title style="underline4" title="Practices" title_font_container="tag:h2" title_use_theme_fonts="yes" content_font_container="tag:p" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1485427976520{margin-bottom: 75px !important;}"]Helping justice is our priority.[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Insurance" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/lawyer-content1.png"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Family Law" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/lawyer-content2.png"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4 vc_col-md-offset-0 vc_col-md-6 vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10"][ra_content_box style="s3" show_button="yes" ib_style="btn-naked" ib_text="text-uppercase" ib_i_type="fontawesome" ib_i_align="right" title="Employee" ib_title="See Practice" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/lawyer-content3.png"]Claritas est etiam processus dynamicus, sequitur muationem consuetudium lipsum easa lectorum.[/ra_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Process', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/main-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1490739071481{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1490616854772{margin-right: 100px !important;}"][vc_row_inner][vc_column_inner width="1/3" align="text-right" css=".vc_custom_1490740186619{padding-left: 125px !important;}"][vc_column_text el_class="vertical"] <h2 style="text-align: left;"><strong><span style="color: #edeef0;">01</span><span style="color: #000000;">
</span></strong></h2> [/vc_column_text][/vc_column_inner][vc_column_inner width="2/3" css_animation="none"][vc_column_text] <h4 style="text-align: left;"><strong><span style="color: #000000;"><mark>Capabilities</mark></span></strong><strong><span style="color: #000000;"></span></strong></h4> [/vc_column_text][vc_column_text] <h6>Our team discussed every single detail to make sure Boo is the most versatile and unique theme created so far. Better, together</h6> [/vc_column_text][vc_separator color="custom" accent_color="#efefef"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3" align="text-right" css=".vc_custom_1490740162425{padding-left: 125px !important;}"][vc_column_text el_class="vertical"] <h2 style="text-align: left;"><strong><span style="color: #edeef0;">01</span><span style="color: #000000;">
</span></strong></h2> [/vc_column_text][/vc_column_inner][vc_column_inner width="2/3" css_animation="none"][vc_column_text] <h4 style="text-align: left;"><strong><span style="color: #000000;"><mark>Capabilities</mark></span></strong><strong><span style="color: #000000;"></span></strong></h4> [/vc_column_text][vc_column_text] <h6>Our team discussed every single detail to make sure Boo is the most versatile and unique theme created so far. Better, together</h6> [/vc_column_text][vc_separator color="custom" accent_color="#efefef"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3" css=".vc_custom_1490740156142{padding-left: 125px !important;}"][vc_column_text el_class="vertical"] <h2 style="text-align: left;"><strong><span style="color: #edeef0;">01</span><span style="color: #000000;"></span></strong></h2> [/vc_column_text][/vc_column_inner][vc_column_inner width="2/3" css_animation="none"][vc_column_text] <h4 style="text-align: left;"><strong><span style="color: #000000;"><mark>Capabilities</mark></span></strong><strong><span style="color: #000000;"></span></strong></h4> [/vc_column_text][vc_column_text] <h6>Our team discussed every single detail to make sure Boo is the most versatile and unique theme created so far. Better, together</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Services 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services With Accordion', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/main-services-2.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row content_placement="top" css=".vc_custom_1490734153020{margin-bottom: 150px !important;}"][vc_column width="1/2" css=".vc_custom_1490734142464{padding-right: 100px !important;}"][vc_column_text] <h5 style="text-align: left;"><strong><span style="color: #000000;">Brand identities, digital platforms ecommerce flagships, and branded <mark>Capabilities</mark> content that bring culture and commerce together.</span></strong><strong><span style="color: #000000;"></span></strong></h5> [/vc_column_text][ra_button style="btn-underlined" text="text-uppercase" title="View our Projects" text_color="rgba(0,0,0,0.7)" htext_color="#000000" bc="rgba(2,2,2,0.7)" hbc="#020202"][ra_particles items="%5B%7B%22image%22%3A%224199%22%2C%22top_pos%22%3A%22-200px%22%2C%22right_pos%22%3A%2270px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%20170%2C%20%5C%22scale%5C%22%3A%201.5%2C%20%5C%22y%5C%22%3A%20150%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-400%22%2C%22prlx_time%22%3A%222%22%2C%22prlx_duration%22%3A%222775%22%7D%2C%7B%22image%22%3A%224198%22%2C%22top_pos%22%3A%2290px%22%2C%22right_pos%22%3A%22400px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%2045%2C%20%5C%22y%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-400%22%2C%22prlx_time%22%3A%222%22%2C%22prlx_duration%22%3A%222000%22%7D%5D"][/vc_column][vc_column width="1/2"][vc_accordion style="underline" alignment="accordion-right" show_icon=""][vc_accordion_tab title="CREATIVE APPROACH TO MULTI-PURPOSE"][vc_column_text]Our team discussed every single detail to make sure Boo is the most versatile and unique theme created so far.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="CODING KNOWLEDGE NOT REQUIRED"][vc_column_text]No coding skills required to create unique sites. Customize your site in real-time and see the results instantly.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="PREMIUM LOOK AND FEEL"][vc_column_text]Extreme attention to detail is the essence of Boo?s unique design.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="OUTSTANDING PORTFOLIO FEATURES"][vc_column_text]From unique layouts to customizable hover effects, Boo offers the most advanced portfolio on the market.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Services 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services List with Button', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/main-services-3.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1490618177805{margin-bottom: 150px !important;}"][vc_column width="1/3" css=".vc_custom_1490616854772{margin-right: 100px !important;}"][vc_column_text] <h5 style="text-align: left;"><strong><span style="color: #000000;">Capabilities</span></strong><strong><span style="color: #000000;"></span></strong></h5> [/vc_column_text][vc_column_text css=".vc_custom_1490622394264{margin-right: 50px !important;}"]
<h6>Our team discussed every single detail to make sure Boo is the most versatile and unique theme created so far. <mark>Better, together</mark></h6> [/vc_column_text][/vc_column][vc_column width="1/3"][vc_column_text] <h6 style="text-align: left;"><strong><span style="color: #000000;">Digital Brand</span></strong> <strong><span style="color: #000000;">Seo Consultation</span></strong><strong><span style="color: #000000;">All in One Solutions</span></strong><strong><span style="color: #000000;">Development</span></strong><strong><span style="color: #000000;">Content Management</span></strong><strong><span style="color: #000000;">Virtual Reality
</span></strong></h6> [/vc_column_text][ra_button style="btn-underlined" text="text-uppercase" title="Explore all Features" link="url:%23|||" text_color="#000000" bc="#000000"][/vc_column][vc_column width="1/3"][vc_column_text] <h6 style="text-align: left;"><span style="color: #000000;"><strong>Digital Brand</strong></span> <span style="color: #000000;"><strong>Seo Consultation</strong></span> <span style="color: #000000;"><strong>All in One Solutions</strong></span> <span style="color: #000000;"><strong>Development</strong></span> <span style="color: #000000;"><strong>Content Management</strong></span>
<span style="color: #000000;"><strong>Virtual Reality</strong></span></h6> [/vc_column_text][ra_button style="btn-underlined" text="text-uppercase" title="Explore all Features" link="url:%23|||" text_color="#000000" bc="#000000"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Portfolio Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services List Dark', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/pf05-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1489776328347{margin-bottom: 40px !important;}"][vc_column][vc_single_image image=""][/vc_column][/vc_row][vc_row css=".vc_custom_1489776710342{margin-bottom: 100px !important;}"][vc_column width="1/3"][/vc_column][vc_column width="1/3"][vc_column_text] <h5><span style="color: #ffffff;"><strong>Digital Brand </strong></span>
<strong>Seo Consultation</strong><span style="color: #ffffff;"><strong>Multi-Channel Solutions</strong></span><strong><span style="color: #ffffff;">Development</span></strong><span style="color: #ffffff;"><strong>Content Management</strong></span><span style="color: #ffffff;"><strong>Mobile VR</strong></span></h5><h5><span style="color: #ffffff;"><strong> </strong></span></h5> [/vc_column_text][/vc_column][vc_column width="1/3"][vc_column_text] <h5><span style="color: #ffffff;"><strong>Digital Brand </strong></span><strong>Seo Consultation</strong><span style="color: #ffffff;"><strong>Multi-Channel Solutions</strong></span><strong><span style="color: #ffffff;">Development</span></strong><span style="color: #ffffff;"><strong>Content Management</strong></span><span style="color: #ffffff;"><strong>Mobile VR</strong></span></h5> [/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Restaurant Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Elegant Hover', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/restaurant-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479492306050{padding-top: 50px !important;padding-bottom: 75px !important;}"][vc_column css=".vc_custom_1485157501851{padding-right: 30px !important;padding-left: 30px !important;}" offset="vc_col-md-4"][ra_content_box style="s2" title="quick" info="Breakfast" link="url:%23||" img_link="url:%23|||" image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/restaurant-1.jpg"]Fusce tincidunt gravida accusman. Suspendisse ac luctus nibh.[/ra_content_box][/vc_column][vc_column css=".vc_custom_1485157511726{padding-right: 30px !important;padding-left: 30px !important;}" offset="vc_col-md-4"][ra_content_box style="s2" title="quick" info="Lunch" link="url:%23||" img_link="url:%23|||" image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/restaurant-2.jpg"]Fusce tincidunt gravida accusman. Suspendisse ac luctus nibh.[/ra_content_box][/vc_column][vc_column css=".vc_custom_1485157523224{padding-right: 30px !important;padding-left: 30px !important;}" offset="vc_col-md-4"][ra_content_box style="s2" title="quick" info="Dinner" link="url:%23||" img_link="url:%23|||" image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/restaurant-3.jpg"]Fusce tincidunt gravida accusman. Suspendisse ac luctus nibh.[/ra_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services No Gap', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/university-content-box.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1485508627834{padding-top: 0px !important;padding-bottom: 75px !important;}"][vc_column][ra_section_title style="classic2" title="Campus Life" content_font_container="tag:p" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1485455732810{margin-bottom: 70px !important;}"]Facilities[/ra_section_title][vc_row_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-7.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" primary_color="#dd3333" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-8.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-9.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-10.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-11.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-12.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-13.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][vc_column_inner offset="vc_col-lg-3 vc_col-md-6"][ra_content_box style="s5" title="Working places around our campus" image="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-content-14.png"]Lorem ipsum dolor sit amet, consect etura ipiscins elit vivamus vestibulum.[/ra_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Minimal Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Minimal', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/minimal-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row gap="35" css=".vc_custom_1497371615288{margin-bottom: 50px !important;border-bottom-width: 1px !important;padding-bottom: 38px !important;border-bottom-color: rgba(255,255,255,0.11) !important;border-bottom-style: dotted !important;}"][vc_column width="1/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" align="text-lg-left" parallax_from="``y``: 40, ``rotationX``: -10, ``rotationY``: 35, ``opacity``: 0, ``transformOrigin``: ``0% 0%``" parallax_to="``y``: 0, ``rotationX``: 0, ``rotationY``: 0, ``opacity``: 1, ``transformOrigin``: ``0% 0%``, ``ease``: ``Quint.easeOut``" parallax_trigger_number="0.7" parallax_duration="0%" parallax_time="1.75"][vc_column_text css=".vc_custom_1497370337821{border-left-width: 100px !important;}"] <h5><span style="font-size: 21px; color: #ffffff;">Digital Innovation</span></h5> <span style="color: #a9a9b4;">Improve him believe opinion offered met and end cheered forbade. Friendly as stronger speedily by recurred. </span>[/vc_column_text][/vc_column][vc_column width="1/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" align="text-lg-left" parallax_from="``y``: 40, ``rotationX``: -10, ``rotationY``: 35, ``opacity``: 0, ``transformOrigin``: ``0% 0%``" parallax_to="``y``: 0, ``rotationX``: 0, ``rotationY``: 0, ``opacity``: 1, ``transformOrigin``: ``0% 0%``, ``ease``: ``Quint.easeOut``, ``delay``: 0.15" parallax_trigger_number="0.7" parallax_duration="0%" parallax_time="1.75"][vc_column_text css=".vc_custom_1497370337821{border-left-width: 100px !important;}"] <h5><span style="font-size: 21px; color: #ffffff;">Digital Innovation</span></h5> <span style="color: #a9a9b4;">Improve him believe opinion offered met and end cheered forbade. Friendly as stronger speedily by recurred. </span>[/vc_column_text][/vc_column][vc_column width="1/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" align="text-lg-left" parallax_from="``y``: 40, ``rotationX``: -10, ``rotationY``: 35, ``opacity``: 0, ``transformOrigin``: ``0% 0%``" parallax_to="``y``: 0, ``rotationX``: 0, ``rotationY``: 0, ``opacity``: 1, ``transformOrigin``: ``0% 0%``, ``ease``: ``Quint.easeOut``, ``delay``: 0.3" parallax_trigger_number="0.7" parallax_duration="0%" parallax_time="1.75"][vc_column_text css=".vc_custom_1497370337821{border-left-width: 100px !important;}"] <h5><span style="font-size: 21px; color: #ffffff;">Digital Innovation</span></h5> <span style="color: #a9a9b4;">Improve him believe opinion offered met and end cheered forbade. Friendly as stronger speedily by recurred. </span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Minimal Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services Text with title', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/text-with-title-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="top" css=".vc_custom_1497373293234{margin-top: 40px !important;border-bottom-width: 1px !important;padding-bottom: 80px !important;border-bottom-color: rgba(255,255,255,0.11) !important;border-bottom-style: dotted !important;}"][vc_column width="1/3" parallax="yes" parallax_preset="fadeInLeftShort" parallax_duration="0%"][vc_single_image image="128" css=".vc_custom_1497373314134{margin-top: 26px !important;margin-left: 45px !important;}"][/vc_column][vc_column width="1/3" parallax="yes" parallax_preset="fadeInLeftShort" parallax_duration="0%"][vc_column_text] <h6><span style="font-size: 18px;"><span style="color: #ffffff;">Virtual Collaboration</span></span><br/><span style="font-size: 18px;"><span style="color: #ffffff;">Art Direction</span></span><br/><span style="font-size: 18px;"><span style="color: #ffffff;">Digital Printing</span></span><br/><span style="font-size: 18px;"><span style="color: #ffffff;">E-commerce Solutions</span></span><br/><span style="font-size: 18px;"><span style="color: #ffffff;">App Development</span></span><br/><span style="font-size: 18px;"><span style="color: #ffffff;">Retouching</span></span><br/><span style="font-size: 18px;"><span style="color: #ffffff;">Furniture Design</span></span></h6> [/vc_column_text][/vc_column][vc_column width="1/3" parallax="yes" parallax_preset="fadeInLeftShort" parallax_duration="0%"][vc_column_text] <h6><span style="color: #000000; font-size: 18px;"><span style="color: #ffffff;">Industrial Design</span><br/><span style="color: #ffffff;">Visual Effects</span><br/><span style="color: #ffffff;">Creative Direction</span><br/><span style="color: #ffffff;">Animation</span><br/><span style="color: #ffffff;">Digital Photography</span><br/><span style="color: #ffffff;">Interior Design</span><br/><span style="color: #ffffff;">Packaging</span><strong></strong></span></h6> [/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Minimal Services vc-template
	$data = array();
	$data['name'] = esc_html__( 'Services FlipBox', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/services/flipbox-services.jpg' );
	$data['sort_name'] = 'Services';
	$data['custom_class'] = 'general service';
	$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3" css=".vc_custom_1497361885108{margin-bottom: 70px !important;}"][vc_custom_heading text="WHAT WE DO" font_container="tag:h6|font_size:16px|text_align:center|color:%2346dfb4" use_theme_fonts="yes" letter_spacing="0.3em" css=".vc_custom_1497371082456{margin-bottom: 35px !important;}"][vc_custom_heading text="Endeavor bachelor but add eat pleasure doubtful sociable. Age forming covered you entered the examine. " font_container="tag:h4|font_size:26px|text_align:center|color:%23ffffff|line_height:1.333em" use_theme_fonts="yes"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row css=".vc_custom_1497362191352{margin-bottom: 75px !important;}"][vc_column width="1/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" css=".vc_custom_1497446944886{margin-bottom: 30px !important;}" parallax_from="``y``: -5, ``scale``: 0.4, ``opacity``: 0" parallax_to="``y``: 0, ``scale``: 1, ``opacity``: 1, ``ease``: ``Quint.easeOut``" parallax_trigger_number="0.7" parallax_duration="0%"][ra_flipbox back_bg_type="gradient" bg_image="87" back_bg_gradient="linear-gradient(172deg,rgb(35, 51, 219) 0%,rgb(35, 51, 221) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027560387{padding-top: 140px !important;padding-bottom: 140px !important;}"][vc_custom_heading text="Video Production" font_container="tag:h3|font_size:30px|text_align:center|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" css=".vc_custom_1497359832109{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="17px" lh="40px" css=".vc_custom_1497361666629{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="1/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" parallax_from="``y``: -5, ``scale``: 0.4, ``opacity``: 0" parallax_to="``y``: 0, ``scale``: 1, ``opacity``: 1, ``ease``: ``Quint.easeOut``, ``delay``: 0.15" parallax_trigger_number="0.7" parallax_duration="0%" css=".vc_custom_1497447093705{margin-bottom: 30px !important;}"][ra_flipbox back_bg_type="gradient" back_bg_gradient="linear-gradient(160deg,rgb(35, 51, 219) 0%,rgb(35, 51, 219) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" bg_image="106"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028253925{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027560387{padding-top: 140px !important;padding-bottom: 140px !important;}"][vc_custom_heading text="Photography" font_container="tag:h3|font_size:30px|text_align:center|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" css=".vc_custom_1497370996043{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="17px" lh="40px" css=".vc_custom_1497361666629{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column width="1/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" parallax_from="``y``: -5, ``scale``: 0.4, ``opacity``: 0" parallax_to="``y``: 0, ``scale``: 1, ``opacity``: 1, ``ease``: ``Quint.easeOut``, ``delay``: 0.3" parallax_trigger_number="0.7" parallax_duration="0%" css=".vc_custom_1497447106287{margin-bottom: 30px !important;}"][ra_flipbox back_bg_type="gradient" back_bg_gradient="linear-gradient(172deg,rgb(35, 51, 221) 0%,rgb(35, 51, 221) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;" bg_image="107"][ra_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1497028244861{padding-right: 20px !important;padding-left: 20px !important;}"][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027560387{padding-top: 140px !important;padding-bottom: 140px !important;}"][vc_custom_heading text="Art Direction" font_container="tag:h3|font_size:30px|text_align:center|color:%23ffffff|line_height:1.5em" use_theme_fonts="yes" css=".vc_custom_1497359839942{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][ra_flipbox_section title="Back"][vc_row_inner][vc_column_inner offset="vc_col-xs-12" css=".vc_custom_1497027767759{padding-top: 0px !important;padding-bottom: 0px !important;}" align="text-lg-center"][ra_button style="btn-underlined" border="border-thicker" text="text-uppercase" title="Let's Work Together" link="url:%23|||" text_color="#ffffff" bc="#ffffff" fs="17px" lh="40px" css=".vc_custom_1497361666629{padding-bottom: 10px !important;}" fw="700" ls="0.2em"][/vc_column_inner][/vc_row_inner][/ra_flipbox_section][/ra_flipbox][/vc_column][vc_column align="text-lg-center" css=".vc_custom_1497362270536{margin-top: 50px !important;}"][ra_button style="btn-solid" shape="round" title="Let's Work Together" primary_color="#ffffff" hbg="#46dfb4" text_color="#020202" htext_color="#020202" fs="16px"][/vc_column]
CONTENT;
	$templates[] = $data;	

	//Shop Category
	//Car Dealer Shop vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Shadow hover', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/car-dealer-shop.jpg' );
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479317597595{padding-top: 60px !important;padding-bottom: 100px !important;background-color: #f3f3f3 !important;}"][vc_column][ra_section_title style="underline6" title="Products"][/ra_section_title][ra_woo_carousel taxonomies="6"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner Shop vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Banner', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-banner-shop.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1510322811031{padding-top: 30px !important;padding-bottom: 130px !important;background-image: url(http://shoptwo.themerella.com/wp-content/uploads/2017/11/parallax.jpg?id=4330) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-lg-4 vc_col-md-5"][vc_custom_heading text="Eclectic collection<br /> of luxe coats. " use_theme_fonts="yes" css=".vc_custom_1510223941454{margin-bottom: 0px !important;}"][vc_column_text]</p> <h5><span style="font-size: 21px;">Blazer: $39.90</span></h5> <p>[/vc_column_text][ra_button style="btn-solid" curtain_hover="bottom" shape="semi-round" size="btn-lg" text="text-uppercase" i_type="fontawesome" i_align="right" title="Shop Collection" link="url:%23|||" primary_color="#ffffff" hbg="#ffffff" fs="12px" text_color="#000000" htext_color="#ffffff" curtain_hbg="#000000" i_icon_fontawesome="fa fa-angle-right"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Categories Shop vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Categories', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-categories-shop.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" enable_responsive_options="yes" css=".vc_custom_1510152329340{padding-top: 100px !important;padding-bottom: 50px !important;}"][vc_column][ra_section_title style="resolve" title="Shop Women" title_font_container="tag:h2|font_size:40px|line_height:1.5em" title_use_theme_fonts="yes" content_font_container="tag:h5|color:rgba(0%2C0%2C0%2C0.52)|line_height:1.25em" content_use_theme_fonts="yes" use_custom_fonts_title="true" use_custom_fonts_content="true" css=".vc_custom_1510153658098{margin-bottom: 70px !important;}"]Eclectic collection of luxe coats. Wear like a boss.[/ra_section_title][/vc_column][vc_column offset="vc_col-md-6"][ra_shop_banner image="http://shoptwo.themerella.com/wp-content/uploads/2017/11/shop-banner-2.jpg" height="450px"][ra_button style="btn-naked" title="Basics" link="url:%23|||" fs="30px" text_color="#000000"][/ra_shop_banner][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_shop_banner image="http://shoptwo.themerella.com/wp-content/uploads/2017/11/shop-banner-3.jpg" height="450px"][ra_button style="btn-naked" title="Skirts" link="url:%23|||" fs="25px" text_color="#000000"][/ra_shop_banner][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_shop_banner image="http://shoptwo.themerella.com/wp-content/uploads/2017/11/shop-banner-4.jpg" css=".vc_custom_1510646630260{margin-bottom: 30px !important;}" height="210px"][ra_button style="btn-naked" title="Hoodies" link="url:%23|||" fs="25px" text_color="#000000"][/ra_shop_banner][ra_shop_banner image="http://shoptwo.themerella.com/wp-content/uploads/2017/11/shop-banner-5.jpg" css=".vc_custom_1510646786175{margin-bottom: 0px !important;}" height="210px"][ra_button style="btn-naked" title="Bass" link="url:%23|||" fs="25px" text_color="#000000"][/ra_shop_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Look Shop vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Look', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-look-shop.jpg' );
	$data['new'] = true;
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column bg_position="center top" offset="vc_col-md-6" css=".vc_custom_1510322673626{padding-top: 0px !important;padding-bottom: 0px !important;background-image: url(http://shoptwo.themerella.com/wp-content/uploads/2017/11/Collection.jpg?id=4328) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" align="text-lg-center"][ra_shop_banner style="hover-effect"][ra_button style="btn-solid" curtain_hover="bottom" size="btn-lg" text="text-uppercase" title="Shop Collection" link="url:%23|||" primary_color="#000000" hbg="#000000" fs="12px" text_color="#ffffff" htext_color="#000000" curtain_hbg="#ffffff"][/ra_shop_banner][/vc_column][vc_column bg_position="center top" offset="vc_col-md-6" css=".vc_custom_1510322682236{padding-top: 0px !important;padding-bottom: 0px !important;background-image: url(http://shoptwo.themerella.com/wp-content/uploads/2017/11/Todayslook.jpg?id=4332) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ra_shop_banner style="hover-effect" el_class="content-top-left"][vc_column_text css=".vc_custom_1510221581539{margin-top: 20px !important;margin-left: 60px !important;}"] <h5><span style="font-size: 18px;">Blazer: <span style="color: #5c5c5c;">$39.90</span></span> <span style="font-size: 18px;">Skane?s Watch: <span style="color: #5c5c5c;">$90</span></span> <span style="font-size: 18px;">Check Top: <span style="color: #5c5c5c;">$49.30</span></span> <span style="font-size: 18px;">Black Socks: <span style="color: #5c5c5c;">$69</span></span> <span style="font-size: 18px;">Ankle Boots: <span style="color: #5c5c5c;">$190</span></span> <span style="font-size: 18px;">Fleece Top: <span style="color: #5c5c5c;">$90</span></span></h5> [/vc_column_text][/ra_shop_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Categories vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Featured Categories', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-categories.jpg' );
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484649177001{padding-top: 70px !important;}"][vc_column][ra_section_title style="sub-underlined" title="Accessories" i_type="fontawesome" i_align="right" i_icon_fontawesome="fa fa-long-arrow-right" css=".vc_custom_1492518685701{margin-bottom: 45px !important;}"]Fall Season[/ra_section_title][/vc_column][/vc_row][vc_row equal_height="yes" css=".vc_custom_1484650264132{padding-bottom: 140px !important;}"][vc_column css=".vc_custom_1492521584549{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;background-image: url(http://womens-shop.boo.themerella.com/wp-content/uploads/sites/22/2016/12/womens-shop-bg2.png?id=19) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][ra_shop_banner style="hover-effect"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-offset-6" css=".vc_custom_1492521225501{padding-top: 0px !important;padding-right: 60px !important;padding-bottom: 0px !important;}"][vc_column_text css=".vc_custom_1492520738108{margin-bottom: 35px !important;}"] <h6><span style="color: #d72828;">Collection</span></h6> <h4>Shoes &amp; Bags</h4>
Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec enim sed nisi pretium suscipit amet.[/vc_column_text][ra_button style="btn-solid" size="btn-md" border="border-thick" others="wide" text="text-uppercase" i_type="fontawesome" i_align="right" title="Shop Now" link="url:%23|||" text_color="#000000" htext_color="#ffffff" fs="13px" bc="#000000" i_icon_fontawesome="fa fa-long-arrow-right" lh="30px" hbg="#0a0a0a" i_ml="10px" ls="0.2em" primary_color="rgba(255,255,255,0)"][/vc_column_inner][/vc_row_inner][/ra_shop_banner][/vc_column][vc_column css=".vc_custom_1492521598376{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;background-image: url(http://womens-shop.boo.themerella.com/wp-content/uploads/sites/22/2016/12/womens-shop-bg3.png?id=21) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][ra_shop_banner style="hover-effect"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-offset-6" css=".vc_custom_1484650407622{padding-right: 60px !important;}"][vc_column_text css=".vc_custom_1492521302299{margin-bottom: 35px !important;}"] <h6><span style="color: #d72828;">Skagen</span></h6> <h4>Watches
&amp; Wallets</h4> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis nec enim sed nisi pretium suscipit amet.[/vc_column_text][ra_button style="btn-solid" size="btn-md" border="border-thick" others="wide" text="text-uppercase" i_type="fontawesome" i_align="right" title="Shop Now" link="url:%23|||" text_color="#000000" htext_color="#ffffff" fs="13px" bc="#000000" i_icon_fontawesome="fa fa-long-arrow-right" lh="30px" hbg="#0a0a0a" i_ml="10px" ls="0.2em" primary_color="rgba(255,255,255,0)"][/vc_column_inner][/vc_row_inner][/ra_shop_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Categories 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Packery Categories', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-categories-2.jpg' );
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484648074284{padding-top: 30px !important;}"][vc_column][ra_section_title style="sub-underlined" title="Shop Women" use_resolve_effect="yes" resolve_effect_seperator="chars" css=".vc_custom_1488919281719{margin-bottom: 45px !important;}" resolve_effect_delay="100"]2017 Collection[/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1481292705580{padding-bottom: 80px !important;}"][vc_column width="1/4"][ra_shop_banner height="450px" image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/shop-banner1.jpg"][ra_button style="btn-solid" size="btn-xxsm" text="text-uppercase" title="Footwear" link="url:%23|||" primary_color="#ffffff" hbg="#000000" text_color="#000000" htext_color="#ffffff" fs="14px" ls="0.2em !important"][/ra_shop_banner][/vc_column][vc_column width="1/4"][ra_shop_banner height="450px" image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/shop-banner2.jpg"][ra_button style="btn-solid" size="btn-xxsm" text="text-uppercase" title="Watches" link="url:%23|||" primary_color="#ffffff" hbg="#000000" text_color="#000000" htext_color="#ffffff" fs="14px" ls="0.2em !important"][/ra_shop_banner][/vc_column][vc_column width="1/4"][ra_shop_banner height="450px" image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/shop-banner3.jpg"][ra_button style="btn-solid" size="btn-xxsm" text="text-uppercase" title="Sweatshirts" link="url:%23|||" primary_color="#ffffff" hbg="#000000" text_color="#000000" htext_color="#ffffff" fs="14px" ls="0.2em !important"][/ra_shop_banner][/vc_column][vc_column width="1/4"][ra_shop_banner css=".vc_custom_1481296309696{margin-bottom: 30px !important;}" height="210px" image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/shop-banner4.jpg"][ra_button style="btn-solid" size="btn-xxsm" text="text-uppercase" title="Bags" link="url:%23|||" primary_color="#ffffff" hbg="#000000" text_color="#000000" htext_color="#ffffff" fs="14px" ls="0.2em !important"][/ra_shop_banner][ra_shop_banner height="210px" image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/shop-banner5.jpg"][ra_button style="btn-solid" size="btn-xxsm" text="text-uppercase" title="Accessories" link="url:%23|||" primary_color="#ffffff" hbg="#000000" text_color="#000000" htext_color="#ffffff" fs="14px" ls="0.2em !important"][/ra_shop_banner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Products vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Products with Tabs', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-products.jpg' );
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1492518478237{padding-top: 25px !important;padding-bottom: 60px !important;}"][vc_column][ra_section_title style="sub-underlined" title="New Arrivals" use_resolve_effect="yes" css=".vc_custom_1488919349775{margin-bottom: 45px !important;}"][/ra_section_title][ra_tabs style="s21"][ra_tab_section title="Men's Wear" el_class="pt-40"][ra_woo_carousel style="s3" taxonomies="6" el_class="mt-75"][/ra_tab_section][ra_tab_section title="Women's Wear"][ra_woo_carousel style="s3" taxonomies="6" el_class="mt-75"][/ra_tab_section][ra_tab_section title="Kids's Wear"][ra_woo_carousel style="s3" taxonomies="6" el_class="mt-75"][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Products 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Products Border Left', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-products-2.jpg' );
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1492521652150{padding-top: 70px !important;}"][vc_column][ra_section_title style="sub-underlined" title="Watches &amp; Wallets" i_align="right" css=".vc_custom_1484658685968{margin-bottom: 45px !important;}"]2017 Collection[/ra_section_title][ra_woo_carousel style="s4" taxonomies="8"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Shop Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Shop Pointer', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/shop/shop-tabs.jpg' );
	$data['sort_name'] = 'Shop';
	$data['custom_class'] = 'general shop';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][ra_section_title style="sub-underlined" title="Today's Look"][/ra_section_title][/vc_column][/vc_row][vc_row][vc_column width="2/3" offset="vc_col-md-offset-2"][ra_tabs style="s20"][ra_tab_section title="Men's Wear"][ra_mapped_image image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/women-shop-img-map.jpg"][ra_pointer include="" top="17%" left="16%" width="50px"][ra_pointer position="align-left" include="" top="35%" left="78%" width="10px"][ra_pointer include="35" top="54%" left="10%" width="35px"][ra_pointer position="align-left" include="36" top="70%" left="76%" width="30px"][ra_pointer include="32" top="83%" left="7%" width="30px"][/ra_mapped_image][/ra_tab_section][ra_tab_section title="Kid's Wear"][ra_mapped_image image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/women-shop-img-map.jpg"][ra_pointer include="33" top="17%" left="16%" width="50px"][ra_pointer position="align-left" include="34" top="35%" left="78%" width="10px"][ra_pointer include="35" top="54%" left="10%" width="35px"][ra_pointer position="align-left" include="36" top="70%" left="76%" width="30px"][ra_pointer include="32" top="83%" left="7%" width="30px"][/ra_mapped_image][/ra_tab_section][ra_tab_section title="Women's Wear"][ra_mapped_image image="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/women-shop-img-map.jpg"][ra_pointer include="33" top="17%" left="16%" width="50px"][ra_pointer position="align-left" include="34" top="35%" left="78%" width="10px"][ra_pointer include="35" top="54%" left="10%" width="35px"][ra_pointer position="align-left" include="36" top="70%" left="76%" width="30px"][ra_pointer include="32" top="83%" left="7%" width="30px"][/ra_mapped_image][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Tabs Categories
	
	//Accordion Tabs
	$data = array();
	$data['name'] = esc_html__( 'Accordion - Tabs', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/accordion-tabs.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1503483774211{padding-top: 150px !important;padding-bottom: 150px !important;}" responsive_css="padding_top_tablet:70|padding_bottom_tablet:100|padding_top_mobile:35|padding_bottom_mobile:50"][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="custom" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" enable_reverse="no" translate_from_x="35" rotate_from_y="24" from_torigin_x_custom="80%" parallax_trigger_number="0.75" parallax_duration="0%"][vc_single_image d_effect="yes" source="external_link" external_img_size="full" alignment="center" css=".vc_custom_1508139294926{margin-bottom: 0px !important;}" stacking_factor="0.8" custom_src="http://four.modern.themerella.com/wp-content/uploads/sites/9/2017/08/modern-13.jpg"][/vc_column][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="custom" from_torigin_y="center" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Quint.easeOut" parallax_trigger="number" enable_transform="yes" enable_reverse="no" translate_from_x="-36" rotate_from_y="-44" from_torigin_x_custom="20%" parallax_trigger_number="0.75" parallax_duration="0%"][vc_custom_heading text="Section Templates." font_container="tag:h2|font_size:55px|text_align:left" use_theme_fonts="yes" css=".vc_custom_1503493364782{margin-top: 0px !important;}"][vc_accordion style="underline" alignment="accordion-right" show_icon=""][vc_accordion_tab title="CREATIVE APPROACH TO MULTI-PURPOSE"][vc_column_text]Unfeeling so rapturous discovery he exquisite. Reasonably so middle saimpressions and by terminated approach.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="OUTSTANDING PORTFOLIO FEATURES"][vc_column_text]From unique layouts to customizable hover effects, Boo offers the most advanced portfolio on the market.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="NO CODING SKILLS REQUIRED"][vc_column_text]No coding skills required to create unique sites. Customize your site in real-time and see the results instantly.[/vc_column_text][/vc_accordion_tab][/vc_accordion][vc_empty_space height="30px"][ra_button style="btn-default" size="btn-md" title="GET IN TOUCH" primary_color="#282d25" fs="14px" ls="0.15em" lh="1.25em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Business Vertical Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Vertical with Icons and Pricing', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/business01-vertical-tabs.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1493277165017{padding-top: 5px !important;padding-bottom: 40px !important;background-color: #f2f7f8 !important;}"][vc_column css=".vc_custom_1484545918118{padding-top: 15px !important;}"][ra_section_title style="default" title="Flexible Plans" css=".vc_custom_1487590064706{margin-bottom: 55px !important;}"]<span style="color: #c3c8c8;">for your bus?ness</span>[/ra_section_title][ra_tabs style="s17"][ra_tab_section i_type="fontawesome" title="Flexible Rates" i_icon_fontawesome="fa fa-angle-right"][vc_row_inner][vc_column_inner width="2/3" css=".vc_custom_1484546140406{padding-left: 45px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-bolt" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-eur" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-ship" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution" description="/month " price="10" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_hbg="#288fd7" pt_htext_color="#ffffff" pt_text_color="#288fd7" primary_color="#000000" pt_bc="#288fd7" pt_hbc="#288fd7"] <ul><li><strong>Credit:</strong> 2000</li><li><strong>Rate:</strong> %7</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="fontawesome" title="Business Solutions" i_icon_fontawesome="fa fa-angle-right"][vc_row_inner][vc_column_inner width="2/3" css=".vc_custom_1484546140406{padding-left: 45px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-bolt" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-eur" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-ship" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution" description="/month " price="10" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_hbg="#288fd7" pt_htext_color="#ffffff" pt_text_color="#288fd7" primary_color="#000000" pt_bc="#288fd7" pt_hbc="#288fd7"] <ul><li><strong>Credit:</strong> 2000</li><li><strong>Rate:</strong> %7</li>
<li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="fontawesome" title="Solution One" i_icon_fontawesome="fa fa-angle-right"][vc_row_inner][vc_column_inner width="2/3" css=".vc_custom_1484546140406{padding-left: 45px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-bolt" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-eur" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-ship" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution" description="/month " price="10" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_hbg="#288fd7" pt_htext_color="#ffffff" pt_text_color="#288fd7" primary_color="#000000" pt_bc="#288fd7" pt_hbc="#288fd7"] <ul><li><strong>Credit:</strong> 2000</li><li><strong>Rate:</strong> %7</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="fontawesome" title="Loan Rates" i_icon_fontawesome="fa fa-angle-right"][vc_row_inner][vc_column_inner width="2/3" css=".vc_custom_1484546140406{padding-left: 45px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-bolt" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-eur" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-ship" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution" description="/month " price="10" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_hbg="#288fd7" pt_htext_color="#ffffff" pt_text_color="#288fd7" primary_color="#000000" pt_bc="#288fd7" pt_hbc="#288fd7"] <ul><li><strong>Credit:</strong> 2000</li><li><strong>Rate:</strong> %7</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="fontawesome" title="Solution One" i_icon_fontawesome="fa fa-angle-right"][vc_row_inner][vc_column_inner width="2/3" css=".vc_custom_1484546140406{padding-left: 45px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-bolt" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-eur" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-ship" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution" description="/month " price="10" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_hbg="#288fd7" pt_htext_color="#ffffff" pt_text_color="#288fd7" primary_color="#000000" pt_bc="#288fd7" pt_hbc="#288fd7"] <ul><li><strong>Credit:</strong> 2000</li><li><strong>Rate:</strong> %7</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="fontawesome" title="Business Solutions" i_icon_fontawesome="fa fa-angle-right"][vc_row_inner][vc_column_inner width="2/3" css=".vc_custom_1484546140406{padding-left: 45px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-bolt" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-eur" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-ship" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution" description="/month " price="10" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_hbg="#288fd7" pt_htext_color="#ffffff" pt_text_color="#288fd7" primary_color="#000000" pt_bc="#288fd7" pt_hbc="#288fd7"] <ul><li><strong>Credit:</strong> 2000</li><li><strong>Rate:</strong> %7</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="fontawesome" title="Flexible Rates" i_icon_fontawesome="fa fa-angle-right"][vc_row_inner][vc_column_inner width="2/3" css=".vc_custom_1484546140406{padding-left: 45px !important;}"][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-bolt" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-eur" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][ra_icon_box template="" heading_size="icon-box-heading-md" heading_weight="weight-normal" i_type="fontawesome" background_shape="square" shape_size="custom" position="icon-box-side" title="Flexible Rates" i_icon_fontawesome="fa fa-ship" icon_bg="#288fd7" icon_fs="25px" shape_custom="55px"]Lorem ipsum dolor sit amet, conse dolor siscin sed eiusmod
ing elit sed eiusmod tempor asesam incididunt.[/ra_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ra_price_table style="s11" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_others="wide" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Solution" description="/month " price="10" currency="$" pt_title="Purchase" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" pt_hbg="#288fd7" pt_htext_color="#ffffff" pt_text_color="#288fd7" primary_color="#000000" pt_bc="#288fd7" pt_hbc="#288fd7"] <ul><li><strong>Credit:</strong> 2000</li><li><strong>Rate:</strong> %7</li><li><strong>Term:</strong> 48 months</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Dealer Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Naked with Banner and Featured Box left', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/car-dealer-tabs-with-featured-box.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485512190792{background-image: url(http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/car-dealer-banner2.png?id=12) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1479318466710{padding-top: 0px !important;}"][ra_banner style="s2"][vc_custom_heading text="Lets find your dream car." font_container="tag:h2|text_align:center" use_theme_fonts="yes"][vc_custom_heading text="`{`ra_icon icon=``fa fa-phone```}` 1 800 823 61 22" font_container="tag:h6|text_align:left" use_theme_fonts="yes"][/ra_banner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1485547875220{margin-top: -79px !important;padding-bottom: 165px !important;}"][vc_column][ra_tabs style="s12"][ra_tab_section title="Sedan"][vc_row_inner css=".vc_custom_1479318856354{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo" ribbon="Hot Offer"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Hatchback"][vc_row_inner css=".vc_custom_1479318856354{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo" ribbon="Hot Offer"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Coupe"][vc_row_inner css=".vc_custom_1479318856354{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo" ribbon="Hot Offer"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Station Wagon"][vc_row_inner css=".vc_custom_1479318856354{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo" ribbon="Hot Offer"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-dealer.boo.themerella.com/wp-content/uploads/sites/12/2016/11/content-box8.jpg" style="s1" title="Infinity Engine X Coupe" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200/mo"][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][vc_row_inner][vc_column_inner align="text-center"][ra_button style="btn-default" shape="round" size="btn-sm" border="border-thick" text="text-uppercase" title="More Cars" link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Naked with Banner and Featured Box', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/car-rental-tabs-with-featured-box.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485522195558{background-image: url(http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/car-rental-banner1.png?id=11) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column css=".vc_custom_1485527908064{padding-top: 0px !important;}"][ra_banner style="s3"][vc_custom_heading text="Let's find the best car for you." font_container="tag:h2|text_align:center" use_theme_fonts="yes" css=".vc_custom_1485552130524{margin-bottom: 35px !important;}"][vc_custom_heading text="`{`ra_icon icon=``fa fa-phone```}` 1 800 0302 39" font_container="tag:h6|text_align:center" use_theme_fonts="yes"][/ra_banner][/vc_column][/vc_row][vc_row css=".vc_custom_1485553272467{margin-top: -79px !important;margin-bottom: 60px !important;}"][vc_column][ra_tabs style="s12"][ra_tab_section i_type="linea" title="Sedan" i_icon_linea="icon-linear-sedan"][vc_row_inner css=".vc_custom_1484544166417{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="linea" title="Hatchback" i_icon_linea="icon-city-car"][vc_row_inner css=".vc_custom_1484544166417{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="linea" title="Coupe" i_icon_linea="icon-cabriolet"][vc_row_inner css=".vc_custom_1484544166417{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section i_type="linea" title="Station Wagon" i_icon_linea="icon-SUV"][vc_row_inner css=".vc_custom_1484544166417{padding-top: 85px !important;}"][vc_column_inner width="1/2" offset="vc_col-lg-offset-0 vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-4"][ra_featured_box image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/content-box7.jpg" style="s2" title="Bentley Blue Edition" link="url:%23|||" fb_atts="%5B%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-car%5C%22%5D%202016%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-cog%5C%22%5D%20Manual%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-user%5C%22%5D%205%22%7D%2C%7B%22fb_label%22%3A%22%5Bra_icon%20icon%3D%5C%22fa%20fa-tint%5C%22%5D%205.6lt%22%7D%5D" price="$200 / day"][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][vc_row_inner css=".vc_custom_1485553420219{padding-top: 12px !important;}"][vc_column_inner align="text-center" css=".vc_custom_1486052695873{padding-top: 0px !important;}"][ra_button style="btn-default" shape="round" border="border-thick" text="text-uppercase" title="More Cars" link="url:%23|||" fs="14px" fw="bold"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Red Pricing Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/hostingred-pricing.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484315239438{padding-top: 10px !important;}"][vc_column][ra_section_title style="underline3" title="Affordable Prices" content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1484132259391{margin-bottom: 0px !important;}"]Linux Packages[/ra_section_title][ra_tabs style="s8"][ra_tab_section title="Hosting"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="PHP 5.5" description="per month" price="39" currency="$" i_icon_fontawesome="fa fa-wordpress" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight" pt_htext_color="#ffffff" primary_color="#eb3659"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li>
<li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Linux" description="per month" price="49" currency="$" i_icon_fontawesome="fa fa-joomla" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-1" pt_htext_color="#ffffff" primary_color="#eb3659"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Drupal Service" description="per month" price="59" currency="$" i_icon_fontawesome="fa fa-drupal" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-2" pt_htext_color="#ffffff" primary_color="#eb3659"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="btn-default" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="All in One" description="per month" price="69" currency="$" i_icon_fontawesome="fa fa-paw" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-3" pt_htext_color="#ffffff" primary_color="#eb3659"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Servers"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="PHP 5.5" description="per month" price="39" currency="$" i_icon_fontawesome="fa fa-wordpress" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Linux" description="per month" price="49" currency="$" i_icon_fontawesome="fa fa-joomla" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-1" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Drupal Service" description="per month" price="59" currency="$" i_icon_fontawesome="fa fa-drupal" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-2" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="All in One" description="per month" price="69" currency="$" i_icon_fontawesome="fa fa-paw" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-3" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Domains"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="PHP 5.5" description="per month" price="39" currency="$" i_icon_fontawesome="fa fa-wordpress" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Linux" description="per month" price="49" currency="$" i_icon_fontawesome="fa fa-joomla" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-1" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="Drupal Service" description="per month" price="59" currency="$" i_icon_fontawesome="fa fa-drupal" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-2" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_price_table style="s8" i_type="fontawesome" pt_style="classic-date-featured" pt_shape="round" pt_border="border-thick" pt_text="text-uppercase" pt_i_type="fontawesome" pt_i_align="right" title="All in One" description="per month" price="69" currency="$" i_icon_fontawesome="fa fa-paw" i_color="#ffffff" pt_title="Add to cart" pt_link="url:%23|||" pt_i_icon_fontawesome="fa fa-angle-right" el_class="animated fadeInRight animated-delay-3" pt_htext_color="#ffffff"] <ul><li>100 GB Disk Space</li><li>Unlimited Traffic</li><li>2 Year Free Domains</li><li>250 Email Accounts</li><li>25 FTP Accounts</li><li>Free SEO Tools</li><li>No Setup Fee</li></ul> [/ra_price_table][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Red Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Shadow with checkmarks', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/hostingred-tabs.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484315115182{margin-bottom: 100px !important;padding-top: 60px !important;padding-bottom: 100px !important;background-color: #fafafa !important;}"][vc_column][ra_section_title style="underline3" title="Our Services." content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1484315173692{margin-bottom: 0px !important;}"]SSD Supported[/ra_section_title][ra_tabs style="s5" el_class="tabs-heading-sm"][ra_tab_section title="Server Hosting"][vc_row_inner][vc_column_inner width="1/4" el_class="animated fadeInLeft"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499265038579{margin-top: 40px !important;}" custom_src="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/server.png"][/vc_column_inner][vc_column_inner width="2/3" css=".vc_custom_1477404788273{padding-bottom: 20px !important;}"][vc_column_text] <h3 class="animated fadeInRight">Reliable and Secure Server</h3> <p class="animated fadeInRight animated-delay-1"><i class="fa fa-check"></i> Donec dapibus pharetra placerat</p> <p class="animated fadeInRight animated-delay-2"><i class="fa fa-check"></i> Nam eu neque nec ante porttitor finibus</p> <p class="animated fadeInRight animated-delay-3"><i class="fa fa-check"></i> Nunc non risus vitae sapien laoreet vulputate ac suscipit lectus</p> <p class="animated fadeInRight animated-delay-4"><i class="fa fa-check"></i> Second raw denim you probably haven't heard of them jean shorts Austin.</p> <h6 class="animated fadeInRightBig animated-delay-5"><i class="fa fa-wordpress"></i> Wordpress</h6> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Cloud"][vc_row_inner][vc_column_inner width="1/4" el_class="animated fadeInLeft"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499265046703{margin-top: 40px !important;}" custom_src="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/server.png"][/vc_column_inner][vc_column_inner width="2/3" css=".vc_custom_1477404795936{padding-bottom: 20px !important;}"][vc_column_text] <h3 class="animated fadeInRight">Reliable and Secure Server</h3> <p class="animated fadeInRight animated-delay-1"><i class="fa fa-check"></i> Donec dapibus pharetra placerat</p> <p class="animated fadeInRight animated-delay-2"><i class="fa fa-check"></i> Nam eu neque nec ante porttitor finibus</p> <p class="animated fadeInRight animated-delay-3"><i class="fa fa-check"></i> Nunc non risus vitae sapien laoreet vulputate ac suscipit lectus</p> <p class="animated fadeInRight animated-delay-4"><i class="fa fa-check"></i> Second raw denim you probably haven't heard of them jean shorts Austin.</p> <h6 class="animated fadeInRightBig animated-delay-5"><i class="fa fa-wordpress"></i> Wordpress</h6> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="VPN Hosting"][vc_row_inner][vc_column_inner width="1/4" el_class="animated fadeInLeft"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499265055878{margin-top: 40px !important;}" custom_src="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/server.png"][/vc_column_inner][vc_column_inner width="2/3" css=".vc_custom_1477404844760{padding-bottom: 20px !important;}"][vc_column_text] <h3 class="animated fadeInRight">Reliable and Secure Server</h3> <p class="animated fadeInRight animated-delay-1"><i class="fa fa-check"></i> Donec dapibus pharetra placerat</p> <p class="animated fadeInRight animated-delay-2"><i class="fa fa-check"></i> Nam eu neque nec ante porttitor finibus</p> <p class="animated fadeInRight animated-delay-3"><i class="fa fa-check"></i> Nunc non risus vitae sapien laoreet vulputate ac suscipit lectus</p> <p class="animated fadeInRight animated-delay-4"><i class="fa fa-check"></i> Second raw denim you probably haven't heard of them jean shorts Austin.</p> <h6 class="animated fadeInRightBig animated-delay-5"><i class="fa fa-wordpress"></i> Wordpress</h6> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Solutions"][vc_row_inner][vc_column_inner width="1/4" el_class="animated fadeInLeft"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499265064367{margin-top: 40px !important;}" custom_src="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/server.png"][/vc_column_inner][vc_column_inner width="2/3" css=".vc_custom_1477404852556{padding-bottom: 20px !important;}"][vc_column_text] <h3 class="animated fadeInRight">Reliable and Secure Server</h3> <p class="animated fadeInRight animated-delay-1"><i class="fa fa-check"></i> Donec dapibus pharetra placerat</p> <p class="animated fadeInRight animated-delay-2"><i class="fa fa-check"></i> Nam eu neque nec ante porttitor finibus</p> <p class="animated fadeInRight animated-delay-3"><i class="fa fa-check"></i> Nunc non risus vitae sapien laoreet vulputate ac suscipit lectus</p> <p class="animated fadeInRight animated-delay-4"><i class="fa fa-check"></i> Second raw denim you probably haven't heard of them jean shorts Austin.</p> <h6 class="animated fadeInRightBig animated-delay-5"><i class="fa fa-wordpress"></i> Wordpress</h6> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Protections"][vc_row_inner][vc_column_inner width="1/4" el_class="animated fadeInLeft"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499265071767{margin-top: 40px !important;}" custom_src="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/server.png"][/vc_column_inner][vc_column_inner width="2/3" css=".vc_custom_1477404861219{padding-bottom: 20px !important;}"][vc_column_text] <h3 class="animated fadeInRight">Reliable and Secure Server</h3> <p class="animated fadeInRight animated-delay-1"><i class="fa fa-check"></i> Donec dapibus pharetra placerat</p> <p class="animated fadeInRight animated-delay-2"><i class="fa fa-check"></i> Nam eu neque nec ante porttitor finibus</p> <p class="animated fadeInRight animated-delay-3"><i class="fa fa-check"></i> Nunc non risus vitae sapien laoreet vulputate ac suscipit lectus</p> <p class="animated fadeInRight animated-delay-4"><i class="fa fa-check"></i> Second raw denim you probably haven't heard of them jean shorts Austin.</p> <h6 class="animated fadeInRightBig animated-delay-5"><i class="fa fa-wordpress"></i> Wordpress</h6> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Text Only with Contacts', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/main-tabs-contact.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1492509113593{padding-top: 35px !important;}" responsive_css="padding_top_tablet:0"][vc_column offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1490028363501{margin-bottom: 65px !important;}"][vc_column_text] <h4><span style="color: #cfcfcf;">Based in</span></h4> [/vc_column_text][ra_tabs style="s18" use_resolve_effect="yes" title="test"][ra_tab_section title="Stockholm,"][vc_row_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Email us</span></h4> <h4 style="color: #000;">info@boolondon.com</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Find us</span></h4><h4 style="color: #000;">3rd Avenue, Upper East Side, San Francisco</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Call us</span></h4><h4 style="color: #000;">0 800 330 38 83</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1491310590572{padding-top: 40px !important;}"][ra_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(30,18,49,0.5)" hover_color="#1e1231" font_size="25px"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="London, "][vc_row_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Email us</span></h4> <h4 style="color: #000;">info@boolondon.com</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Find us</span></h4> <h4 style="color: #000;">3rd Avenue, Upper East Side, San Francisco</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Call us</span></h4> <h4 style="color: #000;">0 800 330 38 83</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1491310600425{padding-top: 40px !important;}"][ra_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(30,18,49,0.5)" hover_color="#1e1231" font_size="25px"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="San Francisco"][vc_row_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Email us</span></h4> <h4 style="color: #000;">info@boolondon.com</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Find us</span></h4> <h4 style="color: #000;">3rd Avenue, Upper East Side, San Francisco</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text] <h4><span style="color: #cfcfcf;">Call us</span></h4> <h4 style="color: #000;">0 800 330 38 83</h4> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1491310613770{padding-top: 40px !important;}"][ra_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22instagram%22%2C%22url%22%3A%22%23%22%7D%5D" primary_color="rgba(30,18,49,0.5)" hover_color="#1e1231" font_size="25px"][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Big Icons with Carousel', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/mobile-tabs-carousel.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1485349194366{padding-top: 70px !important;padding-bottom: 140px !important;background-color: #f9f9f9 !important;}"][vc_column][ra_section_title style="classic6" title=" Live Previews." css=".vc_custom_1479219161739{margin-bottom: 55px !important;}"][/ra_section_title][ra_tabs style="s15"][ra_tab_section i_type="linea" title="Portrait" i_icon_linea="icon-iphone"][ra_carousel style="mobile" autoplay="yes" image="" autoplaytime="3000"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot1.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot2.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot3.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot4.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot5.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot6.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot7.jpg"][/ra_carousel][/ra_tab_section][ra_tab_section i_type="linea" title="iPad" i_icon_linea="icon-ipad"][ra_carousel style="mobile" autoplay="yes" image="" autoplaytime="3000"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot1.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot2.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot3.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot4.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot5.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot6.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot7.jpg"][/ra_carousel][/ra_tab_section][ra_tab_section i_type="linea" title="Landscape" i_icon_linea="icon-iphone-landscape"][ra_carousel style="mobile" autoplay="yes" image="" autoplaytime="3000"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot1.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot2.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot3.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot4.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot5.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot6.jpg"][vc_single_image source="external_link" custom_src="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/screenshot7.jpg"][/ra_carousel][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Restaurant Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Minimal with Content Box', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/restaurant-tabs-with-content-boxes.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479492500736{padding-top: 45px !important;padding-bottom: 60px !important;}"][vc_column][ra_section_title style="classic4" title="Cuisine" content_font_container="tag:div" content_google_fonts="font_family:Pinyon%20Script%3Aregular|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_content="true"]mediterranean[/ra_section_title][ra_tabs style="s14"][ra_tab_section title="Breakfast"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12" pagedots="yes"][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][/ra_carousel][/ra_tab_section][ra_tab_section title="Lunch"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12" pagedots="yes"][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][/ra_carousel][/ra_tab_section][ra_tab_section title="Dinner"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12" pagedots="yes"][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][/ra_carousel][/ra_tab_section][ra_tab_section title="Meat"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12" pagedots="yes"][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][/ra_carousel][/ra_tab_section][ra_tab_section title="Fish"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12" pagedots="yes"][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][/ra_carousel][/ra_tab_section][ra_tab_section title="Chicken"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12" pagedots="yes"][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][ra_content_box image="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/content-box10.jpg" style="s9" title="Grilled Chicken Salad" info="23" img_link="url:%23|||"]Potato, Chicken, Olive oil, Salt[/ra_content_box][/ra_carousel][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University Calendar Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Calendar', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/university-calendar.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485443604533{padding-top: 85px !important;padding-bottom: 170px !important;}"][vc_column][ra_tabs style="s4" title="Upcoming Events"][ra_tab_section title="20|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3> <span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="19|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3> <span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="18|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3><span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="17|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3> <span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="16|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3><span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="15|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3><span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="14|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3><span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="13|SEP"][vc_row_inner equal_height="yes" content_placement="middle" css=".vc_custom_1485442460866{padding-right: 15px !important;padding-left: 15px !important;}"][vc_column_inner css=".vc_custom_1491982642085{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/tab-content5.png?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-6"][vc_single_image image="" img_size="full" invisible="yes"][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1491982677436{padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}"][vc_column_text css=".vc_custom_1486039594803{margin-bottom: 25px !important;}"] <h3><span style="color: #000000;">Book Fair</span></h3><span style="color: #767676;">Second raw denim you probably haven't heard of them jean shorts Austin. Nesciunt tofu stumptown aliqua, retro synth master cleanse.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486039605809{margin-bottom: 32px !important;}"]<i class="fa fa-check"></i><span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur</span><i class="fa fa-check"></i><span style="color: #767676;">Eu eleifend massa congue sed. Duis ut tellus purus.</span>[/vc_column_text][ra_button style="btn-default" size="btn-sm" border="border-thick" text="text-uppercase" i_type="fontawesome" i_align="right" title="View details" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right"][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//University Tabs vc-template
	$data = array();
	$data['name'] = esc_html__( 'Tabs Classic with Content Box', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/tabs/university-tabs.jpg' );
	$data['sort_name'] = 'Tabs';
	$data['custom_class'] = 'general tabs';
	$data['content'] = <<<CONTENT
[vc_row gap="15" css=".vc_custom_1485424081637{padding-top: 40px !important;padding-bottom: 50px !important;}"][vc_column][ra_section_title style="classic2" title="Lets meets!" content_font_container="tag:p" content_use_theme_fonts="yes" use_custom_fonts_content="true"]Orientation[/ra_section_title][/vc_column][vc_column parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Power2.easeOut" parallax_trigger="number" enable_reverse="no" css=".vc_custom_1499258724932{padding-top: 0px !important;}" offset="vc_col-md-6" translate_from_y="41" parallax_trigger_number="0.75" parallax_duration="0%"][ra_tabs style="s3"][ra_tab_section title="Welcome"][vc_row_inner equal_height="yes" content_placement="top"][vc_column_inner width="1/2"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499262222967{margin-bottom: -25px !important;}" custom_src="http://university.boowp.staging.wpengine.com/wp-content/uploads/sites/11/2016/10/person-1.jpg"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1479296528068{padding-left: 35px !important;}"][vc_column_text] <h3><span style="color: #000000;">We Are Boo</span></h3> <span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed fermentum dui malesuada eros pharetra, a consectetur ex viverra. Phasellus hendrerit a magna a posuere. Etiam a odio nec felis ullamcorper.</span> <span style="color: #000000;"><strong>YOUR DEAN</strong></span> <figure><img class="alignleft wp-image-9 size-full" src="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/signature.png" alt="signature" width="100" height="44" /></figure> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="History"][vc_row_inner equal_height="yes" content_placement="top"][vc_column_inner width="1/2"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499262232915{margin-bottom: -25px !important;}" custom_src="http://university.boowp.staging.wpengine.com/wp-content/uploads/sites/11/2016/10/person-1.jpg"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1479296528068{padding-left: 35px !important;}"][vc_column_text] <h3><span style="color: #000000;">We Are Boo</span></h3> <span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed fermentum dui malesuada eros pharetra, a consectetur ex viverra. Phasellus hendrerit a magna a posuere. Etiam a odio nec felis ullamcorper.</span> <span style="color: #000000;"><strong>YOUR DEAN</strong></span> <figure><img class="alignleft wp-image-9 size-full" src="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/signature.png" alt="signature" width="100" height="44" /></figure> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Vision"][vc_row_inner equal_height="yes" content_placement="top"][vc_column_inner width="1/2"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499262242774{margin-bottom: -25px !important;}" custom_src="http://university.boowp.staging.wpengine.com/wp-content/uploads/sites/11/2016/10/person-1.jpg"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1479296528068{padding-left: 35px !important;}"][vc_column_text] <h3><span style="color: #000000;">We Are Boo</span></h3> <span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed fermentum dui malesuada eros pharetra, a consectetur ex viverra. Phasellus hendrerit a magna a posuere. Etiam a odio nec felis ullamcorper.</span> <strong>YOUR DEAN</strong> <figure><img class="alignleft wp-image-9 size-full" src="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/signature.png" alt="signature" width="100" height="44" /></figure> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][ra_tab_section title="Mission"][vc_row_inner equal_height="yes" content_placement="top"][vc_column_inner width="1/2"][vc_single_image source="external_link" alignment="center" css=".vc_custom_1499262252631{margin-bottom: -25px !important;}" custom_src="http://university.boowp.staging.wpengine.com/wp-content/uploads/sites/11/2016/10/person-1.jpg"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1479296528068{padding-left: 35px !important;}"][vc_column_text] <h3><span style="color: #000000;">We Are Boo</span></h3> <span style="color: #767676;">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed fermentum dui malesuada eros pharetra, a consectetur ex viverra. Phasellus hendrerit a magna a posuere. Etiam a odio nec felis ullamcorper.</span> <strong>YOUR DEAN</strong> <figure><img class="alignleft wp-image-9 size-full" src="http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/signature.png" alt="signature" width="100" height="44" /></figure> [/vc_column_text][/vc_column_inner][/vc_row_inner][/ra_tab_section][/ra_tabs][/vc_column][vc_column width="1/2" parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Power2.easeOut" parallax_trigger="number" enable_reverse="no" css=".vc_custom_1499258782137{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-banner3.png?id=10) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-3" translate_from_y="42" to_delay="0.2" parallax_trigger_number="0.75" parallax_duration="0%"][ra_button style="btn-center" text="text-uppercase" others="btn-block" i_type="linea" i_align="right" scheme="btn-inverse" title="Study" text_color="#ffffff" hbg="rgba(221,51,51,0.01)" i_icon_linea="icon-basic_spread_text_bookmark" primary_color="#dd3333"][vc_separator color="custom" accent_color="rgba(255,255,255,0.2)" css=".vc_custom_1499257706630{margin-bottom: 0px !important;padding-top: 13px !important;padding-bottom: 13px !important;}"][ra_button style="btn-center" text="text-uppercase" others="btn-block" i_type="linea" i_align="right" scheme="btn-inverse" title="Research" link="url:%23|||" text_color="#ffffff" hbg="rgba(255,255,255,0.01)" i_icon_linea="icon-basic_share"][vc_separator color="custom" accent_color="rgba(255,255,255,0.2)" css=".vc_custom_1499257724362{margin-bottom: 0px !important;padding-top: 13px !important;padding-bottom: 13px !important;}"][ra_button style="btn-center" text="text-uppercase" others="btn-block" i_type="linea" i_align="right" scheme="btn-inverse" title="Work" link="url:%23|||" text_color="#ffffff" hbg="rgba(255,255,255,0.01)" i_icon_linea="icon-basic_notebook_pencil"][/vc_column][vc_column width="1/2" parallax="yes" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" to_easy="Power2.easeOut" parallax_trigger="number" enable_reverse="no" css=".vc_custom_1499258810652{padding-top: 0px !important;}" offset="vc_col-md-3" translate_from_y="42" to_delay="0.4" parallax_trigger_number="0.75" parallax_duration="0%"][vc_row_inner][vc_column_inner bg_position="center center" align="text-center" css=".vc_custom_1494402608188{margin-bottom: 20px !important;border-right-width: 15px !important;border-left-width: 15px !important;padding-top: 75px !important;padding-bottom: 70px !important;background-image: url(http://university.boo.themerella.com/wp-content/uploads/sites/11/2016/10/university-banner4.png?id=38) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;}"][ra_button style="btn-play" lightbox="yes" lightbox_type="video" alt_size="btn-sm" text="text-uppercase" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWVPRkcczXCY|||" title="take a tour" other="Play" text_color="#ffffff" second_color="#000000"][/vc_column_inner][vc_column_inner][ra_testimonial style="s12" avatar_size="avatar-xxs" title="John Doe" position="Student" avatar="http://university.boowp.staging.wpengine.com/wp-content/uploads/sites/11/2016/10/team-square.jpg" primary_color="#3598db"]Donec massa velit, iamet dictum et, volme tuahasellusu corper.[/ra_testimonial][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Team category
	//Colorful Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Colorful', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/agency-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1476867236285{margin-bottom: 180px !important;}"][vc_column][ra_section_title style="classic" title="Skilled People" css=".vc_custom_1484834493397{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="top-curve" name="Ben Smith" position="Chief" socials="%5B%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D" pos_color="" bg_color="" main_bg="#1ab9c8" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/team-1.jpg"]Lorem ipsum dolor dipiscing elit, sed do eiusmod[/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="top-curve" name="Alex Shephard" position="developer"  socials="%5B%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D" pos_color="" bg_color="" main_bg="#ca5737" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/team-2.jpg"]Lorem ipsum dolor dipiscing elit, sed do eiusmod[/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="top-curve" name="Micheal Scott" position="des?gner" socials="%5B%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D" pos_color="" bg_color="" main_bg="#62447b" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/team-3.jpg"]Lorem ipsum dolor dipiscing elit, sed do eiusmod[/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="top-curve" name="Pam Gabriel" position="MARKETING" socials="%5B%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%5D" pos_color="" bg_color="" main_bg="#e8b103" image="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/team-4.jpg"]Lorem ipsum dolor dipiscing elit, sed do eiusmod[/ra_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Colorful Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Gradient', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/gradient-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1497371781883{margin-bottom: 10px !important;padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="2/3" offset="vc_col-md-offset-2" css=".vc_custom_1496931634362{margin-bottom: 30px !important;}"][vc_custom_heading text="WHO WE ARE" font_container="tag:h6|font_size:16px|text_align:center|color:%2346dfb4" use_theme_fonts="yes" letter_spacing="0.3em" css=".vc_custom_1497371755686{margin-bottom: 35px !important;}"][vc_custom_heading text="Endeavor bachelor but add eat pleasure doubtful sociable. Age forming covered you entered the examine. " font_container="tag:h4|font_size:26px|text_align:center|color:%23ffffff|line_height:1.333em" use_theme_fonts="yes"][/vc_column][vc_column][vc_row_inner][vc_column_inner width="1/3" css_animation="none" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" parallax_from="``y``: 0, ``x``: 50, ``rotationY``: 35, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``" parallax_duration="0%" css=".vc_custom_1497448716689{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;border-radius: 10px !important;}" parallax_trigger_number="0.8"][ra_team_member template="hover-special" name="David Williams " position="Designer" image="http://boo.themerella.com/wp-content/uploads/2017/06/team-1-1.jpg" socials="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/3" css_animation="none" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" delay="200" parallax_from="``y``: 0, ``x``: 50, ``rotationY``: 35, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``, ``delay``: 0.15" parallax_duration="0%" css=".vc_custom_1497448243082{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;}" parallax_trigger_number="0.8"][ra_team_member template="hover-special" name="David Williams " position="Designer" image="http://boo.themerella.com/wp-content/uploads/2017/06/team-2.jpg" socials="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/3" css_animation="none" parallax="yes" parallax_preset="custom" parallax_trigger="number" enable_transform="yes" delay="400" parallax_from="``y``: 0, ``x``: 50, ``rotationY``: 35, ``opacity``: 0" parallax_to="``ease``: ``Quint.easeOut``, ``delay``: 0.3" parallax_duration="0%" css=".vc_custom_1497448253152{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;}" parallax_trigger_number="0.8"][ra_team_member template="hover-special" name="David Williams " position="Designer" image="http://boo.themerella.com/wp-content/uploads/2017/06/team-3-1.jpg" socials="%5B%7B%22network%22%3A%22facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%5D"][/ra_team_member][/vc_column_inner][vc_column_inner align="text-lg-center" css=".vc_custom_1497361054445{margin-top: 50px !important;}"][ra_button style="btn-solid" shape="round" title="Meet the Team" primary_color="#ffffff" hbg="#46dfb4" text_color="#020202" htext_color="#020202" fs="16px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Border Left', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/car-rental-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485751644457{padding-top: 50px !important;padding-bottom: 110px !important;}"][vc_column][ra_section_title style="underline5" title="Our Team" css=".vc_custom_1484544431432{margin-bottom: 90px !important;}"][/ra_section_title][vc_row_inner][vc_column_inner width="1/3"][ra_team_member image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/team113.jpg" template="border-bw" side_border="yes" name="Robert Clark" position="Co-Founder" link="|||" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D" border_color="#efa80f"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tempus arcu ut faucibus tempus.[/ra_team_member][/vc_column_inner][vc_column_inner width="1/3"][ra_team_member image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/team113.jpg" template="border-bw" side_border="yes" name="Robert Clark" position="Co-Founder" link="|||" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D" border_color="#efa80f"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tempus arcu ut faucibus tempus.[/ra_team_member][/vc_column_inner][vc_column_inner width="1/3"][ra_team_member image="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/team113.jpg" template="border-bw" side_border="yes" name="Robert Clark" position="Co-Founder" link="|||" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google%22%2C%22url%22%3A%22%23%22%7D%5D" border_color="#efa80f"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tempus arcu ut faucibus tempus.[/ra_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Cloud Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Colored Position', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/cloud-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485516748797{padding-top: 20px !important;padding-bottom: 65px !important;background-color: #fbfbfb !important;}"][vc_column][ra_section_title style="big" title="Support Ninjas." title_font_container="tag:h2" title_use_theme_fonts="yes" show_button="yes" ib_style="btn-naked" ib_i_type="fontawesome" ib_i_align="right" use_custom_fonts_title="true" ib_title="Apply for a job" ib_link="url:%23|||" ib_i_icon_fontawesome="fa fa-angle-right" ib_text_color="#30c2f9" ib_i_size="16px" ib_i_ml="9px" ib_fs="20px" css=".vc_custom_1485515459672{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore.aliqua.[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member image="http://cloud.boo.themerella.com/wp-content/uploads/sites/14/2016/11/team-1.jpg" template="hover-social" vertical="vertical" name="Jonathan Doe" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" name_size="22px" title_size="15px"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member image="http://cloud.boo.themerella.com/wp-content/uploads/sites/14/2016/11/team-2.jpg" template="hover-social" vertical="vertical" name="Alex Smith" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" name_size="22px" title_size="15px"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member image="http://cloud.boo.themerella.com/wp-content/uploads/sites/14/2016/11/team-3.jpg" template="hover-social" vertical="vertical" name="John Hopkins" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" name_size="22px" title_size="15px"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member image="http://cloud.boo.themerella.com/wp-content/uploads/sites/14/2016/11/team-4.jpg" template="hover-social" vertical="vertical" name="Kate Austen" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" name_size="22px" title_size="15px"][/ra_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Colored Position 3', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/corporate02-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484230471474{padding-top: 130px !important;}"][vc_column][ra_section_title style="thick2" title="advisors." css=".vc_custom_1484514227480{margin-bottom: 90px !important;}"] <hr /> [/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1485864988701{padding-bottom: 170px !important;}"][vc_column css=".vc_custom_1484230489838{padding-top: 0px !important;}"][ra_carousel columns="col-md-3 col-sm-6 col-xs-12"][ra_team_member template="hover-social" name="Alex Smith" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" name_color="#3d3985" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team41.jpg"][/ra_team_member][ra_team_member template="hover-social" name="Alex Smith" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" name_color="#3d3985" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team42.jpg"][/ra_team_member][ra_team_member template="hover-social" name="Alex Smith" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" name_color="#3d3985" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team43.jpg"][/ra_team_member][ra_team_member template="hover-social" name="Alex Smith" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" name_color="#3d3985" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team40.jpg"][/ra_team_member][ra_team_member template="hover-social" name="Alex Smith" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" name_color="#3d3985" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team41.jpg"][/ra_team_member][ra_team_member template="hover-social" name="Alex Smith" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" name_color="#3d3985" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team42.jpg"][/ra_team_member][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/corporate03-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1487417219284{padding-top: 90px !important;padding-bottom: 140px !important;}"][vc_column][ra_section_title style="thick3" title="Our Team" title_font_container="tag:h2|color:%23000000" title_use_theme_fonts="yes" use_custom_fonts_title="true"] <hr /> [/ra_section_title][vc_row_inner][vc_column_inner width="1/3"][ra_team_member template="border-bw" image="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/team-1-min.jpg" name="John Doe" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" social_color="rgba(0,0,0,0.5)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tempus arcu ut faucibus tempus.[/ra_team_member][/vc_column_inner][vc_column_inner width="1/3"][ra_team_member template="border-bw" image="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/team-2-min.jpg" name="John Doe" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" social_color="rgba(0,0,0,0.5)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tempus arcu ut faucibus tempus.[/ra_team_member][/vc_column_inner][vc_column_inner width="1/3"][ra_team_member template="border-bw" image="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/team-3-min.jpg" name="John Doe" position="Founder" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" social_color="rgba(0,0,0,0.5)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur tempus arcu ut faucibus tempus.[/ra_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Elegant Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Shadow', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/elegant-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gradient_bg="yes" css=".vc_custom_1485615029123{padding-top: 30px !important;padding-bottom: 40px !important;background-color: #fafafa !important;}" gradient_bg_color="linear-gradient(137deg,rgb(245, 242, 242) 0%,rgba(247, 244, 240, 0.6) 100%)|background-size: auto auto;background-position: 50% 50%;background-repeat: repeat;background-attachment: scroll;background-origin: border-box;background-clip: border-box;"][vc_column][ra_section_title style="underline" title="Skilled Team" content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" use_resolve_effect="yes" resolve_effect_seperator="chars"]<span style="color: #bcb3c9;">STAY HEALTHY.</span>[/ra_section_title][ra_carousel style="s3" columns="col-md-3 col-sm-6 col-xs-12" prevnextbuttons="yes"][ra_team_member template="cards" name="Pam Sharon" position="Sales" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/team40.jpg"][/ra_team_member][ra_team_member template="cards" name="Adam Smith" position="OPERATION" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/team41.jpg"][/ra_team_member][ra_team_member template="cards" name="Pam Sharon" position="Sales" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/team42.jpg"][/ra_team_member][ra_team_member template="cards" name="Pam Sharon" position="Operation" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/team43.jpg"][/ra_team_member][ra_team_member template="cards" name="Pam Sharon" position="Sales" socials="%5B%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://elegant.boo.themerella.com/wp-content/uploads/sites/2/2016/10/team40.jpg"][/ra_team_member][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Hosting Red Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Masonry', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/hostingred-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485272023345{margin-top: 110px !important;margin-bottom: 120px !important;}"][vc_column][ra_section_title style="underline3" title="Support Staff" content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true" css=".vc_custom_1479142286717{margin-bottom: 0px !important;}"]Ninjas[/ra_section_title][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="masonry" name="Ben Smith" position="Developer" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" main_bg="#eb3659" image="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/team75.jpg"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="masonry" info_up="team-details-up" name="Ben Smith" position="Developer" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" main_bg="#eb3659" image="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/team76.jpg"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="masonry" name="Ben Smith" position="Developer" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" main_bg="#eb3659" image="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/staff-1.jpg"][/ra_team_member][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ra_team_member template="masonry" info_up="team-details-up" name="Ben Smith" position="Developer" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" main_bg="#eb3659" image="http://hosting-red.boo.themerella.com/wp-content/uploads/sites/8/2016/10/staff-2.jpg"][/ra_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Contact Info', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/lawyer-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479289834434{padding-top: 10px !important;padding-bottom: 80px !important;background-color: #fbfbfb !important;}"][vc_column][ra_section_title style="underline4" title="Our Attorney" css=".vc_custom_1485437816341{margin-bottom: 5px !important;}"]Our trust policy protects you.[/ra_section_title][ra_carousel style="s5" columns="col-md-3 col-sm-6 col-xs-12" prevnextbuttons="yes"][ra_team_member template="contact-info" phone="232 992 32" email="nicole@boo.com" name="Niche Smith" position="Attorney" socials="%5B%7B%22network%22%3A%22behance%22%7D%5D" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/team34.jpg"]Claritas est etiam processus dynamicus, qui sequitur.[/ra_team_member][ra_team_member template="contact-info" phone="232 992 32" email="nicole@boo.com" name="Niche Smith" position="Attorney" socials="%5B%7B%22network%22%3A%22behance%22%7D%5D" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/team33.jpg"]Claritas est etiam processus dynamicus, qui sequitur.[/ra_team_member][ra_team_member template="contact-info" phone="232 992 32" email="nicole@boo.com" name="Niche Smith" position="Attorney" socials="%5B%7B%22network%22%3A%22behance%22%7D%5D" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/team35.jpg"]Claritas est etiam processus dynamicus, qui sequitur.[/ra_team_member][ra_team_member template="contact-info" phone="232 992 32" email="nicole@boo.com" name="Niche Smith" position="Attorney" socials="%5B%7B%22network%22%3A%22behance%22%7D%5D" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/team32.jpg"]Claritas est etiam processus dynamicus, qui sequitur.[/ra_team_member][ra_team_member template="contact-info" phone="232 992 32" email="nicole@boo.com" name="Niche Smith" position="Attorney" socials="%5B%7B%22network%22%3A%22behance%22%7D%5D" image="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/team34.jpg"]Claritas est etiam processus dynamicus, qui sequitur.[/ra_team_member][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Business Card', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/main-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_row_inner][vc_column_inner width="1/3"][ra_team_member template="minimal" phone="0 800 332 38 31" name="Jane Pearl" position="Attorney" image="" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D"]0 800 332 38 31[/ra_team_member][/vc_column_inner][vc_column_inner width="1/3"][ra_team_member template="minimal" phone="0 800 332 38 31" name="Alexander Smith" position="Attorney" image="" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D"]0 800 332 38 31[/ra_team_member][/vc_column_inner][vc_column_inner width="1/3"][ra_team_member template="minimal" phone="0 800 332 38 31" name="John Doe" position="Attorney" image="" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D"]0 800 332 38 31[/ra_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Team 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Minimal', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/main-team-2.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1492169720663{padding-top: 80px !important;padding-bottom: 50px !important;}"][vc_column width="1/2"][ra_team_member template="info-side" phone="phone: 0 233 392 38 83" socials="%5B%7B%22network%22%3A%22behance%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22linkedin%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22dribbble%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" link="url:%23|title:Read%20about%20me||" image="http://boo.themerella.com/wp-content/uploads/2017/03/team2-optimized.jpg"][/ra_team_member][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Main Team 3 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Gradient Hover', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/main2-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1490432735063{margin-bottom: 100px !important;}"][vc_column css=".vc_custom_1490445408342{margin-bottom: 60px !important;}"][ra_section_title style="default" title="Skilled Team" css=".vc_custom_1490442029928{margin-bottom: 0px !important;}"]Say Hello[/ra_section_title][/vc_column][vc_column width="1/3"][ra_team_member template="hover-special" name="Giovanni Bruno" position="Developer" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://boo.themerella.com/wp-content/uploads/2017/05/team12-2.jpg"][/ra_team_member][/vc_column][vc_column width="1/3"][ra_team_member template="hover-special" name="Francesco Rossi" position="Developer" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://boo.themerella.com/wp-content/uploads/2017/05/team_member3-1-1.png"][/ra_team_member][/vc_column][vc_column width="1/3"][ra_team_member template="hover-special" name="Valentina Bianchi" position="Developer" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%5D" image="http://boo.themerella.com/wp-content/uploads/2017/05/team_member4-1.png"][/ra_team_member][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Team vc-template
	$data = array();
	$data['name'] = esc_html__( 'Team Colored Position 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/team/mobile-team.jpg' );
	$data['sort_name'] = 'Team';
	$data['custom_class'] = 'general team';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1485357897151{padding-top: 60px !important;padding-bottom: 120px !important;background-color: #f9f9f9 !important;}"][vc_column align="text-center" css=".vc_custom_1485969394456{margin-bottom: 30px !important;}"][ra_section_title style="classic6" title="Skilled People"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam.[/ra_section_title][ra_button style="btn-naked" text="text-uppercase" i_type="fontawesome" i_align="right" title="Apply for a job" link="url:%23|||" i_icon_fontawesome="fa fa-angle-right" fw="500" fs="14px"][/vc_column][vc_column][ra_carousel columns="col-md-3 col-sm-6 col-xs-12" pagedots="yes"][ra_team_member image="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/team-1.jpg" template="hover-social" vertical="vertical" name="Jonathan Doe" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" title_size="11px"][/ra_team_member][ra_team_member image="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/team-2.jpg" template="hover-social" vertical="vertical" name="Jonathan Doe" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" title_size="11px"][/ra_team_member][ra_team_member image="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/team-3.jpg" template="hover-social" vertical="vertical" name="Jonathan Doe" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" title_size="11px"][/ra_team_member][ra_team_member image="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/team-4.jpg" template="hover-social" vertical="vertical" name="Jonathan Doe" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" title_size="11px"][/ra_team_member][ra_team_member image="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/hosting-team2.png" template="hover-social" vertical="vertical" name="Jonathan Doe" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" title_size="11px"][/ra_team_member][ra_team_member image="http://mobile.boo.themerella.com/wp-content/uploads/sites/9/2016/10/hosting-team3.png" template="hover-social" vertical="vertical" name="Jonathan Doe" position="Developer" link="url:%23|||" socials="%5B%7B%22network%22%3A%22google-plus%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22facebook%22%2C%22url%22%3A%22%23%22%7D%5D" title_size="11px"][/ra_team_member][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Testimonials Category
	//Agency Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials bubbles with clients', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/agency-testimonial.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484838311871{margin-bottom: 170px !important;padding-top: 20px !important;}"][vc_column][ra_section_title style="classic" title="Testimonials" css=".vc_custom_1484838240354{padding-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.[/ra_section_title][vc_row_inner css=".vc_custom_1476881141061{margin-bottom: 40px !important;}"][vc_column_inner width="1/2"][ra_testimonial style="s6" title="John Doe" company_link="url:%23||" company_name="envato.com"]These guys are the best. You should check out their portfolio. Don?t miss their holiday discounts.[/ra_testimonial][/vc_column_inner][vc_column_inner width="1/2"][ra_testimonial style="s6" title="John Doe" company_link="url:%23||" company_name="envato.com"]These guys are the best. You should check out their portfolio. Don?t miss their holiday discounts.[/ra_testimonial][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/4"][ra_client effect="client-border2" name="Lilys" logo="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/client2.png"][/vc_column_inner][vc_column_inner width="1/4"][ra_client effect="client-border2" name="Bakeries" logo="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/client1.png"][/vc_column_inner][vc_column_inner width="1/4"][ra_client effect="client-border2" name="Handmade" logo="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/client4.png"][/vc_column_inner][vc_column_inner width="1/4"][ra_client effect="client-border2" name="Fluffy" logo="http://agency.boo.themerella.com/wp-content/uploads/sites/3/2016/10/client3.png"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Text Only Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Text Only', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/text-only-testimonials.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_image="" parallax_speed_bg="1.65" css=".vc_custom_1497519962261{margin-bottom: 30px !important;padding-top: 70px !important;padding-bottom: 200px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/Testimonials-2.jpg) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="3/4" offset="vc_col-md-offset-1"][vc_row_inner][vc_column_inner parallax="yes" parallax_preset="custom" enable_transform="yes" parallax_from="``y``: 80, ``rotationX``: -45, ``opacity``: 0" parallax_duration="50%" parallax_to="``ease``: ``Quint.easeOut``"][vc_custom_heading text="?It is not enough that we build products that function, that are understandable and usable." font_container="tag:h3|font_size:40px|text_align:center|color:%2351423b|line_height:60px" google_fonts="font_family:Merriweather%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20italic%3A400%3Aitalic" css=".vc_custom_1497012157551{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner parallax="yes" parallax_preset="custom" parallax_from="``y``: 80, ``rotationX``: -25, ``opacity``: 0" parallax_duration="50%" parallax_to="``ease``: ``Quint.easeOut``"][vc_custom_heading text="Bruce Sanchez" font_container="tag:h6|font_size:18px|text_align:center|color:rgba(0%2C0%2C0%2C0.5)|line_height:1.2em" use_theme_fonts="yes" css=".vc_custom_1497011212391{margin-top: 40px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Text Only Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials With Clients', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/with-clients-testimonials.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" parallax="content-moving" parallax_speed_bg="1.2" css=".vc_custom_1497520250614{margin-bottom: 30px !important;padding-top: 120px !important;padding-bottom: 100px !important;background-image: url(http://boo.themerella.com/wp-content/uploads/2017/06/testimonial-1-bg.jpg) !important;background-position: center;background-repeat: no-repeat;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-md-3"][ra_client effect="client-opaque-inverted" name="Plain View" logo="http://boo.themerella.com/wp-content/uploads/2017/06/plain-view.svg"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_client effect="client-opaque-inverted" name="McKlein" logo="http://boo.themerella.com/wp-content/uploads/2017/06/mcklein-logo.svg"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_client effect="client-opaque-inverted" name="Tailor Maide" logo="http://boo.themerella.com/wp-content/uploads/2017/06/tailor_maide.svg"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ra_client effect="client-opaque-inverted" name="Metric" logo="http://boo.themerella.com/wp-content/uploads/2017/06/metric.svg"][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-2" css=".vc_custom_1497010030865{margin-top: 40px !important;}"][ra_carousel style="s3" pagedots="yes" dot_color="rgba(255,255,255,0.5)" dot_color_active="#50e2c1"][ra_testimonial style="s14" title="Bruce Sanchez" primary_color="#ffffff"]?It is not enough that we build products that function, that are understandable and usable, we also need to build products that bring joy and excitement.[/ra_testimonial][ra_testimonial style="s14" title="Bruce Sanchez" primary_color="#ffffff"]?It is not enough that we build products that function, that are understandable and usable, we also need to build products that bring joy and excitement.[/ra_testimonial][ra_testimonial style="s14" title="Bruce Sanchez" primary_color="#ffffff"]?It is not enough that we build products that function, that are understandable and usable, we also need to build products that bring joy and excitement.[/ra_testimonial][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Car Rental Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Inverse', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/car-rental-testimonials.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1484544684242{padding-top: 10px !important;padding-right: 20% !important;padding-bottom: 100px !important;padding-left: 20% !important;background-image: url(http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/car-rental-bg2.png?id=16) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="5/6" offset="vc_col-sm-offset-1"][vc_custom_heading text="Testimonials" font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1485751776363{margin-top: 30px !important;margin-bottom: 40px !important;}"][ra_carousel pagedots="yes" dot_color="#ffffff" dot_color_active="#f9c700"][ra_testimonial style="s14" title="Jason Smith" position="Co-Founder" avatar="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/team-square.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/ra_testimonial][ra_testimonial style="s14" title="Jason Smith" position="Co-Founder" avatar="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/team-square.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/ra_testimonial][ra_testimonial style="s14" title="Jason Smith" position="Co-Founder" avatar="http://car-rental.boo.themerella.com/wp-content/uploads/sites/13/2016/11/team-square.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce quis ultrices purus. Quisque ut feugiat augue. Vivamus rhoncus nulla elementum, vestibulum ante id, bibendum nisl.[/ra_testimonial][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Horizontal Border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/corporate01-testimonials.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479399457297{padding-top: 130px !important;padding-bottom: 60px !important;}"][vc_column][ra_section_title style="thick" title="clients." content_font_container="tag:div" content_use_theme_fonts="yes" use_custom_fonts_content="true"]Happy Results[/ra_section_title][vc_row_inner][vc_column_inner width="1/2"][ra_testimonial style="s15" avatar_size="avatar-sm" title="Melanie Doe" position="Developer" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/team-square.jpg"]At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium volupt.[/ra_testimonial][/vc_column_inner][vc_column_inner width="1/2"][ra_testimonial style="s15" avatar_size="avatar-sm" title="Melanie Doe" position="Developer" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/team-square.jpg"]At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium volupt.[/ra_testimonial][/vc_column_inner][vc_column_inner width="1/2"][ra_testimonial style="s15" avatar_size="avatar-sm" title="Melanie Doe" position="Developer" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/team-square.jpg"]At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium volupt.[/ra_testimonial][/vc_column_inner][vc_column_inner width="1/2"][ra_testimonial style="s15" avatar_size="avatar-sm" title="Melanie Doe" position="Developer" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate.boo.themerella.com/wp-content/uploads/sites/15/2016/11/team-square.jpg"]At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium volupt.[/ra_testimonial][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Corporate 2 Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Speech bubble', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/corporate02-testimonial.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1484514049275{padding-top: 125px !important;}"][vc_column][ra_section_title style="thick2" title="testimonails." css=".vc_custom_1484230872947{margin-bottom: 60px !important;}"] <hr /> [/ra_section_title][/vc_column][/vc_row][vc_row css=".vc_custom_1485864367330{padding-bottom: 160px !important;}"][vc_column css=".vc_custom_1484230115275{padding-top: 0px !important;}"][ra_carousel columns="col-md-4 col-sm-6 col-xs-12"][ra_testimonial style="s5" title="Adam Smith" position="Chief" primary_color="#f2774b" avatar="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/testi-4.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut laliqua.[/ra_testimonial][ra_testimonial style="s5" title="Adam Smith" position="Chief" primary_color="#f2784b" avatar="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/testi-5.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut laliqua.[/ra_testimonial][ra_testimonial style="s5" title="Adam Smith" position="Chief" primary_color="#f2784b" avatar="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/testi-6.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut laliqua.[/ra_testimonial][ra_testimonial style="s5" title="Adam Smith" position="Chief" primary_color="#f2784b" avatar="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team-square.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut laliqua.[/ra_testimonial][ra_testimonial style="s5" title="Adam Smith" position="Chief" primary_color="#f2784b" avatar="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/testi-5.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut laliqua.[/ra_testimonial][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate 2 Testimonials 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials featured image', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/corporate02-testimonails-2.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1485863373347{padding-top: 120px !important;padding-bottom: 170px !important;}"][vc_column][ra_section_title style="thick2" title="partners." css=".vc_custom_1484231424708{margin-bottom: 95px !important;}"] <hr /> [/ra_section_title][vc_row_inner][vc_column_inner width="1/2"][ra_team_member template="whole-bordered" name="Robert Clark" position="Chairman" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team-whole.jpg"]Lorem ipsum dolor sit amet, adipiscing elit. Duis consectetur auctor elit vehicula onec conse tetur risus dignissim justo faubus pretium.[/ra_team_member][/vc_column_inner][vc_column_inner width="1/2"][ra_team_member template="whole-bordered" name="Elisa Austen" position="Founder" socials="%5B%7B%22network%22%3A%22facebook%22%7D%5D" image="http://corporate-two.boo.themerella.com/wp-content/uploads/sites/16/2016/11/team-whole2.png"]Lorem ipsum dolor sit amet, adipiscing elit. Duis consectetur auctor elit vehicula onec conse tetur risus dignissim justo faubus pretium.[/ra_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Corporate 3 Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Rounded Image center', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/corporate03-testimonials.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1493127682290{padding-top: 100px !important;padding-bottom: 224px !important;}"][vc_column][ra_section_title style="thick3" title="Testimonials" title_font_container="tag:h2|color:%23000000" title_use_theme_fonts="yes" use_custom_fonts_title="true" css=".vc_custom_1493127726934{margin-bottom: 70px !important;}"] <hr /> [/ra_section_title][ra_carousel columns="col-md-4 col-sm-6 col-xs-12" pagedots="yes" size_dots="dots-md"][ra_testimonial style="s3" avatar_size="avatar-md2" title="John Doe" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/testi-1.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit fusce orci lacus, egestas eget viverra id, laoreet et libero.[/ra_testimonial][ra_testimonial style="s3" avatar_size="avatar-md2" title="John Doe" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/testi-2.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit fusce orci lacus, egestas eget viverra id, laoreet et libero.[/ra_testimonial][ra_testimonial style="s3" avatar_size="avatar-md2" title="John Doe" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/testi-3.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit fusce orci lacus, egestas eget viverra id, laoreet et libero.[/ra_testimonial][ra_testimonial style="s3" avatar_size="avatar-md2" title="John Doe" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/team-square.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit fusce orci lacus, egestas eget viverra id, laoreet et libero.[/ra_testimonial][ra_testimonial style="s3" avatar_size="avatar-md2" title="John Doe" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/team-whole.jpg"]Lorem ipsum dolor sit amet, consectetur adipiscing elit fusce orci lacus, egestas eget viverra id, laoreet et libero.[/ra_testimonial][ra_testimonial style="s3" avatar_size="avatar-md2" title="John Doe" company_name="envato.com" company_link="url:%23|||" avatar="http://corporate-three.boo.themerella.com/wp-content/uploads/sites/17/2016/11/team-whole2.png"]Lorem ipsum dolor sit amet, consectetur adipiscing elit fusce orci lacus, egestas eget viverra id, laoreet et libero.[/ra_testimonial][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Lawyer Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials rounded image with border', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/lawyer-testimonails.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1479288520950{padding-top: 70px !important;}"][vc_column][ra_section_title style="underline4" title="Trusted Clients"]Trusted partners from all over the world.[/ra_section_title][ra_carousel columns="col-md-4 col-sm-6 col-xs-12"][ra_testimonial style="s9" avatar_size="avatar-sm" title="Alex Smith" company_name="envato.com" company_link="url:%23|||" primary_color="#ed3a1c" avatar="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/avatar1.png"]Claritas est etiam processus dynamicus, qui sequitur mutationem.[/ra_testimonial][ra_testimonial style="s9" avatar_size="avatar-sm" title="Alex Smith" company_name="envato.com" company_link="url:%23|||" avatar="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/avatar2.png"]Claritas est etiam processus dynamicus, qui sequitur mutationem.[/ra_testimonial][ra_testimonial style="s9" avatar_size="avatar-sm" title="Alex Smith" company_name="envato.com" company_link="url:%23|||" avatar="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/avatar3.png"]Claritas est etiam processus dynamicus, qui sequitur mutationem.[/ra_testimonial][ra_testimonial style="s9" avatar_size="avatar-sm" title="Alex Smith" company_name="envato.com" company_link="url:%23|||" avatar="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/avatar1.png"]Claritas est etiam processus dynamicus, qui sequitur mutationem.[/ra_testimonial][ra_testimonial style="s9" avatar_size="avatar-sm" title="Alex Smith" company_name="envato.com" company_link="url:%23|||" avatar="http://lawyer.boo.themerella.com/wp-content/uploads/sites/10/2016/10/avatar2.png"]Claritas est etiam processus dynamicus, qui sequitur mutationem.[/ra_testimonial][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Main Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Split', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/main-testimonial.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row enable_responsive_options="yes" css=".vc_custom_1493674377392{padding-top: 185px !important;padding-bottom: 100px !important;}" responsive_css="padding_top_desktop:200|padding_bottom_desktop:50|padding_top_tablet:200|padding_bottom_tablet:0"][vc_column][ra_section_title style="resolve" title="Real Testimonials." use_resolve_effect="yes" resolve_effect_seperator="chars" css=".vc_custom_1490019792655{margin-bottom: 65px !important;}"][/ra_section_title][ra_testi_slider][ra_testi author="- THEMERELLA" image="http://boo.themerella.com/wp-content/uploads/2017/03/testimonials-2.jpg"]I dont know what else to say. This is something you haven't seen before. Unique design, high performance and outstanding support![/ra_testi][ra_testi author="- THEMERELLA" image="http://boo.themerella.com/wp-content/uploads/2017/03/testimonials-2.jpg"]I dont know what else to say. This is something you haven't seen before. Unique design, high performance and outstanding support![/ra_testi][ra_testi author="- THEMERELLA" image="http://boo.themerella.com/wp-content/uploads/2017/03/testimonials-2.jpg"]I dont know what else to say. This is something you haven't seen before. Unique design, high performance and outstanding support![/ra_testi][/ra_testi_slider][/vc_column][vc_column align="text-center" css=".vc_custom_1489502084876{margin-top: 90px !important;}"][ra_button style="btn-v-line" text="text-uppercase" title="Join The Club" link="url:%23|||" text_color="#000000" bc="#333333" hbc="#000000"][/vc_column][vc_column][ra_particles items="%5B%7B%22image%22%3A%224197%22%2C%22top_pos%22%3A%22-850px%22%2C%22left_pos%22%3A%22-50px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%20179%2C%20%5C%22y%5C%22%3A%20300%22%2C%22prlx_time%22%3A%221%22%2C%22prlx_duration%22%3A%221110%22%7D%2C%7B%22image%22%3A%224196%22%2C%22left_pos%22%3A%22150px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%20179%2C%20%5C%22y%5C%22%3A%20-100%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-850%22%2C%22prlx_duration%22%3A%222500%22%7D%2C%7B%22image%22%3A%224199%22%2C%22top_pos%22%3A%22-200px%22%2C%22right_pos%22%3A%22-50px%22%2C%22prlx_preset%22%3A%22custom%22%2C%22prlx_from%22%3A%22%5C%22rotationZ%5C%22%3A%20360%2C%20%5C%22scale%5C%22%3A%201.5%2C%20%5C%22y%5C%22%3A%200%22%2C%22prlx_to%22%3A%22%5C%22y%5C%22%3A%20-800%22%2C%22prlx_duration%22%3A%221970%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Main Testimonials 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Classic', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/main2-testimonials.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1490456301876{margin-bottom: 20px !important;}"][vc_column offset="vc_col-md-offset-2 vc_col-md-8"][ra_section_title style="default" title="Happy Customers" css=".vc_custom_1490433867694{margin-bottom: 40px !important;}"]Hear from them[/ra_section_title][ra_carousel style="s10" prevnextbuttons="yes"][ra_testimonial style="s13" avatar_size="avatar-sm" title="Laura Ricci" position="Designer" avatar="http://main-3.boo.themerella.com/wp-content/uploads/sites/28/2017/03/team_member1.png"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/ra_testimonial][ra_testimonial style="s13" avatar_size="avatar-sm" title="John Doe" position="Designer" avatar="http://main-3.boo.themerella.com/wp-content/uploads/sites/28/2017/03/team_member1.png"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed doeiusmod tempor incididunt utlaboreet dolore masna.[/ra_testimonial][ra_testimonial style="s13" avatar_size="avatar-sm" title="John Doe" position="Designer" avatar="http://main-3.boo.themerella.com/wp-content/uploads/sites/28/2017/03/team_member1.png"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed doeiusmod tempor incididunt utlaboreet dolore masna.[/ra_testimonial][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Mobile Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Minimal', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/minimal-testimonials.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row equal_height="yes" content_placement="top" css=".vc_custom_1497270902143{margin-top: 70px !important;margin-bottom: 90px !important;}"][vc_column width="2/3" parallax="yes" parallax_preset="custom" parallax_trigger="number" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-2" parallax_from="``opacity``: 0, ``scale``: 0.25" parallax_trigger_number="0.7" parallax_duration="0%"][vc_column_text] <h3 style="text-align: center;"><span style="color: #747e80;">Testimonials</span></h3> [/vc_column_text][/vc_column][vc_column width="2/3" parallax="yes" parallax_preset="custom" enable_transform="yes" offset="vc_col-md-offset-3 vc_col-md-6 vc_col-sm-offset-2" parallax_from="``opacity``: 0, ``rotationX``: -45, ``transformOrigin``: ``0% 0%``" parallax_duration="0%" parallax_to="``transformOrigin``: ``0% 0%``, ``ease``: ``Quint.easeOut``" parallax_offset="300"][ra_carousel pagedots="yes" adaptiveheight="yes"][vc_column_text] <h3 style="text-align: center;">?It is not enough that we build products that function, that are understandable and usable, we also need to build products that we trust.?</h3> <p style="text-align: center;"><span style="color: #999999;">Alta Rivera</span></p> [/vc_column_text][vc_column_text] <h3 style="text-align: center;">?It is not enough that we build products that function, that are understandable and usable, we also need to build products that we trust.?</h3> <p style="text-align: center;"><span style="color: #999999;">Alta Rivera</span></p> [/vc_column_text][vc_column_text] <h3 style="text-align: center;">?It is not enough that we build products that function, that are understandable and usable, we also need to build products that we trust.?</h3> <p style="text-align: center;"><span style="color: #999999;">Alta Rivera</span></p> [/vc_column_text][/ra_carousel][vc_empty_space height="80px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Shop Testimonials vc-template
	$data = array();
	$data['name'] = esc_html__( 'Testimonials Carousel with Instagram', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/testimonials/shop-tesitmonails.jpg' );
	$data['sort_name'] = 'Testimonials';
	$data['custom_class'] = 'general testimonial';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1492521700884{padding-top: 110px !important;padding-bottom: 130px !important;}"][vc_column width="1/2"][ra_instagram limit="9" show_button="yes" ib_style="btn-default" ib_size="btn-md" ib_text="text-uppercase" ib_others="wide" username="girlsheartfashion" ib_title="<strong>Follow on instagram</strong>" ib_link="url:%23|||" ib_text_color="#000000" ib_htext_color="#0a0a0a"][/vc_column][vc_column width="1/2" css=".vc_custom_1481809361129{padding-right: 60px !important;padding-left: 60px !important;}"][ra_section_title style="sub-underlined" title="Testimonials" el_class="mb-0" el_id="st-no-underline"]Share Your Story[/ra_section_title][ra_carousel style="s10" prevnextbuttons="yes"][ra_testimonial style="s13" avatar_size="avatar-sm" title="John Doe" position="Designer" avatar="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/client5.png"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed doeiusmod tempor incididunt utlaboreet dolore masna.[/ra_testimonial][ra_testimonial style="s13" avatar_size="avatar-sm" title="John Doe" position="Designer" avatar="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/client5.png"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed doeiusmod tempor incididunt utlaboreet dolore masna.[/ra_testimonial][ra_testimonial style="s13" avatar_size="avatar-sm" title="John Doe" position="Designer" avatar="http://store.boo.themerella.com/wp-content/uploads/sites/22/2016/12/client5.png"]Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed doeiusmod tempor incididunt utlaboreet dolore masna.[/ra_testimonial][/ra_carousel][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Text Category
	//Busines Contact vc-template
	$data = array();
	$data['name'] = esc_html__( 'Text Space', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/text/business08-contact.jpg' );
	$data['sort_name'] = 'Text';
	$data['custom_class'] = 'general text';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1493407325515{padding-top: 60px !important;padding-bottom: 75px !important;background-color: #f3ece9 !important;}"][vc_column][vc_row_inner css=".vc_custom_1493407272402{margin-bottom: 32px !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3"][vc_column_text]<span style="color: #2f43a9;">- New York City</span> <h6>( 272 ) 283 82 73</h6> <h6>5th Avenue, 87</h6> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][vc_column_text]<span style="color: #2f43a9;">- New York City</span> <h6>( 272 ) 283 82 73</h6> <h6>5th Avenue, 87</h6> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][vc_column_text]<span style="color: #2f43a9;">- Istanbul</span> <h6>( 272 ) 283 82 73</h6> <h6>5th Avenue, 87</h6> [/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][vc_column_text]<span style="color: #2f43a9;">- Berlin</span> <h6>( 272 ) 283 82 73</h6> <h6>5th Avenue, 87</h6> [/vc_column_text][/vc_column_inner][vc_column_inner width="2/3" align="text-center" offset="vc_col-md-offset-2"][vc_column_text] <h4><span style="color: #9d9d9d;">Like us on <span style="color: #2f43a9;"><a class="bar-fill-hover" style="color: #2f43a9;" href="#" target="">Facebook</a> </span>, Follow us on <span style="color: #2f43a9;"><a style="color: #2f43a9;" href="#">Twitter</a> </span>, Follow us on <span style="color: #2f43a9;"><a style="color: #2f43a9;" href="#">Dribbble</a> </span>, </span><span style="color: #9d9d9d;">View our projects on <span style="color: #2f43a9;"><a class="bar-fill-hover" style="color: #2f43a9;" href="#" target="">Behance</a></span></span></h4> [/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Portfolio text vc-template
	$data = array();
	$data['name'] = esc_html__( 'Text Heading Light', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/text/pf04-text.jpg' );
	$data['sort_name'] = 'Text';
	$data['custom_class'] = 'general text';
	$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_column_text css=".vc_custom_1491426243633{margin-bottom: 100px !important;}"] <h5 style="text-align: left;"><span style="color: #000000;">Brand identities, digital platforms ecommerce flagships, and creative content that bring culture and commerce together.</span><strong><span style="color: #000000;"> </span></strong></h5> [/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Portfolio text 2 vc-template
	$data = array();
	$data['name'] = esc_html__( 'Text Heading dark', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/text/pf05-text.jpg' );
	$data['sort_name'] = 'Text';
	$data['custom_class'] = 'general text';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1489766914067{margin-top: 50px !important;}"][vc_column css=".vc_custom_1489780958512{margin-bottom: 25px !important;}"][vc_column_text css=".vc_custom_1489856932949{margin-bottom: 50px !important;}"] <h4 style="text-align: left;"><strong>We create brand identities, digital platforms</strong> <strong>ecommerce flagships, and branded content that bring</strong> <strong>culture and commerce together.</strong></h4> [/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;	

	//Restaurant text vc-template
	$data = array();
	$data['name'] = esc_html__( 'Text Center with Image', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/text/restaurant-text.jpg' );
	$data['sort_name'] = 'Text';
	$data['custom_class'] = 'general text';
	$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1479490028618{margin-bottom: 100px !important;padding-top: 120px !important;}"][vc_column css_animation="fadeInLeft" css=".vc_custom_1485156216279{padding-right: 0px !important;padding-left: 0px !important;}" offset="vc_col-md-6"][vc_single_image source="external_link" alignment="center" custom_src="http://restaurant.boo.themerella.com/wp-content/uploads/sites/5/2016/10/restaurant-welcome.jpg"][/vc_column][vc_column css_animation="fadeInRight" align="text-center" css=".vc_custom_1485156766774{padding-top: 60px !important;padding-right: 4.5% !important;padding-bottom: 40px !important;padding-left: 4.5% !important;}" offset="vc_col-md-6"][ra_section_title style="classic4" title="Our Story" content_font_container="tag:div" content_google_fonts="font_family:Pinyon%20Script%3Aregular|font_style:400%20regular%3A400%3Anormal" use_custom_fonts_content="true" css=".vc_custom_1485871456852{margin-bottom: 30px !important;}"]welcome[/ra_section_title][vc_column_text css=".vc_custom_1486113643759{margin-bottom: 30px !important;padding-right: 30px !important;padding-left: 30px !important;}"]<span style="color: #7c7c82;">Fusce tincidunt gravida accumsan. Suspendisse ac luctus nib praesent ullamcorper diam, at vulputate libero. Lorem ipsum dolor sit amet adipiscing elit uisque sit amet.</span>[/vc_column_text][vc_column_text css=".vc_custom_1486113654242{margin-bottom: 35px !important;padding-right: 30px !important;padding-left: 30px !important;}"]<span style="color: #7c7c82;">Fed convallis fringilla aliquet. Aenean et pellentesque arcu. Aenean et maximus nulla. In rutrum nulla viverra.</span>[/vc_column_text][ra_button style="btn-underlined" border="border-thick" text="text-uppercase" title="Read our story" link="url:%23||" fs="13px" ls="0.25em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Split text vc-template
	$data = array();
	$data['name'] = esc_html__( 'Text Split', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/text/split-text.jpg' );
	$data['sort_name'] = 'Text';
	$data['custom_class'] = 'general text';
	$data['content'] = <<<CONTENT
[vc_row content_placement="top" css=".vc_custom_1497265055819{margin-bottom: 90px !important;}"][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_torigin_x="0%" to_torigin_y="0%" to_opacity="1" to_easy="Quint.easeOut" enable_transform="yes" css=".vc_custom_1500970290642{margin-top: -40px !important;}" parallax_duration="0%" parallax_offset="250" translate_from_y="51"][vc_column_text] <h3>Nice to meet you.</h3> [/vc_column_text][/vc_column][vc_column parallax="yes" width="1/2" parallax_preset="custom" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_torigin_x="left" from_torigin_y="top" from_opacity="0" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_torigin_x="50%" to_torigin_y="0%" to_opacity="1" to_easy="Quint.easeOut" enable_transform="yes" parallax_duration="0%" parallax_offset="250" translate_from_x="-45" rotate_from_y="-55"][vc_column_text]<span style="font-size: 18px; color: #747e80;">Unfeeling so rapturous discovery he exquisite. Reasonably so middletons or impression by terminated. Old pleasure required removing elegance him had.</span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Split text vc-template
	$data = array();
	$data['name'] = esc_html__( 'Text Split 2', 'boo' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  get_template_directory_uri() . '/rella/assets/img/rella_templates/text/split-text-2.jpg' );
	$data['sort_name'] = 'Text';
	$data['custom_class'] = 'general text';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" css=".vc_custom_1497374246383{padding-top: 70px !important;padding-bottom: 110px !important;}"][vc_column width="1/2"][vc_column_text]
<h5>I'm Thomas. This is my story.</h5> [/vc_column_text][vc_single_image image="18"][/vc_column][vc_column width="1/2" parallax="yes" parallax_preset="fadeInRightShort"][vc_column_text] <h5><span style="color: #ffffff;">I'm a freelance Mary gazed designer motion. She was not prepared for Sophia. As Mary stepped outside and Sophia came closer, she could see the sore glint in her eye. Sophia gazed with the affection of 2031 ruthless motionless maggots. She said, in hushed tones, "I love you and I want a fight."Mary looked back, even more sleepy and still fingering the enchanted newspaper.</span></h5> [/vc_column_text][/vc_column][vc_column width="1/2" parallax="yes" parallax_preset="fadeInLeftShort"][vc_column_text] <h5><span style="color: #ffffff;">On then sake home is am leaf. Of suspicion do departure at extremely he believing. Do know said mind do rent they oh hope of. General enquire picture letters garrets on offices of no on. Say one hearing between excited evening all inhabit thought you.</span></h5> [/vc_column_text][/vc_column][vc_column width="1/2"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	return $templates;
}