<?php
/*
 * General Section
 *
 * Available options on $section array:
 * separate_box (boolean) - separate metabox is created if true
 * box_title - title for separate metabox
 * title - section title
 * desc - section description
 * icon - section icon
 * fields - fields, @see https://docs.reduxframework.com/ for details
*/

$sections[] = array(
	'post_types' => array( 'post', 'page', 'rella-portfolio' ),
	'title' => esc_html__('Page', 'boo'),
	'icon' => 'el-icon-adjust-alt',
	'fields' => array(

		array(
			'id'        => 'page-layout-width',
			'type'      => 'button_set',
			'title'     => esc_html__( 'Layout width', 'boo' ),
			'subtitle'  => esc_html__( 'Controls the site layout width', 'boo' ),
			'options'   => array(
				'boxed'    => esc_html__( 'Boxed', 'boo' ),
				'0'        => esc_html__( 'Default', 'boo' ),
				'wide'     => esc_html__( 'Wide - 1270px', 'boo' ),
			),
			'default'   => '0'
		),

		//Body Background
		array(
			'id'       => 'body-background-type',
			'type'     => 'select',
			'title'    => esc_html__( 'Body Background Type', 'boo' ),
			'options'  => array(
				'solid'    => 'Solid',
				'gradient' => 'Gradient'
			),
			'required' => array(
				'page-layout-width',
				'equals',
				'boxed'
			),
		),

		array(
			'id'       => 'body-bg',
			'type'     => 'background',
			'preview'  => false,
			'title'  => esc_html__( 'Body Background', 'boo' ),
			'required' => array(
				'body-background-type',
				'equals',
				'solid'
			),
		),

		array(
			'id'       => 'body-bar-gradient',
			'type'     => 'gradient',
			'url'      => true,
			'title'    => esc_html__('Body Background Gradient', 'boo'),
			'required' => array(
				'body-background-type',
				'equals',
				'gradient'
			),
		),

		//Content Background
		array(
			'id'       => 'page-background-type',
			'type'     => 'select',
			'title'    => esc_html__( 'Content Background Type', 'boo' ),
			'options'  => array(
				'solid'    => 'Solid',
				'gradient' => 'Gradient'
			),
		),

		array(
			'id'       => 'page-bg',
			'type'     => 'background',
			'preview'  => false,
			'title'  => esc_html__( 'Content Background', 'boo' ),
			'required' => array(
				'page-background-type',
				'equals',
				'solid'
			),
		),

		array(
			'id'=>'page-bar-gradient',
			'type' => 'gradient',
			'url' => true,
			'title' => esc_html__('Content Background Gradient', 'boo'),
			'required' => array(
				'page-background-type',
				'equals',
				'gradient'
			),
		),

		array(
			'id' => 'content-padding',
			'type'	 => 'spacing',
			'title' => esc_html__('Content Padding', 'boo'),
			'left' => false, 'right' => false,
			'units' => array(
				'px',
				'%',
				'em',
				'rem'
			)
		),

		array(
			'id'    => 'enable-fullpage',
			'type'  => 'button_set',
			'title' => esc_html__( 'Enable Fullpage', 'boo' ),
			'desc'  => esc_html__( 'Enable to create row fullscreen with snap scroll navigation on right side', 'boo' ),
			'options' => array(
				'on'   => esc_html__( 'On', 'boo' ),
				'off'  => esc_html__( 'Off', 'boo' ),
			),
			'default'  => 'off',
		),

		array(
			'id'    => 'enable-fullpage-parallax',
			'type'  => 'button_set',
			'title' => esc_html__( 'Enable Fullpage Parallax', 'boo' ),
			'desc'  => esc_html__( 'Enable parallax effect for fullpage sections', 'boo' ),
			'required' => array(
				'enable-fullpage',
				'equals',
				'on'
			),
			'options' => array(
				'on'   => esc_html__( 'On', 'boo' ),
				'off'  => esc_html__( 'Off', 'boo' ),
			),
			'default'  => 'off',
		),

		array(
			'id'    => 'fullpage-header-visibility',
			'type'  => 'select',
			'title' => esc_html__( 'Header visibility', 'boo' ),
			'desc'  => esc_html__( 'Choose header can be visible always or only on first section.', 'boo' ),
			'required' => array(
				'enable-fullpage',
				'equals',
				'on'
			),
			'options' => array(
				'header-visible-always'   => esc_html__( 'Always visible', 'boo' ),
				'header-visible-first-section'  => esc_html__( 'Only visible on first section', 'boo' ),
			),
		),

		array(
			'id'    => 'fullpage-nav-style',
			'type'  => 'select',
			'title' => esc_html__( 'Fullpage navigation style', 'boo' ),
			'desc'  => esc_html__( 'Choose the nav for autogenerated navigation by fullpage', 'boo' ),
			'required' => array(
				'enable-fullpage',
				'equals',
				'on'
			),
			'options' => array(
				'style1'   => esc_html__( 'Style 1', 'boo' ),
				'style2'   => esc_html__( 'Style 2', 'boo' ),
				'style3'   => esc_html__( 'Style 3', 'boo' ),
			),
		),
		
		array(
			'id'    => 'enable-promo',
			'type'  => 'button_set',
			'title' => esc_html__( 'Enable Promo boxes', 'boo' ),
			'desc'  => esc_html__( 'Enable to show promo boxes', 'boo' ),
			'options' => array(
				'on'   => esc_html__( 'On', 'boo' ),
				'off'  => esc_html__( 'Off', 'boo' ),
			),
			'default'  => 'off',
		),
		
		array(
			'id'       => 'promo-positions',
			'type'     => 'select',
			'title'    => esc_html__( 'Promo boxes positions', 'boo' ),
			'options'  => array(
				'top'    => 'Top',
				'inpost' => 'In Content',
				'both'   => 'Both'
			),
			'required' => array(
				'enable-promo',
				'equals',
				'on'
			),
		),
		
		array(
			'id'       => 'promo-top-template',
			'type'     => 'select',
			'title'    => esc_html__( 'Top Promo box content', 'boo' ),
			'subtitle' => esc_html__( 'Select which promobox content post to display', 'boo' ),
			'data'     => 'post',
			'args'     => array( 
				'post_type'      => 'rella-promotions', 
				'posts_per_page' => -1 
			),
			'required'  => array(
				'promo-positions', 
				'!=', 
				'inpost'
			),
		),
		
		array(
			'id'       => 'promo-incontent-template',
			'type'     => 'select',
			'title'    => esc_html__( 'In post Promo box content', 'boo' ),
			'subtitle' => esc_html__( 'Select which promobox content post to display (works for single post only, and display after the Author Bio section)', 'boo' ),
			'data'     => 'post',
			'args'     => array( 
				'post_type'      => 'rella-promotions', 
				'posts_per_page' => -1 
			),
			'required'  => array(
				'promo-positions', 
				'!=', 
				'top'
			),
		),

	)
);
