<?php
if( ! empty($atts->mapkey) ) {

	$key = ( empty($atts->mapkey) ) ? self::myKEY : $atts->mapkey ;
	wp_register_script( 'pt-addon-gmaps', '//maps.googleapis.com/maps/api/js?key='.$atts->mapkey.'&callback=_ptAddon.front.shortcode.gmap.search', null, null, true );
	wp_enqueue_script( 'pt-addon-gmaps' );

	# Config
	$array = array(
		'key' => ( $atts->mapkey == '') ? false : $atts->mapkey,
		'zoom' => $atts->zoom,
		'center' => array('latitude' => $atts->center__latitude, 'longitude' => $atts->center__longitude),
		'controls' => array( 'pancontrol' => ( $atts->control__pancontrol  == '') ? false : true,
		                     'zoomcontrol' => ( $atts->control__zoomcontrol  == '') ? false : true,
		                     'addresscontrol' => ( $atts->control__addresscontrol  == '') ? false : true,
		                     'motiontrackingcontrol' => ( $atts->control__motiontrackingcontrol  == '') ? false : true,
		),
	);

	$config = esc_attr( json_encode( $array, JSON_FORCE_OBJECT));

	return
<<<HTML
		<div class="-wrap"  data-config="$config"></div>
HTML;


} else {
	$msgAlert = __('<b>Oops!</b><br>It looks like you forgot to set you google map key.', PT_VC_ADDON_GMAP_TEXTDOMAIN);

	return
<<<HTML
		<div class="-wrap -key-is-empty">
			<p>$msgAlert</p>
			<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 294.951 294.951" xmlns:xlink="http://www.w3.org/1999/xlink" enable-background="new 0 0 294.951 294.951">
			      <path d="m147.475,103.102c-5.22,0-8.701,3.48-8.701,8.701v62.644c0,5.22 3.48,8.701 8.701,8.701 5.22,0 8.701-3.48 8.701-8.701v-62.644c0-5.221-3.481-8.701-8.701-8.701z"/>
			      <path d="m152.695,212.73c-3.48-3.48-8.701-3.48-12.181,0-1.74,1.74-1.74,5.22-1.74,6.96 0,3.48 0,5.22 1.74,6.96 1.74,1.74 5.22,1.74 6.96,1.74 1.74,0 5.22,0 3.48-1.74 1.74-1.74 3.48-5.22 3.48-6.96 0.002-3.48 0.002-5.22-1.739-6.96z"/>
			      <path d="m288.425,214.47l-102.667-179.232c-6.96-13.921-22.621-22.621-38.283-22.621-15.661,0-29.582,8.701-38.283,22.621l-102.667,179.232c-8.701,13.921-8.701,31.322-5.32907e-15,45.243 6.96,13.921 22.621,22.621 38.283,22.621h205.334c17.401,0 31.322-8.701 38.283-22.621 8.701-13.921 8.701-31.322 0-45.243zm-13.921,38.283c-3.48,8.701-12.181,13.921-22.621,13.921h-207.075c-8.701,0-17.401-5.22-22.621-13.921-5.22-8.701-5.22-19.141 0-27.842l102.667-179.233c3.48-8.701 12.181-13.921 22.621-13.921 10.441,0 19.141,5.22 24.362,13.921l102.667,179.232c5.221,8.701 5.221,19.142 0,27.843z"/>
			</svg>
		</div>
HTML;

}