<?php

/**
 * Shortcode
 * Google Map | Street View
 *
 * @version     1
 * @since       1.0.0
 */
class WPBakeryShortCode_pt_addon__gmap_streetview extends WPBakeryShortCode {

	const myKEY = 'AIzaSyDxFG-1P4v4vbmucAb_d4a2iptAA4jmLbw';

	/**
	 * @param      $atts
	 * @param null $content
	 *
	 * @return mixed|void
	 */
	protected
	function content( $atts, $content = null ) {

		/**
		 * Extract var's from shortcode attributes
		 *
		 * @var object $atts
		 */
		$atts = (object) vc_map_get_attributes( $this->getShortcode(), $atts );

		/**
		 * Create a unique ID
		 *
		 * @since       1.0.0
		 */
		$atts->id = uniqid( $this->shortcode );
		$atts->layout = 'layout_1';

		/**
		 * Default Classes
		 *
		 * @since       1.0.0
		 */
		$elem_classes = array(
			$this->shortcode,
			'ptAddons--shortcode',
			"ptAddons--{$atts->layout}-style",
			"ptAddons--{$atts->align}-align",
			apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $atts->css, ' ' ), $atts->version, $atts )
		);

		/**
		 * Add Extra Classes
		 *
		 * @since       1.0.0
		 */
		$elem_classes = pixelThrone_vc_addon__gmap()->shortcodes->add__extra_classes( $atts->el_class, $elem_classes );

		/**
		 * Add View Port Classes
		 *
		 * @since       1.0.0
		 */
		$elem_classes = pixelThrone_vc_addon__gmap()->shortcodes->add__viewport_classes( $atts, $elem_classes );

		/**
		 * Add shortcode css to footer
		 *
		 * @since       1.0.0
		 */
		$inline_css = $this->add__footer_css( $atts );

		/**
		 * Animations
		 *
		 * @since       1.0.0
		 */
		$animations = pixelThrone_vc_addon__gmap()->shortcodes->get__animation( $atts );

		/*********************************************************************************************************************************/

//				print_r( "<pre>" );
//				print_r( $atts );
//				print_r( "</pre>" );

		/**
		 * Prepare classes output
		 *
		 * @since       1.0.0
		 */
		$classes = implode( ' ', array_filter( $elem_classes ) );

		/**
		 * Prepare classes output
		 *
		 * @since       1.0.0
		 */
		$layout = include __DIR__ . "/tpl/{$atts->layout}.tpl.php";

		/**
		 * Output HTML
		 *
		 * @since       1.0.0
		 */
		return
<<<HTML
			<div id="{$atts->id}" $animations class="$classes">
				$layout
			</div>
			$inline_css
HTML;
	}

	/**
	 * Add css to render on the footer
	 *
	 * @version     1.0.0
	 * @since       1.0.0
	 *
	 * @param       $atts object
	 * @return      mixed
	 */
	private
	function add__footer_css( $atts ) {
		$id = '#' . $atts->id;

		# Load Layout
		include __DIR__ . "/css.php/{$atts->layout}.css.php";

		# Global Css
		$scss =
<<<CSS
			$id {
				visibility: visible;

				$layout_scss

			}
CSS;

		$sass = new scssc();
		$sass->setFormatter("scss_formatter_compressed");
		$css =  $sass->compile($scss);

		if( pixelThrone_vc_addon__gmap()->vc->api->in_frontend_editor() ) {
			return "<style>$css</style>";
		} else {
			pixelThrone_vc_addon__gmap()->add__footer_css( $css );
		}
	}
}

