<?php
$group = __( 'Options', PT_VC_ADDON_GMAP_TEXTDOMAIN );
$icon = '<i class="dashicons dashicons-admin-links"></i>';
$flaticon =  '<span>'. $icon .'<a href="http://www.flaticon.com/search?word=map+pointer&search-type=icons" target="_black">' . __( "Free Icons", PT_VC_ADDON_GMAP_TEXTDOMAIN ) . '</a>' . '</span>';


return array(


	# Size
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Map Width', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'width',
		'value'            => '100',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-right-0px vc_column',
		'min'              => '0',
		'group'            => $group,
		'position'         => 'right',
	),
	# Unit
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => __( "Unit", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "width__unit",
		"value"            => "%",
		"style"            => "button",
		"buttons"          => array(
			array(
				'value' => 'px',
				'label' => __( 'px', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value' => '%',
				'label' => __( '%', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
		),
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-left-5px -addon-padding-right-0px -addon-margin-left--15px vc_column',
		"save_always"      => true,
		"group"            => $group,
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	# Size
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Map Height', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'height',
		'value'            => '300',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-right-0px -addon-padding-left-0px vc_column',
		'min'              => '0',
		'group'            => $group,
		'position'         => 'right',
	),
	# Unit
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => __( "Unit", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "height__unit",
		"value"            => "px",
		"style"            => "button",
		"buttons"          => array(
			array(
				'value' => 'px',
				'label' => __( 'px', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value' => 'vh',
				'label' => __( 'vh', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
		),
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-left-5px -addon-padding-right-0px -addon-margin-left--15px vc_column',
		"save_always"      => true,
		"group"            => $group,
	),

	# Alignment
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => __( "Alignment", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "align",
		"value"            => "left",
		"style"            => "image",
		"buttons"          => array(
			array(
				'value'   => 'left',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-left.png' ),
				'tooltip' => __( "Left", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'center',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-center.png' ),
				'tooltip' => __( "Center", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'right',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-right.png' ),
				'tooltip' => __( "Right", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
		),
		'edit_field_class' => 'vc_col-sm-4 -addon-padding-top-0px vc_column',
		"classes"          => "small",
		"positioning"      => "up",
		"save_always"      => true,
		"group"            => $group,
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	array(
		'type'             => 'pt_addon__empty_space',
		'param_name'       => 'options_empty_0',
		'height'           => '10',
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"group"            => $group,
	),
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	# Latitude
	array(
		'type'             => 'textfield',
		'heading'          => __( 'Center Latitude', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'center__latitude',
		'value'            => '38.719122',
		'edit_field_class' => 'vc_col-sm-4 -addon-border-radius vc_column',
		"save_always"      => true,
		"group"            => $group,
		'admin_label'      => true
	),

	# Longitude
	array(
		'type'             => 'textfield',
		'heading'          => __( 'Center Longitude', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'center__longitude',
		'value'            => '-9.134532',
		'edit_field_class' => 'vc_col-sm-4 -addon-border-radius -addon-padding-left-0px vc_column',
		"save_always"      => true,
		"group"            => $group,
		'admin_label'      => true
	),

	# Zoom Level
	array(
		'type'             => 'pt_addon__dropdown',
		'heading'          => __( 'Zoom', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'zoom',
		'value'            => '10',
		"list"             => array(
			'1'  => '1',
			'2'  => '2',
			'3'  => '3',
			'4'  => '4',
			'5'  => '5',
			'6'  => '6',
			'7'  => '7',
			'8'  => '8',
			'9'  => '9',
			'10' => '10',
			'11' => '11',
			'12' => '12',
			'13' => '13',
			'14' => '14',
			'15' => '15',
			'16' => '16',
			'17' => '17',
			'18' => '18',
			'19' => '19',
			'20' => '20',
		),
		'save_always'      => true,
		'group'            => $group,
		'edit_field_class' => 'vc_col-sm-3 -addon-padding-right-0px vc_column',
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	array(
		'type'             => 'pt_addon__empty_space',
		'param_name'       => 'empty_1',
		'height'           => '20',
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"group"            => $group,
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'options__tag_2',
		'tag'              => 'hr',
		'edit_field_class' => 'vc_col-sm-12 tag--hr m15px vc_column',
		"group"            => $group,
	),
	array(
		'type'             => 'textfield',
		'heading'          => __( 'Google Map Key', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mapkey',
		'value'            => '',
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"save_always"      => true,
		"group"            => $group,
		"description"      => 'All JavaScript API applications require authentication using an API key.<br>For more info please go to  <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank" >Google Maps JavaScript API developers website.</a>',
	),
);