;(function( _ptAddon, $ ) {

	Shortcode = (function() {
		/**
		 * Init
		 *
		 * @since    1.0.0
		 */
		var init = function( el ) {
			//console.log( "... Init: " );

			var $el = $( el ),
			    $wrap = $el.find('.-wrap' ),
			    config = $wrap.data('config' ),
			    mapElement = $wrap.get(0);

			if( $wrap.hasClass('-map-was-initiated') )
				return;

			if(typeof config == 'undefined')
				return;

			if(typeof google == 'undefined')
				return;


			 new google.maps.StreetViewPanorama(
				mapElement,
				{
					position: {lat: Number(config.center.latitude), lng: Number(config.center.longitude)},
					pov: {
						heading: 34,
						pitch: 10
					},
					zoom: config.controls.zoom,

					linksControl:config.controls.pancontrol,
					enableCloseButton:false,
					zoomControl:config.controls.zoomcontrol,
					addressControl:config.controls.addresscontrol,
					motionTrackingControl:config.controls.motiontrackingcontrol,
				});
		};

		return {
			init: init,
		};
	})();

	_ptAddon.front.shortcode.gmap_streetview = Shortcode;

})( _ptAddon, jQuery );
