<?php
$group = __( 'Responsive', PT_VC_ADDON_GMAP_TEXTDOMAIN );

$icon_md = '<i class="fa fa-tablet fa-rotate-90" title="Tablet landscape mode"></i>';
$icon_sm = '<i class="fa fa-tablet" title="Tablet portrait mode"></i>';
$icon_xs = '<i class="fa fa-mobile" title="Smartphone landscape mode"></i>';

return array(
	/**
	 * Medium Devices
	 *
	 * @since       1.0.0
	 */
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'tag_html_1',
		'tag'              => 'title',
		'title'            =>  $icon_md .  __( 'On Medium Devices', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'edit_field_class' => 'vc_col-sm-12 margin-bottom-15px param_title-plus-checkbox vc_column',
		'group'            => $group,
	),
	array(
		"type"             => 'pt_addon__checkbox',
		"param_name"       => "mediaquery_md",
		"value"            => '',
		"list"            => array(
			'label' => '',
			'value' => 'change'
		),
		"description"      => "",
		"group"            => $group,
		'edit_field_class' => 'vc_col-sm-12 checkbox-on-responsive-tab vc_column',
		"save_always"      => true,
	),

	# Size
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Font Size', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mediaquery_md__size',
		'value'            => '16',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3  padding-top-0px vc_column ',
		'unit'             => 'px',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'mediaquery_md',
			'value'   => 'change',
		),
	),

	# Line height
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Line height', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mediaquery_md__line_height',
		'value'            => '100',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3 padding-top-0px vc_column ',
		'unit'             => '%',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'mediaquery_md',
			'value'   => 'change',
		),
	),
	/**
	 * Alignment
	 *
	 * @since       1.0.0
	 */
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => __( "Alignment", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "mediaquery_md__align",
		"value"            => "left",
		"style"            => "image",
		"buttons"          => array(
			array(
				'value'   => 'left',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-left.png' ),
				'tooltip' => __( "Left", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'center',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-center.png' ),
				'tooltip' => __( "Center", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'right',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-right.png' ),
				'tooltip' => __( "Right", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			)
		),
		'edit_field_class' => 'vc_col-sm-4 padding-right-0px padding-top-0px vc_column',
		"classes"          => "small",
		"positioning"      => "up",
		"save_always"      => true,
		"group"            => $group,
		'dependency'       => array(
			'element' => 'mediaquery_md',
			'value'   => 'change',
		),
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'tag_1',
		'tag'               => 'hr',
		'edit_field_class' => 'vc_col-sm-12 m10px tag--hr padding-top-0px vc_column',
		"group"            => $group,
	),
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'tag_html_2',
		'tag'              => 'hr+title',
		'title'            => $icon_sm .  __( 'On Tablet Portrait', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'edit_field_class' => 'vc_col-sm-12 tag--hr m20px  param_title-plus-checkbox hr-0-opacity vc_column',
		'group'            => $group,
	),
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	/**
	 * Tablet Portrait
	 *
	 * @since       1.0.0
	 */
	array(
		"type"             => 'pt_addon__checkbox',
		"param_name"       => "mediaquery_sm",
		"value"            => '',
		"list"            => array(
			'label' => '',
			'value' => 'change'
		),
		"description"      => "",
		"group"            => $group,
		'edit_field_class' => 'vc_col-sm-12 checkbox-on-responsive-tab vc_column',
		"save_always"      => true,
	),

	# Size
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Font Size', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mediaquery_sm__size',
		'value'            => '16',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3  padding-top-0px vc_column ',
		'unit'             => 'px',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'mediaquery_sm',
			'value'   => 'change',
		),
	),

	# Line height
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Line height', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mediaquery_sm__line_height',
		'value'            => '100',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3 padding-top-0px vc_column ',
		'unit'             => '%',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'mediaquery_sm',
			'value'   => 'change',
		),
	),
	/**
	 * Alignment
	 *
	 * @since       1.0.0
	 */
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => __( "Alignment", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "mediaquery_sm__align",
		"value"            => "left",
		"style"            => "image",
		"buttons"          => array(
			array(
				'value'   => 'left',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-left.png' ),
				'tooltip' => __( "Left", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'center',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-center.png' ),
				'tooltip' => __( "Center", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'right',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-right.png' ),
				'tooltip' => __( "Right", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			)
		),
		'edit_field_class' => 'vc_col-sm-4 padding-right-0px padding-top-0px vc_column',
		"classes"          => "small",
		"positioning"      => "up",
		"save_always"      => true,
		"group"            => $group,
		'dependency'       => array(
			'element' => 'mediaquery_sm',
			'value'   => 'change',
		),
	),


	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'tag_2',
		'tag'               => 'hr',
		'edit_field_class' => 'vc_col-sm-12 m10px tag--hr padding-top-0px vc_column',
		"group"            => $group,
	),
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'tag_html_2',
		'tag'              => 'hr+title',
		'title'            => $icon_xs .  __( 'On Smartphone', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'edit_field_class' => 'vc_col-sm-12 tag--hr m20px  param_title-plus-checkbox hr-0-opacity vc_column',
		'group'            => $group,
	),
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	/**
	 * Smartphone
	 *
	 * @since       1.0.0
	 */
	array(
		"type"             => 'pt_addon__checkbox',
		"param_name"       => "mediaquery_xs",
		"value"            => '',
		"list"            => array(
			'label' => '',
			'value' => 'change'
		),
		"description"      => "",
		"group"            => $group,
		'edit_field_class' => 'vc_col-sm-12 checkbox-on-responsive-tab vc_column',
		"save_always"      => true,
	),
	# Size
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Font Size', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mediaquery_xs__size',
		'value'            => '16',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3 padding-top-0px vc_column ',
		'unit'             => 'px',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'mediaquery_xs',
			'value'   => 'change',
		),
	),

	# Line height
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => __( 'Line height', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mediaquery_xs__line_height',
		'value'            => '100',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3 padding-top-0px vc_column ',
		'unit'             => '%',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'mediaquery_xs',
			'value'   => 'change',
		),
	),
	/**
	 * Alignment
	 *
	 * @since       1.0.0
	 */
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => __( "Alignment", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "mediaquery_xs__align",
		"value"            => "left",
		"style"            => "image",
		"buttons"          => array(
			array(
				'value'   => 'left',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-left.png' ),
				'tooltip' => __( "Left", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'center',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-center.png' ),
				'tooltip' => __( "Center", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'right',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-right.png' ),
				'tooltip' => __( "Right", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			)
		),
		'edit_field_class' => 'vc_col-sm-4 padding-right-0px padding-top-0px vc_column',
		"classes"          => "small",
		"positioning"      => "up",
		"save_always"      => true,
		"group"            => $group,
		'dependency'       => array(
			'element' => 'mediaquery_xs',
			'value'   => 'change',
		),
	),
);