<?php
$group    = esc_html__( 'Options', PT_VC_ADDON_GMAP_TEXTDOMAIN );
$icon     = '<i class="dashicons dashicons-admin-links"></i>';
$flaticon = '<span>' . $icon . '<a href="http://www.flaticon.com/search?word=map+pointer&search-type=icons" target="_black">' . esc_html__( "Free Icons", PT_VC_ADDON_GMAP_TEXTDOMAIN ) . '</a>' . '</span>';
$tooltip  = '<span data-balloon-pos="right" data-balloon="Leave empty if you do not want to use."><i class="fa fa-question-circle" ></i></span>';

return array(

	# Size
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => esc_html__( 'Map Width', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'width',
		'value'            => '100',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-right-0px vc_column',
		'min'              => '0',
		'group'            => $group,
		'position'         => 'right',
	),
	# Unit
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => esc_html__( "Unit", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "width__unit",
		"value"            => "%",
		"style"            => "button",
		"buttons"          => array(
			array(
				'value' => 'px',
				'label' => esc_html__( 'px', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value' => '%',
				'label' => esc_html__( '%', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
		),
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-left-5px -addon-padding-right-0px -addon-margin-left--15px vc_column',
		"save_always"      => true,
		"group"            => $group,
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	# Size
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => esc_html__( 'Map Height', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'height',
		'value'            => '300',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-right-0px -addon-padding-left-0px vc_column',
		'min'              => '0',
		'group'            => $group,
		'position'         => 'right',
	),
	# Unit
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => esc_html__( "Unit", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "height__unit",
		"value"            => "px",
		"style"            => "button",
		"buttons"          => array(
			array(
				'value' => 'px',
				'label' => esc_html__( 'px', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value' => 'vh',
				'label' => esc_html__( 'vh', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
		),
		'edit_field_class' => 'vc_col-sm-2 -addon-padding-top-0px -addon-padding-left-5px -addon-padding-right-0px -addon-margin-left--15px vc_column',
		"save_always"      => true,
		"group"            => $group,
	),

	# Alignment
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => esc_html__( "Alignment", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "align",
		"value"            => "left",
		"style"            => "image",
		"buttons"          => array(
			array(
				'value'   => 'left',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-left.png' ),
				'tooltip' => esc_html__( "Left", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'center',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-center.png' ),
				'tooltip' => esc_html__( "Center", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value'   => 'right',
				'img'     => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_URI', 'img/params/horizontal_align-right.png' ),
				'tooltip' => esc_html__( "Right", PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
		),
		'edit_field_class' => 'vc_col-sm-4 -addon-padding-top-0px vc_column',
		"classes"          => "small",
		"positioning"      => "up",
		"save_always"      => true,
		"group"            => $group,
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	array(
		'type'             => 'pt_addon__empty_space',
		'param_name'       => 'options_empty_0',
		'height'           => '10',
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"group"            => $group,
	),
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	# Latitude
	array(
		'type'             => 'textfield',
		'heading'          => esc_html__( 'Center Latitude', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'center__latitude',
		'value'            => '38.719122',
		'edit_field_class' => 'vc_col-sm-4 -addon-border-radius vc_column',
		"save_always"      => true,
		"group"            => $group,
		'admin_label'      => true
	),

	# Longitude
	array(
		'type'             => 'textfield',
		'heading'          => esc_html__( 'Center Longitude', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'center__longitude',
		'value'            => '-9.134532',
		'edit_field_class' => 'vc_col-sm-4 -addon-border-radius -addon-padding-left-0px vc_column',
		"save_always"      => true,
		"group"            => $group,
		'admin_label'      => true
	),

	# Zoom Level
	array(
		'type'             => 'pt_addon__dropdown',
		'heading'          => esc_html__( 'Zoom', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'zoom',
		'value'            => '10',
		"list"             => array(
			'1'  => '1',
			'2'  => '2',
			'3'  => '3',
			'4'  => '4',
			'5'  => '5',
			'6'  => '6',
			'7'  => '7',
			'8'  => '8',
			'9'  => '9',
			'10' => '10',
			'11' => '11',
			'12' => '12',
			'13' => '13',
			'14' => '14',
			'15' => '15',
			'16' => '16',
			'17' => '17',
			'18' => '18',
			'19' => '19',
			'20' => '20',
		),
		'save_always'      => true,
		'group'            => $group,
		'edit_field_class' => 'vc_col-sm-3 -addon-padding-right-0px vc_column',
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	array(
		'type'             => 'pt_addon__empty_space',
		'param_name'       => 'empty_1',
		'height'           => '20',
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"group"            => $group,
	),
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'options__tag_1',
		'tag'              => 'hr',
		'edit_field_class' => 'vc_col-sm-12 tag--hr m15px vc_column',
		"group"            => $group,
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


	array(
		'type'             => 'param_group',
		'param_name'       => 'markers',
		'heading'          => esc_html__( 'Markers', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"group"            => $group,
		'value'            => '%5B%7B%22latitude%22%3A%2238.719122%22%2C%22longitude%22%3A%22-9.134532%22%2C%22title%22%3A%22%22%2C%22description%22%3A%22%22%7D%5D',
		'params'           => array(

			# Latitude
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Latitude', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
				'param_name'       => 'latitude',
				'value'            => '',
				'edit_field_class' => 'vc_col-sm-4 -addon-padding-top-0px vc_column',
				"save_always"      => true,
				"group"            => $group,
			),
			# Longitude
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Longitude', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
				'param_name'       => 'longitude',
				'value'            => '',
				'edit_field_class' => 'vc_col-sm-4 -addon-padding-top-0px vc_column',
				"save_always"      => true,
				"group"            => $group,
			),
			# Image
			array(
				"type"             => "attach_image",
				"heading"          => esc_html__( "Image  ", PT_VC_ADDON_GMAP_TEXTDOMAIN ) . $flaticon,
				"param_name"       => "image",
				'edit_field_class' => 'vc_col-sm-4 -addon-padding-top-0px vc_column',
				"group"            => $group,
			),
			# Max Width
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Info Max width', PT_VC_ADDON_GMAP_TEXTDOMAIN ) . $tooltip,
				'param_name'       => 'maxwidth',
				'value'            => '',
				'edit_field_class' => 'vc_col-sm-4 vc_column',
				"save_always"      => true,
				"group"            => $group,
			),
			# Title
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Title', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
				'param_name'       => 'title',
				'value'            => '',
				'edit_field_class' => 'vc_col-sm-8 vc_column',
				"save_always"      => true,
				"group"            => $group,
				'admin_label'      => true,
			),
			# Description
			array(
				'type'             => 'textarea',
				'heading'          => esc_html__( 'Description', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
				'param_name'       => 'description',
				'value'            => '',
				'edit_field_class' => 'vc_col-sm-12 vc_column',
				"save_always"      => true,
				"group"            => $group,
			),
		)
	),


	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'options__tag_2',
		'tag'              => 'hr',
		'edit_field_class' => 'vc_col-sm-12 tag--hr m15px vc_column',
		"group"            => $group,
	),
	array(
		'type'             => 'textfield',
		'heading'          => esc_html__( 'Google Map Key', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'mapkey',
		'value'            => '',
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"save_always"      => true,
		"group"            => $group,
		"description"      => 'All JavaScript API applications require authentication using an API key.<br>For more info please go to  <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank" >Google Maps JavaScript API developers website.</a>',
	),
);