;(function( _ptAddon, $ ) {

	Shortcode = (function() {
		var search = function() {
			//console.log( "... Procura: " );
			$('.pt_addon__gmap').each(function() {
				new init( this );
			});
			$('.pt_addon__gmap_streetview').each(function() {
				new _ptAddon.front.shortcode.gmap_streetview.init( this );
			});
		};

		/**
		 * Init
		 *
		 * @since    1.0.0
		 */
		var init = function( el ) {
			//console.log( "... Init: " );

			var $el = $( el ),
			    $wrap = $el.find('.-wrap' ),
			    config = $wrap.data('config' );

			if( $wrap.hasClass('-map-was-initiated') )
				return;

			if(typeof config == 'undefined')
				return;

			if(typeof google == 'undefined')
				return;


			config.center.latitude = config.center.latitude.replace(/[^\d.-]/g, '');
			config.center.longitude = config.center.longitude.replace(/[^\d.-]/g, '');

			// Start Map
			google.maps.event.addDomListener(window, 'load', buildMap($el, $wrap, config));
		};
		/**
		 * Build Map
		 *
		 * @since    1.0.0
		 */
		var buildMap = function($el, $wrap, config) {
			$wrap.addClass('-map-was-initiated');

			var mapOptions = {
				zoom: Number(config.zoom),
				center: new google.maps.LatLng(Number(config.center.latitude), Number(config.center.longitude)),

				zoomControl: config.controls.zoom,
				mapTypeControl: config.controls.maptype,
				scaleControl: config.controls.scale,
				streetViewControl: config.controls.streetview,
				rotateControl: config.controls.rotate,
				fullscreenControl: false,
				scrollwheel: config.controls.scrollwheel
			};

			if( config.style != '' ) {  mapOptions.styles = JSON.parse(config.style) }

			var mapElement = $wrap.get(0);
			var map = new google.maps.Map(mapElement, mapOptions);

			// Add Markers
			if ( config.markers != '' ) {
				var infowindow = [];

				$.each(config.markers, function( index, value ) {

					var _marker = {
						position: new google.maps.LatLng(value.latitude, value.longitude),
						map: map,
						animation: google.maps.Animation.DROP
					};

					// Add Image
					if( value.image != '' ) { _marker.icon = value.image; }

					// Add Title
					if( value.title != '' ) { _marker.title = value.title; }

					// Add Description
					if( value.description != '' ) {
						var infoWindow_Object = {
							content: '<div><strong>' + value.title + '</strong><br>' + value.description + '</div>'
						};

						// Add Max Width
						if( value.maxwidth ) { infoWindow_Object.maxWidth = value.maxwidth; }

						infowindow[index] = new google.maps.InfoWindow(infoWindow_Object);
					}

					// Add Maker
					var marker = new google.maps.Marker(_marker);

					// Bind Click
					if( value.description != '' ) {
						marker.addListener( 'click', function() {
							infowindow[index].open( map, marker );
						} );
					}
				});
			}

			// FullScreen Button
			$el.find('.-fullscreen').click(function(){
				$el.toggleClass('-fullscreen-mode');
				google.maps.event.trigger(map, 'resize');
				map.setCenter(mapOptions.center);
				return false;
			});
		};

		return {
			init: init,
			search: search
		};
	})();

	_ptAddon.front.shortcode.gmap = Shortcode;

})( _ptAddon, jQuery );