<?php
$group = __( 'Animation', PT_VC_ADDON_GMAP_TEXTDOMAIN );

# Add Extend Param
if( isset($activeParam) ) {
	$activeParam = array(
		"type"             => "pt_addon__checkbox",
		"param_name"       => "animation",
		"value"            => '',
		"list"             => array(
			'label' => 'Activate',
			'value' => 'activate'
		),
		"description"      => "",
		"group"            => $group,
		'edit_field_class' => 'vc_col-sm-3 -addon-padding-top-0px vc_column',
		"save_always"      => true,
		"dependency"       => array(
			'element' => "extend",
			'value'   => array( 'true' )
		),
	);
} else {
	$activeParam = array(
		"type"             => "pt_addon__checkbox",
		"param_name"       => "animation",
		"value"            => '',
		"list"             => array(
			'label' => 'Activate',
			'value' => 'activate'
		),
		"description"      => "",
		"group"            => $group,
		'edit_field_class' => 'vc_col-sm-3 -addon-padding-top-0px vc_column',
		"save_always"      => true,
	);
}



return array(
	# Enable
	$activeParam,
	# Advanced Options
	array(
		"type"             => "pt_addon__checkbox",
		"param_name"       => "animation__advanced",
		"value"            => '',
		"list"             => array(
			'label' => 'Advanced Options',
			'value' => 'activate'
		),
		"description"      => "",
		"group"            => $group,
		'edit_field_class' => 'vc_col-sm-5 -addon-padding-top-0px  vc_column',
		"save_always"      => true,
		'dependency'       => array(
			'element' => 'animation',
			'value'   => 'activate',
		),
	),


	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'animation__tag_01',
		'tag'               => 'hr',
		'edit_field_class' => 'vc_col-sm-12 tag--hr m10px -addon-padding-top-0px vc_column',
		"group"            => $group,
		'dependency'       => array(
			'element' => 'animation',
			'value'   => 'activate',
		),
	),
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


	# Animations
	array(
		'type'             => 'pt_addon__dropdown',
		'heading'          => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("There are serveral predefined animations you can use already.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'right') . __( 'Animations', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'animation__animations',
		'value'            => 'fade-up',
		'list'             => pixelThrone_vc_addon__gmap()->shortcodes->get__option( 'animation_types' ),
		'edit_field_class' => 'vc_col-sm-6 vc_column',
		"group"            => $group,
		'save_always'      => true,
		'dependency'       => array(
			'element' => 'animation',
			'value'   => 'activate',
		),
	),
	# Preview
	array(
		'type'             => 'pt_addon__animation_preview',
		'heading'          => '',
		'param_name'       => 'animation__preview',
		'value'            => '',
		'edit_field_class' => 'vc_col-sm-4 vc_column ',
		'group'            => $group,
		'dependency'       => array(
			'element' => 'animation',
			'value'   => 'activate',
		),
	),

	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	array(
		'type'             => 'pt_addon__empty_space',
		'param_name'       => 'animation__empty_1',
		'height'           => '0',
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"group"            => $group,
		'dependency'       => array(
			'element' => 'animation',
			'value'   => 'activate',
		),
	),
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	# Duration
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("Duration of animation.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'right') . __( 'Duration', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'animation__duration',
		'value'            => '0.8',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3 vc_column ',
		'unit'             => 's',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'animation',
			'value'   => 'activate',
		),
	),
	# Delay
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("Delay animation.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'right') . __( 'Delay', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'animation__delay',
		'value'            => '0',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3 -addon-padding-bottom-10px vc_column ',
		'unit'             => 's',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'animation',
			'value'   => 'activate',
		),
	),


	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
	array(
		'type'             => 'pt_addon__tag',
		'param_name'       => 'animation__tag_02',
		'tag'               => 'hr',
		'edit_field_class' => 'vc_col-sm-12 tag--hr m15px vc_column',
		"group"            => $group,
		'dependency'       => array(
			'element' => 'animation__advanced',
			'value'   => 'activate',
		),
	),
	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


	# Easing
	array(
		'type'             => 'dropdown',
		'heading'          => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("Choose timing function to ease elements in different ways.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'right') . __( 'Easing', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'animation__easing',
		'value'            => array(
			__( 'Ease', PT_VC_ADDON_GMAP_TEXTDOMAIN )              => 'ease',
			__( 'EaseIn', PT_VC_ADDON_GMAP_TEXTDOMAIN )           => 'ease-in',
			__( 'EaseOut', PT_VC_ADDON_GMAP_TEXTDOMAIN )          => 'ease-out',
			__( 'EaseInOut', PT_VC_ADDON_GMAP_TEXTDOMAIN )       => 'ease-in-out',
			__( 'EaseInBack', PT_VC_ADDON_GMAP_TEXTDOMAIN )      => 'ease-in-back',
			__( 'EaseOutBack', PT_VC_ADDON_GMAP_TEXTDOMAIN )     => 'ease-out-back',
			__( 'EaseInOutBack', PT_VC_ADDON_GMAP_TEXTDOMAIN )  => 'ease-in-out-back',
			__( 'EaseInSine', PT_VC_ADDON_GMAP_TEXTDOMAIN )      => 'ease-in-sine',
			__( 'EaseOutSine', PT_VC_ADDON_GMAP_TEXTDOMAIN )     => 'ease-out-sine',
			__( 'EaseInOutSine', PT_VC_ADDON_GMAP_TEXTDOMAIN )  => 'ease-in-out-sine',
			__( 'EaseInQuad', PT_VC_ADDON_GMAP_TEXTDOMAIN )      => 'ease-in-quad',
			__( 'EaseOutQuad', PT_VC_ADDON_GMAP_TEXTDOMAIN )     => 'ease-out-quad',
			__( 'EaseInOutQuad', PT_VC_ADDON_GMAP_TEXTDOMAIN )  => 'ease-in-out-quad',
			__( 'EaseInCubic', PT_VC_ADDON_GMAP_TEXTDOMAIN )     => 'ease-in-cubic',
			__( 'EaseOutCubic', PT_VC_ADDON_GMAP_TEXTDOMAIN )    => 'ease-out-cubic',
			__( 'EaseInOutCubic', PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'ease-in-out-cubic',
			__( 'EaseInQuart', PT_VC_ADDON_GMAP_TEXTDOMAIN )     => 'ease-in-quart',
			__( 'EaseOutQuart', PT_VC_ADDON_GMAP_TEXTDOMAIN )    => 'ease-out-quart',
			__( 'EaseInOutQuart', PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'ease-in-out-quart',
		),
		'edit_field_class' => 'vc_col-sm-5 -addon-padding-bottom-10px vc_column',
		"group"            => $group,
		'save_always'      => true,
		'dependency'       => array(
			'element' => 'animation__advanced',
			'value'   => 'activate',
		),
	),
	# Once
	array(
		"type"             => "pt_addon__buttons",
		"heading"          => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("Choose whether animation should fire once, or every time you scroll up/down to element.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'right', '200')  . __( 'Fire', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "animation__once",
		"value"            => "false",
		'save_always'      => true,
		"style"            => "button",
		"buttons"          => array(
			array(
				'value' => 'false',
				'label' => __( 'When Scroll', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
			array(
				'value' => 'true',
				'label' => __( 'Once', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			),
		),
		'edit_field_class' => 'vc_col-sm-5 vc_column',
		"save_always"      => true,
		"group"            => $group,
		'dependency'       => array(
			'element' => 'animation__advanced',
			'value'   => 'activate',
		),
	),


	# ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	# Anchor
	array(
		'type'       => 'textfield',
		'heading'    => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("Anchor element, whose offset will be counted to trigger animation instead of actual elements offset.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'right', '200')  . __( 'Anchor', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name' => 'animation__anchor',
		'value'      => '',
		'edit_field_class' => 'vc_col-sm-5 vc_column',
		"save_always"      => true,
		"group"            => $group,
		'dependency'       => array(
			'element' => 'animation__advanced',
			'value'   => 'activate',
		),
	),
	# Anchor Placement
	array(
		'type'             => 'dropdown',
		'heading'          => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("Anchor placement - which one position of element on the screen should trigger animation.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'right', '200') . __( 'Anchor Placement', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'animation__anchor_placement',
		'value'            => array(
			__( 'Top | Bottom', PT_VC_ADDON_GMAP_TEXTDOMAIN )    => 'top-bottom',
			__( 'Top | Center', PT_VC_ADDON_GMAP_TEXTDOMAIN )    => 'top-center',
			__( 'Top | Top', PT_VC_ADDON_GMAP_TEXTDOMAIN )       => 'top-top',
			__( 'Center | Bottom', PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'center-bottom',
			__( 'Center | Center', PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'center-center',
			__( 'Center | Top', PT_VC_ADDON_GMAP_TEXTDOMAIN )    => 'center-top',
			__( 'Bottom | Bottom', PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'bottom-bottom',
			__( 'Bottom | Center', PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'bottom-center',
			__( 'Bottom | Top', PT_VC_ADDON_GMAP_TEXTDOMAIN )    => 'bottom-top',
		),
		'edit_field_class' => 'vc_col-sm-4 vc_column',
		"group"            => $group,
		'save_always'      => true,
		'dependency'       => array(
			'element' => 'animation__advanced',
			'value'   => 'activate',
		),
	),
	# Offset
	array(
		'type'             => 'pt_addon__input_number',
		'heading'          => pixelThrone_vc_addon__gmap()->shortcodes->tooltip(__("Change offset to trigger animations sooner or later.", PT_VC_ADDON_GMAP_TEXTDOMAIN),'left') . __( 'Offset', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'       => 'animation__offset',
		'value'            => '-120',
		'save_always'      => true,
		'edit_field_class' => 'vc_col-sm-3 vc_column ',
		'unit'             => 'px',
		'group'            => $group,
		'position'         => 'right',
		'dependency'       => array(
			'element' => 'animation__advanced',
			'value'   => 'activate',
		),
	),
);