<?php

/**
 * Version Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Version')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Version {
		function __construct() {
			vc_add_shortcode_param( 'pt_addon__version', array( $this, 'render' ) );
			add_filter( 'vc_edit_form_fields_render_field_pt_addon__version_before', array( $this, 'render_before' ) );
			add_filter( 'vc_edit_form_fields_render_field_pt_addon__version_after', array( $this, 'render_after' ) );
		}

		/**
		 * Add Content Before
		 *
		 * @param   $output
		 *
		 * @since   1.0.0
		 * @return  string
		 */
		function render_before( $output ) {
			return '<div class="vc_column vc_edit-form-hidden-field-wrapper">';
		}

		/**
		 * Add Content After
		 *
		 * @param   $output
		 *
		 * @since   1.0.0
		 * @return  string
		 */
		function render_after( $output ) {
			return '</div>';
		}

		/**
		 * Render Metodo
		 *
		 * @since   1.0.0
		 * @return  string
		 */
		public
		function render( $settings, $value ) {

			return <<<HTML

		<input type="hidden"
			   name="{$settings['param_name']}"
			   class="wpb_vc_param_value wpb-textinput form-control {$settings['param_name']} {$settings['type']}_field"
			   value="{$settings['version']}"/>

HTML;
		}
	}
}
new PixelThrone_VC_Addon_Shortcode_Param__Version();
