<?php

/**
 * Input Number Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Tag')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Tag {
		function __construct() {
			vc_add_shortcode_param( 'pt_addon__tag', array( $this, 'render' ) );
		}

		/**
		 * Render Method
		 *
		 * @since   1.0.0
		 * @return  string
		 */
		public
		function render( $settings, $value ) {
			$settings['tag'] = ( ! isset( $settings['tag'] ) ) ? '' : $settings['tag'];

			$output = <<<HTML
		<input name="{$settings['param_name']}"
			   class="wpb_vc_param_value wpb-textinput form-control {$settings['param_name']} {$settings['type']}_param"
			   type="hidden"
			   value="$value"/>
HTML;

			# Tag
			if ( $settings['tag'] == 'hr' ) {
				$output .= <<<HTML
			<hr>
HTML;
			}

			# Tag + Title
			if ( $settings['tag'] == 'hr+title' ) {
				$output .= <<<HTML
			<hr>
			<p class="param__title">{$settings['title']}</p>
HTML;
			}

			# Title
			if ( $settings['tag'] == 'title' ) {
				$output .= <<<HTML
			<p class="param__title">{$settings['title']}</p>
HTML;
			}

			# Tag
			if ( $settings['tag'] == 'toggle' ) {
				$output .= <<<HTML
			<a  href="#"
				onclick="_ptAddon.back.params.tag.toggleSlide(event, '{$settings['trigger']}')"
				>
				Open Options
			</a>
HTML;
			}

			return $output;
		}
	}
}
new PixelThrone_VC_Addon_Shortcode_Param__Tag();



