<?php

/**
 * Input Number Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Input_Number')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Input_Number {
		function __construct() {
			vc_add_shortcode_param( 'pt_addon__input_number', array( $this, 'render' ) );
		}

		/**
		 * Render Metodo
		 *
		 * @since               1.0.0
		 * @return              string
		 * @shortcode-params    onclick | button | icon | min | max | step | unit
		 */
		public
		function render( $settings, $value ) {

			$addon   = ( isset( $settings['unit'] ) && ! empty( $settings['unit'] ) ) ? '<span class="input-group-addon">' . $settings['unit'] . '</span>' : '';
			$onclick = ( isset( $settings['onclick'] ) ) ? "onclick=\"{$settings['onclick']}\"" : '';

			$icon   = ( isset( $settings['icon'] ) ) ? "<i class=\"fa fa-clone\" aria-hidden=\"true\"></i>" : '';
			$button = ( isset( $settings['button'] ) ) ? "<button  $onclick class=\"btn btn-with-bg gray-style input-group-btn\">$icon {$settings['button']}</button>" : '';

			$min   = ( isset( $settings['min'] ) ) ? $settings['min'] : "0";
			$max   = ( isset( $settings['max'] ) ) ? "max=\"{$settings['max']}\"" : "";
			$step  = ( isset( $settings['step'] ) ) ? "step=\"{$settings['step']}\"" : "";
			$left  = ( isset( $settings['unit'] ) && $settings['position'] != "right" ) ? $addon : "";
			$right = ( isset( $settings['unit'] ) && $settings['position'] == "right" ) ? $addon : "";

			//		print_r( "<pre>" );
			//		print_r( "___" . $value );
			//		print_r( "</pre>" );
			//		die();

			return <<<HTML

		<div class="pt_addon__param__input-number input-group">
			$left

			<input name="{$settings['param_name']}"
	               class="wpb_vc_param_value form-input {$settings['param_name']} {$settings['type']}_field"
	               type="number"
	               value="$value"
	               min="$min"
	               $max
	               $step
	               />

			$right
			$button
		</div>

HTML;
		}
	}
}
new PixelThrone_VC_Addon_Shortcode_Param__Input_Number();



