<?php

/**
 * Input Number Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Dropdown')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Dropdown {
		function __construct() {
			vc_add_shortcode_param( 'pt_addon__dropdown', array( $this, 'render' ) );
		}

		/**
		 * Render Methodo
		 *
		 * @since               1.0.0
		 * @return              string
		 */
		public
		function render( $settings, $value ) {
			$output     = '';
			$css_option = str_replace( '#', 'hash-', vc_get_dropdown_option( $settings, $value ) );
			$dependency = "";

			$output .= '<select name="' . $settings['param_name'] . '" class="wpb_vc_param_value wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . ' ' . $css_option . '" data-option="' . $css_option . '">';

			if ( is_array( $value ) ) {
				$value = isset( $value['value'] ) ? $value['value'] : array_shift( $value );
			}

			foreach ( $settings['list'] as $index => $data ) {
				if ( is_numeric( $index ) && ( is_string( $data ) || is_numeric( $data ) ) ) {
					$option_label = $data;
					$option_value = $data;
				} elseif ( is_numeric( $index ) && is_array( $data ) ) {
					$option_label = isset( $data['label'] ) ? $data['label'] : array_pop( $data );
					$option_value = isset( $data['value'] ) ? $data['value'] : array_pop( $data );
				} else {
					$option_value = $data;
					$option_label = $index;
				}

				$option_label = __( $option_label, PT_VC_ADDON_GMAP_TEXTDOMAIN );
				//$val = strtolower(str_replace(array(" "), array("_"), $val));
				//$val = strtolower(str_replace(array(" "), array("_"), $val)); //issue #464 github
				$selected = '';
				if ( $value !== '' && (string) $option_value === (string) $value ) {
					$selected = ' selected="selected"';
				}

				switch ( $option_value ) {
					case 'start':
						$output .= '<optgroup label="' . htmlspecialchars( $option_label ) . '">';
					break;
					case 'end':
						$output .= '</optgroup>';
					break;
					default:
						$output .= '<option class="' . $option_value . '" value="' . $option_value . '"' . $selected . '>' . htmlspecialchars( $option_label ) . '</option>';
					break;
				}


				// $output .= '<option class="' . $option_value . '" value="' . $option_value . '"' . $selected . '>'
				//            . htmlspecialchars( $option_label ) . '</option>';
			}
			$output .= '</select>';


			return $output;

		}
	}
}

new PixelThrone_VC_Addon_Shortcode_Param__Dropdown();



