<?php
/**
 * Buttons Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Colorpicker')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Colorpicker {
		function __construct() {
			vc_add_shortcode_param( 'pt_addon__colorpicker', array( $this, 'render' ) );
		}

		/**
		 * Render Method
		 *
		 * @since               1.0.0
		 * @return              string
		 */
		public
		function render( $settings, $value ) {
			//		$script = '<script>_ptAddon.back.params.multiColorpicker.init("'.$settings['param_name'].'");</script>';
			$inputType = ( isset( $settings['settings']['hidden'] ) && $settings['settings']['hidden'] === false ) ? 'hidden' : 'text';
			$label     = ( isset( $settings['settings']['label'] ) ) ? $settings['settings']['label'] : '';

			return <<<HTML
			<input name="{$settings['param_name']}"
				   class="ptAddons--input-color wpb_vc_param_value wpb-textinput form-control {$settings['param_name']} {$settings['type']}_param"
				   type="hidden"

				   value="$value"
				   />

			<p>$label</p>
HTML;

		}
	}
}
new PixelThrone_VC_Addon_Shortcode_Param__Colorpicker();
