<?php
/**
 * Buttons Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Checkbox')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Checkbox {

		const base = 'pt_addon__checkbox';

		function __construct() {
			add_action( 'vc_load_default_params', array( &$this, 'vc_load_vc_custom_param' ) );
		}

		/**
		 * Load Visual Composer custom param
		 *
		 * @since   1.0.0
		 * @return  void
		 */
		public
		function vc_load_vc_custom_param() {
			vc_add_shortcode_param( self::base, array( $this, 'render' ) );
		}

		/**
		 * Render Method
		 *
		 * @since   1.0.0
		 * @return  string
		 */
		public
		function render( $settings, $value ) {

			$action  = '_ptAddon.back.params.checkbox.save(event);';
			$checked = ( ! empty( $value ) ) ? ' checked' : '';

			return <<<HTML
				<input  type="hidden"
	                    class="wpb_vc_param_value wpb-textinput {$settings['param_name']} {$settings['type']}_field"
	                    name="{$settings['param_name']}"
	                    value="$value"
	                    >

				<label class="form-switch">
					<input  id="{$settings['param_name']}-check"
							data-value="{$settings['list']['value']}"
							class="wpb_vc_param_value {$settings['param_name']} {$settings['type']}"
							type="checkbox"
							name="{$settings['param_name']}-check"
							onclick="$action"
							$checked
							>
							<i class="form-icon"></i>
						   {$settings['list']['label']}
				</label>
HTML;
		}
	}
}
new PixelThrone_VC_Addon_Shortcode_Param__Checkbox();