<?php
/**
 * Buttons Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Buttons')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Buttons {

		const base = 'pt_addon__buttons';

		function __construct() {
			add_action( 'vc_load_default_params', array( &$this, 'vc_load_vc_custom_param' ) );
		}

		/**
		 * Load Visual Composer custom param
		 *
		 * @since   1.0.0
		 * @return  void
		 */
		public
		function vc_load_vc_custom_param() {
			vc_add_shortcode_param( self::base, array( $this, 'render' ) );
		}

		/**
		 * Render Method
		 *
		 * @since   1.0.0
		 * @return  string
		 */
		public
		function render( $settings, $value ) {

			$action = '_ptAddon.back.params.buttons.save(event);';

			$classes = ( isset( $settings['classes'] ) ) ? $settings['classes'] : '';

			$output = '';
			foreach ( $settings['buttons'] as $label => $val ) {
				$val           = (object) $val;
				$extra_classes = $tooltip = $to_hide = '';
				$checked       = ( $val->value == $value ) ? 'selected' : '';

				# Button Style
				if ( $settings['style'] == 'button' ) {
					$label = $val->label;
				}

				# Image Style
				if ( $settings['style'] == 'image' ) {
					$label = "<img src=\"{$val->img}\" >";
				}

				# Tooltip
				if ( isset( $val->tooltip ) ) {
					$positioning = ( isset( $settings['positioning'] ) ) ? $settings['positioning'] : 'up';
					$tooltip     = "data-balloon=\"{$val->tooltip}\" data-balloon-pos=\"$positioning\"";
				}

				# Elements to Hide
				if ( isset( $val->hide ) ) {
					$to_hide .= 'data-hide=" ' . esc_attr( json_encode( $val->hide ) ) . ' "';
					$extra_classes .= ' with-list-to-hide';
				}

				# ToggleClass
				if ( isset( $val->toggleClass ) ) {
					$to_hide .= 'data-toggleClass=" ' . esc_attr( json_encode( $val->toggleClass ) ) . ' "';
					$extra_classes .= ' -with-toggle-classes';
				}

				$output .= <<<HTML
		        <a  href="javascript:void(0);"
		            class="choose-button $checked $extra_classes"
		            data-value="{$val->value}"
		            onclick="$action"
					$tooltip
					$to_hide
		            >
		            $label
				</a>
HTML;
			}

			return <<<HTML
			<input  type="hidden"
	                class="wpb_vc_param_value wpb-textinput {$settings['param_name']} {$settings['type']}_field"
	                name="{$settings['param_name']}"
	                value="$value"
	                >
			<div class="buttons-param-wrap {$settings['style']}-style $classes">
                $output
            </div>
HTML;
		}
	}
}
new PixelThrone_VC_Addon_Shortcode_Param__Buttons();



