;(function( _ptAddon, $ ) {

	Param = (function() {
		$input = $( '#extra-class-input' );

		var save = function(event) {
			event.preventDefault();
			var $button = $(event.currentTarget ),
				value = $button.data('value' ),
				$wrap = $button.parent().parent(),
				toshow = $button.parent().find('a.selected').data('hide' ),
				toHide = $button.data('hide' ),
				toToggle = $button.data('toggleclass');

			$wrap.find( "input.wpb_vc_param_value" ).val( value ).trigger("change");
			$wrap.find('a' ).removeClass('selected');
			$button.addClass('selected');

			// Show Elements
			_showElements(toshow);

			// Hide Elements
			hideElements(toHide);

			// Toggle Class
			_toggleClass(toToggle);
		};

		/**
		 * Show Elements
		 *
		 * @since    1.0.0
		 */
		var _showElements = function(toshow) {
			if (typeof toshow  !== "undefined") {
				toshow = jQuery.parseJSON( toshow );
				$.each(toshow, function( index, value ) {
					_ptAddon.config.vc.$editPanel.find('div[data-vc-shortcode-param-name="' + value + '"]' ).removeClass('ptAddons_dependent-hidden');
					//console.log( "Show : " + value );
				});
			}
		};

		/**
		 * Hide Elements
		 *
		 * @since    1.0.0
		 */
		var hideElements = function(toHide) {
			if (typeof toHide  !== "undefined") {
				toHide = jQuery.parseJSON( toHide );
				$.each(toHide, function( index, value ) {
					_ptAddon.config.vc.$editPanel.find('div[data-vc-shortcode-param-name="' + value + '"]' ).addClass('ptAddons_dependent-hidden');
					//console.log( " Hide : " + value );
				});
			}
		};

		/**
		 * Toggle class
		 *
		 * @since    1.0.0
		 */
		var _toggleClass = function(_data) {
			if (typeof _data  !== "undefined") {
				_data = jQuery.parseJSON( _data );
				_ptAddon.config.vc.$editPanel.find( _data.el ).removeClass( _data.remove ).addClass( _data.add );
			}
		};


		return {
			save: save,
			hideElements: hideElements
		};
	})();

	_ptAddon.back.params.buttons = Param;



	/**
	 * Trigger on load
	 *
	 * @since    1.0.0
	 */
	_ptAddon.config.vc.$editPanel.on( 'vcPanel.shown', function() {
		/**
		 * Hide Params when the panel is initiated
		 *
		 * @since    1.0.0
		 */
		_ptAddon.config.vc.$editPanel
			.find('div[data-param_type="pt_addon__buttons"]' )
			.find('a.selected.with-list-to-hide')
			.each(function( index ) {
				var $el = $( this ),
				toHide = $el.data('hide');

				// Hide
				if (typeof toHide  !== "undefined") {
					toHide = $.parseJSON( toHide );
					$.each(toHide, function( index, value ) {
						_ptAddon.config.vc.$editPanel.find('div[data-vc-shortcode-param-name="' + value + '"]' ).addClass('ptAddons_dependent-hidden');
						//console.log( " Hide : " + value );
					});
				}

			});
		/**
		 * Toggle classes when the panel is initiated
		 *
		 * @since    1.0.2
		 */
		_ptAddon.config.vc.$editPanel
			.find('div[data-param_type="pt_addon__buttons"]' )
			.find('a.selected.-with-toggle-classes')
			.each(function( index ) {
				var $el = $( this ),
				    _data = $el.data('toggleclass');

				if (typeof _data  !== "undefined") {
					_data = jQuery.parseJSON( _data );
					_ptAddon.config.vc.$editPanel.find( _data.el ).addClass( _data.add );
				}
			})

	} );

})( _ptAddon, jQuery);