<?php

/**
 * Input Number Param
 *
 * @version 1.0
 * @since   1.0.0
 */
if ( ! class_exists('PixelThrone_VC_Addon_Shortcode_Param__Animation_Preview')) {
	class PixelThrone_VC_Addon_Shortcode_Param__Animation_Preview {
		function __construct() {
			vc_add_shortcode_param( 'pt_addon__animation_preview', array( $this, 'render' ) );
		}

		/**
		 * Render Method
		 *
		 * @since               1.0.0
		 * @return              string
		 * @shortcode-params    onclick | button | icon | min | max | step | unit
		 */
		public
		function render( $settings, $value ) {

			return <<<HTML
		<input  type="hidden"
	            class="wpb_vc_param_value wpb-textinput {$settings['param_name']} {$settings['type']}_field"
	            name="{$settings['param_name']}"
	            value="$value"
	            >

		<a href="#" id="animation-preview-button" data-aos-once="true" class="aos-init">Preview</a>
HTML;
		}
	}
}
new PixelThrone_VC_Addon_Shortcode_Param__Animation_Preview();



