;(function( _ptAddon, $ ) {


	Param = (function() {

		var update = function() {
			var $previewButton = $( '#animation-preview-button' ),
			    $wrap          = $('div[data-vc-shortcode-param-name="animation"]').parent();

			// Check if exist animation param
			if ( ! $wrap.length )
				return;


			// Start
			var replayButton = function() {

				var delay = $wrap.find('[name="animation__duration"]' ).val();
					delay = delay.replace(",", ".");
					delay = delay * 1000;

				if( $previewButton.hasClass('-animate-loading') )
					return;

				$previewButton.addClass('-animate-loading');
				$previewButton.removeClass('aos-animate');

				setTimeout(function(){
					$previewButton.addClass('aos-animate');
					$previewButton.removeClass('-animate-loading');
				},delay);
			};

			// Bind Butoon
			$previewButton.on( "click", replayButton );

			// Bind Elements
			$.each($wrap.find('input, select'), function( index, value ) {

				$( this ).change(function() {
					var $el   = $( this ),
					    value = $el.val(),
						reload = false;

					if( $el.attr('name') == 'animation__animations') {
						$previewButton.attr('data-aos',value);
						reload = true;
					}

					if( $el.attr('name') == 'animation__duration') {
						value = value.replace(",", ".");
						value = value * 1000;
						$previewButton.attr('data-aos-duration',value);
						reload = true;
					}

					if( $el.attr('name') == 'animation__delay') {
						value = value.replace(",", ".");
						value = value * 1000;
						$previewButton.attr('data-aos-delay',value);
						reload = true;
					}

					if( $el.attr('name') == 'animation__easing') {
						$previewButton.attr('data-aos-easing',value);
						reload = true;
					}

					if( $el.attr('name') == 'animation__easing') {
						$previewButton.attr('data-aos-easing',value);
						reload = true;
					}

					if(reload) {
						replayButton();
					}

				});
			});

			// First Fill
			$val = $wrap.find( '[name="animation__animations"]' ).val();
			$previewButton.attr( 'data-aos', $val );

			$val = $wrap.find( '[name="animation__duration"]' ).val();
			$val = $val.replace( ",", "." );
			$val = $val * 1000;
			$previewButton.attr( 'data-aos-duration', $val );

			$val = $wrap.find( '[name="animation__delay"]' ).val();
			$val = $val.replace( ",", "." );
			$val = $val * 1000;
			$previewButton.attr( 'data-aos-delay', $val );

			$val = $wrap.find( '[name="animation__easing"]' ).val();
			$previewButton.attr( 'data-aos-easing', $val );

			replayButton();

		};

		return {
			update: update
		};
	})();

	_ptAddon.back.params.animationPreview = Param;


	/**
	 * Trigger on load
	 *
	 * @since    1.0.0
	 */
	_ptAddon.config.vc.$editPanel.on( 'vcPanel.shown', function() {
		_ptAddon.back.params.animationPreview.update();
	} );

})( _ptAddon, jQuery);