<?php


class pixelThrone_vc_addon__gmap__Shortcodes_Tools {

	function __construct() {
	}

	/**
	 * @param $value
	 *
	 * @since 1.0.0
	 * @return object
	 */
	function get__vc_link( $value ) {
		$vc_link = vc_parse_multi_attribute( $value, array( 'url' => '', 'title' => '', 'target' => '' ));

		$return['href'] = ($vc_link["url"]) 			? 'href="'.esc_url($vc_link["url"]).'"' : '';
		$return['target'] = ($vc_link["target"]) 	? 'target="'.$vc_link["target"].'"' 	: '';
		$return['title'] = ($vc_link["title"]) 		? 'title="'.$vc_link["title"].'"' 		: '';

		return (object) $return;
	}

	/**
	 * Get Animation html
	 *
	 * @param $atts
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function get__animation( $atts ) {

		# Check
		if( ! isset($atts->animation) || $atts->animation != 'activate' )
			return '';

		$atts->animation__duration = str_replace(",", ".", $atts->animation__duration);
		$atts->animation__duration = $atts->animation__duration * 1000;

		$atts->animation__delay = str_replace(",", ".", $atts->animation__delay);
		$atts->animation__delay = $atts->animation__delay * 1000;

		# Add Animation
		$output = array();
		$output[] = "data-aos='{$atts->animation__animations}'";
		$output[] = ( !empty($atts->animation__duration) )  ? "data-aos-duration='{$atts->animation__duration}'"    :  "data-aos-duration='600'";
		$output[] = ( !empty($atts->animation__delay) )     ? "data-aos-delay='{$atts->animation__delay}'"          :  "data-aos-delay='0'";

		# Check if the user enable the advanced options
		if( $atts->animation__advanced != 'activate' )
			return  implode( ' ', array_filter( $output ) );

		# Add Advanced Options
		$output[] = "data-aos-anchor-placement='{$atts->animation__anchor_placement}'";
		$output[] = ( !empty($atts->animation__anchor) ) ? "data-aos-anchor='{$atts->animation__anchor}'" :  "";
		$output[] = ( !empty($atts->animation__offset) ) ? "data-aos-offset='{$atts->animation__offset}'" :   "data-aos-offset='120'";
		$output[] = "data-aos-easing='{$atts->animation__easing}'";
		$output[] = "data-aos-once='{$atts->animation__once}'";

		return  implode( ' ', array_filter( $output ) );
	}


	/**
	 *  Get Image template ID
	 */
	function get__cdnMedia_id($image)
	{
		$tempImages = get_post_meta(pixelThrone_vc_addon__gmap()->info->cdn->metaID, pixelThrone_vc_addon__gmap()->info->cdn->meta);

		if( empty($tempImages ) )
			return false;

		$tempImages = maybe_unserialize(base64_decode($tempImages[0]));
		$tempImages = maybe_unserialize($tempImages);
		if ( array_key_exists($image, $tempImages) ) {
			foreach($tempImages as $key => $value) {
				if($key == $image)
					return $value;
			}
		} else {
			return false;
		}

	}
	/**
	 *  Get Image template ID
	 */
	function update__cdnMedia_list($image, $id)
	{

		$tempImages_id = get_post_meta(pixelThrone_vc_addon__gmap()->info->cdn->metaID, pixelThrone_vc_addon__gmap()->info->cdn->meta);

		if( empty($tempImages_id)) {
			$tempImages_id[$image] = $id;
			add_post_meta( pixelThrone_vc_addon__gmap()->info->cdn->metaID, pixelThrone_vc_addon__gmap()->info->cdn->meta, base64_encode(maybe_serialize($tempImages_id)) );
		} else {
			$tempImages_id = maybe_unserialize(base64_decode($tempImages_id[0]));
			$tempImages_id[$image] = $id;
			update_post_meta( pixelThrone_vc_addon__gmap()->info->cdn->metaID, pixelThrone_vc_addon__gmap()->info->cdn->meta, base64_encode(maybe_serialize($tempImages_id)) );
		}
	}
	/**
	 * Upload media from PT CDN
	 *
	 * @since 4.2
	 * @return array
	 */
	function upload_media($image)
	{
		$get_id = $this->get__cdnMedia_id($image);

		if( $get_id === false ) {

			$cdn_url    = pixelThrone_vc_addon__gmap()->info->cdn->url;
			$image_path = explode( "-", str_replace( pixelThrone_vc_addon__gmap()->info->cdn->alias, '', $image ) );
			$url = "{$cdn_url}/{$image_path['0']}/{$image_path['1']}";

			require_once(ABSPATH . 'wp-admin/includes/media.php');
			require_once(ABSPATH . 'wp-admin/includes/file.php');
			require_once(ABSPATH . 'wp-admin/includes/image.php');

			$tmp = download_url( $url );

			if( is_wp_error( $tmp ) ){
				// download failed, handle error
				echo("download failed, handle error -> " . $tmp);
				return;
			}

			$post_id = "";
			$desc = "PixelThrone Block Image";
			$file_array = array();

			// Set variables for storage
			// fix file filename for query strings
			preg_match('/[^\?]+\.(jpg|jpe|jpeg|gif|png)/i', $url, $matches);
			$file_array['name'] = basename($matches[0]);
			$file_array['tmp_name'] = $tmp;

			// If error storing temporarily, unlink
			if ( is_wp_error( $tmp ) ) {
				@unlink($file_array['tmp_name']);
				$file_array['tmp_name'] = '';
			}

			// do the validation and storage stuff
			$id = media_handle_sideload( $file_array, $post_id, $desc );

			// If error storing permanently, unlink
			if ( is_wp_error($id) ) {
				@unlink($file_array['tmp_name']);
				return $id;
			}

			// $src = wp_get_attachment_url( $id );
			$this->update__cdnMedia_list($image,$id);

			return $id;

		} else {
			return $get_id;
		}
	}
	/**
	 * Get image info
	 *
	 * @since   4.2
	 * @param   $image_id
	 * @return  object
	 */
	function get__image_object( $images, $size_label, $custom = '' ) {
		if( ! empty($images) ) {
			$return_array = array();
			$images = explode(",", $images);

			foreach ($images as $image_id) {

				# Check if is one of ours
				if (strpos($image_id, pixelThrone_vc_addon__gmap()->info->cdn->alias) !== false)
					$image_id = $this->upload_media( $image_id );

				# Get object
				$image_size = ( $size_label != 'custom' ) ? $size_label : $custom ;
				$img_array = wp_get_attachment_image_src( $image_id, $image_size );
				$src_full = wp_get_attachment_image_src( $image_id, 'full' );
				// $attachment = get_post( $image_id );

				$return_array[] = (object) array(
					'id'       => $image_id,
					'src'      => $img_array[0],
					'src_full' => $src_full[0],
					'width'    => $img_array[1],
					'height'   => $img_array[2],
					'alt'      => get_post_meta( $image_id, '_wp_attachment_image_alt', true )
				);
			}

			return ( count($images) > 1 ) ? $return_array : $return_array[0];

		} else {
			return (object) array(
				'id'       => '',
				'src'      => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_IMG_URI', 'shortcode-frontend/empty-image-thumb.png' ),
				'src_full' => pixelThrone_vc_addon__gmap__tools()->path( 'ASSETS_IMG_URI', 'shortcode-frontend/empty-image-thumb.png' ),
				'width'    => '',
				'height'   => '',
				'alt'      => __( 'Temporary Image', PT_VC_ADDON_GMAP_TEXTDOMAIN )
			);
		}
	}
	/**
	 * ToolTip  | up / down / left / right
	 *
	 * @since   1.0.0
	 * @version 1.0.0
	 *
	 * @param          $title
	 * @param   string $placement
	 *
	 * @return string
	 */
	public static
	function tooltip( $title, $placement = 'up', $w='', $icon='fa fa-question-circle' ) {
		return "<span data-balloon-pos='$placement'
					  data-balloon='$title'
					  class='with-{$w}-width'
					  >
					  <i class='$icon' ></i>
				</span>";
	}
	/**
	 * Get substring between two strings
	 *
	 * @since   1.0.0
	 * @version 1.0.0
	 *
	 * @param   $string
	 * @param   $start
	 * @param   $end
	 *
	 * @return string
	 */
	function get__string_between($string, $start, $end){
		$string = ' ' . $string;
		$ini = strpos($string, $start);
		if ($ini == 0) return '';
		$ini += strlen($start);
		$len = strpos($string, $end, $ini) - $ini;
		return substr($string, $ini, $len);
	}
}