<?php
return array(
	/**
	 * Viewport
	 *
	 * @since   1.0.0
	 */
	'viewport' => array(
		"type"        => "pt_addon__checkbox",
		"heading"     => __( "Hidden Viewport", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"  => "pt_hidden_viewport",
		"value"       => array(
			"<span class='pt_ext_screen-size' title='Large'></span> Large Devices<br>"                 => "hidden-lg",
			"<span class='pt_ext_screen-size size-md' title='Medium'></span> Medium devices<br>"       => "hidden-md",
			"<span class='pt_ext_screen-size size-sm' title='Small'></span> Small Devices<br>"         => "hidden-sm",
			"<span class='pt_ext_screen-size size-xs' title='Extra small'></span> Extra Small Devices" => "hidden-xs"
		),
		"description" => "",
		"group"       => __( 'Viewport', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"save_always" => true,
	),
	/**
	 * Design Options
	 *
	 * @since   1.0.0
	 */
	'design_options' => array(
		"type"       => "css_editor",
		"heading"    => __( 'Css', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name" => "css",
		//"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", PT_VC_ADDON_GMAP_TEXTDOMAIN),
		"group"      => __( 'Design Options', PT_VC_ADDON_GMAP_TEXTDOMAIN )
	),
	/**
	 * Css Delay
	 *
	 * @since   1.0.0
	 */
	'css_delay' => array(
		"type"             => "pt_textfield",
		"heading"          => __( "Delay ", PT_VC_ADDON_GMAP_TEXTDOMAIN ) . pixelThrone_vc_addon__gmap__tools()->shortcode_tooltip( __( 'You can set a delay for the animation in seconds.', PT_VC_ADDON_GMAP_TEXTDOMAIN ) ),
		"param_name"       => "css_delay",
		"unit"             => "seconds",
		"admin_label"      => true,
		"dependency"       => array( 'element' => "css_animation", 'not_empty' => true ),
		'edit_field_class' => 'vc_col-md-2 vc_col-md-offset-1 vc_column no_rigth_padding',
		"group"            => __( 'Animation', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"save_always"      => true
	),
	/**
	 * Get Link Target Types
	 *
	 * @since   1.0.0
	 */
	'responsiveness' => array(
		'type'        => 'column_offset',
		'heading'     => __( 'Responsiveness', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'param_name'  => 'offset',
		'group'       => __( 'Width & Responsiveness', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		'description' => __( 'Adjust column for different screen sizes. Control width, offset and visibility settings.', PT_VC_ADDON_GMAP_TEXTDOMAIN )
	),
	/**
	 * Css Editor
	 *
	 * @since   1.0.0
	 */
	'css_editor' => array(
		"type"       => "css_editor",
		"heading"    => __( 'Css', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name" => "css",
		//"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", PT_VC_ADDON_GMAP_TEXTDOMAIN),
		"group"      => __( 'Design Options', PT_VC_ADDON_GMAP_TEXTDOMAIN )
	),
	/**
	 * Animation Speed
	 *
	 * @since   1.0.0
	 */
	'animation_speed' => array(
		"type"             => "pt_button_list",
		"heading"          => __( "Speed ", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "css_speed",
		"value"            => "normal",
		"list"             => array(
			__( "Faster", PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'faster',
			__( "Fast", PT_VC_ADDON_GMAP_TEXTDOMAIN )   => 'fast',
			__( "Normal", PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'normal',
			__( "Slow", PT_VC_ADDON_GMAP_TEXTDOMAIN )   => 'slow',
			__( "Slower", PT_VC_ADDON_GMAP_TEXTDOMAIN ) => 'slower'
		),
		'edit_field_class' => 'vc_col-md-5 vc_col-md-offset-1 vc_column',
		"dependency"       => array( 'element' => "css_animation", 'not_empty' => true ),
		"save_always"      => true,
		"group"            => __( 'Animation', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"save_always"      => true
	),
	/**
	 * Extra Class
	 *
	 * @since   1.0.0
	 */
	'el_class' => array(
		"type"             => "textfield",
		"heading"          => __( 'Extra Class Name', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"param_name"       => "el_class",
		'edit_field_class' => 'vc_col-sm-12 vc_column',
		"group"            => __( 'Settings', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
		"save_always"      => true,
	)
);
