<?php
# Tools

class PixelThrone_VC_Addon__GMap__Shortcodes_Manager {
	/**
	 * Shortcode Options
	 *
	 * @since 1.0.0
	 * @var array
	 */
	public $options = array();

	/**
	 * Plugin Params
	 *
	 * @since 1.0.0
	 * @var array
	 */
	public $params = array();

	/**
	 * Active Shortcodes List
	 *
	 * @since   1.0.0
	 * @return  array
	 */
	public $autoload_shortcodes = array();

	/**
	 * Active Params List
	 *
	 * @since   1.0.0
	 * @return  array
	 */
	public $autoload_params = array();

	function __construct() {

		/**
		 * Fill Shortcodes Autoload
		 *
		 * @since 1.0.0
		 */
		$this->autoload_shortcodes = include __DIR__ . '/autoload.shortcodes.php';
		/**
		 * Fill Params Autoload
		 *
		 * @since 1.0.0
		 */
		$this->autoload_params = include __DIR__ . '/autoload.params.php';

		/**
		 * Load Options
		 *
		 * @since 1.0.0
		 */
		$this->options = include __DIR__ . '/config.options.php';

		/**
		 * Load Params
		 *
		 * @since 1.0.0
		 */
		$this->params = include __DIR__ . '/config.params.php';

		/**
		 * Loads when the plugins have all loaded
		 *
		 * @since 1.0.0
		 */
		add_action( 'vc_after_init', array( $this, 'vc_after_init' ), 10 );
	}

	/**
	 * Loads only after Visual Composer init
	 *
	 * @since   1.0.0
	 * @return  string
	 */
	public
	function vc_after_init() {
		/**
		 * Start the shortcode loader
		 *
		 * @since 1.0.0
		 */
		foreach ( $this->autoload_shortcodes as $key => $val ) {
			$base = 'pt_addon__' . $val;
			$inc = include __DIR__ . "/shortcodes/$val/params.php";
			vc_map( $inc );
			require_once( __DIR__ . "/shortcodes/$val/shortcode.php" );

		}

		/**
		 * Start the shortcode loader
		 *
		 * @since 1.0.0
		 */
		foreach ( $this->autoload_params as $key => $name ) {
			require_once( __DIR__ . "/params/$name/param.php" );
		}
	}

	/**
	 *  Get Param
	 *
	 * @since   1.0.0
	 *
	 * @param   $param
	 *
	 * @return  array
	 */
	public
	function get__param( $param ) {
		return $this->params[ $param ];
	}
	/**
	 *  Get Option
	 *
	 * @since     1.0.0
	 * @return    (array)
	 */
	public
	function get__option( $opt ) {
		return $this->options[ $opt ];
	}

	/**
	 *  Get Version Param
	 *
	 * @since   1.0.0
	 * @return  array
	 */
	public
	function get__param__version( $v ) {
		return array(
			'type'               => 'pt_addon__version',
			'param_name'         => 'version',
			'version'            => $v,
			"save_always"        => true,
			"group"              => __( 'Settings', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			'param_holder_class' => 'display-none',
		);
	}

	/**
	 * Get ViewPort Param
	 *
	 * @since   1.0.0
	 * @return  array
	 */
	public
	function get__param__viewport( $opt ) {
		$array['lg'] = array(
			"type"             => "pt_addon__checkbox",
			"heading"          => __( "Hide on:", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			"param_name"       => "viewport_lg",
			"value"            => "",
			"list"             => array(
				'label' => '<span class=\'pt_ext_screen-size\' title=\'Large\'></span> Large Devices',
				'value' => '-hide-on-lg'
			),
			"group"            => __( 'Settings', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			'edit_field_class' => 'vc_col-sm-4 -addon-padding-top-0px vc_column',
			//	"save_always"        => true,
		);

		$array['md'] = array(
			"type"             => "pt_addon__checkbox",
			"heading"          => __( "", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			"param_name"       => "viewport_md",
			"value"            => "",
			"list"            => array(
				'label' => '<span class=\'pt_ext_screen-size size-md\' title=\'Medium\'></span> Medium devices',
				'value' => '-hide-on-md'
			),
			"group"            => __( 'Settings', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			'edit_field_class' => 'vc_col-sm-5 vc_column padding-top-15px',
			//	"save_always"        => true,
		);

		$array['sm'] = array(
			"type"             => "pt_addon__checkbox",
			"heading"          => __( "", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			"param_name"       => "viewport_sm",
			"value"            => "",
			"list"            => array(
				'label' => '<span class=\'pt_ext_screen-size size-sm\' title=\'Small\'></span> Small Devices',
				'value' => '-hide-on-sm'
			),
			"group"            => __( 'Settings', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			'edit_field_class' => 'vc_col-sm-4 vc_column -addon-padding-top-0px margin-top--10px',
			//	"save_always"        => true,
		);

		$array['xs'] = array(
			"type"             => "pt_addon__checkbox",
			"heading"          => __( "", PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			"param_name"       => "viewport_xs",
			"value"            => "",
			"list"            => array(
				'label' => '<span class=\'pt_ext_screen-size size-xs\' title=\'Extra small\'></span> Extra Small Devices',
				'value' => '-hide-on-xs'
			),
			"group"            => __( 'Settings', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			'edit_field_class' => 'vc_col-sm-5 vc_column -addon-padding-top-0px margin-top--10px',
			//	"save_always"        => true,
		);


		return $array[ $opt ];
	}

	/**
	 *  Enqueue and get google font css
	 *
	 * @since   1.0.0
	 *
	 * @param   $google_fonts
	 *
	 * @return  string
	 */
	public
	function get__google_font( $google_fonts, $size = "", $lineheight = "" ) {
		$styles = array();
		# Get Fonts
		$google_fonts = pixelThrone_vc_addon__gmap__tools()->parse_multi_attribute( $google_fonts );

		# Breaks that s*#&
		$google_fonts_family = explode( ':', $google_fonts['font_family'] );
		$styles[]            = "font-family:" . $google_fonts_family[0];
		$google_fonts_styles = explode( ':', $google_fonts['font_style'] );
		$styles[]            = "font-weight:" . $google_fonts_styles[1];
		$styles[]            = "font-style:" . $google_fonts_styles[2];

		if( ! empty($size) )
			$styles[]        = "font-size:{$size}px;";

		if( ! empty($lineheight) )
			$styles[]        = "line-height:{$lineheight}%;";

		# Get subsets
		$settings = get_option( 'wpb_js_google_fonts_subsets' );
		$subsets  = ( is_array( $settings ) && ! empty( $settings ) ) ? '&subset=' . implode( ',', $settings ) : '';

		# Get Safe Class
		$vc_class = vc_build_safe_css_class( $google_fonts['font_family'] );

		# Create Css
		$css = ( ! empty( $styles ) ) ? esc_attr( implode( ';', $styles ) ) . ';' : '';

		# Enqueue Font
		wp_enqueue_style( 'vc_google_fonts_' . $vc_class, '//fonts.googleapis.com/css?family=' . $google_fonts['font_family'] . $subsets );

		return $css;
	}

	/**
	 * Add View port classes
	 *
	 * @since    1.0.0
	 *
	 * @param $extra
	 * @param $actual
	 *
	 * @return array
	 */
	public static
	function add__viewport_classes( $atts, $actual ) {

		if ( isset( $atts->viewport_lg ) ) {
			$actual[] = $atts->viewport_lg;
		}
		if ( isset( $atts->viewport_md ) ) {
			$actual[] = $atts->viewport_md;
		}
		if ( isset( $atts->viewport_sm ) ) {
			$actual[] = $atts->viewport_sm;
		}
		if ( isset( $atts->viewport_xs ) ) {
			$actual[] = $atts->viewport_xs;
		}

		return $actual;
	}


	/**
	 *  Convert array to string separated by spaces
	 *
	 * @since  1.0.0
	 * @return string
	 * @access protected
	 *
	 * @param  array $css_classes List of classes
	 */
	protected
	function echo_classes( $css_classes ) {
		echo implode( ' ', array_filter( $css_classes ) );
	}

	/**
	 * Config for the aniamtion param
	 *
	 * @since   1.0.0
	 * @version 1.0.0
	 * @return  array
	 */
	public static
	function get__param_css_animation() {
		return array(
			"type"             => "pt__dropdown",
			"heading"          => __( "Animation Styles ", PT_VC_ADDON_GMAP_TEXTDOMAIN ) . pixelThrone_vc_addon__gmap()->shortcodes->tooltip( __( 'Select animation type if you want this element to be animated when it enters into the browsers viewport.', PT_VC_ADDON_GMAP_TEXTDOMAIN ) ),
			"param_name"       => "css_animation",
			"admin_label"      => true,
			"value"            => pixelThrone_vc_addon__gmap()->shortcodes->get__option( 'animation_types' ),
			// Note: Works only in modern browsers.
			//"description" => __('<span class="glyphicon glyphicon-new-window" style="font-size: 11px;margin-right: 3px;"></span> <a href="http://daneden.github.io/animate.css?TB_iframe=true&width=950&height=950" class="thickbox">Browse the animation effects gallery.</a>', PT_VC_ADDON_GMAP_TEXTDOMAIN),
			'edit_field_class' => 'vc_col-md-3 vc_column no_rigth_padding',
			"group"            => __( 'Animation', PT_VC_ADDON_GMAP_TEXTDOMAIN ),
			"save_always"      => true,
		);
	}

	/**
	 * Get extra class params
	 *
	 * @since    1.0.0
	 *
	 * @param $extra
	 * @param $actual
	 *
	 * @return array
	 */
	public static
	function add__extra_classes( $extra, $actual ) {
		if ( $extra == '' ) {
			return $actual;
		}

		$extra = str_replace( ".", "", $extra );
		$extra = str_replace( ",", "", $extra );
		$extra = explode( " ", $extra );

		return array_merge( $actual, $extra );
	}

	/**
	 * ToolTip  | up / down / left / right
	 *
	 * @since   1.0.0
	 * @version 1.0.0
	 *
	 * @param          $title
	 * @param   string $placement
	 *
	 * @return string
	 */
	public static
	function tooltip( $title, $placement = 'up', $w='', $icon='fa fa-question-circle' ) {
		return "<span data-balloon-pos='$placement'
					  data-balloon='$title'
					  class='with-{$w}-width'
					  >
					  <i class='$icon' ></i>
				</span>";
	}

	/**
	 * Get image info
	 *
	 * @since   4.2
	 * @param   $image_id
	 * @return  object
	 */
	function get__image_object( $images, $size_label, $custom = '' ) {
		if( ! empty($images) ) {
			$return_array = array();
			$images = explode(",", $images);

			foreach ($images as $image_id) {

				# Get object
				$image_size = ( $size_label != 'custom' ) ? $size_label : $custom ;
				$img_array = wp_get_attachment_image_src( $image_id, $image_size );
				$src_full = wp_get_attachment_image_src( $image_id, 'full' );
				// $attachment = get_post( $image_id );

				$return_array[] = (object) array(
					'id'       => $image_id,
					'src'      => $img_array[0],
					'src_full' => $src_full[0],
					'width'    => $img_array[1],
					'height'   => $img_array[2],
					'alt'      => get_post_meta( $image_id, '_wp_attachment_image_alt', true )
				);
			}

			return ( count($images) > 1 ) ? $return_array : $return_array[0];

		} else {
			return (object) array(
				'id'       => '',
				'width'    => '',
				'height'   => '',
				'alt'      => __( 'Temporary Image', PT_EXT_TEXTDOMAIN )
			);
		}
	}
	/**
	 * Parse Grupo Atts
	 * @param $atts_string
	 *
	 * @since 1.0.0
	 * @return array|mixed
	 */
	function group_parse_atts( $atts_string ) {
		$array = json_decode( urldecode( $atts_string ), true );

		return $array;
	}

	/**
	 * Get Animation html
	 *
	 * @param $atts
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function get__animation( $atts ) {

		# Check
		if( ! isset($atts->animation) || $atts->animation != 'activate' )
			return '';

		$atts->animation__duration = str_replace(",", ".", $atts->animation__duration);
		$atts->animation__duration = $atts->animation__duration * 1000;

		$atts->animation__delay = str_replace(",", ".", $atts->animation__delay);
		$atts->animation__delay = $atts->animation__delay * 1000;

		# Add Animation
		$output = array();
		$output[] = "data-aos='{$atts->animation__animations}'";
		$output[] = ( !empty($atts->animation__duration) )  ? "data-aos-duration='{$atts->animation__duration}'"    :  "data-aos-duration='600'";
		$output[] = ( !empty($atts->animation__delay) )     ? "data-aos-delay='{$atts->animation__delay}'"          :  "data-aos-delay='0'";

		# Check if the user enable the advanced options
		if( $atts->animation__advanced != 'activate' )
			return  implode( ' ', array_filter( $output ) );

		# Add Advanced Options
		$output[] = "data-aos-anchor-placement='{$atts->animation__anchor_placement}'";
		$output[] = ( !empty($atts->animation__anchor) ) ? "data-aos-anchor='{$atts->animation__anchor}'" :  "";
		$output[] = ( !empty($atts->animation__offset) ) ? "data-aos-offset='{$atts->animation__offset}'" :   "data-aos-offset='120'";
		$output[] = "data-aos-easing='{$atts->animation__easing}'";
		$output[] = "data-aos-once='{$atts->animation__once}'";

		return  implode( ' ', array_filter( $output ) );
	}
}


//require_once( "index__organize.php" );
