<?php
/**
 * Plugin Name: Google Maps Addon — Visual Composer
 * Plugin URI: https://codecanyon.net/item/pixelthrone-extension-for-visual-composer/12279745?ref=pixelthrone
 * Description: Create google maps in a simple and fast way.
 * Version: 1.3
 * Author: Pixelthrone
 * Author URI: http://themeforest.net/user/pixelthrone
 *
 * Text Domain: pt_addon__extension
 * Domain Path: /languages/
 *
 * @package pt_addon__extension
 * @author  Helder Vilela
 * @since   1.0.0
 */

# Don't load directly
if( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Debug
 *
 * @since 1.0.0
 * @var string
 */
if (isset($_REQUEST['pixelthrone'])) {
	if ( $_REQUEST['pixelthrone'] == 'debug') {
		ini_set('display_errors', true);
		ini_set("error_reporting", E_ALL);
	}
}

/**
 * Plugin Url Constant
 *
 * @since 1.0.0
 * @var string
 */
if( !defined( 'PT_VC_ADDON_GMAP_URL' ) ) {
	define( 'PT_VC_ADDON_GMAP_URL', plugin_dir_url( __FILE__ ) );
}

/**
 * Plugin Basename Constant
 *
 * @since 1.1.0
 * @var string
 */
if( !defined( 'PT_VC_ADDON_GMAP_BASENAME' ) ) {
	define( 'PT_VC_ADDON_GMAP_BASENAME', plugin_basename( __FILE__ ) );
}

/**
 * Plugin Textdomain
 *
 * @since 1.0.0
 * @var string
 */
if ( ! defined( 'PT_VC_ADDON_GMAP_TEXTDOMAIN' ) ) {
	define( 'PT_VC_ADDON_GMAP_TEXTDOMAIN', 'pt_addon__extension' );
}

/**
 * Plugin Dir Constant
 *
 * @since 1.0.0
 * @var string
 */
if( !defined( 'PT_VC_ADDON_GMAP_DIR' ) ) {
	define( 'PT_VC_ADDON_GMAP_DIR', plugin_dir_path( __FILE__ ) );
}

/**
 * Include Tools & Factory
 *
 * @since 1.0.0
 * @var string
 */
require_once( __DIR__ . '/lib/mobile-detect/Pixelthrone_Mobile_Detect.php' );
require_once( __DIR__ . '/include/PixelThrone_VC_Addon__GMap__Tools.php' );

/**
 * Load Core
 *
 * @since 1.0.0
 */
require_once( 'config/Plugin_Core_Init.php' );

/**
 * Release the Kraken!
 */
pixelThrone_vc_addon__gmap();
