<?php
// don't load directly
if( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}

class pixelThrone_vc_addon__gmap__Tools
{
	/**
	 * List of paths.
	 *
	 * @since 1.0.0
	 * @var pixelThrone_vc_addon__gmap__Mobile_Detect
	 */
	public $detect = array();
	/**
	 * List of paths.
	 *
	 * @since 1.0.0
	 * @var array
	 */
	public $paths = array();

	/**
	 * Core singleton class
	 *
	 * @var self - pattern realization
	 */
	private static $_instance;
	/**
	 * Get the instance of PixelThrone__Manager
	 *
	 * @return self
	 */
	public static
	function getInstance()
	{
		if( !( self::$_instance instanceof self ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	function __construct(  )
	{
		$this->paths = include __DIR__ . '/../config/settings/paths.php';
		$this->detect = new pixelThrone_vc_addon__gmap__Mobile_Detect();
	}

	/**
	 * Gets absolute path for file/directory in filesystem.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @param        $name - name of path dir
	 * @param string $file - file name or directory inside path
	 *
	 * @return string
	 */
	public
	function path( $name, $file = '' )
	{
		$path = $this->paths[ $name ] . ( strlen( $file ) > 0 ? '/' . preg_replace( '/^\//', '', $file ) : '' );

		return $path;
		// return apply_filters( 'pt_theme__path_filter', $path );
	}

	/**
	 * Replace array hyphen
	 *
	 * @since   1.0.0
	 * @version 1.0
	 *
	 * @param   array $array
	 *
	 * @return  array
	 */
	public
	function array_hyphen_replace( $array )
	{
		if( ! is_array($array) )
			return array();

		foreach( $array as $key => $value ):

			if( strpos( $key, '-' ) !== false ):
				unset( $array[ $key ] );
				$key           = str_replace( '-', '_', $key );
				$array[ $key ] = $value;
			endif;

			if( is_array( $value ) ):
				$array[ $key ] = $this->array_hyphen_replace( $value );
			endif;

		endforeach;

		return $array;
	}

	/**
	 * Encode array to json and replace quotes for html compatibility
	 *
	 * @since   1.0.0
	 * @version 1.0
	 *
	 * @param   array $array
	 *
	 * @return  string
	 */
	public
	function html_json_encode( $array )
	{
		return str_replace( "\"", "'", json_encode( $array ) );
	}

	/**
	 * Check if the admin bar is showing and return a class
	 *
	 * @since   1.0.0
	 * @version 1.0
	 *
	 * @return  string
	 */
	public
	function is_admin_bar_showing()
	{
		$var =  ( is_admin_bar_showing()  ) ? 'admin-bar' : '';
		echo $var;
	}

	/**
	 * Convert Array to Object with stdClass
	 *
	 * @since   1.0.0
	 * @version 1.0
	 *
	 * @return  object
	 */
	public
	function array_to_object($array) {
		if (!is_array($array)) {
			return $array;
		}

		if (is_array($array) && count($array) > 0) {
			return json_decode(json_encode($array), FALSE);
		} else {
			return false;
		}
	}
	/**
	 * ToolTip
	 *
	 * @since   1.0.0
	 * @version 1
	 *
	 * @param          $title
	 * @param   string $placement
	 *
	 * @return string
	 */
	public static function shortcode_tooltip($title, $placement='top') {
		return 	' <span class="pt_tooltip" data-toggle="tooltip" data-placement="'.$placement.'" data-html="true" title="'.$title.'" ><i class="fa fa-question-circle" ></i></span>';
	}
	/**
	 * Parse string like "title:Hello world|weekday:Monday" to array('title' => 'Hello World', 'weekday' => 'Monday')
	 *
	 * @param $value
	 * @param array $default
	 *
	 * @since  1.0.0
	 * @return array
	 */
	public
	function parse_multi_attribute( $value, $default = array() ) {
		$result = $default;
		$params_pairs = explode( '|', $value );
		if ( ! empty( $params_pairs ) ) {
			foreach ( $params_pairs as $pair ) {
				$param = preg_split( '/\:/', $pair );
				if ( ! empty( $param[0] ) && isset( $param[1] ) ) {
					$result[ $param[0] ] = rawurldecode( $param[1] );
				}
			}
		}

		return $result;
	}
	/**
	 * Remove break lines from string
	 *
	 * @param string $string
	 * @since  1.0.0
	 * @return string
	 */
	public
	function remove_break_lines( $string ) {
		return preg_replace('/^\s+|\n|\r|\s+$/m', '', $string );
	}

	/**
	 * Get param value from $_POST if exists.
	 *
	 * @param $param
	 * @param $default
	 *
	 * @since 4.2
	 * @return null|string - null for undefined param.
	 */
	function get__postParam( $param, $default = null ) {
		return isset( $_POST[ $param ] ) ? $_POST[ $param ] : $default;
	}

	/**
	 * Get param value from $_GET if exists.
	 *
	 * @param $param
	 * @param $default
	 *
	 * @since 4.2
	 * @return null|string - null for undefined param.
	 */
	function get__getParam( $param, $default = null ) {
		return isset( $_GET[ $param ] ) ? $_GET[ $param ] : $default;
	}

	/**
	 * Get param value from $_REQUEST if exists.
	 *
	 * @param $param
	 * @param $default
	 *
	 * @since 4.4
	 * @return null|string - null for undefined param.
	 */
	function get__requestParam( $param, $default = null ) {
		return isset( $_REQUEST[ $param ] ) ? $_REQUEST[ $param ] : $default;
	}

	/**
	 * Load SVG Icon
	 *
	 * @since    1.0.0
	 * @version  1.0
	 *
	 * @param $svg_name
	 *
	 * @return string
	 */
	public
	function load_svg( $path, $folder, $svg )
	{

		$abs_path = $this->path($path, "{$folder}{$svg}.svg");
		ob_start();
			include $abs_path;
			$file = ob_get_contents();
		ob_end_clean();

		return $file;

	}
	/**
	 * Get substring between two strings
	 *
	 * @since   1.0.0
	 * @version 1.0.0
	 *
	 * @param   $string
	 * @param   $start
	 * @param   $end
	 *
	 * @return string
	 */
	function get__string_between($string, $start, $end){
		$string = ' ' . $string;
		$ini = strpos($string, $start);
		if ($ini == 0) return '';
		$ini += strlen($start);
		$len = strpos($string, $end, $ini) - $ini;
		return substr($string, $ini, $len);
	}

	/**
	 * Get Post Type
	 *
	 * @since   1.0.0
	 * @version 1.0.0
	 *
	 * @param   $string
	 * @param   $start
	 * @param   $end
	 *
	 * @return string
	 */
	public function getPostType() {
		$post_type = false;

		if ( isset( $_GET['post'] ) ) {
			$post_type = get_post_type( $_GET['post'] );
		} else if ( isset( $_GET['post_type'] ) ) {
			$post_type = $_GET['post_type'];
		}

		return $post_type;
	}
}

/**
 * Create Public Api.
 *
 * @since 1.0.0
 * @return pixelThrone_vc_addon__gmap__Tools
 */
if( !function_exists( 'pixelThrone_vc_addon__gmap__tools' ) ) {
	function pixelThrone_vc_addon__gmap__tools()
	{
		return pixelThrone_vc_addon__gmap__Tools::getInstance();
	}
}