<?php

class PixelThrone_VC_Addon__GMap__Notices_Manager
{
	function __construct()
	{
	}

	/**
	 * Check if visual composer is installed.
	 *
	 * @since 1.0.0
	 * @return boolean
	 */
	public
	function composer__is_installed()
	{
		if( !defined( 'WPB_VC_VERSION' ) ) {
			add_action( 'admin_notices', array( $this, 'admin__vc_is_required') );
			return false;
		} else {
			return true;
		}
	}

	/**
	 * Display plugin required notice
	 *
	 * @since 1.0.0
	 */
	public
	function admin__vc_is_required()
	{
		$title = __('Warning', PT_VC_ADDON_GMAP_TEXTDOMAIN);
		$text1 = __( 'The', PT_VC_ADDON_GMAP_TEXTDOMAIN );
		$text2 = __( 'plugin requires', PT_VC_ADDON_GMAP_TEXTDOMAIN );
		$text3 = __( 'plugin installed and activated.', PT_VC_ADDON_GMAP_TEXTDOMAIN );
		$text4 = PT_VC_ADDON_GMAP_NAME;


		echo
<<<HTML
	        <div class="error pt_addon__vc_is_required">
				<h3>$title</h3>
				<p>$text1 <strong>$text4</strong> $text2 <strong>Visual Composer</strong> $text3
				</p>
			</div>
HTML;
	}

	/**
	 * Check if visual composer version.
	 *
	 * @since 1.0.0
	 * @return boolean
	 */
	public
	function composer__compare_versions()
	{
		if( version_compare( PT_VC_ADDON_GMAP_REQUIRED_VERSION, WPB_VC_VERSION, '>' ) ) {
			add_action( 'admin_notices', array( $this, 'admin__for_old_version') );
			return false;
		} else {
			return true;
		}
	}
	/**
	 * Display compare version notice
	 *
	 * @since 1.0.0
	 */
	public static
	function admin__for_old_version()
	{
		$title = __('Warning', PT_VC_ADDON_GMAP_TEXTDOMAIN);
		$text1 = __( 'The', PT_VC_ADDON_GMAP_TEXTDOMAIN );
		$text2 = __( 'version ', PT_VC_ADDON_GMAP_TEXTDOMAIN ) . PT_VC_ADDON_GMAP_REQUIRED_VERSION . __( ' or greater', PT_VC_ADDON_GMAP_TEXTDOMAIN );
		$text3 = PT_VC_ADDON_GMAP_NAME;
		$text4 = __( 'plugin requires the', PT_VC_ADDON_GMAP_TEXTDOMAIN );

		echo
<<<HTML
			  <div class="error pt_addon__for_old_version">
					<h3>$title</h3>
					<p>$text1 <strong>$text3</strong> $text4 <strong>Visual Composer</strong> $text2 </p>
				</div>
HTML;
	}
}