<?php
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

# Config
require_once pixelThrone_vc_addon__gmap__tools()->path( 'CONFIG_DIR', 'visual-composer/PixelThrone_VC_Addon__Visual_Composer__Extend.php' );
require_once pixelThrone_vc_addon__gmap__tools()->path( 'CONFIG_DIR', 'notices/PixelThrone_VC_Addon__Notices_Manager.php' );

# Shortcodes
require_once pixelThrone_vc_addon__gmap__tools()->path( 'SHORTCODES_DIR', 'PixelThrone_VC_Addon__Shortcodes_Manager.php' );

# Load Lib
require_once pixelThrone_vc_addon__gmap__tools()->path( 'LIB_DIR', 'sass/scss.php' );

class PixelThrone_VC_Addon__GMap__Manager {

	/**
	 * Plugin Settings
	 *
	 * @since 1.0.0
	 * @var object
	 */
	public $info = array();

	/**
	 * Theme Info
	 *
	 * @since 1.0.0
	 * @var object
	 */
	public $theme_info = array();

	/**
	 * Shortcodes css on header
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public static $shortcodes_header_css = array();

	/**
	 * Shortcodes css on footer
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public static $shortcodes_footer_css = array();

	/**
	 * Core singleton class
	 *
	 * @var self - pattern realization
	 */
	private static $_instance;

	/**
	 * List of paths.
	 *
	 * @since 1.0.0
	 * @var array
	 */
	private $paths = array();

	/**
	 * Tools functions
	 *
	 * @since 1.0.0
	 * @var PixelThrone_VC_Addon__GMap__Tools
	 */
	public $tools = array();

	/**
	 * Notices functions
	 *
	 * @since 1.0.0
	 * @var pixelThrone_vc_addon__gmap__Notices_Manager
	 */
	public $notices = array();

	/**
	 * My visual composer functions and actions.
	 *
	 * @since 1.0.0
	 * @var pixelThrone_vc_addon__gmap__Shortcodes_Manager
	 */
	public $shortcodes = array();

	/**
	 * Visual composer Extend Class
	 *
	 * @since   1.0.0
	 * @var     PixelThrone_VC_Addon__GMap__Visual_Composer__Extend
	 */
	public $vc = array();

	/**
	 * Get the instance of PixelThrone_VC_Addon__GMap__Manager
	 *
	 * @return PixelThrone_VC_Addon__GMap__Manager
	 */
	public static
	function getInstance() {
		if ( ! ( self::$_instance instanceof self ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	function __construct() {
		add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
	}

	function plugins_loaded() {
		/**
		 * Include Plugin Paths
		 *
		 * @since 1.0.0
		 */
		$this->paths = include __DIR__ . '/settings/paths.php';
		/**
		 * Include Plugin Info
		 *
		 * @since 1.0.0
		 */
		$this->info = pixelThrone_vc_addon__gmap__tools()->array_to_object( include __DIR__ . '/settings/info.php' );

		# Define default plugin constants
		$this->define_constants();
		/**
		 * Init Notices
		 *
		 * @since 1.0.0
		 */
		$this->notices = new PixelThrone_VC_Addon__GMap__Notices_Manager();


		/**
		 * Checke if Visual Composer is Installed
		 *
		 * @since 1.0.0
		 */
		if ( ! $this->notices->composer__is_installed() )
			return;

		/**
		 * Compare Visual Composer Versions
		 *
		 * @since 1.0.0
		 */
		if ( ! $this->notices->composer__compare_versions() )
			 return;

		/**
		 * Theme  Info
		 *
		 * @since 1.0.0
		 */
		$wp_get_theme = wp_get_theme();
		$this->theme_info =  (object) array(
			'name' =>  strtolower( $wp_get_theme->get( 'Name' ) ),
			'version' => $wp_get_theme->get( 'Version' ),
		);

		/**
		 * Init Redux Plugin Extra Config
		 *
		 * @since  1.0.0
		 */
		$this->vc = new PixelThrone_VC_Addon__GMap__Visual_Composer__Extend();

		/**
		 * Load Shortcodes
		 *
		 * @since 1.0.0
		 */
		$this->shortcodes = new PixelThrone_VC_Addon__GMap__Shortcodes_Manager();
		/**
		 * Init Actions
		 *
		 * @since  1.0.0
		 */
		add_action( 'vc_after_init', array( $this, 'vc_after_init' ), 10 );
	}

	/**
	 * Init Plugin Settings
	 *
	 * @since       1.0.0
	 *
	 * @return      void
	 */
	public
	function vc_after_init() {
		/**
		 * Load plugin textdomain
		 *
		 * @since 1.0.0
		 */
		load_plugin_textdomain( PT_VC_ADDON_GMAP_TEXTDOMAIN, false, basename( dirname( __FILE__ ) ) . '/languages' );

		/**
		 * Add function to wp_head action
		 *
		 * @since  1.0.0
		 */
		add_action( 'wp_head', array( $this, 'header__echo_css' ), 100 );

		/**
		 * Add function to wp_footer action
		 *
		 * @since  1.0.0
		 */
		add_action( 'wp_footer', array( $this, 'footer__echo_css' ), 100 );
		/**
		 * Enqueue Scripts
		 *
		 * @since  1.0.0
		 */
		if ( is_admin() ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'backend__enqueue_scripts' ) );
		} else {
			add_action( 'wp_enqueue_scripts', array( $this, 'frontend__enqueue_scripts' ) );
		}
		/**
		 * Add plugin extra class to body
		 *
		 * @since  1.0.0
		 */
		add_action( 'body_class', array( $this, 'add__body_classes' ) );
	}

	/**
	 * Admin Init
	 *
	 * @since   1.0.0
	 * @return  void
	 */
	public
	function add__body_classes( $classes ) {
		$classes[] = 'pixelthrone--addon-gmap--version-' . $this->info->version;
		return $classes;
	}
	/**
	 * Admin Init
	 *
	 * @since   1.0.0
	 * @return  void
	 */
	public
	function define_constants( ) {
		/**
		 * Our plugin version
		 *
		 * @since 1.0.0
		 * @var string
		 */
		if ( ! defined( 'PT_VC_ADDON_GMAP_VERSION' ) ) {
			define( 'PT_VC_ADDON_GMAP_VERSION', $this->info->version );
		}
		/**
		 * Name
		 *
		 * @since 1.0.0
		 * @var string
		 */
		if ( ! defined( 'PT_VC_ADDON_GMAP_NAME' ) ) {
			define( 'PT_VC_ADDON_GMAP_NAME', $this->info->name );
		}

		/**
		 * Compatible version of visual composer
		 *
		 * @since 1.0.0
		 * @var string
		 */
		if ( ! defined( 'PT_VC_ADDON_GMAP_COMPATIBLE_VERSION' ) ) {
			define( 'PT_VC_ADDON_GMAP_COMPATIBLE_VERSION', $this->info->vc->compatible );
		}
		/**
		 * Required version of visual composer
		 *
		 * @since 1.0.0
		 * @var string
		 */
		if ( ! defined( 'PT_VC_ADDON_GMAP_REQUIRED_VERSION' ) ) {
			define( 'PT_VC_ADDON_GMAP_REQUIRED_VERSION', $this->info->vc->required );
		}
	}

	/**
	 * Gets absolute path for file/directory in filesystem.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @param        $name - name of path dir
	 * @param string $file - file name or directory inside path
	 *
	 * @return string
	 */
	public
	function path( $name, $file = '' ) {
		$path = $this->paths[ $name ] . ( strlen( $file ) > 0 ? '/' . preg_replace( '/^\//', '', $file ) : '' );

		return $path;
		// return apply_filters( 'pt_theme__path_filter', $path );
	}

	/**
	 * Add css to footer
	 *
	 * @access      public
	 * @version     1.0.0
	 * @since       1.0.0
	 *
	 * @return      string
	 */
	public
	function header__echo_css( $action = 'echo' ) {
		$style = implode( ' ', array_filter( self::$shortcodes_header_css ) );
		$style = preg_replace('/^\s+|\n|\r|\s+$/m', '', trim( preg_replace( '/\s\s+/', ' ', $style ) ));

		$output =
<<<HTML
<!---- PIXELTHRONE EXTENSION SHORTCODE STYLE ---->
<style>
$style
</style>
<!--------------------- END --------------------->
HTML;

		if ( $action == 'return' ):
			return $output;
		else:
			echo $output;
		endif;
	}

	/**
	 * Add css to footer
	 *
	 * @access      public
	 * @since       1.0.0
	 *
	 * @return      string
	 */
	public
	function footer__echo_css( $action = 'echo' ) {
		$style = implode( ' ', array_filter( self::$shortcodes_footer_css ) );
		$style = preg_replace('/^\s+|\n|\r|\s+$/m', '', trim( preg_replace( '/\s\s+/', ' ', $style ) ));

		$output =
<<<HTML
<!---- PIXELTHRONE EXTENSION SHORTCODE STYLE ---->
<style>
$style
</style>
<!--------------------- END --------------------->
HTML;

		if ( $action == 'return' ):
			return $output;
		else:
			echo $output;
		endif;
	}

	/**
	 * Add css to print on header
	 *
	 * @access  public
	 * @since   1.0.0
	 *
	 * @param   $new_css string
	 *
	 * @return  void
	 */
	public
	function add__header_css( $new_css ) {
		self::$shortcodes_header_css [] = $new_css;
	}

	/**
	 * Print added css to footer
	 *
	 * @access  public
	 * @since   1.0.0
	 *
	 * @param   $new_css string
	 *
	 * @return  void
	 */
	public
	function add__footer_css( $new_css ) {
		self::$shortcodes_footer_css [] = $new_css;
	}

	/**
	 * Load Admin CSS/JS.
	 *
	 * @access  public
	 * @since   1.0.0
	 * @return void
	 */
	public
	function backend__enqueue_scripts() {
		/**
		 * Load Backend Css Style for Editor
		 *
		 * @since   1.0.0
		 */
		wp_register_style( 'pt_addon_gmap__backend', $this->path( 'ASSETS_URI', 'css.min/backend.css'), null, $this->info->version );
		wp_enqueue_style( 'pt_addon_gmap__backend' );

		/**
		 * Load Backend Vendor Css Style
		 *
		 * @since   1.0.0
		 */
		wp_register_style( 'pt_addon_gmap__backend-vendor', $this->path( 'ASSETS_URI', 'css.min/backend.vendor.css'), null, $this->info->version );
		wp_enqueue_style( 'pt_addon_gmap__backend-vendor' );

		/**
		 * Load Backend Vendor Js Script
		 *
		 * @since   1.0.0
		 */
		wp_register_script( 'pt_addon_gmap__vender-backend', $this->path( 'ASSETS_URI', 'js.min/vendor-backend.js'), array( 'jquery' ), null, true );
		wp_enqueue_script( 'pt_addon_gmap__vender-backend' );

		/**
		 * Load Backend Js Script
		 *
		 * @since   1.0.0
		 */
		wp_register_script( 'pt_addon_gmap__core_backend', $this->path( 'ASSETS_URI', 'js.min/backend.js'), array( 'jquery', 'pt_addon_gmap__vender-backend' ), null, true );
		wp_enqueue_script( 'pt_addon_gmap__core_backend' );
	}

	/**
	 * Load Frontend CSS/JS.
	 *
	 * @access  public
	 * @since   1.0.0
	 * @return void
	 */
	public
	function frontend__enqueue_scripts() {

		wp_register_style( 'pt_addon_gmap__frontend', $this->path( 'ASSETS_URI', 'css.min/frontend.css'), null, $this->info->version );
		wp_enqueue_style( 'pt_addon_gmap__frontend' );

		wp_register_style( 'pt_addon_gmap__frontend-vendor', $this->path( 'ASSETS_URI', 'css.min/frontend.vendor.css'), null, $this->info->version );
		wp_enqueue_style( 'pt_addon_gmap__frontend-vendor' );

		/**
		 * SCRIPTS
		 ***
		 * My Scripts
		 */
		wp_register_script( 'pt_addon_gmap__vender-frontend', $this->path( 'ASSETS_URI', 'js.min/vendor-frontend.js'), array( 'jquery' ), null, true );
		wp_enqueue_script( 'pt_addon_gmap__vender-frontend' );

		wp_register_script( 'pt_addon_gmap__frontend', $this->path( 'ASSETS_URI', 'js.min/frontend.js'), array( 'jquery', 'pt_addon_gmap__vender-frontend' ), null, true );
		wp_enqueue_script( 'pt_addon_gmap__frontend' );

	}

	/**
	 * Installation. Runs on activation.
	 *
	 * @access  public
	 * @since   1.0.0
	 * @return  void
	 */
	public
	function install() {
	}

	/**
	 * Cloning disabled
	 */
	private
	function __clone() {
		_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?' ), $this->info->version );
	}

	/**
	 * Serialization disabled
	 */
	private
	function __sleep() {
		_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?' ), $this->info->version );
	}

	/**
	 * De-serialization disabled
	 */
	private
	function __wakeup() {
		_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?' ), $this->info->version );
	}



}

/**
 * Get plugin instance.
 *
 * @since 1.0.0
 * @return pixelThrone_vc_addon__gmap__Manager
 */
if ( ! function_exists( 'pixelThrone_vc_addon__gmap' ) ) {
	function pixelThrone_vc_addon__gmap() {
		return pixelThrone_vc_addon__gmap__Manager::getInstance();
	}
}




