<?php
/**
* Icon Params
*/

if( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function rella_get_icon( $atts = array(), $add_icon = false, $prefix = 'i_' ) {

	$atts = shortcode_atts( array(

		// Icon
		$prefix . 'add_icon'         => false,
		$prefix . 'type'             => 'fontawesome',
		$prefix . 'icon_fontawesome' => false,
		$prefix . 'icon_linea'       => false,
		$prefix . 'icon_openiconic'  => false,
		$prefix . 'icon_typicons'    => false,
		$prefix . 'icon_entypo'      => false,
		$prefix . 'icon_linecons'    => false,

		//Custom icons
		$prefix . 'icon_rella_custom_icons' => false,

		// Style
		$prefix . 'color'            => false,
		$prefix . 'align'            => false

	), $atts );

	if( $add_icon && 'true' !== $atts[ $prefix . 'add_icon' ] ) {
		return '';
	}

	$type = $atts[ $prefix . 'type' ];
	$icon_class = isset( $atts[ $prefix . 'icon_' . $type ] ) ? esc_attr( $atts[ $prefix . 'icon_' . $type ] ) : 'fa fa-adjust';
	$icon_color = isset( $atts[ $prefix . 'color' ] ) ? $atts[ $prefix . 'color' ] : '';
	$icon_align = isset( $atts[ $prefix . 'align' ] ) ? $atts[ $prefix . 'align' ] : 'left';

	vc_icon_element_fonts_enqueue( $type );

	return array(
		'type'	=> $type,
		'color'	=> $icon_color,
		'icon'	=> $icon_class,
		'align'	=> $icon_align
	);
}

function rella_get_icon_params( $add_icon = false, $group = '', $fonts = 'all', $remove = array(), $prefix = 'i_', $dependency = array() ) {

	$font_hash = array(
		'fontawesome'   => esc_html__( 'Font Awesome', 'infinite-addons' ),
		'linea'         => esc_html__( 'Linea 10', 'infinite-addons' ),
		'openiconic'    => esc_html__( 'Open Iconic', 'infinite-addons' ),
		'typicons'      => esc_html__( 'Typicons', 'infinite-addons' ),
		'entypo'        => esc_html__( 'Entypo', 'infinite-addons' ),
		'linecons'      => esc_html__( 'Linecons', 'infinite-addons' )
	);
	
	//Add custom icons fonts
	$font_hash = apply_filters( 'rella_custom_icons_font', $font_hash );

	$settings = array();

	// Add icon field
	if( $add_icon && 'manual' !== $add_icon ) {
		$settings[] = array(
            'type'       => 'checkbox',
            'param_name' => $prefix . 'add_icon',
            'heading'    => esc_html__( 'Add icon?', 'infinite-addons' )
		);
	}

// Iconpicker field
	$add_these = $add_these_select = array();
	$add_these_select[esc_html__( 'Select icon font.', 'infinite-addons' )] = '';

	if( 'all' == $fonts ) {
		$fonts = array_keys( $font_hash );
	}

	foreach( $fonts as $font ) {
		$add_these_select[ $font_hash[$font] ] = $font;

		$add_these[] = array(
			'type'       => 'iconpicker',
			'param_name' => $prefix . 'icon_' . $font,
			'heading'    => esc_html__( 'Icon', 'infinite-addons' ),
			'description' => esc_html__( 'Select icon from library.', 'infinite-addons' ),
			'settings' => array(
				'emptyIcon'    => false,
				'type'         => $font,
				'iconsPerPage' => 4000
			),
			'dependency' => array(
				'element' => $prefix . 'type',
				'value'   => $font
			),
			'group' => $group
		);
	}

	// Icon library select field
	$settings[] = array(
		'type'       => 'dropdown',
		'param_name' => $prefix . 'type',
		'heading'    => esc_html__( 'Icon library', 'infinite-addons' ),
		'value'      => $add_these_select,
		'description' => esc_html__( 'Select icon library.', 'infinite-addons' ),
		'dependency'  => ! $add_icon ? $dependency : array(
			'element' => $prefix . 'add_icon',
            'value'   => 'true'
		),
		'group' => $group
	);

	$settings = array_merge( $settings, $add_these );

	// Icon color picker field
	if( ! in_array( 'color', $remove ) ) {
		$settings[] = array(
			'type'        => 'colorpicker',
			'param_name'  => $prefix . 'color',
			'heading'     => esc_html__( 'Icon color', 'infinite-addons' ),
			'description' => esc_html__( 'Select icon color.', 'infinite-addons' ),
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			),
			'group' => $group
		);
	}

	// Icon alignment field
	if( ! in_array( 'align', $remove ) ) {
		$settings[] = array(
			'type'       => 'dropdown',
			'param_name' => $prefix . 'align',
			'heading'    => esc_html__( 'Icon alignment', 'infinite-addons' ),
			'value'      => array(
				esc_html__( 'Left', 'infinite-addons' )   => 'left',
				esc_html__( 'Right', 'infinite-addons' )  => 'right'
			),
			'description' => esc_html__( 'Select icon alignment.', 'infinite-addons' ),
			'group' => $group,
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			)
		);
	}

	foreach( $settings as &$param ) {
		if( empty( $param['group'] ) ) {
			unset($param['group']);
		}
	}

	return $settings;
}

add_filter( 'vc_iconpicker-type-linea', 'rs_iconpicker_type_linea' );
/**
 * [rs_iconpicker_type_linea description]
 * @method rs_iconpicker_type_linea
 * @param  [type]                   $icons [description]
 * @return [type]                          [description]
 */
function rs_iconpicker_type_linea( $icons ) {

	$linea_icons = array(

		'Software' => array(
			array('icon-software_font_allcaps' => 'Software font allcaps' ),
			array('icon-software_font_smallcapital' => 'Software font smallcapital' ),
			array('icon-software_font_smallcaps' => 'Software font smallcaps' ),
			array('icon-software_font_underline' => 'Software font underline' ),
			array('icon-software_layers1' => 'Software layers1' ),
			array('icon-software_layers2' => 'Software layers2' ),
			array('icon-software_layout_2columns' => 'Software layout 2columns' ),
			array('icon-software_layout_3columns' => 'Software layout 3columns' ),
			array('icon-software_layout_4boxes' => 'Software layout 4boxes' ),
			array('icon-software_layout_4columns' => 'Software layout 4columns' ),
			array('icon-software_layout_4lines' => 'Software layout 4lines' ),
			array('icon-software_layout_header_2columns' => 'Software layout header 2columns' ),
			array('icon-software_layout_header_3columns' => 'Software layout header 3columns' ),
			array('icon-software_layout_header_4boxes' => 'Software layout header 4boxes' ),
			array('icon-software_layout_header_4columns' => 'Software layout header 4columns' ),
			array('icon-software_layout_header_complex' => 'Software layout header complex' ),
			array('icon-software_layout_header_complex2' => 'Software layout header complex2' ),
			array('icon-software_layout_header_complex3' => 'Software layout header complex3' ),
			array('icon-software_layout_header_complex4' => 'Software layout header complex4' ),
			array('icon-software_layout_header_sideleft' => 'Software layout header sideleft' ),
			array('icon-software_layout_header_sideright' => 'Software layout header sideright' ),
			array('icon-software_layout_header' => 'Software layout header' ),
			array('icon-software_layout_sidebar_left' => 'Software layout sidebar left' ),
			array('icon-software_layout_sidebar_right' => 'Software layout sidebar right' ),
			array('icon-software_layout-8boxes' => 'Software layout 8boxes' ),
			array('icon-software_layout' => 'Software layout' ),
			array('icon-software_pages' => 'Software pages' ),
			array('icon-software_paintbrush' => 'Software paintbrush' ),
			array('icon-software_paintbucket' => 'Software paintbucket' ),
			array('icon-software_paintroller' => 'Software paintroller' ),
			array('icon-software_paragraph_align_left' => 'Software paragraph align left' ),
			array('icon-software_paragraph_align_right' => 'Software paragraph align right' ),
			array('icon-software_paragraph_center' => 'Software paragraph center' ),
			array('icon-software_paragraph_justify_all' => 'Software paragraph justify all' ),
			array('icon-software_paragraph_justify_center' => 'Software paragraph justify center' ),
			array('icon-software_paragraph_justify_left' => 'Software paragraph justify left' ),
			array('icon-software_paragraph_justify_right' => 'Software paragraph justify right' ),
			array('icon-software_pathfinder_exclude' => 'Software pathfinder exclude' ),
			array('icon-software_pathfinder_intersect' => 'Software pathfinder intersect' ),
			array('icon-software_pathfinder_subtract' => 'Software pathfinder subtract' ),
			array('icon-software_pathfinder_unite' => 'Software pathfinder unite' ),
			array('icon-software_pen_add' => 'Software pen add' ),
			array('icon-software_pen_remove' => 'Software pen remove' ),
			array('icon-software_pen' => 'Software pen' ),
			array('icon-software_pencil' => 'Software pencil' ),
			array('icon-software_polygonallasso' => 'Software polygonallasso' ),
			array('icon-software_slice' => 'Software slice' ),
			array('icon-software_transform_bezier' => 'Software transform bezier' ),
			array('icon-software_vector_box' => 'Software vector box' ),
			array('icon-software_vector_composite' => 'Software vector composite' ),
			array('icon-software_vector_line' => 'Software vector line' ),
		),

		'Music' => array(
			array( 'icon-music_beginning_button' => 'Music beginning button' ),
			array( 'icon-music_bell' => 'Music bell' ),
			array( 'icon-music_cd' => 'Music cd' ),
			array( 'icon-music_diapason' => 'Music diapason' ),
			array( 'icon-music_eject_button' => 'Music eject button' ),
			array( 'icon-music_end_button' => 'Music end_button' ),
			array( 'icon-music_fastforward_button' => 'Music fastforward button' ),
			array( 'icon-music_headphones' => 'Music headphones' ),
			array( 'icon-music_ipod' => 'Music ipod' ),
			array( 'icon-music_loudspeaker' => 'Music loudspeaker' ),
			array( 'icon-music_microphone_old' => 'Music microphone old' ),
			array( 'icon-music_microphone' => 'Music microphone' ),
			array( 'icon-music_mixer' => 'Music mixer' ),
			array( 'icon-music_mute' => 'Music mute' ),
			array( 'icon-music_note_multiple' => 'Music note multiple' ),
			array( 'icon-music_note_single' => 'Music note single' ),
			array( 'icon-music_pause_button' => 'Music pause button' ),
			array( 'icon-music_play_button' => 'Music play button' ),
			array( 'icon-music_playlist' => 'Music playlist' ),
			array( 'icon-music_radio_ghettoblaster' => 'Music radio ghettoblaster' ),
			array( 'icon-music_radio_portable' => 'Music radio portable' ),
			array( 'icon-music_record' => 'Music record' ),
			array( 'icon-music_recordplayer' => 'Music recordplayer' ),
			array( 'icon-music_repeat_button' => 'Music repeat button' ),
			array( 'icon-music_rewind_button' => 'Music rewind button' ),
			array( 'icon-music_shuffle_button' => 'Music shuffle button' ),
			array( 'icon-music_stop_button' => 'Music stop button' ),
			array( 'icon-music_tape' => 'Music tape' ),
			array( 'icon-music_volume_down' => 'Music volume down' ),
			array( 'icon-music_volume_up' => 'Music volume up' ),
		),

		'Ecommerce' => array(
			array( 'icon-ecommerce_bag_check' => 'Ecommerce bag check' ),
			array( 'icon-ecommerce_bag_minus' => 'Ecommerce bag minus' ),
			array( 'icon-ecommerce_bag_plus' => 'Ecommerce bag plus' ),
			array( 'icon-ecommerce_bag_refresh' => 'Ecommerce bag refresh' ),
			array( 'icon-ecommerce_bag_remove' => 'Ecommerce bag remove' ),
			array( 'icon-ecommerce_bag_search' => 'Ecommerce bag search' ),
			array( 'icon-ecommerce_bag' => 'Ecommerce bag' ),
			array( 'icon-ecommerce_banknote' => 'Ecommerce banknote' ),
			array( 'icon-ecommerce_banknotes' => 'Ecommerce banknotes' ),
			array( 'icon-ecommerce_basket' => 'Ecommerce basket' ),
			array( 'icon-ecommerce_bath' => 'Ecommerce bath' ),
			array( 'icon-ecommerce_cart_check' => 'Ecommerce cart check' ),
			array( 'icon-ecommerce_cart_content' => 'Ecommerce cart content' ),
			array( 'icon-ecommerce_cart_minus' => 'Ecommerce cart minus' ),
			array( 'icon-ecommerce_cart_plus' => 'Ecommerce cart plus' ),
			array( 'icon-ecommerce_cart_refresh' => 'Ecommerce cart refresh' ),
			array( 'icon-ecommerce_cart_remove' => 'Ecommerce cart remove' ),
			array( 'icon-ecommerce_cart_search' => 'Ecommerce cart search' ),
			array( 'icon-ecommerce_cart' => 'Ecommerce cart' ),
			array( 'icon-ecommerce_cent' => 'Ecommerce cent' ),
			array( 'icon-ecommerce_colon' => 'Ecommerce colon' ),
			array( 'icon-ecommerce_creditcard' => 'Ecommerce creditcard' ),
			array( 'icon-ecommerce_diamond' => 'Ecommerce diamond' ),
			array( 'icon-ecommerce_dollar' => 'Ecommerce dollar' ),
			array( 'icon-ecommerce_euro' => 'Ecommerce euro' ),
			array( 'icon-ecommerce_franc' => 'Ecommerce franc' ),
			array( 'icon-ecommerce_gift' => 'Ecommerce gift' ),
			array( 'icon-ecommerce_graph_decrease' => 'Ecommerce graph decrease' ),
			array( 'icon-ecommerce_graph_increase' => 'Ecommerce graph increase' ),
			array( 'icon-ecommerce_graph1' => 'Ecommerce graph1' ),
			array( 'icon-ecommerce_graph2' => 'Ecommerce graph2' ),
			array( 'icon-ecommerce_graph3' => 'Ecommerce graph3' ),
			array( 'icon-ecommerce_guarani' => 'Ecommerce guarani' ),
			array( 'icon-ecommerce_kips' => 'Ecommerce kips' ),
			array( 'icon-ecommerce_lira' => 'Ecommerce lira' ),
			array( 'icon-ecommerce_megaphone' => 'Ecommerce megaphone' ),
			array( 'icon-ecommerce_money' => 'Ecommerce money' ),
			array( 'icon-ecommerce_naira' => 'Ecommerce naira' ),
			array( 'icon-ecommerce_pesos' => 'Ecommerce pesos' ),
			array( 'icon-ecommerce_pound' => 'Ecommerce pound' ),
			array( 'icon-ecommerce_receipt_bath' => 'Ecommerce receipt bath' ),
			array( 'icon-ecommerce_receipt_cent' => 'Ecommerce receipt cent' ),
			array( 'icon-ecommerce_receipt_dollar' => 'Ecommerce receipt dollar' ),
			array( 'icon-ecommerce_receipt_euro' => 'Ecommerce receipt euro' ),
			array( 'icon-ecommerce_receipt_franc' => 'Ecommerce receipt franc' ),
			array( 'icon-ecommerce_receipt_guarani' => 'Ecommerce receipt guarani' ),
			array( 'icon-ecommerce_receipt_kips' => 'Ecommerce receipt kips' ),
			array( 'icon-ecommerce_receipt_lira' => 'Ecommerce receipt lira' ),
			array( 'icon-ecommerce_receipt_naira' => 'Ecommerce receipt naira' ),
			array( 'icon-ecommerce_receipt_pesos' => 'Ecommerce receipt pesos' ),
			array( 'icon-ecommerce_receipt_pound' => 'Ecommerce receipt pound' ),
			array( 'icon-ecommerce_receipt_rublo' => 'Ecommerce receipt rublo' ),
			array( 'icon-ecommerce_receipt_rupee' => 'Ecommerce receipt rupee' ),
			array( 'icon-ecommerce_receipt_tugrik' => 'Ecommerce receipt tugrik' ),
			array( 'icon-ecommerce_receipt_won' => 'Ecommerce receipt won' ),
			array( 'icon-ecommerce_receipt_yen' => 'Ecommerce receipt yen' ),
			array( 'icon-ecommerce_receipt_yen2' => 'Ecommerce receipt yen2' ),
			array( 'icon-ecommerce_receipt' => 'Ecommerce receipt' ),
			array( 'icon-ecommerce_recept_colon' => 'Ecommerce recept colon' ),
			array( 'icon-ecommerce_rublo' => 'Ecommerce rublo' ),
			array( 'icon-ecommerce_rupee' => 'Ecommerce rupee' ),
			array( 'icon-ecommerce_safe' => 'Ecommerce safe' ),
			array( 'icon-ecommerce_sale' => 'Ecommerce sale' ),
			array( 'icon-ecommerce_sales' => 'Ecommerce sales' ),
			array( 'icon-ecommerce_ticket' => 'Ecommerce ticket' ),
			array( 'icon-ecommerce_tugriks' => 'Ecommerce tugriks' ),
			array( 'icon-ecommerce_wallet' => 'Ecommerce wallet' ),
			array( 'icon-ecommerce_won' => 'Ecommerce won' ),
			array( 'icon-ecommerce_yen' => 'Ecommerce yen' ),
			array( 'icon-ecommerce_yen2' => 'Ecommerce yen2' ),
		),

		'Basic Elaboration' => array(
			array( 'icon-basic_elaboration_bookmark_checck' => 'Basic Eaboration bookmark checck' ),
			array( 'icon-basic_elaboration_bookmark_minus' => 'Basic Eaboration bookmark minus' ),
			array( 'icon-basic_elaboration_bookmark_plus' => 'Basic Eaboration bookmark plus' ),
			array( 'icon-basic_elaboration_bookmark_remove' => 'Basic Eaboration bookmark remove' ),
			array( 'icon-basic_elaboration_mail_check' => 'Basic Eaboration mail check' ),
			array( 'icon-basic_elaboration_mail_cloud' => 'Basic Eaboration mail cloud' ),
			array( 'icon-basic_elaboration_mail_document' => 'Basic Eaboration mail document' ),
			array( 'icon-basic_elaboration_mail_download' => 'Basic Eaboration mail download' ),
			array( 'icon-basic_elaboration_mail_flagged' => 'Basic Eaboration mail flagged' ),
			array( 'icon-basic_elaboration_mail_heart' => 'Basic Eaboration mail heart' ),
			array( 'icon-basic_elaboration_mail_next' => 'Basic Eaboration mail next' ),
			array( 'icon-basic_elaboration_mail_noaccess' => 'Basic Eaboration mail noaccess' ),
			array( 'icon-basic_elaboration_mail_note' => 'Basic Eaboration mail note' ),
			array( 'icon-basic_elaboration_mail_pencil' => 'Basic Eaboration mail pencil' ),
			array( 'icon-basic_elaboration_mail_picture' => 'Basic Eaboration mail picture' ),
			array( 'icon-basic_elaboration_mail_previous' => 'Basic Eaboration mail previous' ),
			array( 'icon-basic_elaboration_mail_refresh' => 'Basic Eaboration mail refresh' ),
			array( 'icon-basic_elaboration_mail_remove' => 'Basic Eaboration mail remove' ),
			array( 'icon-basic_elaboration_mail_search' => 'Basic Eaboration mail search' ),
			array( 'icon-basic_elaboration_mail_star' => 'Basic Eaboration mail star' ),
			array( 'icon-basic_elaboration_mail_upload' => 'Basic Eaboration mail upload' ),
			array( 'icon-basic_elaboration_message_check' => 'Basic Eaboration message check' ),
			array( 'icon-basic_elaboration_message_dots' => 'Basic Eaboration message dots' ),
			array( 'icon-basic_elaboration_message_happy' => 'Basic Eaboration message happy' ),
			array( 'icon-basic_elaboration_message_heart' => 'Basic Eaboration message heart' ),
			array( 'icon-basic_elaboration_message_minus' => 'Basic Eaboration message minus' ),
			array( 'icon-basic_elaboration_message_note' => 'Basic Eaboration message note' ),
			array( 'icon-basic_elaboration_message_plus' => 'Basic Eaboration message plus' ),
			array( 'icon-basic_elaboration_message_refresh' => 'Basic Eaboration message refresh' ),
			array( 'icon-basic_elaboration_message_remove' => 'Basic Eaboration message remove' ),
			array( 'icon-basic_elaboration_message_sad' => 'Basic Eaboration message sad' ),
			array( 'icon-basic_elaboration_todolist_2' => 'Basic Eaboration todolist 2' ),
		),

		'Basic' => array(
			array( 'icon-basic_accelerator' => 'Basic accelerator' ),
			array( 'icon-basic_alarm' => 'Basic alarm' ),
			array( 'icon-basic_anchor' => 'Basic anchor' ),
			array( 'icon-basic_anticlockwise' => 'Basic anticlockwise' ),
			array( 'icon-basic_archive_full' => 'Basic archive full' ),
			array( 'icon-basic_archive' => 'Basic archive' ),
			array( 'icon-basic_ban' => 'Basic ban' ),
			array( 'icon-basic_bolt' => 'Basic bolt' ),
			array( 'icon-basic_book_pen' => 'Basic book pen' ),
			array( 'icon-basic_book_pencil' => 'Basic book pencil' ),
			array( 'icon-basic_book' => 'Basic book' ),
			array( 'icon-basic_bookmark' => 'Basic bookmark' ),
			array( 'icon-basic_calculator' => 'Basic calculator' ),
			array( 'icon-basic_calendar' => 'Basic calendar' ),
			array( 'icon-basic_cards_diamonds' => 'Basic cards diamonds' ),
			array( 'icon-basic_cards_hearts' => 'Basic cards hearts' ),
			array( 'icon-basic_case' => 'Basic case' ),
			array( 'icon-basic_chronometer' => 'Basic chronometer' ),
			array( 'icon-basic_clessidre' => 'Basic clessidre' ),
			array( 'icon-basic_clock' => 'Basic clock' ),
			array( 'icon-basic_clockwise' => 'Basic clockwise' ),
			array( 'icon-basic_cloud' => 'Basic cloud' ),
			array( 'icon-basic_clubs' => 'Basic clubs' ),
			array( 'icon-basic_compass' => 'Basic compass' ),
			array( 'icon-basic_cup' => 'Basic cup' ),
			array( 'icon-basic_diamonds' => 'Basic diamonds' ),
			array( 'icon-basic_display' => 'Basic display' ),
			array( 'icon-basic_download' => 'Basic download' ),
			array( 'icon-basic_exclamation' => 'Basic exclamation' ),
			array( 'icon-basic_eye_closed' => 'Basic eye closed' ),
			array( 'icon-basic_eye' => 'Basic eye' ),
			array( 'icon-basic_female' => 'Basic female' ),
			array( 'icon-basic_flag1' => 'Basic flag1' ),
			array( 'icon-basic_flag2' => 'Basic flag2' ),
			array( 'icon-basic_floppydisk' => 'Basic floppydisk' ),
			array( 'icon-basic_folder_multiple' => 'Basic folder multiple' ),
			array( 'icon-basic_folder' => 'Basic folder' ),
			array( 'icon-basic_gear' => 'Basic gear' ),
			array( 'icon-basic_geolocalize-01' => 'Basic geolocalize 01' ),
			array( 'icon-basic_geolocalize-05' => 'Basic geolocalize 05' ),
			array( 'icon-basic_globe' => 'Basic globe' ),
			array( 'icon-basic_gunsight' => 'Basic gunsight' ),
			array( 'icon-basic_hammer' => 'Basic hammer' ),
			array( 'icon-basic_headset' => 'Basic headset' ),
			array( 'icon-basic_heart_broken' => 'Basic heart broken' ),
			array( 'icon-basic_heart' => 'Basic heart' ),
			array( 'icon-basic_helm' => 'Basic helm' ),
			array( 'icon-basic_home' => 'Basic home' ),
			array( 'icon-basic_info' => 'Basic info' ),
			array( 'icon-basic_ipod' => 'Basic ipod' ),
			array( 'icon-basic_joypad' => 'Basic joypad' ),
			array( 'icon-basic_key' => 'Basic key' ),
			array( 'icon-basic_keyboard' => 'Basic keyboard' ),
			array( 'icon-basic_laptop' => 'Basic laptop' ),
			array( 'icon-basic_life_buoy' => 'Basic life buoy' ),
			array( 'icon-basic_lightbulb' => 'Basic lightbulb' ),
			array( 'icon-basic_link' => 'Basic link' ),
			array( 'icon-basic_lock_open' => 'Basic lock open' ),
			array( 'icon-basic_lock' => 'Basic lock' ),
			array( 'icon-basic_magic_mouse' => 'Basic magic mouse' ),
			array( 'icon-basic_magnifier_minus' => 'Basic magnifier minus' ),
			array( 'icon-basic_magnifier_plus' => 'Basic magnifier plus' ),
			array( 'icon-basic_magnifier' => 'Basic magnifier' ),
			array( 'icon-basic_mail_multiple' => 'Basic mail multiple' ),
			array( 'icon-basic_mail_open_text' => 'Basic mail open_text' ),
			array( 'icon-basic_mail_open' => 'Basic mail open' ),
			array( 'icon-basic_mail' => 'Basic mail' ),
			array( 'icon-basic_male' => 'Basic male' ),
			array( 'icon-basic_map' => 'Basic map' ),
			array( 'icon-basic_message_multiple' => 'Basic message multiple' ),
			array( 'icon-basic_message_txt' => 'Basic message txt' ),
			array( 'icon-basic_message' => 'Basic message' ),
			array( 'icon-basic_mixer2' => 'Basic mixer2' ),
			array( 'icon-basic_mouse' => 'Basic mouse' ),
			array( 'icon-basic_notebook_pen' => 'Basic notebook pen' ),
			array( 'icon-basic_notebook_pencil' => 'Basic notebook pencil' ),
			array( 'icon-basic_notebook' => 'Basic notebook' ),
			array( 'icon-basic_paperplane' => 'Basic paperplane' ),
			array( 'icon-basic_pencil_ruler_pen' => 'Basic pencil ruler pen' ),
			array( 'icon-basic_pencil_ruler' => 'Basic pencil ruler' ),
			array( 'icon-basic_photo' => 'Basic photo' ),
			array( 'icon-basic_picture_multiple' => 'Basic picture multiple' ),
			array( 'icon-basic_picture' => 'Basic picture' ),
			array( 'icon-basic_pin1' => 'Basic pin1' ),
			array( 'icon-basic_pin2' => 'Basic pin2' ),
			array( 'icon-basic_postcard_multiple' => 'Basic postcard multiple' ),
			array( 'icon-basic_postcard' => 'Basic postcard' ),
			array( 'icon-basic_printer' => 'Basic printer' ),
			array( 'icon-basic_question' => 'Basic question' ),
			array( 'icon-basic_rss' => 'Basic rss' ),
			array( 'icon-basic_server_cloud' => 'Basic server cloud' ),
			array( 'icon-basic_server_download' => 'Basic server download' ),
			array( 'icon-basic_server_upload' => 'Basic server upload' ),
			array( 'icon-basic_server' => 'Basic server' ),
			array( 'icon-basic_server2' => 'Basic server2' ),
			array( 'icon-basic_settings' => 'Basic settings' ),
			array( 'icon-basic_share' => 'Basic share' ),
			array( 'icon-basic_sheet_multiple' => 'Basic sheet multiple' ),
			array( 'icon-basic_sheet_pen' => 'Basic sheet pen' ),
			array( 'icon-basic_sheet_pencil' => 'Basic sheet pencil' ),
			array( 'icon-basic_sheet_txt' => 'Basic sheet txt' ),
			array( 'icon-basic_sheet' => 'Basic sheet' ),
			array( 'icon-basic_signs' => 'Basic signs' ),
			array( 'icon-basic_smartphone' => 'Basic smartphone' ),
			array( 'icon-basic_spades' => 'Basic spades' ),
			array( 'icon-basic_spread_bookmark' => 'Basic spread bookmark' ),
			array( 'icon-basic_spread_text_bookmark' => 'Basic spread text bookmark' ),
			array( 'icon-basic_spread_text' => 'Basic spread text' ),
			array( 'icon-basic_spread' => 'Basic spread' ),
			array( 'icon-basic_star' => 'Basic star' ),
			array( 'icon-basic_tablet' => 'Basic tablet' ),
			array( 'icon-basic_target' => 'Basic target' ),
			array( 'icon-basic_todo_pen' => 'Basic todo pen' ),
			array( 'icon-basic_todo_pencil' => 'Basic todo pencil' ),
			array( 'icon-basic_todo_txt' => 'Basic todo txt' ),
			array( 'icon-basic_todo' => 'Basic todo' ),
			array( 'icon-basic_todolist_pen' => 'Basic todolist pen' ),
			array( 'icon-basic_todolist_pencil' => 'Basic todolist pencil' ),
			array( 'icon-basic_upload' => 'Basic upload' ),
			array( 'icon-basic_usb' => 'Basic usb' ),
			array( 'icon-basic_video' => 'Basic video' ),
			array( 'icon-basic_watch' => 'Basic watch' ),
			array( 'icon-basic_webpage_img_txt' => 'Basic webpage img txt' ),
			array( 'icon-basic_webpage_multiple' => 'Basic webpage multiple' ),
			array( 'icon-basic_webpage_txt' => 'Basic webpage txt' ),
			array( 'icon-basic_webpage' => 'Basic webpage' ),
			array( 'icon-basic_world' => 'Basic world' ),
		),

		'Arrows' => array(
			array( 'icon-arrows_anticlockwise_dashed' => 'Arrows anticlockwise dashed' ),
			array( 'icon-arrows_anticlockwise' => 'Arrows anticlockwise' ),
			array( 'icon-arrows_check' => 'Arrows check' ),
			array( 'icon-arrows_circle_check' => 'Arrows circle check' ),
			array( 'icon-arrows_circle_down' => 'Arrows circle down' ),
			array( 'icon-arrows_circle_downleft' => 'Arrows circle downleft' ),
			array( 'icon-arrows_circle_downright' => 'Arrows circle downright' ),
			array( 'icon-arrows_circle_left' => 'Arrows circle left' ),
			array( 'icon-arrows_circle_minus' => 'Arrows circle minus' ),
			array( 'icon-arrows_circle_plus' => 'Arrows circle plus' ),
			array( 'icon-arrows_circle_remove' => 'Arrows circle remove' ),
			array( 'icon-arrows_circle_right' => 'Arrows circle right' ),
			array( 'icon-arrows_circle_up' => 'Arrows circle up' ),
			array( 'icon-arrows_circle_upleft' => 'Arrows circle upleft' ),
			array( 'icon-arrows_circle_upright' => 'Arrows circle upright' ),
			array( 'icon-arrows_clockwise_dashed' => 'Arrows clockwise dashed' ),
			array( 'icon-arrows_clockwise' => 'Arrows clockwise' ),
			array( 'icon-arrows_deny' => 'Arrows deny' ),
			array( 'icon-arrows_down_double-34' => 'Arrows down double 34' ),
			array( 'icon-arrows_down' => 'Arrows down' ),
			array( 'icon-arrows_downleft' => 'Arrows downleft' ),
			array( 'icon-arrows_downright' => 'Arrows downright' ),
			array( 'icon-arrows_exclamation' => 'Arrows exclamation' ),
			array( 'icon-arrows_info' => 'Arrows info' ),
			array( 'icon-arrows_left_double-32' => 'Arrows left double 32' ),
			array( 'icon-arrows_left' => 'Arrows left' ),
			array( 'icon-arrows_minus' => 'Arrows minus' ),
			array( 'icon-arrows_plus' => 'Arrows plus' ),
			array( 'icon-arrows_question' => 'Arrows question' ),
			array( 'icon-arrows_remove' => 'Arrows remove' ),
			array( 'icon-arrows_right_double-31' => 'Arrows right double 31' ),
			array( 'icon-arrows_right' => 'Arrows right' ),
			array( 'icon-arrows_rotate_anti_dashed' => 'Arrows rotate anti dashed' ),
			array( 'icon-arrows_rotate_anti' => 'Arrows rotate anti' ),
			array( 'icon-arrows_rotate_dashed' => 'Arrows rotate dashed' ),
			array( 'icon-arrows_rotate' => 'Arrows rotate' ),
			array( 'icon-arrows_slim_down_dashed' => 'Arrows slim down dashed' ),
			array( 'icon-arrows_slim_down' => 'Arrows slim down' ),
			array( 'icon-arrows_slim_left_dashed' => 'Arrows slim left dashed' ),
			array( 'icon-arrows_slim_left' => 'Arrows slim left' ),
			array( 'icon-arrows_slim_right_dashed' => 'Arrows slim right dashed' ),
			array( 'icon-arrows_slim_right' => 'Arrows slim right' ),
			array( 'icon-arrows_slim_up_dashed' => 'Arrows slim up dashed' ),
			array( 'icon-arrows_slim_up' => 'Arrows slim up' ),
			array( 'icon-arrows_squares' => 'Arrows squares' ),
			array( 'icon-arrows_up_double-33' => 'Arrows up double 33' ),
			array( 'icon-arrows_up' => 'Arrows up' ),
			array( 'icon-arrows_upleft' => 'Arrows upleft' ),
			array( 'icon-arrows_upright' => 'Arrows upright' ),
			array( 'icon-arrows_vertical' => 'Arrows vertical' ),
		),

		'General' => array(
			array( 'icon-home' => 'Icon home' ),
			array( 'icon-apartment' => 'Icon apartment' ),
			array( 'icon-pencil' => 'Icon pencil' ),
			array( 'icon-magic-wand' => 'Icon magic-wand' ),
			array( 'icon-drop' => 'Icon drop' ),
			array( 'icon-lighter' => 'Icon lighter' ),
			array( 'icon-poop' => 'Icon poop' ),
			array( 'icon-sun' => 'Icon sun' ),
			array( 'icon-moon' => 'Icon moon' ),
			array( 'icon-cloud' => 'Icon cloud' ),
			array( 'icon-cloud-upload' => 'Icon cloud upload' ),
			array( 'icon-cloud-download' => 'Icon cloud download' ),
			array( 'icon-cloud-sync' => 'Icon cloud sync' ),
			array( 'icon-cloud-check' => 'Icon cloud check' ),
			array( 'icon-database' => 'Icon database' ),
			array( 'icon-lock' => 'Icon lock' ),
			array( 'icon-cog' => 'Icon cog' ),
			array( 'icon-trash' => 'Icon trash' ),
			array( 'icon-dice' => 'Icon dice' ),
			array( 'icon-heart' => 'Icon heart' ),
			array( 'icon-star' => 'Icon star' ),
			array( 'icon-star-half' => 'Icon star half' ),
			array( 'icon-star-empty' => 'Icon star empty' ),
			array( 'icon-flag' => 'Icon flag' ),
			array( 'icon-envelope' => 'Icon envelope' ),
			array( 'icon-paperclip' => 'Icon paperclip' ),
			array( 'icon-inbox' => 'Icon inbox' ),
			array( 'icon-eye' => 'Icon eye' ),
			array( 'icon-printer' => 'Icon printer' ),
			array( 'icon-file-empty' => 'Icon file empty' ),
			array( 'icon-file-add' => 'Icon file add' ),
			array( 'icon-enter' => 'Icon enter' ),
			array( 'icon-exit' => 'Icon exit' ),
			array( 'icon-graduation-hat' => 'Icon graduation hat' ),
			array( 'icon-license' => 'Icon license' ),
			array( 'icon-music-note' => 'Icon music note' ),
			array( 'icon-film-play' => 'Icon film play' ),
			array( 'icon-camera-video' => 'Icon camera video' ),
			array( 'icon-camera' => 'Icon camera' ),
			array( 'icon-picture' => 'Icon picture' ),
			array( 'icon-book' => 'Icon book' ),
			array( 'icon-bookmark' => 'Icon bookmark' ),
			array( 'icon-user' => 'Icon user' ),
			array( 'icon-users' => 'Icon users' ),
			array( 'icon-shirt' => 'Icon shirt' ),
			array( 'icon-store' => 'Icon store' ),
			array( 'icon-cart' => 'Icon cart' ),
			array( 'icon-tag' => 'Icon tag' ),
			array( 'icon-phone-handset' => 'Icon phone handset' ),
			array( 'icon-phone' => 'Icon phone' ),
			array( 'icon-pushpin' => 'Icon pushpin' ),
			array( 'icon-map-marker' => 'Icon map marker' ),
			array( 'icon-map' => 'Icon map' ),
			array( 'icon-location' => 'Icon location' ),
			array( 'icon-calendar-full' => 'Icon calendar full' ),
			array( 'icon-keyboard' => 'Icon keyboard' ),
			array( 'icon-spell-check' => 'Icon spell check' ),
			array( 'icon-screen' => 'Icon screen' ),
			array( 'icon-smartphone' => 'Icon smartphone' ),
			array( 'icon-tablet' => 'Icon tablet' ),
			array( 'icon-laptop' => 'Icon laptop' ),
			array( 'icon-laptop-phone' => 'Icon laptop phone' ),
			array( 'icon-power-switch' => 'Icon power switch' ),
			array( 'icon-bubble' => 'Icon bubble' ),
			array( 'icon-heart-pulse' => 'Icon heart pulse' ),
			array( 'icon-construction' => 'Icon construction' ),
			array( 'icon-pie-chart' => 'Icon pie chart' ),
			array( 'icon-chart-bars' => 'Icon chart bars' ),
			array( 'icon-gift' => 'Icon gift' ),
			array( 'icon-diamond' => 'Icon diamond' ),
			array( 'icon-linearicons' => 'Icon linearicons' ),
			array( 'icon-dinner' => 'Icon dinner' ),
			array( 'icon-coffee-cup' => 'Icon coffee cup' ),
			array( 'icon-leaf' => 'Icon leaf' ),
			array( 'icon-paw' => 'Icon paw' ),
			array( 'icon-rocket' => 'Icon rocket' ),
			array( 'icon-briefcase' => 'Icon briefcase' ),
			array( 'icon-bus' => 'Icon bus' ),
			array( 'icon-car' => 'Icon car' ),
			array( 'icon-train' => 'Icon train' ),
			array( 'icon-bicycle' => 'Icon bicycle' ),
			array( 'icon-wheelchair' => 'Icon wheelchair' ),
			array( 'icon-select' => 'Icon select' ),
			array( 'icon-earth' => 'Icon earth' ),
			array( 'icon-smile' => 'Icon smile' ),
			array( 'icon-sad' => 'Icon sad' ),
			array( 'icon-neutral' => 'Icon neutral' ),
			array( 'icon-mustache' => 'Icon mustache' ),
			array( 'icon-alarm' => 'Icon alarm' ),
			array( 'icon-bullhorn' => 'Icon bullhorn' ),
			array( 'icon-volume-high' => 'Icon volume high' ),
			array( 'icon-volume-medium' => 'Icon volume medium' ),
			array( 'icon-volume-low' => 'Icon volume low' ),
			array( 'icon-volume' => 'Icon volume' ),
			array( 'icon-mic' => 'Icon mic' ),
			array( 'icon-hourglass' => 'Icon hourglass' ),
			array( 'icon-undo' => 'Icon undo' ),
			array( 'icon-redo' => 'Icon redo' ),
			array( 'icon-sync' => 'Icon sync' ),
			array( 'icon-history' => 'Icon history' ),
			array( 'icon-clock' => 'Icon clock' ),
			array( 'icon-download' => 'Icon download' ),
			array( 'icon-upload' => 'Icon upload' ),
			array( 'icon-enter-down' => 'Icon enter down' ),
			array( 'icon-exit-up' => 'Icon exit up' ),
			array( 'icon-bug' => 'Icon bug' ),
			array( 'icon-code' => 'Icon code' ),
			array( 'icon-link' => 'Icon link' ),
			array( 'icon-unlink' => 'Icon unlink' ),
			array( 'icon-thumbs-up' => 'Icon thumbs up' ),
			array( 'icon-thumbs-down' => 'Icon thumbs down' ),
			array( 'icon-magnifier' => 'Icon magnifier' ),
			array( 'icon-cross' => 'Icon cross' ),
			array( 'icon-chevron-up' => 'Icon chevron up' ),
			array( 'icon-chevron-down' => 'Icon chevron down' ),
			array( 'icon-chevron-left' => 'Icon chevron left' ),
			array( 'icon-chevron-right' => 'Icon chevron right' ),
			array( 'icon-arrow-up' => 'Icon arrow up' ),
			array( 'icon-arrow-down' => 'Icon arrow down' ),
			array( 'icon-arrow-left' => 'Icon arrow left' ),
			array( 'icon-arrow-right' => 'Icon arrow right' ),
			array( 'icon-warning' => 'Icon warning' ),
			array( 'icon-question-circle' => 'Icon question circle' ),
			array( 'icon-menu-circle' => 'Icon menu circle' ),
			array( 'icon-checkmark-circle' => 'Icon checkmark circle' ),
			array( 'icon-cross-circle' => 'Icon cross circle' ),
			array( 'icon-plus-circle' => 'Icon plus circle' ),
			array( 'icon-circle-minus' => 'Icon circle minus' ),
			array( 'icon-arrow-up-circle' => 'Icon arrow up circle' ),
			array( 'icon-arrow-down-circle' => 'Icon arrow down circle' ),
			array( 'icon-arrow-left-circle' => 'Icon arrow left circle' ),
			array( 'icon-arrow-right-circle' => 'Icon arrow right circle' ),
			array( 'icon-chevron-up-circle' => 'Icon chevron up circle' ),
			array( 'icon-chevron-down-circle' => 'Icon chevron down circle' ),
			array( 'icon-chevron-left-circle' => 'Icon chevron left circle' ),
			array( 'icon-chevron-right-circle' => 'Icon chevron right circle' ),
			array( 'icon-layers' => 'Icon layers' ),
			array( 'icon-funnel' => 'Icon funnel' ),
			array( 'icon-highlight' => 'Icon highlight' ),
			array( 'icon-page-break' => 'Icon page break' ),
			array( 'icon-hand' => 'Icon hand' ),
			array( 'icon-pointer-up' => 'Icon pointer up' ),
			array( 'icon-pointer-right' => 'Icon pointer right' ),
			array( 'icon-pointer-down' => 'Icon pointer down' ),
			array( 'icon-pointer-left' => 'Icon pointer left' ),
			array( 'icon-sedan' => 'Icon sedan' ),
			array( 'icon-cabriolet' => 'Icon cabriolet' ),
			array( 'icon-SUV' => 'Icon SUV' ),
			array( 'icon-van' => 'Icon van' ),
			array( 'icon-sportcar' => 'Icon sportcar' ),
			array( 'icon-city-car' => 'Icon city-car' ),
			array( 'icon-number' => 'Icon number' ),
			array( 'icon-number2' => 'Icon number2' ),
			array( 'icon-number3' => 'Icon number3' ),
			array( 'icon-number4' => 'Icon number4' ),
			array( 'icon-number5' => 'Icon number5' ),
			array( 'icon-number6' => 'Icon number6' ),
			array( 'icon-number7' => 'Icon number7' ),
			array( 'icon-number8' => 'Icon number8' ),
			array( 'icon-number9' => 'Icon number9' ),
			array( 'icon-number10' => 'Icon number10' ),
			array( 'icon-number11' => 'Icon number11' ),
			array( 'icon-number12' => 'Icon number12' ),
			array( 'icon-number13' => 'Icon number13' ),
			array( 'icon-number14' => 'Icon number14' ),
			array( 'icon-number15' => 'Icon number15' ),
			array( 'icon-number16' => 'Icon number16' ),
			array( 'icon-number17' => 'Icon number17' ),
			array( 'icon-number18' => 'Icon number18' ),
			array( 'icon-number19' => 'Icon number19' ),
			array( 'icon-number20' => 'Icon number20' ),
			array( 'icon-quote' => 'Icon quote' ),
			array( 'icon-quote2' => 'Icon quote2' ),
			array( 'icon-tag2' => 'Icon tag2' ),
			array( 'icon-tag22' => 'Icon tag22' ),
			array( 'icon-link2' => 'Icon link2' ),
			array( 'icon-link22' => 'Icon link22' ),
			array( 'icon-cabinet' => 'Icon cabinet' ),
			array( 'icon-cabinet2' => 'Icon cabinet2' ),
			array( 'icon-calendar' => 'Icon calendar' ),
			array( 'icon-calendar2' => 'Icon calendar2' ),
			array( 'icon-calendar3' => 'Icon calendar3' ),
			array( 'icon-file' => 'Icon file' ),
			array( 'icon-file2' => 'Icon file2' ),
			array( 'icon-file3' => 'Icon file3' ),
			array( 'icon-files' => 'Icon files' ),
			array( 'icon-phone2' => 'Icon phone2' ),
			array( 'icon-tablet2' => 'Icon tablet2' ),
			array( 'icon-window' => 'Icon window' ),
			array( 'icon-monitor' => 'Icon monitor' ),
			array( 'icon-ipod' => 'Icon ipod' ),
			array( 'icon-tv' => 'Icon tv' ),
			array( 'icon-camera2' => 'Icon camera2' ),
			array( 'icon-camera22' => 'Icon camera22' ),
			array( 'icon-camera3' => 'Icon camera3' ),
			array( 'icon-film' => 'Icon film' ),
			array( 'icon-film2' => 'Icon film2' ),
			array( 'icon-film3' => 'Icon film3' ),
			array( 'icon-microphone' => 'Icon microphone' ),
			array( 'icon-microphone2' => 'Icon microphone2' ),
			array( 'icon-microphone3' => 'Icon microphone3' ),
			array( 'icon-drink' => 'Icon drink' ),
			array( 'icon-drink2' => 'Icon drink2' ),
			array( 'icon-drink3' => 'Icon drink3' ),
			array( 'icon-drink4' => 'Icon drink4' ),
			array( 'icon-coffee' => 'Icon coffee' ),
			array( 'icon-mug' => 'Icon mug' ),
			array( 'icon-icecream' => 'Icon icecream' ),
			array( 'icon-cake' => 'Icon cake' ),
			array( 'icon-checkmark' => 'Icon checkmark' ),
			array( 'icon-checkmark2' => 'Icon checkmark2' ),
			array( 'icon-cancel' => 'Icon cancel' ),
			array( 'icon-cancel2' => 'Icon cancel2' ),
			array( 'icon-plus' => 'Icon plus' ),
			array( 'icon-plus2' => 'Icon plus2' ),
			array( 'icon-minus' => 'Icon minus' ),
			array( 'icon-minus2' => 'Icon minus2' ),
			array( 'icon-notice' => 'Icon notice' ),
			array( 'icon-notice2' => 'Icon notice2' ),
			array( 'icon-cog2' => 'Icon cog2' ),
			array( 'icon-cogs' => 'Icon cogs' ),
			array( 'icon-cog22' => 'Icon cog22' ),
			array( 'icon-warning2' => 'Icon warning2' ),
			array( 'icon-health' => 'Icon health' ),
			array( 'icon-suitcase' => 'Icon suitcase' ),
			array( 'icon-suitcase2' => 'Icon suitcase2' ),
			array( 'icon-suitcase3' => 'Icon suitcase3' ),
			array( 'icon-picture2' => 'Icon picture2' ),
			array( 'icon-pictures' => 'Icon pictures' ),
			array( 'icon-pictures2' => 'Icon pictures2' ),
			array( 'icon-android' => 'Icon android' ),
			array( 'icon-marvin' => 'Icon marvin' ),
			array( 'icon-pacman' => 'Icon pacman' ),
			array( 'icon-cassette' => 'Icon cassette' ),
			array( 'icon-watch' => 'Icon watch' ),
			array( 'icon-chronometer' => 'Icon chronometer' ),
			array( 'icon-watch2' => 'Icon watch2' ),
			array( 'icon-alarmclock' => 'Icon alarmclock' ),
			array( 'icon-time' => 'Icon time' ),
			array( 'icon-time2' => 'Icon time2' ),
			array( 'icon-headphones' => 'Icon headphones' ),
			array( 'icon-wallet' => 'Icon wallet' ),
			array( 'icon-checkmark3' => 'Icon checkmark3' ),
			array( 'icon-cancel3' => 'Icon cancel3' ),
			array( 'icon-eye2' => 'Icon eye2' ),
			array( 'icon-position' => 'Icon position' ),
			array( 'icon-cloud2' => 'Icon cloud2' ),
			array( 'icon-upload2' => 'Icon upload2' ),
			array( 'icon-chart' => 'Icon chart' ),
			array( 'icon-chart2' => 'Icon chart2' ),
			array( 'icon-chart3' => 'Icon chart3' ),
			array( 'icon-chart4' => 'Icon chart4' ),
			array( 'icon-chart5' => 'Icon chart5' ),
			array( 'icon-chart6' => 'Icon chart6' ),
			array( 'icon-location2' => 'Icon location2' ),
			array( 'icon-download2' => 'Icon download2' ),
			array( 'icon-basket' => 'Icon basket' ),
			array( 'icon-folder' => 'Icon folder' ),
			array( 'icon-gamepad' => 'Icon gamepad' ),
			array( 'icon-alarm2' => 'Icon alarm2' ),
			array( 'icon-alarm-cancel' => 'Icon alarm cancel' ),
			array( 'icon-phone22' => 'Icon phone22' ),
			array( 'icon-phone3' => 'Icon phone3' ),
			array( 'icon-image' => 'Icon image' ),
			array( 'icon-open' => 'Icon open' ),
			array( 'icon-sale' => 'Icon sale' ),
			array( 'icon-direction' => 'Icon direction' ),
			array( 'icon-map2' => 'Icon map2' ),
			array( 'icon-trashcan' => 'Icon trashcan' ),
			array( 'icon-vote' => 'Icon vote' ),
			array( 'icon-graduate' => 'Icon graduate' ),
			array( 'icon-lab' => 'Icon lab' ),
			array( 'icon-tie' => 'Icon tie' ),
			array( 'icon-football' => 'Icon football' ),
			array( 'icon-eightball' => 'Icon eightball' ),
			array( 'icon-bowling' => 'Icon bowling' ),
			array( 'icon-bowlingpin' => 'Icon bowlingpin' ),
			array( 'icon-baseball' => 'Icon baseball' ),
			array( 'icon-soccer' => 'Icon soccer' ),
			array( 'icon-3dglasses' => 'Icon 3dglasses' ),
			array( 'icon-microwave' => 'Icon microwave' ),
			array( 'icon-refrigerator' => 'Icon refrigerator' ),
			array( 'icon-oven' => 'Icon oven' ),
			array( 'icon-washingmachine' => 'Icon washingmachine' ),
			array( 'icon-mouse' => 'Icon mouse' ),
			array( 'icon-smiley' => 'Icon smiley' ),
			array( 'icon-sad2' => 'Icon sad2' ),
			array( 'icon-mute' => 'Icon mute' ),
			array( 'icon-hand2' => 'Icon hand2' ),
			array( 'icon-radio' => 'Icon radio' ),
			array( 'icon-satellite' => 'Icon satellite' ),
			array( 'icon-medal' => 'Icon medal' ),
			array( 'icon-medal2' => 'Icon medal2' ),
			array( 'icon-switch' => 'Icon switch' ),
			array( 'icon-key' => 'Icon key' ),
			array( 'icon-cord' => 'Icon cord' ),
			array( 'icon-locked' => 'Icon locked' ),
			array( 'icon-unlocked' => 'Icon unlocked' ),
			array( 'icon-locked2' => 'Icon locked2' ),
			array( 'icon-unlocked2' => 'Icon unlocked2' ),
			array( 'icon-magnifier2' => 'Icon magnifier2' ),
			array( 'icon-zoomin' => 'Icon zoomin' ),
			array( 'icon-zoomout' => 'Icon zoomout' ),
			array( 'icon-stack' => 'Icon stack' ),
			array( 'icon-stack2' => 'Icon stack2' ),
			array( 'icon-stack3' => 'Icon stack3' ),
			array( 'icon-davidstar' => 'Icon davidstar' ),
			array( 'icon-cross2' => 'Icon cross2' ),
			array( 'icon-moonandstar' => 'Icon moonandstar' ),
			array( 'icon-transformers' => 'Icon transformers' ),
			array( 'icon-batman' => 'Icon batman' ),
			array( 'icon-spaceinvaders' => 'Icon spaceinvaders' ),
			array( 'icon-skeletor' => 'Icon skeletor' ),
			array( 'icon-lamp' => 'Icon lamp' ),
			array( 'icon-lamp2' => 'Icon lamp2' ),
			array( 'icon-umbrella' => 'Icon umbrella' ),
			array( 'icon-streetlight' => 'Icon streetlight' ),
			array( 'icon-bomb' => 'Icon bomb' ),
			array( 'icon-archive' => 'Icon archive' ),
			array( 'icon-megaphone' => 'Icon megaphone' ),
			array( 'icon-megaphone2' => 'Icon megaphone2' ),
			array( 'icon-patch' => 'Icon patch' ),
			array( 'icon-pil' => 'Icon pil' ),
			array( 'icon-injection' => 'Icon injection' ),
			array( 'icon-thermometer' => 'Icon thermometer' ),
			array( 'icon-lamp3' => 'Icon lamp3' ),
			array( 'icon-lamp4' => 'Icon lamp4' ),
			array( 'icon-lamp5' => 'Icon lamp5' ),
			array( 'icon-cube' => 'Icon cube' ),
			array( 'icon-box1' => 'Icon box1' ),
			array( 'icon-box2' => 'Icon box2' ),
			array( 'icon-diamond2' => 'Icon diamond2' ),
			array( 'icon-bag' => 'Icon bag' ),
			array( 'icon-moneybag' => 'Icon moneybag' ),
			array( 'icon-grid' => 'Icon grid' ),
			array( 'icon-grid2' => 'Icon grid2' ),
			array( 'icon-ruler' => 'Icon ruler' ),
			array( 'icon-ruler2' => 'Icon ruler2' ),
			array( 'icon-layout' => 'Icon layout' ),
			array( 'icon-layout2' => 'Icon layout2' ),
			array( 'icon-layout3' => 'Icon layout3' ),
			array( 'icon-layout4' => 'Icon layout4' ),
			array( 'icon-layout5' => 'Icon layout5' ),
			array( 'icon-layout6' => 'Icon layout6' ),
			array( 'icon-layout7' => 'Icon layout7' ),
			array( 'icon-layout8' => 'Icon layout8' ),
			array( 'icon-layout9' => 'Icon layout9' ),
			array( 'icon-layout10' => 'Icon layout10' ),
			array( 'icon-layout11' => 'Icon layout11' ),
			array( 'icon-layout12' => 'Icon layout12' ),
			array( 'icon-layout13' => 'Icon layout13' ),
			array( 'icon-layout14' => 'Icon layout14' ),
			array( 'icon-tools' => 'Icon tools' ),
			array( 'icon-screwdriver' => 'Icon screwdriver' ),
			array( 'icon-paint' => 'Icon paint' ),
			array( 'icon-hammer' => 'Icon hammer' ),
			array( 'icon-brush' => 'Icon brush' ),
			array( 'icon-pen' => 'Icon pen' ),
			array( 'icon-chat' => 'Icon chat' ),
			array( 'icon-comments' => 'Icon comments' ),
			array( 'icon-chat2' => 'Icon chat2' ),
			array( 'icon-chat3' => 'Icon chat3' ),
			array( 'icon-volume2' => 'Icon volume2' ),
			array( 'icon-volume22' => 'Icon volume22' ),
			array( 'icon-volume3' => 'Icon volume3' ),
			array( 'icon-equalizer' => 'Icon equalizer' ),
			array( 'icon-resize' => 'Icon resize' ),
			array( 'icon-resize2' => 'Icon resize2' ),
			array( 'icon-resize3' => 'Icon resize3' ),
			array( 'icon-download3' => 'Icon download3' ),
			array( 'icon-calculator' => 'Icon calculator' ),
			array( 'icon-library' => 'Icon library' ),
			array( 'icon-auction' => 'Icon auction' ),
			array( 'icon-justice' => 'Icon justice' ),
			array( 'icon-stats' => 'Icon stats' ),
			array( 'icon-stats2' => 'Icon stats2' ),
			array( 'icon-attachment' => 'Icon attachment' ),
			array( 'icon-hourglass2' => 'Icon hourglass2' ),
			array( 'icon-abacus' => 'Icon abacus' ),
			array( 'icon-pencil2' => 'Icon pencil2' ),
			array( 'icon-pen2' => 'Icon pen2' ),
			array( 'icon-pin' => 'Icon pin' ),
			array( 'icon-pin2' => 'Icon pin2' ),
			array( 'icon-discout' => 'Icon discout' ),
			array( 'icon-edit' => 'Icon edit' ),
			array( 'icon-scissors' => 'Icon scissors' ),
			array( 'icon-profile' => 'Icon profile' ),
			array( 'icon-profile2' => 'Icon profile2' ),
			array( 'icon-profile3' => 'Icon profile3' ),
			array( 'icon-rotate' => 'Icon rotate' ),
			array( 'icon-rotate2' => 'Icon rotate2' ),
			array( 'icon-square' => 'Icon square' ),
			array( 'icon-square2' => 'Icon square2' ),
			array( 'icon-circle' => 'Icon circle' ),
			array( 'icon-dollar' => 'Icon dollar' ),
			array( 'icon-dollar2' => 'Icon dollar2' ),
			array( 'icon-coins' => 'Icon coins' ),
			array( 'icon-pig' => 'Icon pig' ),
			array( 'icon-bookmark2' => 'Icon bookmark2' ),
			array( 'icon-bookmark22' => 'Icon bookmark22' ),
			array( 'icon-addressbook' => 'Icon addressbook' ),
			array( 'icon-addressbook2' => 'Icon addressbook2' ),
			array( 'icon-safe' => 'Icon safe' ),
			array( 'icon-envelope2' => 'Icon envelope2' ),
			array( 'icon-envelope22' => 'Icon envelope22' ),
			array( 'icon-radioactive' => 'Icon radioactive' ),
			array( 'icon-music' => 'Icon music' ),
			array( 'icon-presentation' => 'Icon presentation' ),
			array( 'icon-male' => 'Icon male' ),
			array( 'icon-female' => 'Icon female' ),
			array( 'icon-aids' => 'Icon aids' ),
			array( 'icon-heart2' => 'Icon heart2' ),
			array( 'icon-info' => 'Icon info' ),
			array( 'icon-info2' => 'Icon info2' ),
			array( 'icon-piano' => 'Icon piano' ),
			array( 'icon-rain' => 'Icon rain' ),
			array( 'icon-snow' => 'Icon snow' ),
			array( 'icon-lightning' => 'Icon lightning' ),
			array( 'icon-sun2' => 'Icon sun2' ),
			array( 'icon-moon2' => 'Icon moon2' ),
			array( 'icon-cloudy' => 'Icon cloudy' ),
			array( 'icon-cloudy2' => 'Icon cloudy2' ),
			array( 'icon-car2' => 'Icon car2' ),
			array( 'icon-bike' => 'Icon bike' ),
			array( 'icon-truck' => 'Icon truck' ),
			array( 'icon-bus2' => 'Icon bus2' ),
			array( 'icon-bike2' => 'Icon bike2' ),
			array( 'icon-plane' => 'Icon plane' ),
			array( 'icon-paperplane' => 'Icon paperplane' ),
			array( 'icon-rocket2' => 'Icon rocket2' ),
			array( 'icon-book2' => 'Icon book2' ),
			array( 'icon-book22' => 'Icon book22' ),
			array( 'icon-barcode' => 'Icon barcode' ),
			array( 'icon-barcode2' => 'Icon barcode2' ),
			array( 'icon-popout' => 'Icon popout' ),
			array( 'icon-popin' => 'Icon popin' ),
			array( 'icon-target' => 'Icon target' ),
			array( 'icon-badge' => 'Icon badge' ),
			array( 'icon-badge2' => 'Icon badge2' ),
			array( 'icon-ticket' => 'Icon ticket' ),
			array( 'icon-ticket2' => 'Icon ticket2' ),
			array( 'icon-ticket3' => 'Icon ticket3' ),
			array( 'icon-microphone4' => 'Icon microphone4' ),
			array( 'icon-cone' => 'Icon cone' ),
			array( 'icon-blocked' => 'Icon blocked' ),
			array( 'icon-stop' => 'Icon stop' ),
			array( 'icon-keyboard2' => 'Icon keyboard2' ),
			array( 'icon-keyboard22' => 'Icon keyboard22' ),
			array( 'icon-radio2' => 'Icon radio2' ),
			array( 'icon-printer2' => 'Icon printer2' ),
			array( 'icon-alert' => 'Icon alert' ),
			array( 'icon-pictures3' => 'Icon pictures3' ),
			array( 'icon-atom' => 'Icon atom' ),
			array( 'icon-eyedropper' => 'Icon eyedropper' ),
			array( 'icon-globe' => 'Icon globe' ),
			array( 'icon-globe2' => 'Icon globe2' ),
			array( 'icon-shipping' => 'Icon shipping' ),
			array( 'icon-yingyang' => 'Icon yingyang' ),
			array( 'icon-compass' => 'Icon compass' ),
			array( 'icon-zip' => 'Icon zip' ),
			array( 'icon-zip2' => 'Icon zip2' ),
			array( 'icon-anchor' => 'Icon anchor' ),
			array( 'icon-lockedheart' => 'Icon lockedheart' ),
			array( 'icon-magnet' => 'Icon magnet' ),
			array( 'icon-navigation' => 'Icon navigation' ),
			array( 'icon-tags' => 'Icon tags' ),
			array( 'icon-heart22' => 'Icon heart22' ),
			array( 'icon-heart3' => 'Icon heart3' ),
			array( 'icon-usb' => 'Icon usb' ),
			array( 'icon-clipboard' => 'Icon clipboard' ),
			array( 'icon-clipboard2' => 'Icon clipboard2' ),
			array( 'icon-clipboard3' => 'Icon clipboard3' ),
			array( 'icon-switch2' => 'Icon switch2' ),
			array( 'icon-ruler3' => 'Icon ruler3' ),
			array( 'icon-add-to-list' => 'Icon add-to-list' ),
			array( 'icon-classic-computer' => 'Icon classic computer' ),
			array( 'icon-controller-fast-backward' => 'Icon controller fast-backward' ),
			array( 'icon-creative-commons-attribution' => 'Icon creative commons attribution' ),
			array( 'icon-creative-commons-noderivs' => 'Icon creative commons noderivs' ),
			array( 'icon-creative-commons-noncommercial-eu' => 'Icon creative commons noncommercial eu' ),
			array( 'icon-creative-commons-noncommercial-us' => 'Icon creative commons noncommercial us' ),
			array( 'icon-creative-commons-public-domain' => 'Icon creative commons public-domain' ),
			array( 'icon-creative-commons-remix' => 'Icon creative commons remix' ),
			array( 'icon-creative-commons-share' => 'Icon creative commons share' ),
			array( 'icon-creative-commons-sharealike' => 'Icon creative commons sharealike' ),
			array( 'icon-creative-commons' => 'Icon creative commons' ),
			array( 'icon-document-landscape' => 'Icon document landscape' ),
			array( 'icon-remove-user' => 'Icon remove user' ),
			array( 'icon-warning22' => 'Icon warning22' ),
			array( 'icon-arrow-bold-down' => 'Icon arrow bold down' ),
			array( 'icon-arrow-bold-left' => 'Icon arrow bold left' ),
			array( 'icon-arrow-bold-right' => 'Icon arrow bold right' ),
			array( 'icon-arrow-bold-up' => 'Icon arrow bold up' ),
			array( 'icon-arrow-down2' => 'Icon arrow down2' ),
			array( 'icon-arrow-left2' => 'Icon arrow left2' ),
			array( 'icon-arrow-long-down' => 'Icon arrow long down' ),
			array( 'icon-arrow-long-left' => 'Icon arrow long left' ),
			array( 'icon-arrow-long-right' => 'Icon arrow long right' ),
			array( 'icon-arrow-long-up' => 'Icon arrow long up' ),
			array( 'icon-arrow-right2' => 'Icon arrow right2' ),
			array( 'icon-arrow-up2' => 'Icon arrow up2' ),
			array( 'icon-arrow-with-circle-down' => 'Icon arrow with circle down' ),
			array( 'icon-arrow-with-circle-left' => 'Icon arrow with circle left' ),
			array( 'icon-arrow-with-circle-right' => 'Icon arrow with circle right' ),
			array( 'icon-arrow-with-circle-up' => 'Icon arrow with circle up' ),
			array( 'icon-bookmark3' => 'Icon bookmark3' ),
			array( 'icon-bookmarks' => 'Icon bookmarks' ),
			array( 'icon-chevron-down2' => 'Icon chevron down2' ),
			array( 'icon-chevron-left2' => 'Icon chevron left2' ),
			array( 'icon-chevron-right2' => 'Icon chevron right2' ),
			array( 'icon-chevron-small-down' => 'Icon chevron small down' ),
			array( 'icon-chevron-small-left' => 'Icon chevron small left' ),
			array( 'icon-chevron-small-right' => 'Icon chevron small right' ),
			array( 'icon-chevron-small-up' => 'Icon chevron small up' ),
			array( 'icon-chevron-thin-down' => 'Icon chevron thin down' ),
			array( 'icon-chevron-thin-left' => 'Icon chevron thin left' ),
			array( 'icon-chevron-thin-right' => 'Icon chevron thin right' ),
			array( 'icon-chevron-thin-up' => 'Icon chevron thin up' ),
			array( 'icon-chevron-up2' => 'Icon chevron up2' ),
			array( 'icon-chevron-with-circle-down' => 'Icon chevron with circle down' ),
			array( 'icon-chevron-with-circle-left' => 'Icon chevron with circle left' ),
			array( 'icon-chevron-with-circle-right' => 'Icon chevron with circle right' ),
			array( 'icon-chevron-with-circle-up' => 'Icon chevron with circle up' ),
			array( 'icon-cloud22' => 'Icon cloud22' ),
			array( 'icon-controller-fast-forward' => 'Icon controller fast forward' ),
			array( 'icon-controller-jump-to-start' => 'Icon controller jump to start' ),
			array( 'icon-controller-next' => 'Icon controller next' ),
			array( 'icon-controller-paus' => 'Icon controller paus' ),
			array( 'icon-controller-play' => 'Icon controller play' ),
			array( 'icon-controller-record' => 'Icon controller record' ),
			array( 'icon-controller-stop' => 'Icon controller stop' ),
			array( 'icon-controller-volume' => 'Icon controller volume' ),
			array( 'icon-dot-single' => 'Icon dot-single' ),
			array( 'icon-dots-three-horizontal' => 'Icon dots three horizontal' ),
			array( 'icon-dots-three-vertical' => 'Icon dots three vertical' ),
			array( 'icon-dots-two-horizontal' => 'Icon dots two horizontal' ),
			array( 'icon-dots-two-vertical' => 'Icon dots two vertical' ),
			array( 'icon-download4' => 'Icon download4' ),
			array( 'icon-emoji-flirt' => 'Icon emoji flirt' ),
			array( 'icon-install' => 'Icon install' ),
			array( 'icon-layers2' => 'Icon layers2' ),
			array( 'icon-open-book' => 'Icon open-book' ),
			array( 'icon-resize-100' => 'Icon resize-100' ),
			array( 'icon-resize-full-screen' => 'Icon resize full screen' ),
			array( 'icon-save' => 'Icon save' ),
			array( 'icon-select-arrows' => 'Icon select arrows' ),
			array( 'icon-sound-mute' => 'Icon sound mute' ),
			array( 'icon-sound' => 'Icon sound' ),
			array( 'icon-trash2' => 'Icon trash2' ),
			array( 'icon-triangle-down' => 'Icon triangle down' ),
			array( 'icon-triangle-left' => 'Icon triangle left' ),
			array( 'icon-triangle-right' => 'Icon triangle right' ),
			array( 'icon-triangle-up' => 'Icon triangle up' ),
			array( 'icon-uninstall' => 'Icon uninstall' ),
			array( 'icon-upload-to-cloud' => 'Icon upload to cloud' ),
			array( 'icon-upload3' => 'Icon upload3' ),
			array( 'icon-add-user' => 'Icon add user' ),
			array( 'icon-address' => 'Icon address' ),
			array( 'icon-adjust' => 'Icon adjust' ),
			array( 'icon-air' => 'Icon air' ),
			array( 'icon-aircraft-landing' => 'Icon aircraft landing' ),
			array( 'icon-aircraft-take-off' => 'Icon aircraft take-off' ),
			array( 'icon-aircraft' => 'Icon aircraft' ),
			array( 'icon-archive2' => 'Icon archive2' ),
			array( 'icon-area-graph' => 'Icon area-graph' ),
			array( 'icon-attachment2' => 'Icon attachment2' ),
			array( 'icon-awareness-ribbon' => 'Icon awareness ribbon' ),
			array( 'icon-back-in-time' => 'Icon back in time' ),
			array( 'icon-back' => 'Icon back' ),
			array( 'icon-bar-graph' => 'Icon bar graph' ),
			array( 'icon-battery6' => 'Icon battery6' ),
			array( 'icon-beamed-note' => 'Icon beamed note' ),
			array( 'icon-bell' => 'Icon bell' ),
			array( 'icon-blackboard' => 'Icon blackboard' ),
			array( 'icon-block' => 'Icon block' ),
			array( 'icon-book3' => 'Icon book3' ),
			array( 'icon-bowl' => 'Icon bowl' ),
			array( 'icon-box3' => 'Icon box3' ),
			array( 'icon-briefcase2' => 'Icon briefcase2' ),
			array( 'icon-browser' => 'Icon browser' ),
			array( 'icon-brush2' => 'Icon brush2' ),
			array( 'icon-bucket' => 'Icon bucket' ),
			array( 'icon-cake2' => 'Icon cake2' ),
			array( 'icon-calculator2' => 'Icon calculator2' ),
			array( 'icon-calendar4' => 'Icon calendar4' ),
			array( 'icon-camera4' => 'Icon camera4' ),
			array( 'icon-ccw' => 'Icon ccw' ),
			array( 'icon-chat4' => 'Icon chat4' ),
			array( 'icon-check' => 'Icon check' ),
			array( 'icon-circle-with-cross' => 'Icon circle with cross' ),
			array( 'icon-circle-with-minus' => 'Icon circle with minus' ),
			array( 'icon-circle-with-plus' => 'Icon circle with plus' ),
			array( 'icon-circle2' => 'Icon circle2' ),
			array( 'icon-circular-graph' => 'Icon circular graph' ),
			array( 'icon-clapperboard' => 'Icon clapperboard' ),
			array( 'icon-clipboard4' => 'Icon clipboard4' ),
			array( 'icon-clock2' => 'Icon clock2' ),
			array( 'icon-code2' => 'Icon code2' ),
			array( 'icon-cog3' => 'Icon cog3' ),
			array( 'icon-colours' => 'Icon colours' ),
			array( 'icon-compass2' => 'Icon compass2' ),
			array( 'icon-copy' => 'Icon copy' ),
			array( 'icon-credit-card' => 'Icon credit card' ),
			array( 'icon-credit' => 'Icon credit' ),
			array( 'icon-cross22' => 'Icon cross22' ),
			array( 'icon-cup' => 'Icon cup' ),
			array( 'icon-cw' => 'Icon cw' ),
			array( 'icon-cycle' => 'Icon cycle' ),
			array( 'icon-database2' => 'Icon database2' ),
			array( 'icon-dial-pad' => 'Icon dial-pad' ),
			array( 'icon-direction2' => 'Icon direction2' ),
			array( 'icon-document' => 'Icon document' ),
			array( 'icon-documents' => 'Icon documents' ),
			array( 'icon-drink5' => 'Icon drink5' ),
			array( 'icon-drive' => 'Icon drive' ),
			array( 'icon-drop2' => 'Icon drop2' ),
			array( 'icon-edit2' => 'Icon edit2' ),
			array( 'icon-email' => 'Icon email' ),
			array( 'icon-emoji-happy' => 'Icon emoji happy' ),
			array( 'icon-emoji-neutral' => 'Icon emoji neutral' ),
			array( 'icon-emoji-sad' => 'Icon emoji sad' ),
			array( 'icon-erase' => 'Icon erase' ),
			array( 'icon-eraser' => 'Icon eraser' ),
			array( 'icon-export' => 'Icon export' ),
			array( 'icon-eye22' => 'Icon eye22' ),
			array( 'icon-feather' => 'Icon feather' ),
			array( 'icon-flag2' => 'Icon flag2' ),
			array( 'icon-flash' => 'Icon flash' ),
			array( 'icon-flashlight' => 'Icon flashlight' ),
			array( 'icon-flat-brush' => 'Icon flat-brush' ),
			array( 'icon-forward2' => 'Icon forward2' ),
			array( 'icon-funnel2' => 'Icon funnel2' ),
			array( 'icon-game-controller' => 'Icon game controller' ),
			array( 'icon-gauge' => 'Icon gauge' ),
			array( 'icon-globe3' => 'Icon globe3' ),
			array( 'icon-graduation-cap' => 'Icon graduation cap' ),
			array( 'icon-grid3' => 'Icon grid3' ),
			array( 'icon-hair-cross' => 'Icon hair cross' ),
			array( 'icon-hand22' => 'Icon hand22' ),
			array( 'icon-heart-outlined' => 'Icon heart outlined' ),
			array( 'icon-heart4' => 'Icon heart4' ),
			array( 'icon-help-with-circle' => 'Icon help with circle' ),
			array( 'icon-help' => 'Icon help' ),
			array( 'icon-home2' => 'Icon home2' ),
			array( 'icon-hour-glass' => 'Icon hour glass' ),
			array( 'icon-image-inverted' => 'Icon image inverted' ),
			array( 'icon-image2' => 'Icon image2' ),
			array( 'icon-images' => 'Icon images' ),
			array( 'icon-inbox3' => 'Icon inbox3' ),
			array( 'icon-infinity' => 'Icon infinity' ),
			array( 'icon-info-with-circle' => 'Icon info with circle' ),
			array( 'icon-info3' => 'Icon info3' ),
			array( 'icon-key2' => 'Icon key2' ),
			array( 'icon-keyboard3' => 'Icon keyboard3' ),
			array( 'icon-lab-flask' => 'Icon lab-flask' ),
			array( 'icon-landline' => 'Icon landline' ),
			array( 'icon-language' => 'Icon language' ),
			array( 'icon-laptop2' => 'Icon laptop2' ),
			array( 'icon-leaf2' => 'Icon leaf2' ),
			array( 'icon-level-down' => 'Icon level down' ),
			array( 'icon-level-up' => 'Icon level up' ),
			array( 'icon-lifebuoy' => 'Icon lifebuoy' ),
			array( 'icon-light-bulb' => 'Icon light bulb' ),
			array( 'icon-light-down' => 'Icon light down' ),
			array( 'icon-light-up' => 'Icon light up' ),
			array( 'icon-line-graph' => 'Icon line graph' ),
			array( 'icon-link3' => 'Icon link3' ),
			array( 'icon-list3' => 'Icon list3' ),
			array( 'icon-location-pin' => 'Icon location pin' ),
			array( 'icon-location22' => 'Icon location22' ),
			array( 'icon-lock-open' => 'Icon lock open' ),
			array( 'icon-lock2' => 'Icon lock2' ),
			array( 'icon-log-out' => 'Icon log out' ),
			array( 'icon-login' => 'Icon login' ),
			array( 'icon-magnet2' => 'Icon magnet2' ),
			array( 'icon-magnifying-glass' => 'Icon magnifying glass' ),
			array( 'icon-mail' => 'Icon mail' ),
			array( 'icon-man' => 'Icon man' ),
			array( 'icon-map22' => 'Icon map22' ),
			array( 'icon-mask' => 'Icon mask' ),
			array( 'icon-medal3' => 'Icon medal3' ),
			array( 'icon-megaphone3' => 'Icon megaphone3' ),
			array( 'icon-menu' => 'Icon menu' ),
			array( 'icon-message' => 'Icon message' ),
			array( 'icon-mic2' => 'Icon mic2' ),
			array( 'icon-minus4' => 'Icon minus4' ),
			array( 'icon-mobile' => 'Icon mobile' ),
			array( 'icon-modern-mic' => 'Icon modern mic' ),
			array( 'icon-moon22' => 'Icon moon22' ),
			array( 'icon-mouse2' => 'Icon mouse2' ),
			array( 'icon-music2' => 'Icon music2' ),
			array( 'icon-network' => 'Icon network' ),
			array( 'icon-new-message' => 'Icon new message' ),
			array( 'icon-new' => 'Icon new' ),
			array( 'icon-news' => 'Icon news' ),
			array( 'icon-note' => 'Icon note' ),
			array( 'icon-notification' => 'Icon notification' ),
			array( 'icon-old-mobile' => 'Icon old mobile' ),
			array( 'icon-old-phone' => 'Icon old phone' ),
			array( 'icon-palette' => 'Icon palette' ),
			array( 'icon-paper-plane' => 'Icon paper plane' ),
			array( 'icon-pencil22' => 'Icon pencil22' ),
			array( 'icon-phone4' => 'Icon phone4' ),
			array( 'icon-pie-chart2' => 'Icon pie chart2' ),
			array( 'icon-pin3' => 'Icon pin3' ),
			array( 'icon-plus3' => 'Icon plus3' ),
			array( 'icon-popup' => 'Icon popup' ),
			array( 'icon-power-plug' => 'Icon power plug' ),
			array( 'icon-price-ribbon' => 'Icon price ribbon' ),
			array( 'icon-price-tag' => 'Icon price tag' ),
			array( 'icon-print' => 'Icon print' ),
			array( 'icon-publish' => 'Icon publish' ),
			array( 'icon-quote3' => 'Icon quote3' ),
			array( 'icon-radio3' => 'Icon radio3' ),
			array( 'icon-rocket22' => 'Icon rocket22' ),
			array( 'icon-round-brush' => 'Icon round brush' ),
			array( 'icon-rss' => 'Icon rss' ),
			array( 'icon-ruler4' => 'Icon ruler4' ),
			array( 'icon-scissors2' => 'Icon scissors2' ),
			array( 'icon-share-alternitive' => 'Icon share alternitive' ),
			array( 'icon-share' => 'Icon share' ),
			array( 'icon-shareable' => 'Icon shareable' ),
			array( 'icon-shield' => 'Icon shield' ),
			array( 'icon-shop' => 'Icon shop' ),
			array( 'icon-shopping-bag' => 'Icon shopping bag' ),
			array( 'icon-shopping-basket' => 'Icon shopping basket' ),
			array( 'icon-shopping-cart' => 'Icon shopping cart' ),
			array( 'icon-shuffle2' => 'Icon shuffle2' ),
			array( 'icon-signal' => 'Icon signal' ),
			array( 'icon-sound-mix' => 'Icon sound mix' ),
			array( 'icon-sports-club' => 'Icon sports club' ),
			array( 'icon-spreadsheet' => 'Icon spreadsheet' ),
			array( 'icon-squared-cross' => 'Icon squared cross' ),
			array( 'icon-squared-minus' => 'Icon squared minus' ),
			array( 'icon-squared-plus' => 'Icon squared plus' ),
			array( 'icon-star-outlined' => 'Icon star outlined' ),
			array( 'icon-star2' => 'Icon star2' ),
			array( 'icon-stopwatch' => 'Icon stopwatch' ),
			array( 'icon-suitcase4' => 'Icon suitcase4' ),
			array( 'icon-swap' => 'Icon swap' ),
			array( 'icon-sweden' => 'Icon sweden' ),
			array( 'icon-switch3' => 'Icon switch3' ),
			array( 'icon-tablet22' => 'Icon tablet22' ),
			array( 'icon-tag3' => 'Icon tag3' ),
			array( 'icon-text-document-inverted' => 'Icon text document inverted' ),
			array( 'icon-text-document' => 'Icon text document' ),
			array( 'icon-thermometer2' => 'Icon thermometer2' ),
			array( 'icon-thumbs-down2' => 'Icon thumbs down2' ),
			array( 'icon-thumbs-up2' => 'Icon thumbs up2' ),
			array( 'icon-thunder-cloud' => 'Icon thunder cloud' ),
			array( 'icon-ticket4' => 'Icon ticket4' ),
			array( 'icon-time-slot' => 'Icon time slot' ),
			array( 'icon-tools2' => 'Icon tools2' ),
			array( 'icon-traffic-cone' => 'Icon traffic cone' ),
			array( 'icon-tree' => 'Icon tree' ),
			array( 'icon-trophy' => 'Icon trophy' ),
			array( 'icon-tv2' => 'Icon tv2' ),
			array( 'icon-typing' => 'Icon typing' ),
			array( 'icon-unread' => 'Icon unread' ),
			array( 'icon-untag' => 'Icon untag' ),
			array( 'icon-user2' => 'Icon user2' ),
			array( 'icon-users2' => 'Icon users2' ),
			array( 'icon-v-card' => 'Icon v-card' ),
			array( 'icon-video' => 'Icon video' ),
			array( 'icon-vinyl' => 'Icon vinyl' ),
			array( 'icon-voicemail' => 'Icon voicemail' ),
			array( 'icon-wallet2' => 'Icon wallet2' ),
			array( 'icon-water' => 'Icon water' ),
			array( 'icon-500px-with-circle' => 'Icon 500px with circle' ),
			array( 'icon-500px' => 'Icon 500px' ),
			array( 'icon-basecamp' => 'Icon basecamp' ),
			array( 'icon-behance' => 'Icon behance' ),
			array( 'icon-creative-cloud' => 'Icon creative cloud' ),
			array( 'icon-dropbox' => 'Icon dropbox' ),
			array( 'icon-evernote' => 'Icon evernote' ),
			array( 'icon-flattr' => 'Icon flattr' ),
			array( 'icon-foursquare' => 'Icon foursquare' ),
			array( 'icon-google-drive' => 'Icon google drive' ),
			array( 'icon-google-hangouts' => 'Icon google hangouts' ),
			array( 'icon-grooveshark' => 'Icon grooveshark' ),
			array( 'icon-icloud' => 'Icon icloud' ),
			array( 'icon-mixi' => 'Icon mixi' ),
			array( 'icon-onedrive' => 'Icon onedrive' ),
			array( 'icon-paypal' => 'Icon paypal' ),
			array( 'icon-picasa' => 'Icon picasa' ),
			array( 'icon-qq' => 'Icon qq' ),
			array( 'icon-rdio-with-circle' => 'Icon rdio with circle' ),
			array( 'icon-renren' => 'Icon renren' ),
			array( 'icon-scribd' => 'Icon scribd' ),
			array( 'icon-sina-weibo' => 'Icon sina weibo' ),
			array( 'icon-skype-with-circle' => 'Icon skype with circle' ),
			array( 'icon-skype' => 'Icon skype' ),
			array( 'icon-slideshare' => 'Icon slideshare' ),
			array( 'icon-smashing' => 'Icon smashing' ),
			array( 'icon-soundcloud' => 'Icon soundcloud' ),
			array( 'icon-spotify-with-circle' => 'Icon spotify with circle' ),
			array( 'icon-spotify' => 'Icon spotify' ),
			array( 'icon-swarm' => 'Icon swarm' ),
			array( 'icon-vine-with-circle' => 'Icon vine with circle' ),
			array( 'icon-vine' => 'Icon vine' ),
			array( 'icon-vk-alternitive' => 'Icon vk alternitive' ),
			array( 'icon-vk-with-circle' => 'Icon vk with circle' ),
			array( 'icon-vk' => 'Icon vk' ),
			array( 'icon-xing-with-circle' => 'Icon xing with circle' ),
			array( 'icon-xing' => 'Icon xing' ),
			array( 'icon-yelp' => 'Icon yelp' ),
			array( 'icon-dribbble-with-circle' => 'Icon dribbble with circle' ),
			array( 'icon-dribbble' => 'Icon dribbble' ),
			array( 'icon-facebook-with-circle' => 'Icon facebook with circle' ),
			array( 'icon-facebook' => 'Icon facebook' ),
			array( 'icon-flickr-with-circle' => 'Icon flickr with circle' ),
			array( 'icon-flickr' => 'Icon flickr' ),
			array( 'icon-github-with-circle' => 'Icon github with circle' ),
			array( 'icon-github' => 'Icon github' ),
			array( 'icon-google-with-circle' => 'Icon google with circle' ),
			array( 'icon-google' => 'Icon google' ),
			array( 'icon-instagram-with-circle' => 'Icon instagram with circle' ),
			array( 'icon-instagram' => 'Icon instagram' ),
			array( 'icon-lastfm-with-circle' => 'Icon lastfm with circle' ),
			array( 'icon-lastfm' => 'Icon lastfm' ),
			array( 'icon-linkedin-with-circle' => 'Icon linkedin with circle' ),
			array( 'icon-linkedin' => 'Icon linkedin' ),
			array( 'icon-pinterest-with-circle' => 'Icon pinterest with circle' ),
			array( 'icon-pinterest' => 'Icon pinterest' ),
			array( 'icon-rdio' => 'Icon rdio' ),
			array( 'icon-stumbleupon-with-circle' => 'Icon stumbleupon with circle' ),
			array( 'icon-stumbleupon' => 'Icon stumbleupon' ),
			array( 'icon-tumblr-with-circle' => 'Icon tumblr with circle' ),
			array( 'icon-tumblr' => 'Icon tumblr' ),
			array( 'icon-twitter-with-circle' => 'Icon twitter with circle' ),
			array( 'icon-twitter' => 'Icon twitter' ),
			array( 'icon-vimeo-with-circle' => 'Icon vimeo with circle' ),
			array( 'icon-vimeo' => 'Icon vimeo' ),
			array( 'icon-youtube-with-circle' => 'Icon youtube with circle' ),
			array( 'icon-youtube' => 'Icon youtube' ),
			array( 'icon-plane2' => 'Icon plane2' ),
			array( 'icon-keyboard222' => 'Icon keyboard222' ),
			array( 'icon-vcard' => 'Icon vcard' ),
			array( 'icon-book222' => 'Icon book222' ),
			array( 'icon-wallet22' => 'Icon wallet22' ),
			array( 'icon-brief-case' => 'Icon brief case' ),
			array( 'icon-browser2' => 'Icon browser2' ),
			array( 'icon-speach-bubble' => 'Icon speach bubble' ),
			array( 'icon-mail2' => 'Icon mail2' ),
			array( 'icon-phone222' => 'Icon phone222' ),
			array( 'icon-zoom' => 'Icon zoom' ),
			array( 'icon-map-pin' => 'Icon map-pin' ),
			array( 'icon-telephone' => 'Icon telephone' ),
			array( 'icon-globe22' => 'Icon globe22' ),
			array( 'icon-phone32' => 'Icon phone32' ),
			array( 'icon-mail-open' => 'Icon mail open' ),
			array( 'icon-map-pin2' => 'Icon map-pin2' ),
			array( 'icon-search' => 'Icon search' ),
			array( 'icon-iphone' => 'Icon iphone' ),
			array( 'icon-ipad' => 'Icon ipad' ),
			array( 'icon-iphone-landscape' => 'Icon iphone landscape' ),
			array( 'icon-clock3' => 'Icon clock3' ),
			array( 'icon-commerce' => 'Icon commerce' ),
			array( 'icon-interface' => 'Icon interface' ),
			array( 'icon-magnifying-glass2' => 'Icon magnifying glass2' ),
			array( 'icon-multimedia-1' => 'Icon multimedia-1' ),
			array( 'icon-multimedia' => 'Icon multimedia' ),
			array( 'icon-placeholder' => 'Icon placeholder' ),
			array( 'icon-shopping-bag2' => 'Icon shopping bag2' ),
			array( 'icon-signs' => 'Icon signs' ),
			array( 'icon-phone5' => 'Icon phone5' ),
		),

	);

	return array_merge( $icons, $linea_icons );
}
